/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
import _ from 'lodash'

const DOC_BASE_PATH = 'https://www.ibm.com/support/knowledgecenter'
const DOC_COLLECTION_NUMBER = 'SSBS6K_3.2.1'
const DOC_CLOUD_PAK_COLLECTION_NUMBER = 'SSFC4F_1.1.0'
const DOC_DEFAULT_PAGE = 'kc_welcome_containers.html'

const docPageMapping = {
  '/multicloud': 'kc_welcome_cloud_pak.html',
  '/console': 'kc_welcome_containers.html',
  '/console/workloads/daemonsets': 'manage_applications/create_daemonset.html',
  '/console/workloads/deployments': 'manage_applications/manage_apps.html',
  '/console/workloads/jobs': 'manage_applications/manage_jobs.html',
  '/console/workloads/statefulsets': 'manage_applications/stateful_apps.html',
  '/console/workloads/serviceinstances': 'manage_applications/service_catalog.html',
  '/console/workloads/replicasets': 'manage_applications/replicaSets.html',
  '/console/access/services': 'manage_applications/app_services.html',
  '/console/configuration/configmaps': 'manage_applications/create_config_map.html',
  '/console/configuration/policies': 'manage_policies/manage_policy.html',
  '/console/configuration/secrets': 'manage_applications/create_secrets.html',
  '/console/platform/network': 'manage_network/network.html',
  '/console/platform/nodes': 'getting_started/architecture.html',
  '/console/platform/storage': 'manage_cluster/cluster_storage.html',
  '/console/platform/va': 'manage_cluster/vuln_advisor.html',
  '/console/manage/realms': 'user_management/configure_ldap.html',
  '/console/manage/images': 'manage_images/managing_images.html',
  '/console/manage/clusterservicebrokers': 'manage_applications/service_catalog.html',
  '/console/manage/namespaces': 'user_management/projects.html',
  '/console/manage/podsecurity': 'manage_cluster/security.html',
  '/console/manage/quotas': 'manage_applications/set_resource_quota.html',
  '/console/manage/teams': 'user_management/teams.html',
  '/console/manage/users': 'user_management/users.html',
  '/console/tools/cli': 'manage_cluster/icp_cli.html'
}

const cloudPakDocPagePaths = '/multicloud'

export const getDocLink = (url, mappings = {}) => {
  const newMapping = _.assign({}, docPageMapping, mappings)
  let docPage = newMapping[url]
  if (!docPage) {
    const supportedLinks = Object.keys(newMapping)
    const matches = supportedLinks.filter(link => url && url.indexOf(link) !== -1)
    // support drill-in pages
    const match = matches.length > 0 && matches.reduce((acc, link) => link.length > acc.length && link)
    docPage = match ? newMapping[match] : DOC_DEFAULT_PAGE
  }
  return `${DOC_BASE_PATH}/${url.includes(cloudPakDocPagePaths)
    ? DOC_CLOUD_PAK_COLLECTION_NUMBER
    : DOC_COLLECTION_NUMBER}/${docPage}`
}
