/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
/*
 * action types
 *
 * action name: <NOUN>_<VERB>
 */

export const USER_LOGIN_RECEIVE_SUCCESS = 'USER_LOGIN_RECEIVE_SUCCESS'
export const USER_LOGOUT_REQUEST = 'USER_LOGOUT_REQUEST'
export const USER_LOGOUT_RECEIVE_SUCCESS = 'USER_LOGOUT_RECEIVE_SUCCESS'
export const USER_LOGOUT_RECEIVE_FAILURE = 'USER_LOGOUT_RECEIVE_FAILURE'

export const TABLE_SEARCH = 'TABLE_SEARCH'
export const TABLE_SORT = 'TABLE_SORT'
export const TABLE_PAGE_CHANGE = 'TABLE_PAGE_CHANGE'
export const TABLE_RESET = 'TABLE_RESET'
export const TABLE_FILTER = 'TABLE_FILTER'
export const TABLE_SELECT = 'TABLE_SELECT'

export const RESOURCE_REQUEST = 'RESOURCE_REQUEST'
export const RESOURCE_RECEIVE_SUCCESS = 'RESOURCE_RECEIVE_SUCCESS'
export const RESOURCE_RECEIVE_FAILURE = 'RESOURCE_RECEIVE_FAILURE'

export const POST_REQUEST = 'POST_REQUEST'
export const POST_RECEIVE_SUCCESS = 'POST_RECEIVE_SUCCESS'
export const POST_RECEIVE_FAILURE = 'POST_RECEIVE_FAILURE'

export const PUT_REQUEST = 'PUT_REQUEST'
export const PUT_RECEIVE_SUCCESS = 'PUT_RECEIVE_SUCCESS'
export const PUT_RECEIVE_FAILURE = 'PUT_RECEIVE_FAILURE'

export const DEL_REQUEST = 'DEL_REQUEST'
export const DEL_RECEIVE_SUCCESS = 'DEL_RECEIVE_SUCCESS'
export const DEL_RECEIVE_FAILURE = 'DEL_RECEIVE_FAILURE'

export const CLEAR_REQUEST_STATUS = 'CLEAR_REQUEST_STATUS'

export const RESOURCE_ADD = 'RESOURCE_ADD'
export const RESOURCE_MODIFY = 'RESOURCE_MODIFY'
export const RESOURCE_UPDATE = 'RESOURCE_UPDATE'
export const RESOURCE_DELETE= 'RESOURCE_DELETE'
export const RESOURCE_RESET= 'RESOURCE_RESET'

export const SECONDARY_HEADER_UPDATE = 'SECONDARY_HEADER_UPDATE'
export const SECONDARY_HEADER_UPDATE_CLASSES = 'SECONDARY_HEADER_UPDATE_CLASSES'

export const MODAL_UPDATE = 'MODAL_UPDATE'

export const UICONFIG_RECEIVE_SUCCESS = 'UICONFIG_RECEIVE_SUCCESS'

export const NAMESPACES_RECEIVE_SUCCESS = 'NAMESPACES_RECEIVE_SUCCESS'
export const NAMESPACES_RECEIVE_FAILURE = 'NAMESPACES_RECEIVE_FAILURE'
export const SWITCH_NAMESPACE = 'SWITCH_NAMESPACE'

export const OAUTH_INFO_RECEIVE_SUCCESS = 'OAUTH_INFO_RECEIVE_SUCCESS'
export const OAUTH_INFO_RECEIVE_FAILURE = 'OAUTH_INFO_RECEIVE_FAILURE'

export const USERPREFERENCES_RECEIVE_SUCCESS = 'USERPREFERENCES_RECEIVE_SUCCESS'
export const USERPREFERENCES_RECEIVE_FAILURE = 'USERPREFERENCES_RECEIVE_FAILURE'
export const UPDATE_USERPREFERENCES = 'UPDATE_USERPREFERENCES'

export const ROLE_RECEIVE_SUCCESS = 'ROLE_RECEIVE_SUCCESS'
export const ROLE_RECEIVE_FAILURE = 'ROLE_RECEIVE_FAILURE'

export const NAV_RECEIVE_SUCCESS = 'NAV_RECEIVE_SUCCESS'
export const NAV_MODIFY = 'NAV_MODIFY'

export const LOGO_RECEIVE_SUCCESS = 'LOGO_RECEIVE_SUCCESS'
export const DOC_RECEIVE_SUCCESS = 'DOC_RECEIVE_SUCCESS'
export const SUPPORT_RECEIVE_SUCCESS = 'SUPPORT_RECEIVE_SUCCESS'
export const ABOUT_RECEIVE_SUCCESS = 'ABOUT_RECEIVE_SUCCESS'
export const EXP_RECEIVE_SUCCESS = 'EXP_RECEIVE_SUCCESS '

export const SOCKET_CLOSE_REQUEST = 'SOCKET_CLOSE_REQUEST'

export const TOAST_NOTIFICATION_UPDATE = 'TOAST_NOTIFICATION_UPDATE'

/*
 * other constants specific to particular actions
 */

export const EXPERIENCE = {
  INIT: 'INIT',
  DONE: 'DONE'
}

export const VisibilityFilters = {
  SHOW_ALL: 'SHOW_ALL',
  SHOW_COMPLETED: 'SHOW_COMPLETED',
  SHOW_ACTIVE: 'SHOW_ACTIVE'
}

export const USER_LOGIN_STATUS = {
  LOGGED_IN: 'LOGGED_IN',
  LOGGED_OUT: 'LOGGED_OUT'
}

export const REQUEST_STATUS = {
  INCEPTION: 'INCEPTION',
  DONE: 'DONE',
  IN_PROGRESS: 'IN_PROGRESS',
  ERROR: 'ERROR'
}

export const PAGE_SIZES = {
  DEFAULT: 20,
  VALUES: [5, 10, 20, 50, 75, 100]
}

export const SORT_DIRECTION_ASCENDING = 'asc'
export const SORT_DIRECTION_DESCENDING = 'desc'

