/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2018. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
import {
  NAMESPACES_RECEIVE_SUCCESS, NAMESPACES_RECEIVE_FAILURE, SWITCH_NAMESPACE
} from './index'

export const namespacesReceiveSuccess = items => {
  let defaultNamespace = items && items.length > 0 && items[items.length - 1].Name
  defaultNamespace = defaultNamespace || ''
  return {
    type: NAMESPACES_RECEIVE_SUCCESS,
    namespaces: items,
    defaultNamespace,
    selectedNamespaces: items && items.map(item => item.Name).toString()
  }
}

export const namespacesReceiveFailure = err => ({ type: NAMESPACES_RECEIVE_FAILURE, err })

export const switchNamespace = namespace => ({
  type: SWITCH_NAMESPACE,
  ...namespace
})
