/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'
import _ from 'lodash'
import React from 'react'
import { Link } from 'react-router-dom'
import PropTypes from 'prop-types'
const AdaptiveLink = (props) => {
  const passThoughProps = {..._.omit(props, 'external')}
  return props.external
    ? <a {...passThoughProps} href={props.to} role='menuitem'>{props.label}</a>
    : <Link {...passThoughProps} role='menuitem'>{props.label}</Link>
}

AdaptiveLink.propTypes = {
  external: PropTypes.bool,
  label: PropTypes.string,
  to: PropTypes.string,
}

export default AdaptiveLink
