/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************
/* Copyright (c) 2020 Red Hat, Inc. */
import React from 'react'
import msgs from '../../../nls/platform-header.properties'
import PropTypes from 'prop-types'

export const VisibilityOnIcon = ({ className, width, height, title, onClick, onKeyPress }) =>
  <svg
    className={className}
    onClick={onClick}
    onKeyPress={onKeyPress}
    fillRule='evenodd'
    height={height}
    name='icon--visibility-on'
    role='img'
    viewBox='0 0 16 11'
    width={width}
    title={title}
    aria-label={title} alt={title}
  >
    <title>{title}</title>
    <path d='M8 7.5c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 1c-1.7 0-3-1.3-3-3s1.3-3 3-3 3 1.3 3 3-1.3 3-3 3z'></path>
    <path
      d='M8 10c2.8 0 5.1-1.5 6.9-4.6C13.1 2.5 10.8 1 8 1 5.2 1 3 2.4 1.2 5.4 2.9 8.6 5.2 10 8 10zM8 0c3.3 0 6 1.8 8.1 5.4C14 9.2 11.3 11 8 11S2 9.2 0 5.5C2 1.9 4.6 0 8 0z'>
    </path>
  </svg>

VisibilityOnIcon.propTypes = {
  className: PropTypes.string,
  height: PropTypes.num,
  onClick: PropTypes.func,
  onKeyPress: PropTypes.func,
  title: PropTypes.string,
  width: PropTypes.num,
}

export const VisibilityOffIcon = ({ className, width, height, title, onClick, onKeyPress } ) =>
  <svg
    className={className}
    onClick={onClick}
    onKeyPress={onKeyPress}
    fillRule='evenodd'
    height={height}
    name='icon--visibility-on'
    role='img'
    viewBox='0 0 16 16'
    width={width}
    title={title}
    aria-label={title}
    alt={title}>
    <title>{title}</title>
    <path
      d='M11.846 3.45L15.293.007 16 .714l-3.284 3.281c1.261.902 2.377 2.212 3.347 3.93C14.02 11.642 11.333 13.5 8 13.5c-1.392 0-2.667-.324-3.822-.973L.703 16l-.706-.708 3.323-3.32C2.071 11.042.976 9.694.035 7.924 2.012 4.308 4.667 2.5 8 2.5c1.395 0 2.677.317 3.846.95zm-6.928 8.338c.944.477 1.97.712 3.082.712 2.795 0 5.076-1.483 6.907-4.568-.866-1.417-1.833-2.486-2.91-3.219l-1.55 1.55a3 3 0 0 1-4.185 4.182l-1.344 1.343zm-.882-.533l1.518-1.517A3 3 0 0 1 9.74 5.556l1.364-1.363A7.02 7.02 0 0 0 8 3.5c-2.798 0-5.047 1.439-6.819 4.432.842 1.465 1.792 2.568 2.855 3.323zm2.948-1.532a2 2 0 0 0 2.74-2.738l-2.74 2.738zm-.707-.707l2.74-2.738a2 2 0 0 0-2.74 2.738z'>
    </path>
  </svg>

VisibilityOffIcon.propTypes = {
  className: PropTypes.string,
  height: PropTypes.num,
  onClick: PropTypes.func,
  onKeyPress: PropTypes.func,
  title: PropTypes.string,
  width: PropTypes.num,
}

export const AvatarIcon = ({ className, fill, width, height }) =>
  <svg className={className} width={width} height={height} viewBox='0 0 25 25' version='1.1' xmlns='http://www.w3.org/2000/svg' xmlnsXlink='http://www.w3.org/1999/xlink'>
    <g stroke='none' strokeWidth='1' fill='none' fillRule='evenodd'>
      <g transform='translate(-773.000000, -1993.000000)' fill={fill}>
        <g transform='translate(773.947897, 1993.046875)'>
          <path
            d='M19,19.1356 C17.196,20.9056 14.727,21.9996 12,21.9996 C9.273,21.9996 6.804,20.9056 5,19.1356 L5,17.4986 C5,16.2026 5.74,15.4986 7,15.4986 L17,15.4986 C18.26,15.4986 19,16.2026 19,17.4986 L19,19.1356 Z M12,4.5836 C14.761,4.5836 17,6.8216 17,9.5836 C17,12.3446 14.761,14.5836 12,14.5836 C9.239,14.5836 7,12.3446 7,9.5836 C7,6.8216 9.239,4.5836 12,4.5836 L12,4.5836 Z M12,-0.000400000001 C5.373,-0.000400000001 0,5.3726 0,11.9996 C0,18.6276 5.373,23.9996 12,23.9996 C18.627,23.9996 24,18.6276 24,11.9996 C24,5.3726 18.627,-0.000400000001 12,-0.000400000001 L12,-0.000400000001 Z'>
          </path>
        </g>
      </g>
    </g>
  </svg>

AvatarIcon.propTypes = {
  className: PropTypes.string,
  fill: PropTypes.string,
  height: PropTypes.num,
  width: PropTypes.num,
}

export const AppSwitcherIcon = () =>
  <svg width="16px" height="16px" viewBox="0 0 16 16" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlnsXlink="http://www.w3.org/1999/xlink">
    <title>Actions / Navigation / app-switcher / 20</title>
    <g id="Symbols" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
      <g id="RHACM_Header_1440" transform="translate(-979.000000, -29.000000)" fill="#EDEDED">
        <g id="RHACM_Header">
          <g id="Group-4-appIcon" transform="translate(979.000000, 0.000000)">
            <g id="Actions-/-Navigation-/-app-switcher-/-20" transform="translate(0.000000, 29.000000)">
              <path
                d="M13.5,13.5 L16,13.5 L16,16 L13.5,16 L13.5,13.5 Z M6.75,13.5 L9.25,13.5 L9.25,16 L6.75,16 L6.75,13.5 Z M0,13.5 L2.5,13.5 L2.5,16 L0,16 L0,13.5 Z M13.5,6.75 L16,6.75 L16,9.25 L13.5,9.25 L13.5,6.75 Z M6.75,6.75 L9.25,6.75 L9.25,9.25 L6.75,9.25 L6.75,6.75 Z M0,6.75 L2.5,6.75 L2.5,9.25 L0,9.25 L0,6.75 Z M13.5,0 L16,0 L16,2.5 L13.5,2.5 L13.5,0 Z M6.75,0 L9.25,0 L9.25,2.5 L6.75,2.5 L6.75,0 Z M0,0 L2.5,0 L2.5,2.5 L0,2.5 L0,0 Z"
                id="Fill-appIcon">
              </path>
            </g>
          </g>
        </g>
      </g>
    </g>
  </svg>

export const InfoDropdownIcon = ({ locale }) =>
  <svg role='img' viewBox='0 0 32 32' className='info-dropdown-icon header-icon' id='info-dropdown' aria-label={msgs.get('svg.description.infomenu', locale)}>
    <path d="M16,2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Zm0,26A12,12,0,1,1,28,16,12,12,0,0,1,16,28Z" />
    <circle cx="16" cy="23.5" r="1.5" />
    <path d="M17,8H15.5A4.49,4.49,0,0,0,11,12.5V13h2v-.5A2.5,2.5,0,0,1,15.5,10H17a2.5,2.5,0,0,1,0,5H15v4.5h2V17a4.5,4.5,0,0,0,0-9Z" />
    <rect width="32" height="32" fill="none" />
  </svg>

InfoDropdownIcon.propTypes = {
  locale: PropTypes.string,
}

export const SearchIcon = ({ darkFill, title }) =>
  <svg className='header-icon' id='search-icon' viewBox='0 0 32 32' role='img' title={title} aria-label={title}>
    <g stroke="none" strokeWidth="1" fillRule="evenodd" fill={`${darkFill ? '#161616' : '#f3f3f3'}`}>
      <path d="M30,28.59,22.45,21A11,11,0,1,0,21,22.45L28.59,30ZM5,14a9,9,0,1,1,9,9A9,9,0,0,1,5,14Z" />
      <rect width="32" height="32" fill="none" />
    </g>
  </svg>

SearchIcon.propTypes = {
  darkFill: PropTypes.bool,
  title: PropTypes.string,
}

export const CreateResourceIcon = ({ darkFill, title }) =>
  <svg className='header-icon' id='create-resource-icon' viewBox='0 0 32 32' role='img' title={title} aria-label={title}>
    <g stroke="none" strokeWidth="1" fillRule="evenodd" fill={`${darkFill ? '#161616' : '#f3f3f3'}`}>
      <path d="M16,4A12,12,0,1,1,4,16,12,12,0,0,1,16,4m0-2A14,14,0,1,0,30,16,14,14,0,0,0,16,2Z" />
      <polygon points="22 15 17 15 17 10 15 10 15 15 10 15 10 17 15 17 15 22 17 22 17 17 22 17 22 15" />
      <rect width="32" height="32" fill="none" />
    </g>
  </svg>

CreateResourceIcon.propTypes = {
  darkFill: PropTypes.bool,
  title: PropTypes.string,
}

export const TerminalIcon = ({ darkFill, title }) =>
  <svg title={title} aria-label={title} viewBox='0 0 32 32' role='img' alt={title} className='header-icon' id='terminal-icon'>
    <g stroke="none" strokeWidth="1" fillRule="evenodd" fill={`${darkFill ? '#161616' : '#f3f3f3'}`}>
      <path d="M26,4H6A2,2,0,0,0,4,6V26a2,2,0,0,0,2,2H26a2,2,0,0,0,2-2V6A2,2,0,0,0,26,4Zm0,2v4H6V6ZM6,26V12H26V26Z" transform="translate(0 0.01)" />
      <polygon points="10.76 16.18 13.58 19.01 10.76 21.84 12.17 23.25 16.41 19.01 12.17 14.77 10.76 16.18" />
      <rect width="32" height="32" fill="none" />
    </g>
  </svg>

TerminalIcon.propTypes = {
  darkFill: PropTypes.bool,
  title: PropTypes.string,
}

export const MenuIcon = ({ title }) =>
  <svg className='header-icon' id='menu-icon' viewBox='0 0 32 32' role='img' title={title} aria-label={title}>
    <rect x="4" y="24" width="24" height="2" />
    <rect x="4" y="12" width="24" height="2" />
    <rect x="4" y="18" width="24" height="2" />
    <rect x="4" y="6" width="24" height="2" />
  </svg>

MenuIcon.propTypes = {
  title: PropTypes.string,
}

export const ApplicationIcon = ({ source, title }) =>
  <svg className='header-icon' id={'menu-icon-'+title} viewBox='0 0 32 32' role='img' title={title} aria-label={title}>
    <image href={source} x='0' y='0' height='100%' width='100%' />
  </svg>

ApplicationIcon.propTypes = {
  source: PropTypes.string,
  title: PropTypes.string,
}

export const CloseMenuIcon = ({ title }) =>
  <svg className='header-icon' id='close-menu-icon' viewBox='0 0 32 32' role='img' title={title} aria-label={title}>
    <polygon points="24 9.4 22.6 8 16 14.6 9.4 8 8 9.4 14.6 16 8 22.6 9.4 24 16 17.4 22.6 24 24 22.6 17.4 16 24 9.4" />
    <rect width="32" height="32" fill="none" />
  </svg>

CloseMenuIcon.propTypes = {
  title: PropTypes.string,
}

export const ConfigureClientIcon = () =>
  <svg width="13px" height="14px" viewBox="0 0 13 14" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
      <g transform="translate(-1190.000000, -149.000000)" fill="#161616">
        <g transform="translate(1190.000000, 149.000000)">
          <g>
            <path
              d="M6.52682113,9.1875 C7.72343809,9.1875 8.6934878,8.20812289 8.6934878,7 C8.6934878,5.79187711 7.72343809,4.8125 6.52682113,4.8125 C5.33020417,4.8125 4.36015447,5.79187711 4.36015447,7 C4.36015447,8.20812289 5.33020417,9.1875 6.52682113,9.1875 Z M6.52682113,10.0625 C4.85155739,10.0625 3.4934878,8.69137205 3.4934878,7 C3.4934878,5.30862795 4.85155739,3.9375 6.52682113,3.9375 C8.20208487,3.9375 9.56015447,5.30862795 9.56015447,7 C9.56015447,8.69137205 8.20208487,10.0625 6.52682113,10.0625 Z"
              fillRule="nonzero">
            </path>
            <path
              d="M5.43217161,2.30613772 L5.16119179,2.38779246 C4.58702348,2.56080744 4.05187969,2.8422038 3.58198301,3.21547179 L3.36052341,3.39139084 L2.12438977,2.73129602 L1.0719217,4.24882889 L2.10031591,5.18781299 L2.00939574,5.45973112 C1.84499962,5.95139632 1.76015447,6.4695896 1.76015447,7 C1.76015447,7.2953336 1.78645232,7.58706102 1.83828428,7.87285634 L1.88177067,8.11263513 L0.866689908,9.03946328 L1.91915797,10.5569961 L2.83813043,10.0662653 L3.06443511,10.3076442 C3.6379756,10.9193886 4.36045988,11.3709218 5.16119179,11.6122075 L5.43217161,11.6938623 L5.60936009,13.125 L7.44428217,13.125 L7.62147065,11.6938623 L7.89245047,11.6122075 C8.60991577,11.3960127 9.26527104,11.0108618 9.80743693,10.491398 L10.0332016,10.2750868 L10.9777007,10.7794489 L12.0301688,9.26191608 L11.0940135,8.40715149 L11.155806,8.15344199 C11.2469477,7.77922944 11.2934878,7.39287535 11.2934878,7 C11.2934878,6.52410579 11.2251941,6.05794378 11.0922766,5.61171522 L11.0133642,5.34679173 L12.0107027,4.43616335 L10.9582346,2.91863048 L9.83218543,3.51994024 L9.60852464,3.32837981 C9.10723771,2.89903884 8.52360023,2.57797774 7.89245047,2.38779246 L7.62147065,2.30613772 L7.44428217,0.875 L5.60936009,0.875 L5.43217161,2.30613772 Z M4.74938593,0.766469607 C4.80359906,0.328594387 5.17227993,2.08166817e-16 5.60936009,2.08166817e-16 L7.44428217,1.11022302e-16 C7.88136234,1.11022302e-16 8.25004321,0.328594387 8.30425633,0.766469607 L8.41228479,1.63900713 C8.96136767,1.83586542 9.4757698,2.11782426 9.93812226,2.47351726 L10.5530299,2.14515686 C10.9393956,1.93883775 11.4174675,2.05527334 11.6681664,2.4167511 L12.7206344,3.93428397 C12.9713333,4.29576172 12.9161947,4.78914531 12.5920198,5.08513602 L11.9954934,5.62979951 C12.1044538,6.07441853 12.1601545,6.53360925 12.1601545,7 C12.1601545,7.37373065 12.1243905,7.74295994 12.0540257,8.10394965 L12.6114859,8.61294341 C12.9356609,8.90893412 12.9907995,9.4023177 12.7401006,9.76379546 L11.6876325,11.2813283 C11.4369336,11.6428061 10.9588617,11.7592417 10.572496,11.5529226 L10.1701299,11.3380592 C9.65089473,11.7829944 9.0556666,12.1303206 8.41228493,12.3609917 L8.30425633,13.2335304 C8.25004321,13.6714056 7.88136234,14 7.44428217,14 L5.60936009,14 C5.17227993,14 4.80359906,13.6714056 4.74938593,13.2335304 L4.64135717,12.3609904 C3.90724423,12.0977834 3.2365008,11.6829277 2.67024895,11.1457667 L2.32436269,11.3304698 C1.937997,11.5367889 1.45992509,11.4203533 1.2092262,11.0588755 L0.156758136,9.54134266 C-0.0939407485,9.1798649 -0.0388021564,8.68648132 0.285372795,8.39049061 L0.946956316,7.78642613 C0.911435904,7.52733788 0.893487799,7.26476096 0.893487799,7 C0.893487799,6.47281179 0.964662258,5.95497741 1.10331166,5.45723898 L0.49060459,4.89780155 C0.166429639,4.60181085 0.111291047,4.10842726 0.361989932,3.7469495 L1.414458,2.22941664 C1.66515688,1.86793888 2.14322879,1.75150329 2.52959448,1.9578224 L3.27448878,2.35559563 C3.69499325,2.05492621 4.15465327,1.81349885 4.64135756,1.63900647 L4.74938593,0.766469607 Z"
              fillRule="nonzero">
            </path>
          </g>
        </g>
      </g>
    </g>
  </svg>

export const SetHomepageIcon = () =>
  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="15" viewBox="0 0 16 15">
    <path
      fill="none"
      stroke="#FFF"
      d="M4.86946163,14.1948523 L9.10668564,11.1817152 L9.39850538,11.3988834 L13.1263521,14.1816017 L11.7212806,9.40435842 L12.0043182,9.1967975 L15.9220904,6.33134281 L10.8449802,5.86978734 L10.7333272,5.57948954 L8.95112079,0.939924779 L7.0550198,5.86978734 L6.74526787,5.8979466 L1.88624492,6.33786926 L6.28136974,9.3953474 L6.17968275,9.74108316 L4.86946163,14.1948523 Z M13.2910569,14.7415979 C13.2924368,14.7730121 13.3015724,14.8065066 13.3203172,14.8410832 L13.2910569,14.7415979 Z M16.6073068,6.39363521 C16.6224886,6.39658393 16.6383197,6.39807708 16.6547321,6.3979466 L16.6073068,6.39363521 Z M4.6,14.5711678 C4.585369,14.5545925 4.56873075,14.5390481 4.55,14.525 C4.51063813,14.4954786 4.53173801,14.5 4.6,14.5 L4.6,14.5711678 Z"
      transform="translate(-1)" />
  </svg>

export const IsHomepageIcon = () =>
  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="15" viewBox="0 0 16 15">
    <path
      fill="#FFF"
      fillRule="evenodd"
      d="M4.6,15 C4.26666667,15 4.13333333,14.9 4.2,14.7 L5.7,9.6 L1.1,6.4 C0.9,6.2 1,5.9 1.2,5.9 L6.7,5.4 L8.7,0.2 C8.8,1.81840654e-13 9.1,1.81840654e-13 9.2,0.2 L11.2,5.4 L16.7,5.9 C16.9,5.9 17,6.2 16.8,6.3 L12.3,9.6 L13.8,14.7 C13.9,14.9 13.6,15.1 13.4,15 L9.1,11.8 Z"
      transform="translate(-1)" />
  </svg>

export const LogoutIcon = () =>
  <svg width="13px" height="16px" viewBox="0 0 13 16" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
      <g transform="translate(-1190.000000, -245.000000)" stroke="#161616">
        <g transform="translate(1190.000000, 246.000000)">
          <path
            d="M9.8,6.99669031 L0,6.99669031 M8.34443022,8.4 L9.8,7.00330969 L9.8,7.00330969 L8.34443022,5.6">
          </path>
          <path
            d="M2.1,5.09090909 L2.1,1.27272727 C2.1,0.569819409 2.68501459,1.41301112e-16 3.40666667,0 L10.5933333,0 C11.3149854,7.06505561e-17 11.9,0.569819409 11.9,1.27272727 L11.9,12.7272727 C11.9,13.4301806 11.3149854,14 10.5933333,14 L3.40666667,14 C2.68501459,14 2.1,13.4301806 2.1,12.7272727 L2.1,8.90909091" >
          </path>
        </g>
      </g>
    </g>
  </svg>

export const AboutIcon = () =>
  <svg width="14px" height="15px" viewBox="0 0 14 15" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g  stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
      <g transform="translate(-1218.000000, -62.000000)" fill="#161616">
        <g transform="translate(1217.500000, 49.000000)">
          <g transform="translate(0.500000, 13.500000)">
            <path
              d="M7,12.6875 C10.1411195,12.6875 12.6875,10.1411195 12.6875,7 C12.6875,3.85888049 10.1411195,1.3125 7,1.3125 C3.85888049,1.3125 1.3125,3.85888049 1.3125,7 C1.3125,10.1411195 3.85888049,12.6875 7,12.6875 Z M7,14 C3.13400675,14 0,10.8659932 0,7 C0,3.13400675 3.13400675,0 7,0 C10.8659932,0 14,3.13400675 14,7 C14,10.8659932 10.8659932,14 7,14 Z"
              fillRule="nonzero">
            </path>
            <polygon fillRule="nonzero" points="7.875 11.375 6.125 11.375 6.125 6.125 7.875 6.125"></polygon>
            <circle cx="7" cy="3.5" r="1"></circle>
          </g>
        </g>
      </g>
    </g>
  </svg>

export const DocIcon = () =>
  <svg width="12px" height="15px" viewBox="0 0 12 15" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g  stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
      <g transform="translate(-1219.000000, -102.000000)" fill="#161616">
        <g transform="translate(1217.500000, 49.000000)">
          <g transform="translate(1.500000, 53.500000)">
            <path
              d="M10.5813895,3.49615271 L8.01441679,1.25005156 L8.04015101,3.48926834 L10.5813895,3.49615271 Z M7.01005595,0.875 L1,0.875 L1,13.125 L11,13.125 L11,4.37229094 L8.03705496,4.36426415 C7.48990191,4.36278188 7.04570346,3.97680386 7.04020157,3.49806685 L7.01005595,0.875 Z M1,0 L8,0 L12,3.5 L12,13.125 C12,13.6082492 11.5522847,14 11,14 L1,14 C0.44771525,14 0,13.6082492 0,13.125 L0,0.875 C0,0.391750844 0.44771525,0 1,0 Z"
              fillRule="nonzero">
            </path>
            <rect fillRule="evenodd" x="3" y="7.875" width="6" height="1"></rect>
            <rect fillRule="evenodd" x="3" y="10.5" width="6" height="1"></rect>
          </g>
        </g>
      </g>
    </g>
  </svg>

export const GettingStartedIcon = () =>
  <svg width="15px" height="16px" viewBox="0 0 15 16" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g  stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
      <g transform="translate(-1217.000000, -141.000000)" stroke="#FFFFFF">
        <g transform="translate(1217.500000, 49.000000)">
          <g transform="translate(0.000000, 93.000000)">
            <path
              d="M2.13111111,8.05 L6.02,11.8766667 C11.0677778,7.77777778 14.2722222,3.98222222 13.5177778,0.427777778 C9.26333333,7.25530747e-14 5.68555556,3.58555556 2.13111111,8.05 Z" >
            </path>
            <path
              d="M2.13111111,8.05 L6.66133815e-14,7.65333333 L2.59,5.07888889 L4.92333333,4.81444444 C4.00555556,5.75555556 3.11111111,6.86 2.13111111,8.05 Z" >
            </path>
            <path
              d="M6.02777778,11.8766667 L6.43222222,14 L9.03,11.4411111 L9.33333333,8.97555556 C8.32222222,9.94 7.21777778,10.8888889 6.02777778,11.8766667 Z" >
            </path>
            <path
              d="M10.2977778,0.855555556 C10.4945398,2.34252978 11.7242658,3.47740994 13.2222222,3.55444444">
            </path>
            <circle
              cx="8.85111111"
              cy="5.09444444"
              r="1.10444444">
            </circle>
            <path
              d="M4.24666667,11.6044444 C3.29,13.6655556 0.0155555556,13.9377778 0.0155555556,13.9377778 C0.0155555556,13.9377778 0.28,10.6633333 2.34888889,9.70666667" >
            </path>
          </g>
        </g>
      </g>
    </g>
  </svg>

export const SupportIcon = () =>
  <svg width="15px" height="14px" viewBox="0 0 15 14" version="1.1" xmlns="http://www.w3.org/2000/svg">
    <g  stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
      <g transform="translate(-1217.000000, -184.000000)" fill="#FFFFFF" fillRule="nonzero">
        <g transform="translate(1217.500000, 49.000000)">
          <g transform="translate(0.000000, 135.000000)">
            <polygon points="2.62726722 7.02720116 2.62273278 6.15221291 7.87273278 6.12500587 7.87726722 6.99999413"></polygon>
            <polygon points="2.625 4.375 2.625 3.5 11.375 3.5 11.375 4.375"></polygon>
            <path
              d="M10.2483582,10.5 L6.87738818,13.9948143 L6.24761182,13.3873551 L9.87664183,9.625 L12.25,9.625 C12.7332492,9.625 13.125,9.23324916 13.125,8.75 L13.125,1.75 C13.125,1.26675084 12.7332492,0.875 12.25,0.875 L1.75,0.875 C1.26675084,0.875 0.875,1.26675084 0.875,1.75 L0.875,8.75 C0.875,9.23324916 1.26675084,9.625 1.75,9.625 L6.56427734,9.625 L6.56427734,10.5 L1.75,10.5 C0.783501688,10.5 1.65608268e-15,9.71649831 1.52655666e-15,8.75 L-2.22044605e-16,1.75 C-7.40148683e-16,0.783501688 0.783501688,-6.52256027e-15 1.75,-6.7168493e-15 L12.25,-7.10542736e-15 C13.2164983,-7.29971639e-15 14,0.783501688 14,1.75 L14,8.75 C14,9.71649831 13.2164983,10.5 12.25,10.5 L10.2483582,10.5 Z">
            </path>
          </g>
        </g>
      </g>
    </g>
  </svg>

export const LaunchIcon = (idPostfix) =>
  <svg width="13px" height="13px" viewBox="0 0 14 14" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlnsXlink="http://www.w3.org/1999/xlink">
    <g id={`Getting-Started-${JSON.stringify(idPostfix)}`} stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
      <g id={`01.01-Application-Switcher-${JSON.stringify(idPostfix)}`} transform="translate(-1015.000000, -124.000000)" fill="#737679" fillRule="nonzero">
        <g id={`Group-4-${JSON.stringify(idPostfix)}`} transform="translate(726.000000, 63.000000)">
          <g id={`Launch-icon-${JSON.stringify(idPostfix)}`} transform="translate(289.000000, 61.000000)">
            <path
              d="M11.8125,8.75 L10.9375,8.75 C10.6958754,8.75 10.5,8.94587542 10.5,9.1875 L10.5,12.25 L1.75,12.25 L1.75,3.5 L5.6875,3.5 C5.92912458,3.5 6.125,3.30412458 6.125,3.0625 L6.125,2.1875 C6.125,1.94587542 5.92912458,1.75 5.6875,1.75 L1.3125,1.75 C0.587626266,1.75 0,2.33762627 0,3.0625 L0,12.6875 C0,13.4123737 0.587626266,14 1.3125,14 L10.9375,14 C11.6623737,14 12.25,13.4123737 12.25,12.6875 L12.25,9.1875 C12.25,8.94587542 12.0541246,8.75 11.8125,8.75 Z M13.34375,0 L9.84375,0 C9.25941406,0 8.96738281,0.708476563 9.37890625,1.12109375 L10.3558984,2.09808594 L3.69140625,8.76011719 C3.56784235,8.88325279 3.49838875,9.05051778 3.49838875,9.22496094 C3.49838875,9.39940409 3.56784235,9.56666908 3.69140625,9.68980469 L4.31128906,10.3085938 C4.43442467,10.4321577 4.60168966,10.5016112 4.77613281,10.5016112 C4.95057597,10.5016112 5.11784096,10.4321577 5.24097656,10.3085938 L11.9021875,3.64546875 L12.8789062,4.62109375 C13.2890625,5.03125 14,4.74414063 14,4.15625 L14,0.65625 C14,0.293813133 13.7061869,0 13.34375,0 Z"
              id={`Shape-${JSON.stringify(idPostfix)}`}>
            </path>
          </g>
        </g>
      </g>
    </g>
  </svg>

export const OverflowDotsIcon = () =>
  <svg width="4px" height="18px" viewBox="0 0 4 18" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlnsXlink="http://www.w3.org/1999/xlink">
    <g id="Navigation-overflowIcon" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
      <g id="01.05-Navigation-768px" transform="translate(-730.000000, -29.000000)" fill="#FFFFFF">
        <g id="Actions-/-Navigation-/-overflow-menu--vertical-/-24" transform="translate(720.000000, 26.000000)">
          <path
            d="M12,6 C12.8284271,6 13.5,5.32842712 13.5,4.5 C13.5,3.67157288 12.8284271,3 12,3 C11.1715729,3 10.5,3.67157288 10.5,4.5 C10.5,5.32842712 11.1715729,6 12,6 Z M12,13.5 C12.8284271,13.5 13.5,12.8284271 13.5,12 C13.5,11.1715729 12.8284271,10.5 12,10.5 C11.1715729,10.5 10.5,11.1715729 10.5,12 C10.5,12.8284271 11.1715729,13.5 12,13.5 Z M12,21 C12.8284271,21 13.5,20.3284271 13.5,19.5 C13.5,18.6715729 12.8284271,18 12,18 C11.1715729,18 10.5,18.6715729 10.5,19.5 C10.5,20.3284271 11.1715729,21 12,21 Z"
            id="Fill-overflowIcon">
          </path>
        </g>
      </g>
    </g>
  </svg>

export const CurrentBrowserTabIcon = () =>
  <svg width="14px" height="12px" viewBox="0 0 14 12" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlnsXlink="http://www.w3.org/1999/xlink">
    <g id="Navigation-currTabIcon" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
      <g id="01.04-Navigation-VWT-currTabIcon" transform="translate(-1002.000000, -125.000000)" fill="#161616">
        <g id="Actions-/-Controls-/-open-panel--top-/-16" transform="translate(1001.000000, 123.000000)">
          <path
            d="M14,2 L2,2 C1.44771525,2 1,2.44771525 1,3 L1,13 C1,13.5522847 1.44771525,14 2,14 L14,14 C14.5522847,14 15,13.5522847 15,13 L15,3 C15,2.44771525 14.5522847,2 14,2 Z M14,3 L14,6 L2,6 L2,3 L14,3 Z M2,13 L2,7 L14,7 L14,13 L2,13 Z"
            id="Fill-currTabIcon">
          </path>
        </g>
      </g>
    </g>
  </svg>

export const NewBrowserTabIcon = () =>
  <svg width="14px" height="13px" viewBox="0 0 14 13" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlnsXlink="http://www.w3.org/1999/xlink">
    <g id="Navigation-newTabIcon" stroke="none" strokeWidth="1" fill="none" fillRule="evenodd">
      <g id="01.04-Navigation-VWT-newTabIcon" transform="translate(-1002.000000, -166.000000)" fill="#161616">
        <g id="Organization-/-File-/-document-/-16-Copy-3" transform="translate(1002.000000, 166.000000)">
          <path
            d="M12,8 L11,8 L11,10 L9,10 L9,11 L11,11 L11,13 L12,13 L12,11 L14,11 L14,10 L12,10 L12,8 Z M13,0 L1,0 C0.4,0 0,0.4 0,1 L0,11 C0,11.6 0.4,12 1,12 L7,12 L7,11 L1,11 L1,3 L1,2.44056168 L1,2 L1,1 L13,1 L13,7 L14,7 L14,1 C14,0.4 13.6,0 13,0 Z M1,4 L13,4 L13,5 L1,5 L1,4 Z M6.5,1 L7.5,1 L7.5,4 L6.5,4 L6.5,1 Z"
            id="Fill-newTabIcon">
          </path>
        </g>
      </g>
    </g>
  </svg>
