/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

import React from 'react'
import { connect } from 'react-redux'
import ResourceModal from '../modals/ResourceModal'
import AboutModal from '../modals/AboutModal'
import PropTypes from 'prop-types'

class Modal extends React.PureComponent {

  componentDidUpdate(prevProps) {
    if (prevProps.open && !this.props.open) {
      document.body.classList.remove('bx--body--with-modal-open')
    }
  }

  render() {
    const { type, open } = this.props
    switch (type) {
    case 'resource':
      return open && getResourceModal(this.props)
    case 'about-window':
      return open && getAboutModal(this.props)
    default:
      return null
    }
  }
}

const getResourceModal = props => {
  return getModal(ResourceModal, props)
}

const getAboutModal = props => {
  return getModal(AboutModal, props)
}

const getModal = (Component, props) => <Component {...props} />

const mapStateToProps = state => state.modal

Modal.propTypes = {
  open: PropTypes.bool,
  type: PropTypes.string,
}

export default connect(mapStateToProps)(Modal)
