/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
import React from 'react'
import { hydrate } from 'react-dom'
import { Provider } from 'react-redux'
import thunkMiddleware from 'redux-thunk'
import { createLogger } from 'redux-logger'
import { createStore, combineReducers, applyMiddleware, compose } from 'redux'
import { Router } from 'react-router-dom'
import { createBrowserHistory } from 'history'
import HeaderContainer from './containers/HeaderContainer'
import { user, loggedIn } from './reducers/user'
import { uiconfig } from './reducers/uiconfig'
import { namespaces } from './reducers/namespaces'
import { modal } from './reducers/modal'
import { nav } from './reducers/nav'
import { logo } from './reducers/logo'
import { doc } from './reducers/doc'
import { support } from './reducers/support'
import { about } from './reducers/about'
import { experience } from './reducers/experience'
import { oauthInfo } from './reducers/oauthInfo'

const composeEnhancers = window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || compose

window.SHARED_HISTORY = window.SHARED_HISTORY ? window.SHARED_HISTORY : createBrowserHistory()

const loggerMiddleware = createLogger()
// Grab the state from a global variable injected into the server-generated HTML
const preloadedState = window.__PRELOADED_STATE__

const middleware = [thunkMiddleware] // lets us dispatch() functions
if (!window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__) {
  middleware.push(loggerMiddleware) // middleware that logs actions
}

// Allow the passed state to be garbage-collected
delete window.__PRELOADED_STATE__

// Create Redux store with initial state
const store = createStore(combineReducers({
  user, loggedIn, modal, uiconfig, namespaces, nav, logo, doc, support, about, experience, oauthInfo
}), preloadedState, composeEnhancers(
  applyMiddleware(...middleware)
))

hydrate(
  <Provider store={store}>
    <Router history={window.SHARED_HISTORY}>
      <HeaderContainer />
    </Router>
  </Provider>, document.getElementById('header')
)
