/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
import React from 'react'
import { hydrate } from 'react-dom'
import { Provider } from 'react-redux'
import thunkMiddleware from 'redux-thunk'
import { createLogger } from 'redux-logger'
import { createStore, combineReducers, applyMiddleware, compose } from 'redux'
import { Router } from 'react-router-dom'
import ScrollToTop from './components/common/ScrollToTop'
import * as reducers from './reducers'
import config from '../lib/shared/config'
import { createBrowserHistory } from 'history'
import { WelcomeStatic } from './containers/WelcomeStatic'

const composeEnhancers = window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || compose

window.SHARED_HISTORY = window.SHARED_HISTORY ? window.SHARED_HISTORY : createBrowserHistory()

const loggerMiddleware = createLogger()
// Grab the state from a global variable injected into the server-generated HTML
const preloadedState = window.PLATFORM__PRELOADED_STATE__

const middleware = [thunkMiddleware] // lets us dispatch() functions
if (!window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ && config['featureFlags:reduxLogger']) {
  middleware.push(loggerMiddleware) // middleware that logs actions
}

// Allow the passed state to be garbage-collected
delete window.PLATFORM__PRELOADED_STATE__

// Create Redux store with initial state
const store = createStore(combineReducers(reducers), preloadedState, composeEnhancers(
  applyMiddleware(...middleware)
))

hydrate(
  <Provider store={store}>
    <Router history={window.SHARED_HISTORY}>
      <ScrollToTop>
        <WelcomeStatic></WelcomeStatic>
      </ScrollToTop>
    </Router>
  </Provider>, document.getElementById('page')
)
