
/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */

/*
Since these selectors are common (i.e used across different components and different parts of the store)
we have to create unique selectors each invocation and the selectors need additional metata data sent
though props that indicate which part of the store it should select from.

//See https://github.com/reactjs/reselect#sharing-selectors-with-props-across-multiple-components
//See https://github.com/reactjs/reselect#q-can-i-share-a-selector-across-multiple-components

*/

import { SECONDARY_HEADER_UPDATE, TOAST_NOTIFICATION_UPDATE, SECONDARY_HEADER_UPDATE_CLASSES } from '../actions'

export const secondaryHeader = (state = {title: '', tabs: [], breadcrumbItems: [], links: [], actions: undefined, showToast: false, toastData: {}}, action) => {
  switch (action.type) {
  case SECONDARY_HEADER_UPDATE:
    return Object.assign({}, state, {
      title: action.title,
      tabs: action.tabs,
      breadcrumbItems: action.breadcrumbItems,
      links: action.links,
      actions: action.actions
    })
  case TOAST_NOTIFICATION_UPDATE:
    return Object.assign({}, state, {
      showToast: action.showToast,
      toastData: action.toastData
    })
  default:
    return state
  }
}

export const secondaryHeaderClasses = (state  = {headerClasses: ''}, action) => {
  switch (action.type){
  case SECONDARY_HEADER_UPDATE_CLASSES:
    return Object.assign({}, state, {
      headerClasses: action.headerClasses
    })
  default:
    return state
  }
}
