/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
/*
 *
 * Things you should never do inside a reducer:
 *
 * - Mutate its arguments
 * - Perform side effects like API calls and routing transitions
 * - Call non-pure functions, e.g. Date.now() or Math.random()
 *
 * Reducers must be deterministic pure functions.  Given the same arguments, it should calculate the next state and return it.
 * No surprises. No side effects. No API calls. No mutations. Just a calculation.
 *
 * Selectors should sit along side reducers.
 */

import _ from 'lodash'

export { user, loggedIn } from './user'
export { secondaryHeader, secondaryHeaderClasses } from './common'

export { uiconfig } from './uiconfig'
export { namespaces } from './namespaces'
export { nav } from './nav'

export { modal } from './modal'
export { experience } from './experience'

export function predicate(resourceType, action) {
  if (_.isEqual(resourceType, action.resourceType)) {
    return true
  }
  return _.find(_.values(resourceType), type => type.indexOf(action.resourceType) > -1) || null
}
