/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
import {
  NAMESPACES_RECEIVE_SUCCESS,
  NAMESPACES_RECEIVE_FAILURE,
  REQUEST_STATUS,
  SWITCH_NAMESPACE
} from '../actions'

export const namespaces = (state = null, action) => {
  switch (action.type) {
  case NAMESPACES_RECEIVE_SUCCESS:
    return { ...action, status: REQUEST_STATUS.DONE }
  case NAMESPACES_RECEIVE_FAILURE:
    return { ...state,
      status: REQUEST_STATUS.ERROR,
      errorMessage: action.err && action.err.details,
      statusCode: action.err && action.err.statusCode }
  case SWITCH_NAMESPACE:
    return { ...state, ...action }
  default:
    return state
  }
}
