/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
import {
  NAV_RECEIVE_SUCCESS,
  REQUEST_STATUS,
  NAV_MODIFY
} from '../actions'
import _ from 'lodash'

export const nav = (state = null, action) => {
  let navItems, secondaryNavItems
  switch (action.type) {
  case NAV_RECEIVE_SUCCESS:
    return { ...action, status: REQUEST_STATUS.DONE }
  case NAV_MODIFY:
    navItems = modifyLeftNav(state, action, 'navItems')
    secondaryNavItems = updateSecondaryNav(state.secondaryNavItems, action)
    return { navItems, secondaryNavItems }
  default:
    return state
  }
}

const updateSecondaryNav = (navItems, action) =>{
  navItems.map(item => {
    item.navItems = modifyLeftNav(item, action, 'navItems')
  })
  return navItems
}
const modifyLeftNav = (state, action, key) => {
  const route = state[key] && state[key].find(item => (item.id === action.route || item.id === 'administer'))
  let navItems
  if (!route) {
    return state
  }
  const allowedRoles = action.roles && action.roles.split(',')
  const index = _.findIndex(route.subItems, item => item.id === action.id)
  action.enabled ?
    index === -1 && route.subItems.push({
      id: action.id,
      label: action.displayName,
      url: action.url,
      serviceId: action.chart,
      external: true,
      target: action.target,
      disabled: !(allowedRoles &&
        allowedRoles.find(role =>
          role.toLowerCase() === (action.currentRole && action.currentRole.toLowerCase()))
          && action.namespaces
          && action.namespaces.find(namespace => namespace.Name === action.namespace)
      )
    }) : index > -1 && route.subItems.splice(index, 1)
  navItems = state[key].splice(0)
  navItems = navItems.map(navItem => {
    if (navItem.id === action.id) {
      navItem = route
    }
    return navItem
  })
  return navItems
}

