/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
import {
  OAUTH_INFO_RECEIVE_SUCCESS,
  OAUTH_INFO_RECEIVE_FAILURE,
  REQUEST_STATUS
} from '../actions'

export const oauthInfo = (state = null, action) => {
  switch (action.type) {
  case OAUTH_INFO_RECEIVE_SUCCESS:
    return {
      ...action.oauthInfo,
      status: REQUEST_STATUS.DONE
    }
  case OAUTH_INFO_RECEIVE_FAILURE:
    return {
      ...state,
      status: REQUEST_STATUS.ERROR,
      errorMessage: action.err && action.err.details,
      statusCode: action.err && action.err.statusCode
    }
  default:
    return state
  }
}
