/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

import { leftNavKeyboard, navModalKeyboard, secondaryNavKeyboard } from './keyboard'

const handleKeyboardEvent = (e, data, context) => {
  switch(context) {
  case 'left-nav':
    leftNavKeyboard(e, data)
    break
  case 'secondary-nav':
    secondaryNavKeyboard(e, data)
    break
  case 'nav-modal':
    navModalKeyboard(e, data)
    break
  }
}

export default handleKeyboardEvent
