/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

import React from 'react'
import { Button } from 'carbon-components-react'

const createButton = (title, onClick) =>
  <Button onClick={onClick}>
    {title}
  </Button>

const hasService = (navRoutes, serviceName) => {
  const platformRoutes = navRoutes.find(navRoute => navRoute.id === 'platform')
  const serviceRoute = platformRoutes &&
    platformRoutes.subItems.find(platformRoute => serviceName.includes(platformRoute.id))
  return serviceRoute && !serviceRoute.disabled
}

const parseQueryParams = query => {
  const params = {}
  query.replace(/[?&]+([^=&]+)=([^&]*)/gi, (m, key, value) => params[key] = value)
  return params
}

const envIsDevelopment = process.env.NODE_ENV === 'development'

export { createButton, hasService, parseQueryParams, envIsDevelopment }

