/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

export const leftNavKeyboard = (e, data) => {
  e.persist()
  e.preventDefault()
  e.stopPropagation()

  const { primary, handleMenuClick, leftNav, secondaryNav } = data
  const click = new MouseEvent('click', { 'bubbles': true, 'cancelable': true })

  switch(e.which) {
  case 9:  // tab
  case 27:  // esc
    handleMenuClick()
    break

  case 32:  // space
  case 13:  // enter
    e.target.dispatchEvent(click)
    break

  case 39:  // right
    e.target.className.includes('primary-nav-item') && secondaryNav.focus()
    break

  case 38:  // up
    for (let i = primary.length - 1; i > 0; i--) {
      if (primary[i] === e.target) {
        primary[i - 1].focus()
        break
      }
    }
    break

  case 40: // down
    if (e.target.id === leftNav.id) {
      primary[0].focus()
      return
    }

    for (let i = 0; i < primary.length - 1; i++) {
      if (primary[i] === e.target) {
        primary[i + 1].focus()
        break
      }
    }
    break

  case 36:  // home
    primary[0].focus()
    break

  case 35:  // end
    primary[primary.length - 1].focus()
    break
  }
}
