/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

export const navModalKeyboard = (e, data) => {
  e.persist()
  e.stopPropagation()

  const { menuItems, fields, active } = data
  const click = new MouseEvent('click', { 'bubbles': true, 'cancelable': true })

  if (e.target.className === 'menu-item') {
    e.preventDefault()

    switch(e.which) {
    case 40:  // down
      for (let i = 0; i < menuItems.length - 1; i++) {
        if (e.target === menuItems[i]) {
          menuItems[i + 1].focus()
          break
        }
      }
      break

    case 38:  // up
      for (let i = menuItems.length - 1; i > 0; i--) {
        if (e.target === menuItems[i]) {
          menuItems[i - 1].focus()
          break
        }
      }
      break

    case 9:  // tab
    case 39:  // right
      fields[0].focus()
      break

    case 32:  // space
    case 13:  // enter
      e.target.dispatchEvent(click)
      break

    case 36:  // home
      menuItems[0].focus()
      break

    case 35:  // end
      menuItems[menuItems.length - 1].focus()
      break
    }
  } else {
    switch(e.which) {
    case 37:  // left
      active.focus()
      break

    case 36:  // home
      fields[0].focus()
      break

    case 35:  // end
      fields[fields.length - 1].focus()
    }
  }
}
