/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

export const secondaryNavKeyboard = (e, data) => {
  e.persist()
  e.preventDefault()
  e.stopPropagation()

  const { primary, secondary, opened, handleMenuClick, secondaryNav } = data
  const click = new MouseEvent('click', { 'bubbles': true, 'cancelable': true })

  switch(e.which) {
  case 9:  // tab
  case 27:  // esc
    handleMenuClick()
    break

  case 32:  // space
  case 13:  // enter
    e.target.dispatchEvent(click)
    break

  case 37:  // left
    primary[opened].focus()
    break

  case 38:  // up
    for (let i = secondary.length - 1; i > 0; i--) {
      if (secondary[i] === e.target) {
        secondary[i - 1].focus()
        break
      }
    }
    break

  case 40: // down
    if (e.target.id === secondaryNav.id) {
      secondary[0].focus()
      return
    }

    for (let i = 0; i < secondary.length - 1; i++) {
      if (secondary[i] === e.target) {
        secondary[i + 1].focus()
        break
      }
    }
    break

  case 36:  // home
    secondary[0].focus()
    break

  case 35:  // end
    secondary[secondary.length - 1].focus()
    break
  }
}
