/* Copyright (c) 2020 Red Hat, Inc. */

const fs = require('fs')
const path = require('path')

const config = require('../../../config')

let page

module.exports = {
  '@disabled': false,

  before: (browser) => {
    const loginPage = browser.page.LoginPage()
    loginPage.navigate()
    loginPage.authenticate()
  
    const url = `${browser.launch_url}${config.get('headerContextPath')}`
    page = browser.page.HeaderPage()
    page.navigate(url)
  },

  'Welcome page: ensure page is loading': (browser) => {
    page.waitForHeader()
    page.verifyWelcomePage(browser)
  },

  'Header: ensure header is loaded correctly': (browser) => {
    page.waitForHeader()
    page.verifyLeftNavigation()
    page.verifyACMApps()
    page.verifySearch()
    page.verifyCreateResource()
    page.verifyKUI()
    page.verifyAbout()
    page.verifyConfigureClient()
  },
}
