/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

import { namespacesReceiveSuccess, namespacesReceiveFailure, switchNamespace } from '../../../src-web/actions/namespaces'
import * as Actions from '../../../src-web/actions/index'

const NAMESPACE = {
  defaultNamespace: 'default',
  selectedNamespaces: 'default'
}

const NAMESPACE_LIST = [
  { Name: 'default', actions: 'CRUD', crn: 'crn:v1:icp:private:k8:mycluster:n/default:::'},
  { Name: 'platform', actions: 'CRUD', crn: 'crn:v1:icp:private:k8:mycluster:n/platform:::'}
]

describe('Namespace actions', () => {
  describe('#switchNamespace', () => {
    it('should create an action to change namespace', () => {
      const expectedAction = {
        type: Actions.SWITCH_NAMESPACE,
        ...NAMESPACE
      }
      expect(switchNamespace(NAMESPACE)).toEqual(expectedAction)
    })
  })
  describe('#namespaceReceiveSuccess', () => {
    it('should create an action on success', () => {
      const expectedAction = {
        type: Actions.NAMESPACES_RECEIVE_SUCCESS,
        namespaces: NAMESPACE_LIST,
        defaultNamespace: NAMESPACE_LIST[1].Name,
        selectedNamespaces: NAMESPACE_LIST.map(item => item.Name).toString()
      }
      expect(namespacesReceiveSuccess(NAMESPACE_LIST)).toEqual(expectedAction)
    })
  })
  describe('#namespaceReceiveFailure', () => {
    it('should create an action on failure', () => {
      const ERROR = { message: 'Internal server error' }
      const expectedAction = {
        type: Actions.NAMESPACES_RECEIVE_FAILURE,
        err: ERROR
      }
      expect(namespacesReceiveFailure(ERROR)).toEqual(expectedAction)
    })
  })
})
