/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

import { navReceiveSuccess, updateNav } from '../../../src-web/actions/nav'
import * as Actions from '../../../src-web/actions/index'

const NAV_LIST = [
  { id: 'dashboard', disabled: false, external: false, label: 'Dashboard', serviceId: 'platform-ui', url: '/console/dashboard' },
  { id: 'welcome', disabled: false, external: false, label: 'Getting started', serviceId: 'platform-ui', url: '/console/welcome'}
]

const NAV_ITEM = {
  chart: 'chart-name',
  displayName: 'Display name',
  enabled: false,
  external: true,
  id: 'nav-id',
  namespace: 'default',
  route: 'workloads',
  roles: 'ClusterAdministrator',
  url: [ 'http://test.com' ]
}

const ROLE = 'ClusterAdministrator'

const NAMESPACE_LIST = [
  { Name: 'default', actions: 'CRUD', crn: 'crn:v1:icp:private:k8:mycluster:n/default:::'},
  { Name: 'platform', actions: 'CRUD', crn: 'crn:v1:icp:private:k8:mycluster:n/platform:::'}
]

describe('Nav actions', () => {
  describe('#navReceiveSuccess', () => {
    it('should create an action on success', () => {
      const expectedAction = {
        type: Actions.NAV_RECEIVE_SUCCESS,
        navItems: NAV_LIST
      }
      expect(navReceiveSuccess(NAV_LIST)).toEqual(expectedAction)
    })
  })
  describe('#updateNav', () => {
    it('should create an action to update navigation', () => {
      const expectedAction = {
        type: Actions.NAV_MODIFY,
        ...NAV_ITEM,
        ...ROLE,
        ...NAMESPACE_LIST
      }
      expect(updateNav(NAV_ITEM, ROLE, NAMESPACE_LIST)).toEqual(expectedAction)
    })
  })
})
