/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

import { roleReceiveSuccess, roleReceiveFailure} from '../../../src-web/actions/role'
import * as Actions from '../../../src-web/actions/index'

const ROLE = 'ClusterAdministrator'

describe('Role actions', () => {
  describe('#roleReceiveSuccess', () => {
    it('should create an action on success', () => {
      const expectedAction = {
        type: Actions.ROLE_RECEIVE_SUCCESS,
        role: ROLE
      }
      expect(roleReceiveSuccess(ROLE)).toEqual(expectedAction)
    })
  })
  describe('#roleReceiveFailure', () => {
    it('should create an action on failure', () => {
      const ERROR = { message: 'Internal server error' }
      const expectedAction = {
        type: Actions.ROLE_RECEIVE_FAILURE,
        err: ERROR
      }
      expect(roleReceiveFailure(ERROR)).toEqual(expectedAction)
    })
  })
})
