/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

export const msgs = {
  'action': 'Action',
  'active': 'Active',
  'allocation': 'Allocation',
  'available': 'available',
  'unavailable': 'unavailable',
  'available.uppercase': 'Available',
  'yearAgo': '1 year ago',
  'yearsAgo': '{0} years ago',
  'monthAgo': '1 month ago',
  'monthsAgo': '{0} months ago',
  'dayAgo': '1 day ago',
  'daysAgo': '{0} days ago',
  'hourAgo': '1 hour ago',
  'hoursAgo': '{0} hours ago',
  'minuteAgo': '1 minute ago',
  'minutesAgo': '{0} minutes ago',
  'bytes': 'bytes',
  'annotation': 'Annotation',
  'button.configmap.create': 'Create ConfigMap',
  'button.cronjobs.create': 'Create CronJob',
  'button.daemonset.create': 'Create DaemonSet',
  'button.deployment.create': 'Create Deployment',
  'button.group.import': 'Import group',
  'button.ingress.create': 'Create Ingress',
  'button.jobs.create': 'Create Job',
  'button.namespace.create': 'Create Namespace',
  'button.networkpolicy.create': 'Create NetworkPolicy',
  'button.persistentVolume.create': 'Create PersistentVolume',
  'button.persistentVolumeClaim.create': 'Create PersistentVolumeClaim',
  'button.policy.create': 'Create Policy',
  'button.resourceQuota.create': 'Create ResourceQuota',
  'button.service.create': 'Create Service',
  'button.statefulset.create': 'Create StatefulSet',
  'button.team.create': 'Create team',
  'button.teamresource.add': 'Add resource',
  'button.teamuser.add': 'Add user',
  'button.user.import': 'Import user',
  'button.secret.create': 'Create Secret',
  'carbon.table.toolbar.search.placeholder': 'Search',
  'carbon.table.toolbar.search.label': 'Filter table',
  'cli.description.details': 'The IBM Cloud Pak CLI provides the command line interface to manage applications, containers, infrastructures, services, and other resources.',
  'cli.description.title': 'What is it?',
  'cli.download.link.title': 'Download For',
  'cli.install.description': 'You can download the installer for macOS, Windows, and Linux. For installation instructions, see {0}.',
  'cli.install.link': 'Installing the IBM® Cloud Pak CLI',
  'cli.install.title': 'Install CLI and plug-ins',
  'cli.links.linux-386': 'Linux (32-bit)',
  'cli.links.linux-amd64': 'Linux (64-bit)',
  'cli.links.linux-ppc64le': 'Linux (ppc64le)',
  'cli.links.osx': 'Mac OS X',
  'cli.links.win-386': 'Windows (32-bit)',
  'cli.links.win-amd64': 'Windows (64-bit)',
  'cli.usage.description': 'After you install the CLI, you can use it from your command line by typing {0}. For command details, see {1}.',
  'cli.usage.link': 'IBM® Cloud Pak CLI command reference',
  'cli.usage.title': 'Use the IBM Cloud Pak CLI',
  'command.subTitle': 'Copy to retrieve data on screen',
  'command.title': 'Command line',
  'command.toggle': 'Toggle whether to show or hide the kubernetes command assistance',
  'command.button.label': 'Command assistance button',
  'common.app.name': 'IBM Cloud Pak',
  'configmap.details': 'ConfigMap details',
  'container.details': 'Container details',
  'creationTime': 'Creation time',
  'cronjob.details': 'CronJob details',
  'current': 'Current',
  'daemonset.details': 'DaemonSet details',
  'dashboard.module.cpu': 'CPU',
  'dashboard.module.deployments': 'Deployments',
  'dashboard.module.deployments.notfound': 'No deployments configured',
  'dashboard.module.gpu': 'GPU',
  'dashboard.module.memory': 'Memory',
  'dashboard.module.nodes': 'Nodes',
  'dashboard.module.nodes.notfound': 'No nodes configured',
  'dashboard.module.storage': 'Shared Storage',
  'dashboard.module.storage.notfound': 'No storage configured',
  'dashboard.section.resource-overview': 'Resource Overview',
  'dashboard.section.system-overview': 'System Overview',
  'deployment.details': 'Deployment details',
  'description.title.accessModes': 'Access modes',
  'description.title.active': 'Active',
  'description.title.address': 'Address',
  'description.title.annotations': 'Annotations',
  'description.title.apply': 'Apply to',
  'description.title.available': 'Number of nodes scheduled with available pods',
  'description.title.capacity': 'Capacity',
  'description.title.claim': 'Claim',
  'description.title.clusterIp': 'Cluster IP',
  'description.title.command': 'Command',
  'description.title.completions': 'Completions',
  'description.title.containerId': 'Container ID',
  'description.title.cpu': 'CPU',
  'description.title.cpu.current': 'Current CPU% utilization',
  'description.title.cpu.limits': 'CPU Limits',
  'description.title.cpu.request': 'CPU Request',
  'description.title.cpu.target': 'Target CPU% utilization',
  'description.title.creation': 'Creation time',
  'description.title.current': 'Current number of nodes scheduled',
  'description.title.data': 'Data',
  'description.title.deadline': 'Starting deadline seconds',
  'description.title.desired': 'Desired number of nodes scheduled',
  'description.title.endpoint': 'Endpoint',
  'description.title.env': 'Environment variables',
  'description.title.fromNamespace': 'From namespace',
  'description.title.fromPod': 'From pod',
  'description.title.gpu.limits': 'GPU Limits',
  'description.title.hostname': 'Hostname',
  'description.title.image': 'Image',
  'description.title.imageId': 'Image ID',
  'description.title.imagePullPolicy': 'Image pull policy',
  'description.title.images': 'Images',
  'description.title.ingressIp': 'Ingress IP',
  'description.title.ip': 'IP',
  'description.title.jobs.active': 'Active Jobs',
  'description.title.labels': 'Labels',
  'description.title.last.schedule': 'Last schedule time',
  'description.title.memory': 'Memory',
  'description.title.memory.limits': 'Memory Limits',
  'description.title.memory.request': 'Memory Request',
  'description.title.misscheduled': 'Number of nodes misscheduled',
  'description.title.name': 'Name',
  'description.title.namespace': 'Namespace',
  'description.title.node': 'Node',
  'description.title.nodeSelector': 'Node selector',
  'description.title.owner': 'Owner',
  'description.title.parallelism': 'Parallelism',
  'description.title.persistentVolume': 'PersistentVolume',
  'description.title.podSecurity': 'PodSecurityPolicy applied',
  'description.title.policy.concurrency': 'Concurrency policy',
  'description.title.policy.restart': 'Restart policy',
  'description.title.port': 'Port',
  'description.title.port.node': 'Node port',
  'description.title.ports': 'Ports',
  'description.title.privileged': 'Privileged',
  'description.title.ready': 'Ready',
  'description.title.reclaimPolicy': 'Reclaim policy',
  'description.title.reference': 'Target reference',
  'description.title.replicas': 'Replicas',
  'description.title.replicas.current': 'Current replicas',
  'description.title.replicas.desired': 'Desired replicas',
  'description.title.replicas.max': 'Max replicas',
  'description.title.replicas.min': 'Min replicas',
  'description.title.resourceLimits': 'Resource limits',
  'description.title.resourceRequests': 'Resource requests',
  'description.title.resources': 'Resources',
  'description.title.restartCount': 'Restart count',
  'description.title.schedule': 'Schedule',
  'description.title.scope': 'Scope',
  'description.title.seconds': 'MinReadySeconds',
  'description.title.selector': 'Selector',
  'description.title.service': 'Service',
  'description.title.session.affinity': 'Session affinity',
  'description.title.state': 'State',
  'description.title.status': 'Status',
  'description.title.succeeded': 'Succeeded',
  'description.title.suspend': 'Suspend',
  'description.title.tags': 'Tags',
  'description.title.time': 'Start time',
  'description.title.type': 'Type',
  'description.title.uid': 'Uid',
  'description.title.unschedulable': 'Unschedulable',
  'description.title.update': 'RollingUpdateStrategy',
  'description.title.updateStrategy': 'Update strategy',
  'description.title.upToDate': 'Number of nodes scheduled with Up-to-date pods',
  'description.title.users': 'Users',
  'description.title.volumeMounts': 'Volume mounts',
  'desired': 'Desired',
  'detail': 'Detail',
  'error.default.description': 'An unexpected error occurred. Please try again.',
  'error.nonamespace.description': 'You are not assigned to a namespace. Contact your administrator.',
  'error.unauthorized.description': 'You are unauthorized to view this page.',
  'error.notfound.description': '{0} not found.',
  'expose.details': 'Expose details',
  'failed': 'Failed',
  'false': 'False',
  'formaction.addAnnotations': 'Add annotations',
  'formaction.addArgument': 'Add argument',
  'formaction.addCommand': 'Add command',
  'formaction.addData': 'Add data',
  'formaction.addEnvVar': 'Add environment variable',
  'formaction.addFromPod': 'From Pod',
  'formaction.addFromSelector': 'From Namespace',
  'formaction.addLabel': 'Add label',
  'formaction.addParameter': 'Add parameter',
  'formaction.addPort': 'Add port',
  'formaction.addRules': 'Add rules',
  'formaction.addSelector': 'Add selector',
  'formaction.addUser': 'Add user',
  'formaction.addVolume': 'Add volume',
  'formfield.accessMode': 'Access mode',
  'formfield.accessMode.readOnlyMany': 'Read only many',
  'formfield.accessMode.readWriteMany': 'Read write many',
  'formfield.accessMode.readWriteOnce': 'Read write once',
  'formfield.argument': 'Argument',
  'formfield.capacity': 'Capacity',
  'formfield.clusterIP': 'Cluster IP',
  'formfield.command': 'Command',
  'formfield.completions': 'Completions',
  'formfield.concurrencyPolicy': ' Concurrency policy',
  'formfield.concurrencyPolicy.allow': 'Allow',
  'formfield.concurrencyPolicy.forbid': 'Forbid',
  'formfield.concurrencyPolicy.replace': 'Replace',
  'formfield.configMap': 'ConfigMap',
  'formfield.containernetwork': 'Container network',
  'formfield.containernetwork.bridge': 'Bridge',
  'formfield.containernetwork.host': 'Host',
  'formfield.containerPort': 'Container Port',
  'formfield.cpu': 'CPU',
  'formfield.cpuLimit': 'CPU Limit',
  'formfield.cpuRequest': 'CPU Request',
  'formfield.crn': 'CRN',
  'formfield.deadline': 'Deadline',
  'formfield.gpu': 'GPU',
  'formfield.hostName': 'Hostname',
  'formfield.image': 'Image',
  'formfield.key': 'Key',
  'formfield.label': 'Label',
  'formfield.maxRep': 'Maximum replications',
  'formfield.memory': 'Mem',
  'formfield.memoryLimit': 'Memory Limit',
  'formfield.memoryRequest': 'Memory Request',
  'formfield.minRep': 'Minimum replications',
  'formfield.name': 'Name',
  'formfield.namespace': 'Namespace',
  'formfield.nodeSelectorLabel': 'Node label',
  'formfield.parallelism': 'Parallelism',
  'formfield.path': 'Path',
  'formfield.pod': 'Pod',
  'formfield.port': 'Port',
  'formfield.privileged': 'Privileged',
  'formfield.protocol': 'Protocol',
  'formfield.protocol.tcp': 'TCP',
  'formfield.protocol.udp': 'UDP',
  'formfield.pullpolicy': 'Image pull policy',
  'formfield.pullpolicy.always': 'Always',
  'formfield.pullpolicy.ifnotpresent': 'If not present',
  'formfield.pullpolicy.never': 'Never',
  'formfield.pullsecrets': 'Image Pull Secrets',
  'formfield.reclaimPolicy': 'Reclaim policy',
  'formfield.reclaimPolicy.delete': 'Delete',
  'formfield.reclaimPolicy.recycle': 'Recycle',
  'formfield.reclaimPolicy.retain': 'Retain',
  'formfield.replicas': 'Replicas',
  'formfield.restartPolicy': 'Restart policy',
  'formfield.restartPolicy.never': 'Never',
  'formfield.restartPolicy.onfailure': 'OnFailure',
  'formfield.role': 'Role',
  'formfield.role.administrator': 'Administrator',
  'formfield.role.editor': 'Editor',
  'formfield.role.operator': 'Operator',
  'formfield.role.viewer': 'Viewer',
  'formfield.scaleTarget': 'Scale target',
  'formfield.schedule': 'Schedule',
  'formfield.search.resources': 'Search resources',
  'formfield.search.users': 'Search users',
  'formfield.secret': 'Secret',
  'formfield.selector': 'Selector',
  'formfield.selectorLabel': 'Volume selector label',
  'formfield.service': 'Service',
  'formfield.serviceName': 'Service name',
  'formfield.servicePort': 'Service port',
  'formfield.sessionAffinity': 'Session affinity',
  'formfield.sessionAffinity.clientip': 'ClientIP',
  'formfield.sessionAffinity.none': 'None',
  'formfield.storage': 'Storage',
  'formfield.storageClassName': 'Storage class name',
  'formfield.storageRequests': 'Storage requests',
  'formfield.storageType': 'Storage type',
  'formfield.storageType.gluster': 'Gluster FS',
  'formfield.storageType.hostPath': 'Host path',
  'formfield.storageType.nfs': 'NFS',
  'formfield.storageType.vsphere': 'vSphere',
  'formfield.storageUnit': 'Unit',
  'formfield.storageUnit.gi': 'Gi',
  'formfield.storageUnit.mi': 'Mi',
  'formfield.targetCPU': 'Target CPU',
  'formfield.targetPort': 'TargetPort',
  'formfield.team.name': 'Team name',
  'formfield.team.placeholder': 'Enter team name',
  'formfield.teams.id': 'Team ID',
  'formfield.type': 'Type',
  'formfield.type.clusterip': 'ClusterIP',
  'formfield.type.nodeport': 'NodePort',
  'formfield.updateStrategy': 'Update strategy',
  'formfield.updateStrategy.delete': 'On delete',
  'formfield.updateStrategy.update': 'Rolling update',
  'formfield.usergroups.basedn': 'LDAP Connection Base DN',
  'formfield.usergroups.cn': 'Common Name (CN)',
  'formfield.usergroups.cn.placeholder': 'Enter CN, e.g. cn=name',
  'formfield.usergroups.ou': 'Organizational Unit (OU)',
  'formfield.usergroups.ou.placeholder': 'Enter OU, e.g. ou=member,ou=group',
  'formfield.usergroups.uid': 'User ID (UID)',
  'formfield.username': 'User name',
  'formfield.value': 'Value',
  'formfield.volume': 'Volume',
  'healthy': 'Healthy',
  'horizontalpodautoscaler.details': 'Policy details',
  'images.details': 'Image details',
  'inactive': 'Inactive',
  'ingress.details': 'Ingress details',
  'job.details': 'Job details',
  'secret.details': 'Secret details',
  'login.heading': 'IBM Cloud Pak',
  'max.surge': 'Max surge',
  'max.unavailable': 'Max unavailable',
  'modal.add-teamresource.409': 'The resource that you selected exists.',
  'modal.add-teamresource.500': 'Oops, something unexpected happened. Please retry.',
  'modal.add-teamresource.heading': 'Add resource',
  'modal.add-teamresource.list.label': 'Resource list',
  'modal.add-teamresource.search.label': 'User resource search',
  'modal.add-user.heading': 'Add User',
  'modal.add-user.search.label': 'Add team user search',
  'modal.button.add': 'Add',
  'modal.button.cancel': 'Cancel',
  'modal.button.create': 'Create',
  'modal.button.import': 'Import',
  'modal.button.submit': 'Submit',
  'modal.configure-client.description': 'Before you run commands in the kubectl command line interface for this cluster, you must configure the client.',
  'modal.configure-client.heading': 'Configure kubectl',
  'modal.configure-client.prerequisites': 'Prerequisites',
  'modal.configure-client.tool': 'Install the kubectl CLI',
  'modal.create-configmap.heading': 'Create ConfigMap',
  'modal.create-configmap.label': 'ConfigMap',
  'modal.create-cronjob.heading': 'Create CronJob',
  'modal.create-cronjob.label': 'CronJob',
  'modal.create-daemonset.heading': 'Create DaemonSet',
  'modal.create-daemonset.label': 'DaemonSet',
  'modal.create-deployment.heading': 'Create Deployment',
  'modal.create-deployment.label': 'Deployment',
  'modal.create-ingress.heading': 'Create Ingress',
  'modal.create-ingress.label': 'Ingress',
  'modal.create-job.heading': 'Create Job',
  'modal.create-job.label': 'Job',
  'modal.create-namespace.heading': 'Create Namespace',
  'modal.create-namespace.label': 'Namespace',
  'modal.create-networkpolicy.heading': 'Create NetworkPolicy',
  'modal.create-networkpolicy.label': 'NetworkPolicy',
  'modal.create-persistentVolume.heading': 'Create PersistentVolume',
  'modal.create-persistentVolume.label': 'PersistentVolume',
  'modal.create-persistentVolumeClaim.heading': 'Create PersistentVolumeClaim',
  'modal.create-persistentVolumeClaim.label': 'PersistentVolumeClaim',
  'modal.create-policy.heading': 'Create Policy',
  'modal.create-policy.label': 'Policy',
  'modal.create-resourceQuota.heading': 'Create ResourceQuota',
  'modal.create-resourceQuota.label': 'ResourceQuota',
  'modal.create-service.heading': 'Create Service',
  'modal.create-service.label': 'Service',
  'modal.create-statefulset.heading': 'Create StatefulSet',
  'modal.create-statefulset.label': 'StatefulSet',
  'modal.create-team.409': 'The team you are trying to create already exists. Please specify a different name.',
  'modal.create-team.422': 'One or more required fields was not provided. Please verify and retry.',
  'modal.create-team.500': 'Oops, something unexpected happened. Please retry.',
  'modal.create-team.heading': 'Create Team',
  'modal.create-team.label': 'Team',
  'modal.create-team.list.label': 'Team user list',
  'modal.create-team.search.label': 'Team user search',
  'modal.create-secret.label': 'Secret',
  'modal.create-secret.heading': 'Create Secret',
  'modal.edit-configmap.heading': 'Edit ConfigMap',
  'modal.edit-configmap.label': 'ConfigMap',
  'modal.edit-cronjob.heading': 'Edit CronJob',
  'modal.edit-cronjob.label': 'CronJob',
  'modal.edit-daemonset.heading': 'Edit DaemonSet',
  'modal.edit-daemonset.label': 'DaemonSet',
  'modal.edit-deployment.heading': 'Edit Deployment',
  'modal.edit-deployment.label': 'Deployment',
  'modal.edit-horizontalpodautoscaler.heading': 'Edit Policy',
  'modal.edit-horizontalpodautoscaler.label': 'Policy',
  'modal.edit-ingress.heading': 'Edit Ingress',
  'modal.edit-ingress.label': 'Ingress',
  'modal.edit-job.heading': 'Edit Job',
  'modal.edit-job.label': 'Job',
  'modal.edit-namespace.heading': 'Edit Namespace',
  'modal.edit-namespace.label': 'Namespace',
  'modal.edit-networkpolicy.heading': 'Edit NetworkPolicy',
  'modal.edit-networkpolicy.label': 'NetworkPolicy',
  'modal.edit-persistentVolume.heading': 'Edit PersistentVolume',
  'modal.edit-persistentVolume.label': 'PersistentVolume',
  'modal.edit-persistentVolumeClaim.heading': 'Edit PersistentVolumeClaim',
  'modal.edit-persistentVolumeClaim.label': 'PersistentVolumeClaim',
  'modal.edit-podsecuritypolicy.heading': 'Edit PodSecurityPolicy',
  'modal.edit-podsecuritypolicy.label': 'PodSecurityPolicy',
  'modal.edit-service.heading': 'Edit Service',
  'modal.edit-service.label': 'Service',
  'modal.edit-statefulset.heading': 'Edit StatefulSet',
  'modal.edit-statefulset.label': 'StatefulSet',
  'modal.edit-secret.label': 'Secret',
  'modal.edit-secret.heading': 'Edit Secret',
  'modal.import-group.heading': 'Import Group',
  'modal.import-group.label': 'group',
  'modal.import-user.heading': 'Import User',
  'modal.import-user.label': 'User',
  'modal.nav.annotations': 'Annotations',
  'modal.nav.applyTo': 'Apply to',
  'modal.nav.container-settings': 'Container settings',
  'modal.nav.env-vars': 'Environment variables',
  'modal.nav.from': 'From',
  'modal.nav.general': 'General',
  'modal.nav.labels': 'Labels',
  'modal.nav.node-selector': 'Node selector',
  'modal.nav.parameters': 'Parameters',
  'modal.nav.ports': 'Ports',
  'modal.nav.rules': 'Rules',
  'modal.nav.selectors': 'Selectors',
  'modal.nav.volumes': 'Volumes',
  'modal.nav.data': 'Data',
  'modal.remove-configmap.heading': 'Remove ConfigMap',
  'modal.remove-configmap.label': 'ConfigMap',
  'modal.remove-cronjob.heading': 'Remove CronJob',
  'modal.remove-cronjob.label': 'CronJob',
  'modal.remove-daemonset.heading': 'Remove DaemonSet',
  'modal.remove-daemonset.label': 'DaemonSet',
  'modal.remove-deployment.heading': 'Remove Deployment',
  'modal.remove-deployment.label': 'Deployment',
  'modal.remove-horizontalpodautoscaler.heading': 'Remove Policy',
  'modal.remove-horizontalpodautoscaler.label': 'Policy',
  'modal.remove-ingress.heading': 'Remove Ingress',
  'modal.remove-ingress.label': 'Ingress',
  'modal.remove-job.heading': 'Remove Job',
  'modal.remove-job.label': 'Job',
  'modal.remove-namespace.heading': 'Remove Namespace',
  'modal.remove-namespace.label': 'Namespace',
  'modal.remove-networkpolicy.heading': 'Remove NetworkPolicy',
  'modal.remove-networkpolicy.label': 'NetworkPolicy',
  'modal.remove-persistentvolume.heading': 'Remove PersistentVolume',
  'modal.remove-persistentvolume.label': 'PersistentVolume',
  'modal.remove-persistentvolumeclaim.heading': 'Remove PersistentVolumeClaim',
  'modal.remove-persistentvolumeclaim.label': 'PersistentVolumeClaim',
  'modal.remove-pod.heading': 'Remove Pod',
  'modal.remove-pod.label': 'Pod',
  'modal.remove-service.heading': 'Remove Service',
  'modal.remove-service.label': 'Service',
  'modal.remove-statefulset.heading': 'Remove StatefulSet',
  'modal.remove-statefulset.label': 'StatefulSet',
  'modal.remove-team.heading': 'Remove team',
  'modal.remove-team.label': 'Team',
  'modal.remove-teamresource.heading': 'Remove resource',
  'modal.remove-teamresource.label': 'Resource',
  'modal.remove-teamuser.heading': 'Remove user',
  'modal.remove-teamuser.label': 'User',
  'modal.remove-user.heading': 'Remove user',
  'modal.remove-user.label': 'User',
  'modal.remove-secret.label': 'Secret',
  'modal.remove-secret.heading': 'Remove Secret',
  'modal.remove.confirm': 'Removing {0} is irreversible. Are you sure you want to continue?',
  'modal.scale-deployment.heading': 'Scale Deployment',
  'modal.scale-deployment.label': 'Deployment',
  'modal.scale-job.heading': 'Scale Job',
  'modal.scale-job.label': 'Job',
  'modal.scale-statefulset.heading': 'Scale StatefulSet',
  'modal.scale-statefulset.label': 'StatefulSet',
  'modal.scale.confirm': 'How many instances do you want to scale to?',
  'modal.scale.instances': 'Instances:',
  'module.header.pods': 'Pods',
  'name': 'Name',
  'namespace': 'Namespace',
  'namespace.details': 'Namespace details',
  'networkpolicy.details': 'NetworkPolicy details',
  'no-resource.detail.addmoreteams': 'All available teams have been assigned to this service ID. Add more teams to your cluster to continue.',
  'no-resource.detail.apikey': 'Your service ID has not been assigned any API keys.',
  'no-resource.detail.accesspolicy': 'Your service ID has not been assigned any access policies.',
  'no-resource.detail.configmap': 'Your cluster has not been assigned any configuration maps.',
  'no-resource.detail.configmap-namespace': '{0} has not been assigned any configuration maps.',
  'no-resource.detail.cronjob': 'Your cluster has not been assigned any Cron jobs.',
  'no-resource.detail.cronjob-namespace': '{0} has not been assigned any Cron jobs.',
  'no-resource.detail.clusterservicebroker': 'Your cluster has not been assigned any service brokers.',
  'no-resource.detail.clusterserviceclass': '{0} does not have any associated cluster service classes.',
  'no-resource.detail.clusterserviceplan': '{0} does not have any associated cluster service plans.',
  'no-resource.detail.containers': '{0} does not have any associated containers.',
  'no-resource.detail.daemonset': 'Your cluster has not been assigned any daemon sets.',
  'no-resource.detail.daemonset-namespace': '{0} has not been assigned any daemon sets.',
  'no-resource.detail.deployment': 'Your cluster has not been assigned any deployments.',
  'no-resource.detail.deployment-namespace': '{0} has not been assigned any deployments.',
  'no-resource.detail.events': '{0} does not have any associated events.',
  'no-resource.detail.horizontalpodautoscaler': 'Your cluster has not been assigned any policies.',
  'no-resource.detail.horizontalpodautoscaler-namespace': '{0} has not been assigned any policies.',
  'no-resource.detail.image': 'Your cluster has not been assigned any container images.',
  'no-resource.detail.image-namespace': '{0} has not been assigned any container images.',
  'no-resource.detail.imagepolicies': 'Your cluster has not been assigned any image policies.',
  'no-resource.detail.imagepolicies-namespace': '{0} has not been assigned any image policies.',
  'no-resource.detail.ingress': 'Your cluster has not been assigned any ingresses.',
  'no-resource.detail.ingress-namespace': '{0} has not been assigned any ingresses.',
  'no-resource.detail.job': 'Your cluster has not been assigned any jobs.',
  'no-resource.detail.job-namespace': '{0} has not been assigned any jobs.',
  'no-resource.detail.ldap': 'It looks like you have not added an LDAP connection yet. Try adding one now.',
  'no-resource.detail.namespace': 'Your cluster has not been assigned any namespaces.',
  'no-resource.detail.namespace-namespace': '{0} has not been assigned any namespaces.',
  'no-resource.detail.networkpolicy': 'Your cluster has not been assigned any network policies.',
  'no-resource.detail.networkpolicy-namespace': '{0} has not been assigned any network policies.',
  'no-resource.detail.node': 'Your cluster has not been assigned any nodes.',
  'no-resource.detail.persistentvolume': 'Your cluster has not been assigned any persistent volumes.',
  'no-resource.detail.persistentvolumeclaim': 'Your cluster has not been assigned any persistent volume claims.',
  'no-resource.detail.persistentvolumeclaim-namespace': '{0} has not been assigned any persistent volume claims.',
  'no-resource.detail.pods': '{0} does not have any associated pods',
  'no-resource.detail.podsecuritypolicy': 'Your cluster has not been assigned any pod security policies.',
  'no-resource.detail.replicaset': 'Your cluster has not been assigned any replica sets.',
  'no-resource.detail.replicaset-namespace': '{0} has not been assigned any replica sets.',
  'no-resource.detail.resource': 'Your cluster has not been assigned any resources.',
  'no-resource.detail.resourcequota': 'Your cluster has not been assigned any resource quotas.',
  'no-resource.detail.resourcequota-namespace': '{0} has not been assigned any resource quotas.',
  'no-resource.detail.secret': 'Your cluster has not been assigned any secrets.',
  'no-resource.detail.secret-namespace': '{0} has not been assigned any secrets.',
  'no-resource.detail.service': 'Your cluster has not been assigned any services.',
  'no-resource.detail.service-namespace': '{0} has not been assigned any services.',
  'no-resource.detail.serviceid': 'Your cluster has not been assigned any service IDs.',
  'no-resource.detail.serviceid-namespace': '{0} has not been assigned any service IDs.',
  'no-resource.detail.serviceidteam': 'Your service ID is not associated with any teams.',
  'no-resource.detail.serviceinstance': 'Your cluster has not been assigned any service instances.',
  'no-resource.detail.serviceinstance-namespace': '{0} has not been assigned any service instances.',
  'no-resource.detail.servicebinding': '{0} does not have any associated service bindings.',
  'no-resource.detail.setup': 'Set up the connection',
  'no-resource.detail.statefulset': 'Your cluster has not been assigned any stateful sets.',
  'no-resource.detail.statefulset-namespace': '{0} has not been assigned any stateful sets.',
  'no-resource.detail.team': 'Your cluster is not associated with any teams.',
  'no-resource.detail.teamresource': 'This team has not been assigned any resources.',
  'no-resource.detail.team-namespace': '{0} is not associated with any teams.',
  'no-resource.detail.user': 'This team has not been assigned any users.',
  'no-resource.detail.usergroup': 'This team has not been assigned any user groups.',
  'no-resource.helptext.user': 'Search to load available users.',
  'no-resource.helptext.usergroup': 'Search to load available user groups.',
  'no-resource.title': 'No {0} found.',
  'no-resource.title.addmoreteams': 'No additional teams found.',
  'no-resource.title.apikey': 'No API keys found.',
  'no-resource.title.accesspolicy': 'No access policies found.',
  'no-resource.title.configmap': 'No configuration maps found.',
  'no-resource.title.cronjob': 'No cron jobs found.',
  'no-resource.title.clusterservicebroker': 'No service brokers found.',
  'no-resource.title.clusterserviceclass': 'No cluster service classes found.',
  'no-resource.title.clusterserviceplan': 'No cluster service plans found.',
  'no-resource.title.containers': 'No containers found.',
  'no-resource.title.daemonset': 'No daemon sets found.',
  'no-resource.title.deployment': 'No deployments found.',
  'no-resource.title.events': 'No events found.',
  'no-resource.title.horizontalpodautoscaler': 'No policies found.',
  'no-resource.title.image': 'No container images found.',
  'no-resource.title.imagepolicies': 'No image policies found.',
  'no-resource.title.ingress': 'No ingresses found.',
  'no-resource.title.job': 'No jobs found.',
  'no-resource.title.ldap': 'No LDAP connection found.',
  'no-resource.title.namespace': 'No namespaces found.',
  'no-resource.title.networkpolicy': 'No network policies found.',
  'no-resource.title.node': 'No nodes found.',
  'no-resource.title.persistentvolume': 'No persistent volumes found.',
  'no-resource.title.persistentvolumeclaim': 'No persistent volume claims found.',
  'no-resource.title.podsecuritypolicy': 'No pod security policies found.',
  'no-resource.title.policy': 'No access policies found.',
  'no-resource.title.pods': 'No pods found.',
  'no-resource.title.replicaset': 'No replica sets found.',
  'no-resource.title.resource': 'No resources found.',
  'no-resource.title.resourcequota': 'No resource quotas found.',
  'no-resource.title.secret': 'No secrets found.',
  'no-resource.title.service': 'No services found.',
  'no-resource.title.serviceid': 'No service IDs found.',
  'no-resource.title.serviceinstance': 'No service instances found.',
  'no-resource.title.servicebinding': 'No service bindings found.',
  'no-resource.title.statefulset': 'No stateful sets found.',
  'no-resource.title.team': 'No teams found.',
  'no-resource.title.user': 'No users found.',
  'no-resource.title.usergroup': 'No groups found.',
  'node.details': 'Node details',
  'none': 'None',
  'page.cli': 'IBM Cloud Pak CLI',
  'persistentvolume.details': 'PersistentVolume details',
  'persistentvolumeclaim.details': 'PersistentVolumeClaim details',
  'pod.details': 'Pod details',
  'podsecuritypolicy.details': 'PodSecurityPolicy details',
  'policy.details': 'Policy details',
  'quotas.details': 'Quota details',
  'recreate': 'Recreate',
  'released': 'Released',
  'replicaSet': 'ReplicaSets',
  'resourcequota.details': 'Resource Quota details',
  'running': 'Running',
  'routes.dashboard': 'Dashboard',
  'routes.platform': 'Platform',
  'routes.platform.alerting': 'Alerting',
  'routes.platform.images': 'Images',
  'routes.platform.logging': 'Logging',
  'routes.platform.monitoring': 'Monitoring',
  'routes.platform.network': 'Network Policies',
  'routes.platform.nodes': 'Nodes',
  'routes.platform.storage': 'Storage',
  'routes.platform.va': 'Vulnerability Advisor',
  'routes.platform.metering': 'Metering',
  'routes.tools': 'Command Line Tools',
  'routes.tools.cli': 'Cloud Pak CLI',
  'routes.workloads': 'Workloads',
  'routes.workloads.daemonsets': 'DaemonSets',
  'routes.workloads.deployments': 'Deployments',
  'routes.workloads.helmReleases': 'Helm Releases',
  'routes.workloads.jobs': 'Jobs',
  'routes.workloads.statefulsets': 'StatefulSets',
  'routes.access': 'Network Access',
  'routes.access.services': 'Services',
  'routes.configuration': 'Configuration',
  'routes.configuration.configmaps': 'ConfigMaps',
  'routes.configuration.scaling': 'Scaling Policies',
  'routes.configuration.secrets': 'Secrets',
  'routes.manage': 'Manage',
  'routes.manage.authentication': 'Authentication',
  'routes.manage.helmRepositories': 'Helm Repositories',
  'routes.manage.namespaces': 'Namespaces',
  'routes.manage.podSecurity': 'Pod Security',
  'routes.manage.quotas': 'Quotas',
  'routes.manage.teams': 'Teams',
  'routes.manage.users': 'Users',
  'search.label': 'Search',
  'search.noresults': 'No search results found',
  'search.notfound': 'No results found matching {0}',
  'search.placeholder': 'Search items',
  'secondaryHeader': 'secondary header',
  'security.connect': 'Create',
  'security.edit': 'Edit',
  'security.save': 'Save',
  'security.save.error': 'There was a problem saving your LDAP connection.',
  'security.setup': 'Set up directory connection',
  'security.setup.authentication': 'Authentication',
  'security.setup.basedn': 'Base DN',
  'security.setup.basedn.placeholder': 'Enter base DN',
  'security.setup.binddn': 'Bind DN',
  'security.setup.binddn.placeholder': 'Enter bind DN',
  'security.setup.directoryinfo': 'Directory information',
  'security.setup.edit.warning': 'Changing your LDAP connection might prevent current users from logging in to IBM Cloud Pak.',
  'security.setup.filters': 'LDAP filters',
  'security.setup.groupfilter': 'Group filter',
  'security.setup.groupfilter.placeholder': 'Enter group filter',
  'security.setup.groupidmap': 'Group ID map',
  'security.setup.groupidmap.placeholder': 'Enter group ID map',
  'security.setup.groupmemberidmap': 'Group member ID map',
  'security.setup.groupmemberidmap.placeholder': 'Enter group member ID map',
  'security.setup.ldapauthentication': 'LDAP authentication',
  'security.setup.ldapconnection': 'LDAP connection',
  'security.setup.ldaptype.custom': 'Custom',
  'security.setup.ldaptype.lotus': 'IBM Lotus Domino',
  'security.setup.ldaptype.microsoft': 'Microsoft Active Directory',
  'security.setup.ldaptype.netscape': 'Netscape Directory Server',
  'security.setup.ldaptype.novell': 'Novell eDirectory',
  'security.setup.ldaptype.placeholder': 'Select LDAP directory type',
  'security.setup.ldaptype.secureway': 'IBM SecureWay Directory Server',
  'security.setup.ldaptype.sun': 'Sun Java System Directory Server',
  'security.setup.ldaptype.tivoli': 'IBM Tivoli Directory Server',
  'security.setup.name': 'Name',
  'security.setup.name.placeholder': 'Enter connection name',
  'security.setup.password': 'Admin password',
  'security.setup.password.placeholder': 'Enter password',
  'security.setup.port': 'Port',
  'security.setup.port.placeholder': 'Enter port',
  'security.setup.url': 'URL',
  'security.setup.url.placeholder': 'Enter server URL, e.g. ldap(s)://<host>:<port>',
  'security.setup.test.success': 'Your LDAP connection is valid.',
  'security.setup.testconnection': 'Test connection',
  'security.setup.testconnection.connected': 'Connected',
  'security.setup.testconnection.disconnected': 'Disconnected',
  'security.setup.type': 'Type',
  'security.setup.userfilter': 'User filter',
  'security.setup.userfilter.placeholder': 'Enter user filter',
  'security.setup.useridmap': 'User ID map',
  'security.setup.useridmap.placeholder': 'Enter user ID map',
  'service.details': 'Service details',
  'serviceid.create.name': 'Name',
  'serviceid.create.description': 'Description',
  'serviceid.create.binding-type': 'Binding type',
  'statefulset.details': 'StatefulSet details',
  'table.actions.delete': 'Delete',
  'table.actions.edit': 'Edit',
  'table.actions.expose': 'Expose',
  'table.actions.pause': 'Pause',
  'table.actions.remove': 'Remove',
  'table.actions.rollback': 'Rollback',
  'table.actions.rollout': 'Rollout',
  'table.actions.scale': 'Scale',
  'table.actions.suspend': 'Suspend',
  'table.actions.update': 'Update',
  'table.cell.active': 'Active',
  'table.cell.inactive': 'Inactive',
  'table.cell.schedulable': 'Schedulable',
  'table.cell.unschedulable': 'Scheduling disabled',
  'table.cell.scan.passed': 'Passed',
  'table.cell.scan.failed': 'Failed',
  'table.cell.scan.unchanged': 'Unchanged',
  'table.cell.scan.changed': 'Mutated',
  'table.cell.cluster': 'cluster',
  'table.cell.enforced': 'Enforced',
  'table.cell.notEnforced': 'Not enforced',
  'table.header.access': 'Access mode',
  'table.header.action': 'Action',
  'table.header.active': 'Active',
  'table.header.activeusers': 'Active users',
  'table.header.address': 'Address',
  'table.header.architecture': 'Architecture',
  'table.header.authorizedto': 'Authorized To',
  'table.header.available': 'Available',
  'table.header.capacity': 'Capacity',
  'table.header.claim': 'Claim',
  'table.header.count': 'Count',
  'table.header.cpuutilization': 'CPU%',
  'table.header.created': 'Created',
  'table.header.creation': 'Creation time',
  'table.header.crn': 'CRN',
  'table.header.current': 'Current',
  'table.header.description': 'Description',
  'table.header.desired': 'Desired',
  'table.header.email': 'Email',
  'table.header.firstSeen': 'First Seen',
  'table.header.hostIp': 'Host IP',
  'table.header.hostnames': 'Hostnames',
  'table.header.id': 'ID',
  'table.header.image': 'Image',
  'table.header.lastLogin': 'Last Login',
  'table.header.lastSchedule': 'Last Schedule',
  'table.header.lastSeen': 'Last Seen',
  'table.header.message': 'Message',
  'table.header.name': 'Name',
  'table.header.namespace': 'Namespace',
  'table.header.nodeSelector': 'Node-Selector',
  'table.header.owner': 'Owner',
  'table.header.podIp': 'Pod IP',
  'table.header.port': 'Port',
  'table.header.ready': 'Ready',
  'table.header.reason': 'Reason',
  'table.header.reclaim': 'Reclaim policy',
  'table.header.reference': 'Reference',
  'table.header.replicas.max': 'Max Replicas',
  'table.header.replicas.min': 'Min Replicas',
  'table.header.requests': 'Requests',
  'table.header.restartCount': 'Restart count',
  'table.header.role': 'Role',
  'table.header.serviceid-binding.Name': 'Namespaces',
  'table.header.schedulable': 'Schedulable',
  'table.header.schedule': 'Schedule',
  'table.header.scope': 'Scope',
  'table.header.source': 'Source',
  'table.header.startTime': 'Start Time',
  'table.header.state': 'State',
  'table.header.status': 'Status',
  'table.header.successful': 'Successful',
  'table.header.suspend': 'Suspend',
  'table.header.teamId': 'Team ID',
  'table.header.type': 'Type',
  'table.header.upToDate': 'Up-to-date',
  'table.header.url': 'URL',
  'table.header.usergroup': 'Group',
  'table.header.users': 'Users',
  'table.header.volume': 'PersistentVolume',
  'tabs.configmap': 'ConfigMaps',
  'tabs.containers': 'Containers',
  'tabs.cronjob': 'CronJobs',
  'tabs.daemonset': 'DaemonSet',
  'tabs.deployment': 'Deployments',
  'tabs.details': 'Details',
  'tabs.events': 'Events',
  'tabs.groups': 'Groups',
  'tabs.horizontalpodautoscaler': 'Policies',
  'tabs.image': 'Images',
  'tabs.ingress': 'Ingress',
  'tabs.job': 'Batch Jobs',
  'tabs.label': 'tabs',
  'tabs.ldap': 'LDAP Connection',
  'tabs.ldap.setup': 'Setup',
  'tabs.logs': 'Logs',
  'tabs.namespace': 'Namespaces',
  'tabs.networkpolicy': 'Network Policies',
  'tabs.node': 'Nodes',
  'tabs.overview': 'Overview',
  'tabs.persistentvolume': 'PersistentVolume',
  'tabs.persistentvolumeclaim': 'PersistentVolumeClaim',
  'tabs.podsecuritypolicy': 'Pod Security',
  'tabs.resourcequota': 'Quotas',
  'tabs.resources': 'Resources',
  'tabs.service': 'Services',
  'tabs.statefulset': 'StatefulSet',
  'tabs.team': 'Team',
  'tabs.teams': 'Teams',
  'tabs.usage': 'Usage',
  'tabs.user': 'User',
  'tabs.usergroup': 'Usergroups',
  'tabs.users': 'Users',
  'tabs.secret': 'Secrets',
  'terminated': 'Terminated',
  'total': 'Total',
  'true': 'True',
  'type': 'Type',
  'unhealthy': 'Unhealthy',
  'unit.cpu': 'CPU',
  'unit.gpu': 'GPU',
  'updated': 'Updated',
  'used': 'Used',
  'user.cancel': 'Cancel',
  'user.details.edit': 'Edit user details',
  'user.details.email': 'Email address',
  'user.details.firstname': 'First name',
  'user.details.group': 'Group',
  'user.details.jobtitle': 'Job title',
  'user.details.lastname': 'Last name',
  'user.details.new': 'Add user details',
  'user.details.organization': 'Organization',
  'user.details.readonly': 'Read only',
  'user.details.role': 'Role',
  'user.details.status': 'Status',
  'user.save': 'Save',
  'usergroup.details': 'Usergroup details',
  'utilization': 'Utilization',
  'volume.details': 'PersistentVolume details',
  'waiting': 'Waiting',
  'product.version.text': 'Version',
  'product.technologies': 'Technologies used',
  'product.java.alt': 'Java logo',
  'product.kubernetes.alt': 'Kubernetes logo',
  'product.icp.alt': 'IBM Cloud Pak logo',
  'svg.description.locked': 'Locked icon',
  'svg.description.unlocked': 'Unlocked icon',
  'svg.description.resource': 'Resource icon',
  'svg.description.remove': 'Remove',
  'svg.description.close': 'Close',
  'secret.show': 'Show secret',
  'secret.hide': 'Hide secret',
  'secret.copied': 'Secret copied',
  'resources.helmchart': 'Helm chart',
  'resources.helmrepository': 'Helm repository',
  'resources.namespace': 'Namespace',
  'resources.clusterserviceclass': 'ClusterServiceClass',
  'resources.clusterserviceplan': 'ClusterServicePlan'
}
