/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

import { configure } from 'enzyme'
import config from '../../../lib/shared/config'
import Adapter from 'enzyme-adapter-react-16'

configure({ adapter: new Adapter() })

jest.mock('../../../nls/platform.properties', () => ({
  get: jest.fn((key) => {
    const msgs = require('./properties').msgs
    return msgs[key]
  })
}))

jest.mock('../../../nls/platform-header.properties', () => ({
  get: jest.fn((key) => {
    const msgs = require('./header-properties').msgs
    return msgs[key]
  })
}))

jest.mock('../../../nls/login.properties', () => ({
  get: jest.fn((key) => {
    const msgs = require('./login-properties').msgs
    return msgs[key]
  })
}))

// window.location.replace = jest.fn()
config.headerContextPath = '/console'
document.body.innerHTML += '<script id="context">{"locale":"en"}</script><input id="headerAccess" type="hidden" value="somevalue" />'
