/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

import { namespaces } from '../../../src-web/reducers/namespaces'
import * as Actions from '../../../src-web/actions/index'

describe('Namespaces reducer', () => {
  describe('#namespaces', () => {
    const namespaceData = {
      namespaces: [{ name: 'default', actions: 'CRUD', crn: 'crn:v1:icp:private:k8:mycluster:n/default:::' }],
      selectedNamespaces: 'default',
      defaultNamespace: 'default'
    }
    it('should return the initial state', () => {
      expect(namespaces(undefined, {})).toEqual(null)
    })
    it('should handle NAMESPACES_RECEIVE_SUCCESS', () => {
      const action = {
        type: Actions.NAMESPACES_RECEIVE_SUCCESS,
        ...namespaceData
      }
      expect(namespaces({}, action)).toEqual({...action, status: Actions.REQUEST_STATUS.DONE})
    })
    it('should handle SWITCH_NAMESPACE', () => {
      const action = {
        type: Actions.SWITCH_NAMESPACE,
        selectedNamespaces: 'namespace-switch',
        defaultNamespace: 'namespace-switch'
      }
      expect(namespaces(namespaceData, action)).toEqual({...namespaceData, ...action})
    })
    it('should handle NAMESPACES_RECEIVE_FAILURE', () => {
      const action = {
        type: Actions.NAMESPACES_RECEIVE_FAILURE,
        err: {
          details: 'Internal server error',
          statusCode: 500
        }
      }
      expect(namespaces({}, action)).toEqual({status: Actions.REQUEST_STATUS.ERROR, errorMessage: action.err.details, statusCode: action.err.statusCode})
    })
  })
})
