/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

import { nav } from '../../../src-web/reducers/nav'
import * as Actions from '../../../src-web/actions/index'
import { ROLES } from '../../../lib/shared/constants'

const defaultSubItem = {
  disabled: false,
  external: false,
  id: 'workloads-brokeredservices',
  label: 'Brokered Services',
  serviceId: 'platform-ui',
  url: '/console/workloads/serviceinstances'
}

describe.skip('Nav reducer', () => {
  describe('#nav', () => {
    it('should return the initial state', () => {
      expect(nav(undefined, {})).toEqual(null)
    })
    it('should handle NAV_RECEIVE_SUCCESS', () => {
      const navItemsState = [{
        id: 'workloads',
        label: 'Workloads',
        subItems: [{ defaultSubItem }]
      }]
      const action = {
        type: Actions.NAV_RECEIVE_SUCCESS,
        ...navItemsState
      }
      expect(nav({}, action)).toEqual({...action, status: Actions.REQUEST_STATUS.DONE})
    })
    it('should handle NAV_MODIFY', () => {
      const navItemsState = [{
        id: 'workloads',
        label: 'Workloads',
        subItems: [{ defaultSubItem }]
      }]
      const action = {
        type: Actions.NAV_MODIFY,
        roles: ROLES.CLUSTER_ADMIN,
        enabled: true,
        id: 'workloads-test',
        displayName: 'Test',
        url: 'https://test.com',
        chart: 'test-chart',
        target: 'test-chart',
        route: 'workloads',
        namespace: 'default',
        namespaces: [{ Name: 'default' }],
        currentRole: ROLES.CLUSTER_ADMIN
      }
      expect(nav({ navItems: navItemsState }, action)).toEqual(
        {
          navItems: [{
            id: 'workloads',
            label: 'Workloads',
            subItems: [{ defaultSubItem }, { disabled: false, external: true, id: action.id, label: action.displayName, serviceId: action.chart, target: action.target, url: action.url }]
          }],
          secondaryNavItems: null
        }
      )
    })
    it('should handle NAV_MODIFY and return original state when no route match is found ', () => {
      const action = {
        type: Actions.NAV_MODIFY,
        roles: ROLES.CLUSTER_ADMIN,
        enabled: true,
        id: 'workloads-test',
        displayName: 'Test',
        url: 'https://test.com',
        chart: 'test-chart',
        target: 'test-target',
        route: 'foobar',
        namespace: 'default',
        namespaces: [{ Name: 'default' }],
        currentRole: ROLES.CLUSTER_ADMIN
      }
      const navItemsState = [{
        id: 'workloads',
        label: 'Workloads',
        subItems: [{ defaultSubItem }]
      }]
      expect(nav(navItemsState, action)).toEqual({
        navItems: [{id: 'workloads',
          label: 'Workloads',
          subItems: [{ defaultSubItem }]
        }],
        secondaryNavItems: null})
    })
    it('should handle NAV_MODIFY and return correct disabled state ', () => {
      const navItemsState = [{
        id: 'workloads',
        label: 'Workloads',
        subItems: [{ defaultSubItem }]
      }]
      const action = {
        type: Actions.NAV_MODIFY,
        roles: ROLES.CLUSTER_ADMIN,
        enabled: true,
        id: 'workloads-test',
        displayName: 'Test',
        url: 'https://test.com',
        chart: 'test-chart',
        target: 'test-target',
        route: 'workloads',
        namespace: 'foobar',
        namespaces: [{ Name: 'default' }],
        currentRole: ROLES.VIEWER
      }
      expect(nav({ navItems: navItemsState }, action)).toEqual({ secondaryNavItems: null, navItems: [{
        id: 'workloads',
        label: 'Workloads',
        subItems: [{ defaultSubItem }, { disabled: true, external: true, id: action.id, label: action.displayName, serviceId: action.chart, target: action.target, url: action.url }]
      }]})
    })
    it('should handle NAV_MODIFY and return original nav routes when id match is found', () => {
      const navItemsState = [{
        id: 'workloads',
        label: 'Workloads',
        subItems: [{ defaultSubItem }]
      }]
      const action = {
        type: Actions.NAV_MODIFY,
        roles: ROLES.CLUSTER_ADMIN,
        enabled: true,
        id: 'workloads',
        displayName: 'Test',
        url: 'https://test.com',
        chart: 'test-chart',
        target: 'test-chart',
        route: 'workloads',
        namespace: 'default',
        namespaces: [{ Name: 'default' }],
        currentRole: ROLES.CLUSTER_ADMIN
      }
      expect(nav({ navItems: navItemsState }, action)).toEqual({ secondaryNavItems: null, navItems: [{
        id: 'workloads',
        label: 'Workloads',
        subItems: [{ defaultSubItem }, { disabled: false, external: true, id: action.id, label: action.displayName, serviceId: action.chart, target: action.target, url: action.url }]
      }]})
    })
    it('should handle NAV_MODIFY and remove nav item if not enabled', () => {
      const navItemsState = [{
        id: 'workloads',
        label: 'Workloads',
        subItems: [{ defaultSubItem }, {
          type: Actions.NAV_MODIFY,
          roles: ROLES.CLUSTER_ADMIN,
          enabled: true,
          id: 'workloads-test',
          displayName: 'Test',
          url: 'https://test.com',
          chart: 'test-chart',
          target: 'test-chart',
          route: 'workloads',
          namespace: 'default',
          namespaces: [{ Name: 'default' }],
          currentRole: ROLES.CLUSTER_ADMIN
        }]
      }]
      const action = {
        type: Actions.NAV_MODIFY,
        roles: ROLES.CLUSTER_ADMIN,
        enabled: false,
        id: 'workloads-test',
        displayName: 'Test',
        url: 'https://test.com',
        chart: 'test-chart',
        target: 'test-chart',
        route: 'workloads'
      }
      expect(nav({ navItems: navItemsState }, action)).toEqual({ secondaryNavItems: null, navItems: [{
        id: 'workloads',
        label: 'Workloads',
        subItems: [{ defaultSubItem }]
      }]})
    })
  })
})
