/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

import { uiconfig } from '../../../src-web/reducers/uiconfig'
import * as Actions from '../../../src-web/actions/index'

describe('UI config reducer', () => {
  const uiConfigData = {
    qccess_ip: '9.99.99.99',
    cluster_name: 'cluster.local',
    edition: 'Enterprise Edition',
    kube_apiserver_secure_port: '8001',
    proxy_ip: '9.99.99.99'
  }
  describe('#uiconfig', () => {
    it('should return the initial state', () => {
      expect(uiconfig(undefined, {})).toEqual(null)
    })
    it('should handle UICONFIG_RECEIVE_SUCCESS', () => {
      const action = {
        type: Actions.UICONFIG_RECEIVE_SUCCESS,
        data: { uiConfiguration: uiConfigData }
      }
      expect(uiconfig({}, action)).toEqual(action.data)
    })
  })
})
