/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */

module.exports = {
  elements: {
    header: '.app-header',
    hamburgerBtn: '#hamburger',
    leftNav: '.left-nav',
    appsDropdownBtn: '#acm-apps-dropdown',
    appsDropdownMenu: '#acm-apps-dropdown .dropdown-container.dropdown-container-apps.is-open',
    searchBtn: '#acm-search',
    infoDropdownBtn: '#acm-info-dropdown',
    infoDropdownMenu: '#acm-info-dropdown .dropdown-container.dropdown-container-info.is-open',
    userDropdownBtn: '#acm-user-dropdown',
    userDropdownMenu: '#acm-user-dropdown .dropdown-container.dropdown-container-admin.is-open',
    createResourceBtn: '#acm-create-resource',
    createResourceModal: '#resource-modal-container',
    cancelCreateResourceBtn: '#resource-modal-container .bx--btn--secondary',
    aboutModalBtn: '#acm-about',
    aboutModal: '#acm-about-dialog',
    configureClientBtn: '#configure-client',
    configureClientModal: '#configure-client-modal',
    kuiDropdownBtn: '#acm-kui-dropdown',
    kuiDropdownBtnMenu: '#acm-kui-dropdown .dropdown-container.dropdown-container-apps.is-open'
  },
  commands: [{
    
    waitForHeader,
    openInfoMenu,
    closeInfoMenu,
    openUserMenu,
    closeUserMenu,
    openCreateResource,
    closeCreateResource,
    openAboutModal,
    closeAboutModal,
    openKUI,
    closeKUI,
    verifyWelcomePage,
    verifyLeftNavigation,
    openLeftNavigation,
    closeLeftNavigation,
    verifyACMApps,
    verifySearch,
    verifyCreateResource,
    verifyKUI,
    verifyAbout,
    verifyConfigureClient
  }]
}

function waitForHeader() {
    this.waitForElementPresent('@header')
}
function verifyWelcomePage(browser) {
  this.expect.url().to.equal(`${browser.launch_url}/multicloud/welcome`)
  this.expect.element('.welcome--introduction').to.be.visible
  this.expect.element('.welcome--svcs').to.be.visible
  this.expect.element('.welcome--info').to.be.visible
  this.expect.element('.welcome--connect').to.be.visible
}

function verifyLeftNavigation(browser) {
  this.openLeftNavigation()
  this.expect.element('a#home').to.be.visible
  this.expect.element('li#observe').to.be.visible
  this.moveToElement('li#observe', 10, 10)
  this.pause(1000)
  this.expect.element('a#overview').to.be.visible
  this.expect.element('a#topology').to.not.be.present
  this.expect.element('li#automate').to.be.visible
  this.moveToElement('li#automate', 10, 10)
  this.pause(1000)
  this.expect.element('a#clusters').to.be.visible
  this.expect.element('a#applications').to.be.visible
  this.expect.element('a#grc').to.be.visible
  this.closeLeftNavigation()
}

function openLeftNavigation() {
  this.waitForElementVisible('@hamburgerBtn')
    .click('@hamburgerBtn')
    .waitForElementPresent('@leftNav')
}

function closeLeftNavigation() {
  this.waitForElementVisible('@hamburgerBtn')
    .click('@hamburgerBtn')
    .waitForElementNotPresent('@leftNav')
}

function verifyACMApps(){
  this.waitForElementVisible('@appsDropdownBtn')
    .click('@appsDropdownBtn')
    .waitForElementPresent('@appsDropdownMenu')
  this.expect.element('#applications .dropwdown-content-items span')
    .text.to.equal('Red Hat OpenShift Container Platform')
  this.waitForElementVisible('@appsDropdownBtn')
    .click('@appsDropdownBtn')
    .waitForElementNotPresent('@appsDropdownMenu')
}

function verifySearch(){
  this.waitForElementPresent('@searchBtn')
  this.expect.element('#acm-search a').to.have.attribute('href').to.endWith('/search')
}

function verifyCreateResource(){
  this.openCreateResource()
  // more verification to be added
  this.expect.element('.monaco-editor').to.be.visible
  this.expect.element('#create-resource-select .bx--list-box__label').text.to.equal('Target clusters')
  this.click('#create-resource-select')
  this.expect.element('#create-resource-select__menu').to.be.present
  this.waitForElementPresent('#create-resource-select__menu>div')
  this.expect.elements('#create-resource-select__menu>div').count.to.equal(1)
  this.click('#create-resource-select')
  this.expect.element('#create-resource-select__menu').to.not.be.present
  this.expect.element('#resource-modal-dropdown').to.be.present
  const editor1stPart = '#resource-modal div.yamlEditorContainerContainer div.monaco-scrollable-element.editor-scrollable.vs-dark div.view-lines > div:nth-child(1) > span > span:nth-child(1)'
  this.expect.element(editor1stPart).text.to.equal('apiVersion')
  this.click('#resource-modal-dropdown')
  this.expect.elements('#resource-modal-dropdown__menu .bx--list-box__menu-item__option').count.to.equal(2)
  this.expect.element('#resource-modal-dropdown__menu > div:nth-child(1) > div').text.to.equal('YAML')
  this.expect.element('#resource-modal-dropdown__menu > div:nth-child(2) > div').text.to.equal('JSON')
  this.click('#resource-modal-dropdown__menu > div:nth-child(2)')
  this.expect.element(editor1stPart).text.to.equal('{')
  this.closeCreateResource()
}

function verifyKUI(){
  this.openKUI()
  this.expect.element('#current-tab-terminal').to.be.visible
  this.expect.element('#new-tab-terminal').to.be.visible
  this.closeKUI()
}

function verifyAbout(){
  this.openInfoMenu()
  this.openAboutModal()
  this.expect.element('.acm-logo').to.be.visible
  this.expect.element('.version-details__no').text.to.not.equal('unavailable');
  this.closeAboutModal()
  this.expect.element('@infoDropdownMenu').to.not.be.present
}

function verifyConfigureClient(){
  this.openUserMenu()
  this.expect.element('#configure-client a').to.have.attribute('href').to.endWith('/oauth/token/request')
  this.closeUserMenu()
}

function openInfoMenu() {
  this.waitForElementVisible('@infoDropdownBtn')
    .click('@infoDropdownBtn')
    .waitForElementPresent('@infoDropdownMenu')
}

function closeInfoMenu() {
  this.waitForElementVisible('@infoDropdownBtn')
    .click('@infoDropdownBtn')
    
}

function openUserMenu() {
  this.waitForElementVisible('@userDropdownBtn')
    .click('@userDropdownBtn')
    .waitForElementPresent('@userDropdownMenu')
}

function closeUserMenu() {
  this.waitForElementVisible('@userDropdownBtn')
    .click('@userDropdownBtn')
    .waitForElementNotPresent('@userDropdownMenu')
}

function openCreateResource() {
  this.waitForElementVisible('@createResourceBtn')
    .click('@createResourceBtn')
    .waitForElementPresent('@createResourceModal')
}

function closeCreateResource() {
  this.waitForElementVisible('@cancelCreateResourceBtn')
    .click('@cancelCreateResourceBtn')
    .waitForElementNotPresent('@createResourceModal')
}

function openAboutModal() {
  this.waitForElementVisible('@aboutModalBtn')
    .click('@aboutModalBtn')
    .waitForElementPresent('@aboutModal')
}

function closeAboutModal(){
  this.waitForElementVisible('.close-about')
    .click('.close-about')
    .waitForElementNotPresent('@aboutModal')
}

function openKUI() {
  this.waitForElementVisible('@kuiDropdownBtn')
    .click('@kuiDropdownBtn')
  this.waitForElementVisible('@kuiDropdownBtnMenu')
}
function closeKUI() {
  this.waitForElementVisible('@kuiDropdownBtn')
    .click('@kuiDropdownBtn')
  this.waitForElementNotPresent('@kuiDropdownBtnMenu')
  //test close when opening create, etc
  this.waitForElementVisible('@kuiDropdownBtn')
    .click('@kuiDropdownBtn')
  this.waitForElementVisible('@kuiDropdownBtnMenu')
  this.waitForElementVisible('@createResourceBtn')
    .click('@createResourceBtn')
    .waitForElementPresent('@createResourceModal')
  this.waitForElementNotPresent('@kuiDropdownBtnMenu')
  this.waitForElementVisible('@cancelCreateResourceBtn')
    .click('@cancelCreateResourceBtn')
    .waitForElementNotPresent('@createResourceModal')
}
