const path = require('path');
const webpack = require('webpack');

module.exports = {
  devtool: 'eval',
  entry: [
    `${require.resolve('webpack-dev-server/client')}?http://localhost:9999`,
    './client/index',
  ],
  output: {
    path: path.join(__dirname, 'dist'),
    filename: 'bundle.js',
    publicPath: '/static/',
  },
  plugins: [new webpack.HotModuleReplacementPlugin()],
  module: {
    loaders: [
      {
        test: /\.js$/,
        loader: require.resolve('babel-loader'),
        query: { presets: ['react', 'env', 'stage-0'] },
        include: [path.join(__dirname, 'client'), path.resolve(__dirname, '../src')],
      },
    ],
  },
};
