'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _CardFooter = require('../CardFooter');

var _CardFooter2 = _interopRequireDefault(_CardFooter);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('CardFooter', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(
      _CardFooter2.default,
      { className: 'extra-class' },
      _react2.default.createElement(
        'div',
        { className: 'child' },
        'Test'
      )
    ));

    it('renders children as expected', function () {
      expect(wrapper.find('.child').length).toBe(1);
    });

    it('has the expected classes', function () {
      expect(wrapper.hasClass('bx--card-footer')).toEqual(true);
    });

    it('renders extra classes passed in via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });
});