'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; /* eslint-disable no-console */

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _addonActions = require('@storybook/addon-actions');

var _Dropdown = require('../Dropdown');

var _Dropdown2 = _interopRequireDefault(_Dropdown);

var _DropdownItem = require('../DropdownItem');

var _DropdownItem2 = _interopRequireDefault(_DropdownItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var dropdownEvents = {
  className: 'some-class'
};

(0, _react3.storiesOf)('Dropdown', module).addDecorator(function (story) {
  return _react2.default.createElement(
    'div',
    { style: { minWidth: '20em' } },
    story()
  );
}).addWithInfo('with default text', '\n      The Dropdown component is used for navigating or filtering existing content.\n      Create Dropdown Item components for each option in the dropdown menu.\n    ', function () {
  return _react2.default.createElement(
    _Dropdown2.default,
    _extends({}, dropdownEvents, {
      onChange: (0, _addonActions.action)('onChange'),
      defaultText: 'Dropdown label' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 1', value: 'option1' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 2', value: 'option2' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 3', value: 'option3' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 4', value: 'option4' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 5', value: 'option5' })
  );
}).addWithInfo('with item preselected', '\n      The Dropdown component is used for navigating or filtering existing content.\n      You can also have an option preselected in the dropdown.\n    ', function () {
  return _react2.default.createElement(
    _Dropdown2.default,
    _extends({}, dropdownEvents, {
      onChange: function onChange(selectedItemInfo) {
        return console.log(selectedItemInfo);
      },
      defaultText: 'Option 1',
      value: 'all' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 1', value: 'option1' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 2', value: 'option2' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 3', value: 'option3' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 4', value: 'option4' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 5', value: 'option5' })
  );
}).addWithInfo('disabled', '\n      The Dropdown component is used for navigating or filtering existing content.\n      You can also have an option preselected in the dropdown.\n    ', function () {
  return _react2.default.createElement(
    _Dropdown2.default,
    _extends({}, dropdownEvents, {
      onChange: function onChange(selectedItemInfo) {
        return console.log(selectedItemInfo);
      },
      defaultText: 'Dropdown label',
      disabled: true }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 1', value: 'option1' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 2', value: 'option2' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 3', value: 'option3' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 4', value: 'option4' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 5', value: 'option5' })
  );
}).addWithInfo('with pre-selected value', '\n        The Dropdown component is used for navigating or filtering existing content.\n        You can also have an option preselected in the dropdown.\n      ', function () {
  return _react2.default.createElement(
    _Dropdown2.default,
    _extends({}, dropdownEvents, {
      onChange: function onChange(selectedItemInfo) {
        return console.log(selectedItemInfo);
      },
      defaultText: 'Dropdown label',
      value: 'all',
      selectedText: 'Option 4' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 1', value: 'option1' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 2', value: 'option2' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 3', value: 'option3' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 4', value: 'option4' }),
    _react2.default.createElement(_DropdownItem2.default, { itemText: 'Option 5', value: 'option5' })
  );
});