'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _react3 = require('@storybook/react');

var _addonActions = require('@storybook/addon-actions');

var _Checkbox = require('../Checkbox');

var _Checkbox2 = _interopRequireDefault(_Checkbox);

var _Form = require('../Form');

var _Form2 = _interopRequireDefault(_Form);

var _FormGroup = require('../FormGroup');

var _FormGroup2 = _interopRequireDefault(_FormGroup);

var _FileUploader = require('../FileUploader');

var _FileUploader2 = _interopRequireDefault(_FileUploader);

var _NumberInput = require('../NumberInput');

var _NumberInput2 = _interopRequireDefault(_NumberInput);

var _RadioButton = require('../RadioButton');

var _RadioButton2 = _interopRequireDefault(_RadioButton);

var _RadioButtonGroup = require('../RadioButtonGroup');

var _RadioButtonGroup2 = _interopRequireDefault(_RadioButtonGroup);

var _Button = require('../Button');

var _Button2 = _interopRequireDefault(_Button);

var _Search = require('../Search');

var _Search2 = _interopRequireDefault(_Search);

var _Select = require('../Select');

var _Select2 = _interopRequireDefault(_Select);

var _SelectItem = require('../SelectItem');

var _SelectItem2 = _interopRequireDefault(_SelectItem);

var _TextArea = require('../TextArea');

var _TextArea2 = _interopRequireDefault(_TextArea);

var _TextInput = require('../TextInput');

var _TextInput2 = _interopRequireDefault(_TextInput);

var _Toggle = require('../Toggle');

var _Toggle2 = _interopRequireDefault(_Toggle);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var additionalProps = {
  className: 'some-class',
  onSubmit: function onSubmit(e) {
    e.preventDefault();
    (0, _addonActions.action)('FormSubmitted')(e);
  }
};

var checkboxEvents = {
  className: 'some-class',
  labelText: 'Checkbox label'
};

var fieldsetCheckboxProps = {
  className: 'some-class',
  legendText: 'Checkbox heading'
};

var numberInputProps = {
  className: 'some-class',
  id: 'number-input-1',
  label: 'Number Input',
  min: 0,
  max: 100,
  value: 50,
  step: 10
};

var toggleProps = {
  className: 'some-class'
};

var fieldsetToggleProps = {
  className: 'some-class',
  legendText: 'Toggle heading'
};

var fileUploaderEvents = {
  className: 'some-class'
};

var fieldsetFileUploaderProps = {
  className: 'some-class',
  legendText: 'File Uploader'
};

var radioProps = {
  className: 'some-class'
};

var fieldsetRadioProps = {
  className: 'some-class',
  legendText: 'Radio Button heading'
};

var searchProps = {
  className: 'some-class'
};

var fieldsetSearchProps = {
  className: 'some-class',
  legendText: 'Search'
};

var selectProps = {
  className: 'some-class'
};

var TextInputProps = {
  className: 'some-class',
  id: 'test2',
  labelText: 'Text Input label',
  placeholder: 'Placeholder text'
};

var PasswordProps = {
  className: 'some-class',
  id: 'test2',
  labelText: 'Password'
};

var InvalidPasswordProps = {
  className: 'some-class',
  id: 'test2',
  labelText: 'Password',
  invalid: true,
  invalidText: 'Your password must be at least 6 characters as well as contain at least one uppercase, one lowercase, and one number.'
};

var textareaProps = {
  labelText: 'Text Area label',
  className: 'some-class',
  placeholder: 'Placeholder text',
  id: 'test2',
  cols: 50,
  rows: 4
};

var buttonEvents = {
  className: 'some-class'
};

(0, _react3.storiesOf)('Form', module).addWithInfo('Default', '\n    Forms are widely used to collect user input.\n\n    Form can have any number of react components enclosed within FormGroup component. FormGroup component\n    is a wrapper for legend and fieldset component.\n\n  ', function () {
  return _react2.default.createElement(
    _Form2.default,
    additionalProps,
    _react2.default.createElement(
      _FormGroup2.default,
      fieldsetCheckboxProps,
      _react2.default.createElement(_Checkbox2.default, _extends({ defaultChecked: true }, checkboxEvents, { id: 'checkbox-0' })),
      _react2.default.createElement(_Checkbox2.default, _extends({}, checkboxEvents, { id: 'checkbox-1' })),
      _react2.default.createElement(_Checkbox2.default, _extends({ disabled: true }, checkboxEvents, { id: 'checkbox-2' }))
    ),
    _react2.default.createElement(_NumberInput2.default, numberInputProps),
    _react2.default.createElement(
      _FormGroup2.default,
      fieldsetToggleProps,
      _react2.default.createElement(_Toggle2.default, _extends({}, toggleProps, { id: 'toggle-1' })),
      _react2.default.createElement(_Toggle2.default, _extends({ disabled: true }, toggleProps, { id: 'toggle-2' }))
    ),
    _react2.default.createElement(
      _FormGroup2.default,
      fieldsetFileUploaderProps,
      _react2.default.createElement(_FileUploader2.default, _extends({}, fileUploaderEvents, {
        id: 'file-1',
        labelDescription: 'Choose Files...'
      }))
    ),
    _react2.default.createElement(
      _FormGroup2.default,
      fieldsetRadioProps,
      _react2.default.createElement(
        _RadioButtonGroup2.default,
        {
          onChange: (0, _addonActions.action)('onChange'),
          name: 'radio-button-group',
          defaultSelected: 'default-selected' },
        _react2.default.createElement(_RadioButton2.default, _extends({
          value: 'standard',
          id: 'radio-1',
          labelText: 'Standard Radio Button'
        }, radioProps)),
        _react2.default.createElement(_RadioButton2.default, _extends({
          value: 'default-selected',
          labelText: 'Default Selected Radio Button',
          id: 'radio-2'
        }, radioProps)),
        _react2.default.createElement(_RadioButton2.default, _extends({
          value: 'disabled',
          labelText: 'Disabled Radio Button',
          id: 'radio-3',
          disabled: true
        }, radioProps))
      )
    ),
    _react2.default.createElement(
      _FormGroup2.default,
      fieldsetSearchProps,
      _react2.default.createElement(_Search2.default, _extends({}, searchProps, {
        id: 'search-1',
        labelText: 'Search',
        placeHolderText: 'Search'
      }))
    ),
    _react2.default.createElement(
      _Select2.default,
      _extends({}, selectProps, { id: 'select-1', defaultValue: 'placeholder-item' }),
      _react2.default.createElement(_SelectItem2.default, {
        disabled: true,
        hidden: true,
        value: 'placeholder-item',
        text: 'Choose an option'
      }),
      _react2.default.createElement(_SelectItem2.default, { value: 'option-1', text: 'Option 1' }),
      _react2.default.createElement(_SelectItem2.default, { value: 'option-2', text: 'Option 2' }),
      _react2.default.createElement(_SelectItem2.default, { value: 'option-3', text: 'Option 3' })
    ),
    _react2.default.createElement(_TextInput2.default, TextInputProps),
    _react2.default.createElement(_TextInput2.default, _extends({
      type: 'password',
      required: true,
      pattern: '(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{6,}'
    }, PasswordProps)),
    _react2.default.createElement(_TextInput2.default, _extends({
      type: 'password',
      required: true,
      pattern: '(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{6,}'
    }, InvalidPasswordProps)),
    _react2.default.createElement(_TextArea2.default, textareaProps),
    _react2.default.createElement(
      _Button2.default,
      _extends({ type: 'submit', className: 'some-class' }, buttonEvents),
      'Submit'
    )
  );
});