"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _lodash = _interopRequireDefault(require("lodash.debounce"));

var _Icon = _interopRequireDefault(require("../Icon"));

var _Select = _interopRequireDefault(require("../Select"));

var _SelectItem = _interopRequireDefault(require("../SelectItem"));

var _TextInput = _interopRequireDefault(require("../TextInput"));

var _array = require("../../tools/array");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

var Pagination =
/*#__PURE__*/
function (_Component) {
  _inherits(Pagination, _Component);

  function Pagination() {
    var _ref;

    var _temp, _this;

    _classCallCheck(this, Pagination);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _possibleConstructorReturn(_this, (_temp = _this = _possibleConstructorReturn(this, (_ref = Pagination.__proto__ || Object.getPrototypeOf(Pagination)).call.apply(_ref, [this].concat(args))), Object.defineProperty(_assertThisInitialized(_this), "state", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: {
        page: _this.props.page,
        pageSize: _this.props.pageSize && _this.props.pageSizes.includes(_this.props.pageSize) ? _this.props.pageSize : _this.props.pageSizes[0]
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "handleSizeChange", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(evt) {
        var pageSize = Number(evt.target.value);

        _this.setState({
          pageSize: pageSize,
          page: 1
        });

        _this.props.onChange({
          page: 1,
          pageSize: pageSize
        });
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "handlePageInputChange", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value(evt) {
        var page = Number(evt.target.value);

        if ( // Added props for defaultPageText and defaultItemText to be
        // used for case when page # is 0 or empty. For other cases
        // existing props will be used.
        page >= 0 && page <= Math.max(Math.ceil(_this.props.totalItems / _this.state.pageSize), 1)) {
          _this.setState({
            page: page
          }, function () {
            return _this.pageInputDebouncer(_this.state.page);
          });
        }
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "incrementPage", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value() {
        var page = _this.state.page + 1;

        _this.setState({
          page: page
        });

        _this.props.onChange({
          page: page,
          pageSize: _this.state.pageSize
        });
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "decrementPage", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value() {
        var page = _this.state.page - 1;

        _this.setState({
          page: page
        });

        _this.props.onChange({
          page: page,
          pageSize: _this.state.pageSize
        });
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "getItemsText", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value() {
        var _this$props = _this.props,
            pagesUnknown = _this$props.pagesUnknown,
            totalItems = _this$props.totalItems,
            itemRangeText = _this$props.itemRangeText,
            itemText = _this$props.itemText,
            defaultItemText = _this$props.defaultItemText;
        var _this$state = _this.state,
            pageSize = _this$state.pageSize,
            page = _this$state.page;

        if (pagesUnknown) {
          return itemText(pageSize * (page - 1) + 1, page * pageSize);
        } else if (page > 0) {
          return itemRangeText(Math.min(pageSize * (page - 1) + 1, totalItems), Math.min(page * pageSize, totalItems), totalItems);
        }

        return defaultItemText(totalItems);
      }
    }), Object.defineProperty(_assertThisInitialized(_this), "getPagesText", {
      configurable: true,
      enumerable: true,
      writable: true,
      value: function value() {
        var _this$props2 = _this.props,
            pagesUnknown = _this$props2.pagesUnknown,
            totalItems = _this$props2.totalItems,
            pageRangeText = _this$props2.pageRangeText,
            pageText = _this$props2.pageText,
            defaultPageText = _this$props2.defaultPageText;
        var _this$state2 = _this.state,
            pageSize = _this$state2.pageSize,
            page = _this$state2.page;

        if (pagesUnknown) {
          return pageText(page);
        } else if (page > 0) {
          return pageRangeText(page, Math.max(Math.ceil(totalItems / pageSize), 1));
        }

        return defaultPageText(Math.ceil(totalItems / pageSize));
      }
    }), _temp));
  }

  _createClass(Pagination, [{
    key: "componentWillMount",
    value: function componentWillMount() {
      this.uniqueId = "".concat(Math.floor(Math.random() * 0xffff));
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      this.pageInputDebouncer = (0, _lodash.default)(function (page) {
        return page > 0 && _this2.props.onChange({
          page: page,
          pageSize: _this2.state.pageSize
        });
      }, this.props.onChangeInterval);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.pageInputDebouncer.cancel();
    }
  }, {
    key: "componentWillReceiveProps",
    value: function componentWillReceiveProps(_ref2) {
      var pageSizes = _ref2.pageSizes,
          page = _ref2.page,
          pageSize = _ref2.pageSize;

      if (!(0, _array.equals)(pageSizes, this.props.pageSizes)) {
        this.setState({
          pageSize: pageSizes[0],
          page: 1
        });
      }

      if (page !== this.props.page) {
        this.setState({
          page: page
        });
      }

      if (pageSize !== this.props.pageSize) {
        this.setState({
          pageSize: pageSize
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _props = this.props,
          backwardText = _props.backwardText,
          className = _props.className,
          defaultItemText = _props.defaultItemText,
          defaultPageText = _props.defaultPageText,
          forwardText = _props.forwardText,
          id = _props.id,
          itemsPerPageText = _props.itemsPerPageText,
          itemRangeText = _props.itemRangeText,
          pageNumberText = _props.pageNumberText,
          pageRangeText = _props.pageRangeText,
          pageSize = _props.pageSize,
          pageSizes = _props.pageSizes,
          itemText = _props.itemText,
          pageText = _props.pageText,
          pagesUnknown = _props.pagesUnknown,
          isLastPage = _props.isLastPage,
          pageInputDisabled = _props.pageInputDisabled,
          totalItems = _props.totalItems,
          onChange = _props.onChange,
          onChangeInterval = _props.onChangeInterval,
          pageNumber = _props.page,
          other = _objectWithoutProperties(_props, ["backwardText", "className", "defaultItemText", "defaultPageText", "forwardText", "id", "itemsPerPageText", "itemRangeText", "pageNumberText", "pageRangeText", "pageSize", "pageSizes", "itemText", "pageText", "pagesUnknown", "isLastPage", "pageInputDisabled", "totalItems", "onChange", "onChangeInterval", "page"]);

      var statePage = this.state.page;
      var statePageSize = this.state.pageSize;
      var totalPages = Math.max(Math.ceil(totalItems / statePageSize), 1);
      var classNames = (0, _classnames.default)('bx--pagination', className);
      var inputId = id || this.uniqueId;
      return _react.default.createElement("div", _extends({
        className: classNames
      }, other), _react.default.createElement("div", {
        className: "bx--pagination__left"
      }, _react.default.createElement(_Select.default, {
        id: "bx-pagination-select-".concat(inputId),
        labelText: itemsPerPageText,
        hideLabel: true,
        onChange: this.handleSizeChange,
        value: statePageSize
      }, pageSizes.map(function (size) {
        return _react.default.createElement(_SelectItem.default, {
          key: size,
          value: size,
          text: String(size)
        });
      })), _react.default.createElement("span", {
        className: "bx--pagination__text"
      }, itemsPerPageText), _react.default.createElement("span", {
        className: "bx--pagination__text"
      }, this.getItemsText())), _react.default.createElement("div", {
        className: "bx--pagination__right"
      }, _react.default.createElement("span", {
        className: "bx--pagination__text"
      }, this.getPagesText()), _react.default.createElement("button", {
        className: "bx--pagination__button bx--pagination__button--backward",
        onClick: this.decrementPage,
        disabled: this.props.disabled || statePage === 1
      }, _react.default.createElement(_Icon.default, {
        className: "bx--pagination__button-icon",
        name: "chevron--left",
        description: backwardText
      })), pageInputDisabled ? _react.default.createElement("span", {
        className: "bx--pagination__text"
      }, "|") : _react.default.createElement(_TextInput.default, {
        id: "bx-pagination-input-".concat(inputId),
        value: statePage > 0 ? statePage : '',
        onChange: this.handlePageInputChange,
        labelText: pageNumberText,
        hideLabel: true
      }), _react.default.createElement("button", {
        className: "bx--pagination__button bx--pagination__button--forward",
        onClick: this.incrementPage,
        disabled: this.props.disabled || statePage === totalPages || isLastPage
      }, _react.default.createElement(_Icon.default, {
        className: "bx--pagination__button-icon",
        name: "chevron--right",
        description: forwardText
      }))));
    }
  }]);

  return Pagination;
}(_react.Component);

exports.default = Pagination;
Object.defineProperty(Pagination, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    backwardText: _propTypes.default.string,
    className: _propTypes.default.string,
    itemRangeText: _propTypes.default.func,
    forwardText: _propTypes.default.string,
    id: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),
    itemsPerPageText: _propTypes.default.string,
    itemText: _propTypes.default.func,
    onChange: _propTypes.default.func,
    pageNumberText: _propTypes.default.string,
    pageRangeText: _propTypes.default.func,
    pageText: _propTypes.default.func,
    pageSizes: _propTypes.default.arrayOf(_propTypes.default.number).isRequired,
    totalItems: _propTypes.default.number,
    disabled: _propTypes.default.bool,
    page: _propTypes.default.number,
    pageSize: _propTypes.default.number,
    pagesUnknown: _propTypes.default.bool,
    isLastPage: _propTypes.default.bool,
    pageInputDisabled: _propTypes.default.bool,
    onChangeInterval: _propTypes.default.number,
    defaultPageText: _propTypes.default.func,
    defaultItemText: _propTypes.default.func
  }
});
Object.defineProperty(Pagination, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    backwardText: 'Backward',
    itemRangeText: function itemRangeText(min, max, total) {
      return "".concat(min, "-").concat(max, " of ").concat(total, " items");
    },
    forwardText: 'Forward',
    itemsPerPageText: 'items per page | ',
    onChange: function onChange() {},
    pageNumberText: 'Page Number',
    pageRangeText: function pageRangeText(current, total) {
      return "".concat(current, " of ").concat(total, " pages");
    },
    disabled: false,
    page: 1,
    pagesUnknown: false,
    isLastPage: false,
    pageInputDisabled: false,
    itemText: function itemText(min, max) {
      return "".concat(min, "-").concat(max, " items");
    },
    pageText: function pageText(page) {
      return "page ".concat(page);
    },
    defaultPageText: function defaultPageText(totalPages) {
      return "".concat(totalPages, " pages");
    },
    defaultItemText: function defaultItemText(totalItems) {
      return "".concat(totalItems, " items");
    },
    onChangeInterval: 250
  }
});