function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

import React from 'react';
import { storiesOf } from '@storybook/react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, text } from '@storybook/addon-knobs';
import Select from '../Select';
import SelectItem from '../SelectItem';
import SelectItemGroup from '../SelectItemGroup';
import SelectSkeleton from '../Select/Select.Skeleton';
var props = {
  select: function select() {
    return {
      className: 'some-class',
      light: boolean('Light variant (light in <Select>)', false),
      inline: boolean('Put control in-line with label (inline in <Select>)', false),
      disabled: boolean('Disabled (disabled in <Select>)', false),
      hideLabel: boolean('No label (hideLabel in <Select>)', false),
      invalid: boolean('Show form validation UI (invalid in <Select>)', false),
      invalidText: text('Form validation UI content (invalidText in <Select>)', 'A valid value is required'),
      helperText: text('Helper text (helperText)', 'Optional helper text.'),
      onChange: action('onChange')
    };
  },
  group: function group() {
    return {
      disabled: boolean('Disabled (disabled in <SelectItemGroup>)', false)
    };
  }
};
storiesOf('Select', module).addDecorator(withKnobs).add('Default', function () {
  var groupProps = props.group();
  return React.createElement(Select, _extends({}, props.select(), {
    id: "select-1",
    defaultValue: "placeholder-item"
  }), React.createElement(SelectItem, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), React.createElement(SelectItemGroup, _extends({
    label: "Category 1"
  }, groupProps), React.createElement(SelectItem, {
    value: "option-1",
    text: "Option 1"
  }), React.createElement(SelectItem, {
    value: "option-2",
    text: "Option 2"
  })), React.createElement(SelectItemGroup, _extends({
    label: "Category 2"
  }, groupProps), React.createElement(SelectItem, {
    value: "option-3",
    text: "Option 3"
  }), React.createElement(SelectItem, {
    value: "option-4",
    text: "Option 4"
  })));
}, {
  info: {
    text: "\n            Select displays a list below its title when selected. They are used primarily in forms,\n            where a user chooses one option from a list. Once the user selects an item, the dropdown will\n            disappear and the field will reflect the user's choice. Create Select Item components for each\n            option in the list. The example below shows an enabled Select component with three items.\n          "
  }
}).add('skeleton', function () {
  return React.createElement("div", {
    style: {
      width: '300px'
    }
  }, React.createElement(SelectSkeleton, null));
}, {
  info: {
    text: "\n            Placeholder skeleton state to use when content is loading.\n          "
  }
});