// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/http/original_ip_detection/custom_header/v3/custom_header.proto

package envoy_extensions_http_original_ip_detection_custom_header_v3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"strings"
	"time"
	"unicode/utf8"

	"github.com/golang/protobuf/ptypes"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = ptypes.DynamicAny{}
)

// Validate checks the field values on CustomHeaderConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, an error is returned.
func (m *CustomHeaderConfig) Validate() error {
	if m == nil {
		return nil
	}

	if utf8.RuneCountInString(m.GetHeaderName()) < 1 {
		return CustomHeaderConfigValidationError{
			field:  "HeaderName",
			reason: "value length must be at least 1 runes",
		}
	}

	if !_CustomHeaderConfig_HeaderName_Pattern.MatchString(m.GetHeaderName()) {
		return CustomHeaderConfigValidationError{
			field:  "HeaderName",
			reason: "value does not match regex pattern \"^:?[0-9a-zA-Z!#$%&'*+-.^_|~`]+$\"",
		}
	}

	// no validation rules for AllowExtensionToSetAddressAsTrusted

	if v, ok := interface{}(m.GetRejectWithStatus()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CustomHeaderConfigValidationError{
				field:  "RejectWithStatus",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	return nil
}

// CustomHeaderConfigValidationError is the validation error returned by
// CustomHeaderConfig.Validate if the designated constraints aren't met.
type CustomHeaderConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CustomHeaderConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CustomHeaderConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CustomHeaderConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CustomHeaderConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CustomHeaderConfigValidationError) ErrorName() string {
	return "CustomHeaderConfigValidationError"
}

// Error satisfies the builtin error interface
func (e CustomHeaderConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCustomHeaderConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CustomHeaderConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CustomHeaderConfigValidationError{}

var _CustomHeaderConfig_HeaderName_Pattern = regexp.MustCompile("^:?[0-9a-zA-Z!#$%&'*+-.^_|~`]+$")
