// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package databricks

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/databricks/mgmt/2021-04-01-preview/databricks"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type CustomParameterType = original.CustomParameterType

const (
	CustomParameterTypeBool   CustomParameterType = original.CustomParameterTypeBool
	CustomParameterTypeObject CustomParameterType = original.CustomParameterTypeObject
	CustomParameterTypeString CustomParameterType = original.CustomParameterTypeString
)

type KeySource = original.KeySource

const (
	KeySourceDefault           KeySource = original.KeySourceDefault
	KeySourceMicrosoftKeyvault KeySource = original.KeySourceMicrosoftKeyvault
)

type PeeringProvisioningState = original.PeeringProvisioningState

const (
	PeeringProvisioningStateDeleting  PeeringProvisioningState = original.PeeringProvisioningStateDeleting
	PeeringProvisioningStateFailed    PeeringProvisioningState = original.PeeringProvisioningStateFailed
	PeeringProvisioningStateSucceeded PeeringProvisioningState = original.PeeringProvisioningStateSucceeded
	PeeringProvisioningStateUpdating  PeeringProvisioningState = original.PeeringProvisioningStateUpdating
)

type PeeringState = original.PeeringState

const (
	PeeringStateConnected    PeeringState = original.PeeringStateConnected
	PeeringStateDisconnected PeeringState = original.PeeringStateDisconnected
	PeeringStateInitiated    PeeringState = original.PeeringStateInitiated
)

type PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningState

const (
	PrivateEndpointConnectionProvisioningStateCreating  PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateCreating
	PrivateEndpointConnectionProvisioningStateDeleting  PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateDeleting
	PrivateEndpointConnectionProvisioningStateFailed    PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateFailed
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateSucceeded
	PrivateEndpointConnectionProvisioningStateUpdating  PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateUpdating
)

type PrivateLinkServiceConnectionStatus = original.PrivateLinkServiceConnectionStatus

const (
	PrivateLinkServiceConnectionStatusApproved     PrivateLinkServiceConnectionStatus = original.PrivateLinkServiceConnectionStatusApproved
	PrivateLinkServiceConnectionStatusDisconnected PrivateLinkServiceConnectionStatus = original.PrivateLinkServiceConnectionStatusDisconnected
	PrivateLinkServiceConnectionStatusPending      PrivateLinkServiceConnectionStatus = original.PrivateLinkServiceConnectionStatusPending
	PrivateLinkServiceConnectionStatusRejected     PrivateLinkServiceConnectionStatus = original.PrivateLinkServiceConnectionStatusRejected
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateAccepted  ProvisioningState = original.ProvisioningStateAccepted
	ProvisioningStateCanceled  ProvisioningState = original.ProvisioningStateCanceled
	ProvisioningStateCreated   ProvisioningState = original.ProvisioningStateCreated
	ProvisioningStateCreating  ProvisioningState = original.ProvisioningStateCreating
	ProvisioningStateDeleted   ProvisioningState = original.ProvisioningStateDeleted
	ProvisioningStateDeleting  ProvisioningState = original.ProvisioningStateDeleting
	ProvisioningStateFailed    ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateReady     ProvisioningState = original.ProvisioningStateReady
	ProvisioningStateRunning   ProvisioningState = original.ProvisioningStateRunning
	ProvisioningStateSucceeded ProvisioningState = original.ProvisioningStateSucceeded
	ProvisioningStateUpdating  ProvisioningState = original.ProvisioningStateUpdating
)

type PublicNetworkAccess = original.PublicNetworkAccess

const (
	PublicNetworkAccessDisabled PublicNetworkAccess = original.PublicNetworkAccessDisabled
	PublicNetworkAccessEnabled  PublicNetworkAccess = original.PublicNetworkAccessEnabled
)

type RequiredNsgRules = original.RequiredNsgRules

const (
	RequiredNsgRulesAllRules               RequiredNsgRules = original.RequiredNsgRulesAllRules
	RequiredNsgRulesNoAzureDatabricksRules RequiredNsgRules = original.RequiredNsgRulesNoAzureDatabricksRules
	RequiredNsgRulesNoAzureServiceRules    RequiredNsgRules = original.RequiredNsgRulesNoAzureServiceRules
)

type AddressSpace = original.AddressSpace
type BaseClient = original.BaseClient
type CreatedBy = original.CreatedBy
type Encryption = original.Encryption
type EncryptionEntitiesDefinition = original.EncryptionEntitiesDefinition
type EncryptionV2 = original.EncryptionV2
type EncryptionV2KeyVaultProperties = original.EncryptionV2KeyVaultProperties
type ErrorDetail = original.ErrorDetail
type ErrorInfo = original.ErrorInfo
type ErrorResponse = original.ErrorResponse
type GroupIDInformation = original.GroupIDInformation
type GroupIDInformationProperties = original.GroupIDInformationProperties
type ManagedIdentityConfiguration = original.ManagedIdentityConfiguration
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationsClient = original.OperationsClient
type PrivateEndpoint = original.PrivateEndpoint
type PrivateEndpointConnection = original.PrivateEndpointConnection
type PrivateEndpointConnectionProperties = original.PrivateEndpointConnectionProperties
type PrivateEndpointConnectionsClient = original.PrivateEndpointConnectionsClient
type PrivateEndpointConnectionsCreateFuture = original.PrivateEndpointConnectionsCreateFuture
type PrivateEndpointConnectionsDeleteFuture = original.PrivateEndpointConnectionsDeleteFuture
type PrivateEndpointConnectionsList = original.PrivateEndpointConnectionsList
type PrivateEndpointConnectionsListIterator = original.PrivateEndpointConnectionsListIterator
type PrivateEndpointConnectionsListPage = original.PrivateEndpointConnectionsListPage
type PrivateLinkResourcesClient = original.PrivateLinkResourcesClient
type PrivateLinkResourcesList = original.PrivateLinkResourcesList
type PrivateLinkResourcesListIterator = original.PrivateLinkResourcesListIterator
type PrivateLinkResourcesListPage = original.PrivateLinkResourcesListPage
type PrivateLinkServiceConnectionState = original.PrivateLinkServiceConnectionState
type Resource = original.Resource
type Sku = original.Sku
type SystemData = original.SystemData
type TrackedResource = original.TrackedResource
type VNetPeeringClient = original.VNetPeeringClient
type VNetPeeringCreateOrUpdateFuture = original.VNetPeeringCreateOrUpdateFuture
type VNetPeeringDeleteFuture = original.VNetPeeringDeleteFuture
type VirtualNetworkPeering = original.VirtualNetworkPeering
type VirtualNetworkPeeringList = original.VirtualNetworkPeeringList
type VirtualNetworkPeeringListIterator = original.VirtualNetworkPeeringListIterator
type VirtualNetworkPeeringListPage = original.VirtualNetworkPeeringListPage
type VirtualNetworkPeeringPropertiesFormat = original.VirtualNetworkPeeringPropertiesFormat
type VirtualNetworkPeeringPropertiesFormatDatabricksVirtualNetwork = original.VirtualNetworkPeeringPropertiesFormatDatabricksVirtualNetwork
type VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetwork = original.VirtualNetworkPeeringPropertiesFormatRemoteVirtualNetwork
type Workspace = original.Workspace
type WorkspaceCustomBooleanParameter = original.WorkspaceCustomBooleanParameter
type WorkspaceCustomObjectParameter = original.WorkspaceCustomObjectParameter
type WorkspaceCustomParameters = original.WorkspaceCustomParameters
type WorkspaceCustomStringParameter = original.WorkspaceCustomStringParameter
type WorkspaceEncryptionParameter = original.WorkspaceEncryptionParameter
type WorkspaceListResult = original.WorkspaceListResult
type WorkspaceListResultIterator = original.WorkspaceListResultIterator
type WorkspaceListResultPage = original.WorkspaceListResultPage
type WorkspaceProperties = original.WorkspaceProperties
type WorkspacePropertiesEncryption = original.WorkspacePropertiesEncryption
type WorkspaceProviderAuthorization = original.WorkspaceProviderAuthorization
type WorkspaceUpdate = original.WorkspaceUpdate
type WorkspacesClient = original.WorkspacesClient
type WorkspacesCreateOrUpdateFuture = original.WorkspacesCreateOrUpdateFuture
type WorkspacesDeleteFuture = original.WorkspacesDeleteFuture
type WorkspacesUpdateFuture = original.WorkspacesUpdateFuture

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionsClient(subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClient(subscriptionID)
}
func NewPrivateEndpointConnectionsClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionsListIterator(page PrivateEndpointConnectionsListPage) PrivateEndpointConnectionsListIterator {
	return original.NewPrivateEndpointConnectionsListIterator(page)
}
func NewPrivateEndpointConnectionsListPage(cur PrivateEndpointConnectionsList, getNextPage func(context.Context, PrivateEndpointConnectionsList) (PrivateEndpointConnectionsList, error)) PrivateEndpointConnectionsListPage {
	return original.NewPrivateEndpointConnectionsListPage(cur, getNextPage)
}
func NewPrivateLinkResourcesClient(subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClient(subscriptionID)
}
func NewPrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkResourcesListIterator(page PrivateLinkResourcesListPage) PrivateLinkResourcesListIterator {
	return original.NewPrivateLinkResourcesListIterator(page)
}
func NewPrivateLinkResourcesListPage(cur PrivateLinkResourcesList, getNextPage func(context.Context, PrivateLinkResourcesList) (PrivateLinkResourcesList, error)) PrivateLinkResourcesListPage {
	return original.NewPrivateLinkResourcesListPage(cur, getNextPage)
}
func NewVNetPeeringClient(subscriptionID string) VNetPeeringClient {
	return original.NewVNetPeeringClient(subscriptionID)
}
func NewVNetPeeringClientWithBaseURI(baseURI string, subscriptionID string) VNetPeeringClient {
	return original.NewVNetPeeringClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkPeeringListIterator(page VirtualNetworkPeeringListPage) VirtualNetworkPeeringListIterator {
	return original.NewVirtualNetworkPeeringListIterator(page)
}
func NewVirtualNetworkPeeringListPage(cur VirtualNetworkPeeringList, getNextPage func(context.Context, VirtualNetworkPeeringList) (VirtualNetworkPeeringList, error)) VirtualNetworkPeeringListPage {
	return original.NewVirtualNetworkPeeringListPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewWorkspaceListResultIterator(page WorkspaceListResultPage) WorkspaceListResultIterator {
	return original.NewWorkspaceListResultIterator(page)
}
func NewWorkspaceListResultPage(cur WorkspaceListResult, getNextPage func(context.Context, WorkspaceListResult) (WorkspaceListResult, error)) WorkspaceListResultPage {
	return original.NewWorkspaceListResultPage(cur, getNextPage)
}
func NewWorkspacesClient(subscriptionID string) WorkspacesClient {
	return original.NewWorkspacesClient(subscriptionID)
}
func NewWorkspacesClientWithBaseURI(baseURI string, subscriptionID string) WorkspacesClient {
	return original.NewWorkspacesClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleCustomParameterTypeValues() []CustomParameterType {
	return original.PossibleCustomParameterTypeValues()
}
func PossibleKeySourceValues() []KeySource {
	return original.PossibleKeySourceValues()
}
func PossiblePeeringProvisioningStateValues() []PeeringProvisioningState {
	return original.PossiblePeeringProvisioningStateValues()
}
func PossiblePeeringStateValues() []PeeringState {
	return original.PossiblePeeringStateValues()
}
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return original.PossiblePrivateEndpointConnectionProvisioningStateValues()
}
func PossiblePrivateLinkServiceConnectionStatusValues() []PrivateLinkServiceConnectionStatus {
	return original.PossiblePrivateLinkServiceConnectionStatusValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return original.PossiblePublicNetworkAccessValues()
}
func PossibleRequiredNsgRulesValues() []RequiredNsgRules {
	return original.PossibleRequiredNsgRulesValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
