// DO NOT EDIT: This file is autogenerated via the builtin command.

package influxdb

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 2,
					Line:   99,
				},
				File:   "influxdb.flux",
				Source: "package influxdb\n\n\nimport \"influxdata/influxdb\"\nimport \"influxdata/influxdb/v1\"\n\n// _mask will hide the given columns from downstream\n// transformations. It will not perform any copies and\n// it will not regroup. This should only be used when\n// the user knows it can't cause a key conflict.\nbuiltin _mask : (<-tables: [A], columns: [string]) => [B] where A: Record, B: Record\n\n// from will retrieve data from a bucket between the start and stop time.\n// This version of from is the equivalent of doing from |> range\n// as a single call.\nfrom = (\n        bucket,\n        start,\n        stop=now(),\n        org=\"\",\n        host=\"\",\n        token=\"\",\n) => {\n    source = if org != \"\" and host != \"\" and token != \"\" then\n        influxdb.from(bucket, org, host, token)\n    else if org != \"\" and token != \"\" then\n        influxdb.from(bucket, org, token)\n    else if org != \"\" and host != \"\" then\n        influxdb.from(bucket, org, host)\n    else if host != \"\" and token != \"\" then\n        influxdb.from(bucket, host, token)\n    else if org != \"\" then\n        influxdb.from(bucket, org)\n    else if host != \"\" then\n        influxdb.from(bucket, host)\n    else if token != \"\" then\n        influxdb.from(bucket, token)\n    else\n        influxdb.from(bucket)\n\n    return source |> range(start, stop)\n}\n\n// _from allows us to reference the from function from\n// within the select call which has a function parameter\n// with the same name.\n_from = from\n\n// select will select data from an influxdb instance within\n// the range between `start` and `stop` from the bucket specified by\n// the `from` parameter. It will select the specific measurement\n// and it will only include fields that are included in the list of\n// `fields`.\n//\n// In order to filter by tags, the `where` function can be used to further\n// limit the amount of data selected.\nselect = (\n        from,\n        start,\n        stop=now(),\n        m,\n        fields=[],\n        org=\"\",\n        host=\"\",\n        token=\"\",\n        where=(r) => true,\n) => {\n    bucket = from\n    tables = _from(\n        bucket,\n        start,\n        stop,\n        org,\n        host,\n        token,\n    )\n        |> filter(fn: (r) => r._measurement == m)\n        |> filter(fn: where)\n    nfields = length(arr: fields)\n    fn = if nfields == 0 then\n        (r) => true\n    else if nfields == 1 then\n        (r) => r._field == fields[0]\n    else if nfields == 2 then\n        (r) => r._field == fields[0] or r._field == fields[1]\n    else if nfields == 3 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n    else if nfields == 4 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n    else if nfields == 5 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n    else\n        (r) => contains(value: r._field, set: fields)\n\n    return tables\n        |> filter(fn)\n        |> v1.fieldsAsCols()\n        |> _mask(columns: [\"_measurement\", \"_start\", \"_stop\"])\n}",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// _mask will hide the given columns from downstream\n"}, ast.Comment{Text: "// transformations. It will not perform any copies and\n"}, ast.Comment{Text: "// it will not regroup. This should only be used when\n"}, ast.Comment{Text: "// the user knows it can't cause a key conflict.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   11,
					},
					File:   "influxdb.flux",
					Source: "builtin _mask",
					Start: ast.Position{
						Column: 1,
						Line:   11,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   11,
						},
						File:   "influxdb.flux",
						Source: "_mask",
						Start: ast.Position{
							Column: 9,
							Line:   11,
						},
					},
				},
				Name: "_mask",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   11,
						},
						File:   "influxdb.flux",
						Source: "(<-tables: [A], columns: [string]) => [B] where A: Record, B: Record",
						Start: ast.Position{
							Column: 17,
							Line:   11,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 74,
								Line:   11,
							},
							File:   "influxdb.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 65,
								Line:   11,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 74,
									Line:   11,
								},
								File:   "influxdb.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 68,
									Line:   11,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   11,
								},
								File:   "influxdb.flux",
								Source: "A",
								Start: ast.Position{
									Column: 65,
									Line:   11,
								},
							},
						},
						Name: "A",
					},
				}, &ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   11,
							},
							File:   "influxdb.flux",
							Source: "B: Record",
							Start: ast.Position{
								Column: 76,
								Line:   11,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   11,
								},
								File:   "influxdb.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 79,
									Line:   11,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 77,
									Line:   11,
								},
								File:   "influxdb.flux",
								Source: "B",
								Start: ast.Position{
									Column: 76,
									Line:   11,
								},
							},
						},
						Name: "B",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   11,
							},
							File:   "influxdb.flux",
							Source: "(<-tables: [A], columns: [string]) => [B]",
							Start: ast.Position{
								Column: 17,
								Line:   11,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   11,
								},
								File:   "influxdb.flux",
								Source: "<-tables: [A]",
								Start: ast.Position{
									Column: 18,
									Line:   11,
								},
							},
						},
						Kind: "Pipe",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   11,
									},
									File:   "influxdb.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 20,
										Line:   11,
									},
								},
							},
							Name: "tables",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   11,
									},
									File:   "influxdb.flux",
									Source: "[A]",
									Start: ast.Position{
										Column: 28,
										Line:   11,
									},
								},
							},
							ElementType: &ast.TvarType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   11,
										},
										File:   "influxdb.flux",
										Source: "A",
										Start: ast.Position{
											Column: 29,
											Line:   11,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   11,
											},
											File:   "influxdb.flux",
											Source: "A",
											Start: ast.Position{
												Column: 29,
												Line:   11,
											},
										},
									},
									Name: "A",
								},
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   11,
								},
								File:   "influxdb.flux",
								Source: "columns: [string]",
								Start: ast.Position{
									Column: 33,
									Line:   11,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   11,
									},
									File:   "influxdb.flux",
									Source: "columns",
									Start: ast.Position{
										Column: 33,
										Line:   11,
									},
								},
							},
							Name: "columns",
						},
						Ty: &ast.ArrayType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   11,
									},
									File:   "influxdb.flux",
									Source: "[string]",
									Start: ast.Position{
										Column: 42,
										Line:   11,
									},
								},
							},
							ElementType: &ast.NamedType{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   11,
										},
										File:   "influxdb.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   11,
										},
									},
								},
								ID: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 49,
												Line:   11,
											},
											File:   "influxdb.flux",
											Source: "string",
											Start: ast.Position{
												Column: 43,
												Line:   11,
											},
										},
									},
									Name: "string",
								},
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   11,
								},
								File:   "influxdb.flux",
								Source: "[B]",
								Start: ast.Position{
									Column: 55,
									Line:   11,
								},
							},
						},
						ElementType: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   11,
									},
									File:   "influxdb.flux",
									Source: "B",
									Start: ast.Position{
										Column: 56,
										Line:   11,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   11,
										},
										File:   "influxdb.flux",
										Source: "B",
										Start: ast.Position{
											Column: 56,
											Line:   11,
										},
									},
								},
								Name: "B",
							},
						},
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   42,
					},
					File:   "influxdb.flux",
					Source: "from = (\n        bucket,\n        start,\n        stop=now(),\n        org=\"\",\n        host=\"\",\n        token=\"\",\n) => {\n    source = if org != \"\" and host != \"\" and token != \"\" then\n        influxdb.from(bucket, org, host, token)\n    else if org != \"\" and token != \"\" then\n        influxdb.from(bucket, org, token)\n    else if org != \"\" and host != \"\" then\n        influxdb.from(bucket, org, host)\n    else if host != \"\" and token != \"\" then\n        influxdb.from(bucket, host, token)\n    else if org != \"\" then\n        influxdb.from(bucket, org)\n    else if host != \"\" then\n        influxdb.from(bucket, host)\n    else if token != \"\" then\n        influxdb.from(bucket, token)\n    else\n        influxdb.from(bucket)\n\n    return source |> range(start, stop)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   16,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// from will retrieve data from a bucket between the start and stop time.\n"}, ast.Comment{Text: "// This version of from is the equivalent of doing from |> range\n"}, ast.Comment{Text: "// as a single call.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   16,
						},
						File:   "influxdb.flux",
						Source: "from",
						Start: ast.Position{
							Column: 1,
							Line:   16,
						},
					},
				},
				Name: "from",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   42,
						},
						File:   "influxdb.flux",
						Source: "(\n        bucket,\n        start,\n        stop=now(),\n        org=\"\",\n        host=\"\",\n        token=\"\",\n) => {\n    source = if org != \"\" and host != \"\" and token != \"\" then\n        influxdb.from(bucket, org, host, token)\n    else if org != \"\" and token != \"\" then\n        influxdb.from(bucket, org, token)\n    else if org != \"\" and host != \"\" then\n        influxdb.from(bucket, org, host)\n    else if host != \"\" and token != \"\" then\n        influxdb.from(bucket, host, token)\n    else if org != \"\" then\n        influxdb.from(bucket, org)\n    else if host != \"\" then\n        influxdb.from(bucket, host)\n    else if token != \"\" then\n        influxdb.from(bucket, token)\n    else\n        influxdb.from(bucket)\n\n    return source |> range(start, stop)\n}",
						Start: ast.Position{
							Column: 8,
							Line:   16,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   42,
							},
							File:   "influxdb.flux",
							Source: "{\n    source = if org != \"\" and host != \"\" and token != \"\" then\n        influxdb.from(bucket, org, host, token)\n    else if org != \"\" and token != \"\" then\n        influxdb.from(bucket, org, token)\n    else if org != \"\" and host != \"\" then\n        influxdb.from(bucket, org, host)\n    else if host != \"\" and token != \"\" then\n        influxdb.from(bucket, host, token)\n    else if org != \"\" then\n        influxdb.from(bucket, org)\n    else if host != \"\" then\n        influxdb.from(bucket, host)\n    else if token != \"\" then\n        influxdb.from(bucket, token)\n    else\n        influxdb.from(bucket)\n\n    return source |> range(start, stop)\n}",
							Start: ast.Position{
								Column: 6,
								Line:   23,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   39,
								},
								File:   "influxdb.flux",
								Source: "source = if org != \"\" and host != \"\" and token != \"\" then\n        influxdb.from(bucket, org, host, token)\n    else if org != \"\" and token != \"\" then\n        influxdb.from(bucket, org, token)\n    else if org != \"\" and host != \"\" then\n        influxdb.from(bucket, org, host)\n    else if host != \"\" and token != \"\" then\n        influxdb.from(bucket, host, token)\n    else if org != \"\" then\n        influxdb.from(bucket, org)\n    else if host != \"\" then\n        influxdb.from(bucket, host)\n    else if token != \"\" then\n        influxdb.from(bucket, token)\n    else\n        influxdb.from(bucket)",
								Start: ast.Position{
									Column: 5,
									Line:   24,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   24,
									},
									File:   "influxdb.flux",
									Source: "source",
									Start: ast.Position{
										Column: 5,
										Line:   24,
									},
								},
							},
							Name: "source",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.ConditionalExpression{
								Alternate: &ast.ConditionalExpression{
									Alternate: &ast.ConditionalExpression{
										Alternate: &ast.ConditionalExpression{
											Alternate: &ast.ConditionalExpression{
												Alternate: &ast.ConditionalExpression{
													Alternate: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   39,
																	},
																	File:   "influxdb.flux",
																	Source: "bucket",
																	Start: ast.Position{
																		Column: 23,
																		Line:   39,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   39,
																		},
																		File:   "influxdb.flux",
																		Source: "bucket",
																		Start: ast.Position{
																			Column: 23,
																			Line:   39,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   39,
																			},
																			File:   "influxdb.flux",
																			Source: "bucket",
																			Start: ast.Position{
																				Column: 23,
																				Line:   39,
																			},
																		},
																	},
																	Name: "bucket",
																},
																Separator: nil,
																Value:     nil,
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   39,
																},
																File:   "influxdb.flux",
																Source: "influxdb.from(bucket)",
																Start: ast.Position{
																	Column: 9,
																	Line:   39,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   39,
																	},
																	File:   "influxdb.flux",
																	Source: "influxdb.from",
																	Start: ast.Position{
																		Column: 9,
																		Line:   39,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 17,
																			Line:   39,
																		},
																		File:   "influxdb.flux",
																		Source: "influxdb",
																		Start: ast.Position{
																			Column: 9,
																			Line:   39,
																		},
																	},
																},
																Name: "influxdb",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   39,
																		},
																		File:   "influxdb.flux",
																		Source: "from",
																		Start: ast.Position{
																			Column: 18,
																			Line:   39,
																		},
																	},
																},
																Name: "from",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   39,
															},
															File:   "influxdb.flux",
															Source: "if token != \"\" then\n        influxdb.from(bucket, token)\n    else\n        influxdb.from(bucket)",
															Start: ast.Position{
																Column: 10,
																Line:   36,
															},
														},
													},
													Consequent: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 36,
																		Line:   37,
																	},
																	File:   "influxdb.flux",
																	Source: "bucket, token",
																	Start: ast.Position{
																		Column: 23,
																		Line:   37,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   37,
																		},
																		File:   "influxdb.flux",
																		Source: "bucket",
																		Start: ast.Position{
																			Column: 23,
																			Line:   37,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   37,
																			},
																			File:   "influxdb.flux",
																			Source: "bucket",
																			Start: ast.Position{
																				Column: 23,
																				Line:   37,
																			},
																		},
																	},
																	Name: "bucket",
																},
																Separator: nil,
																Value:     nil,
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   37,
																		},
																		File:   "influxdb.flux",
																		Source: "token",
																		Start: ast.Position{
																			Column: 31,
																			Line:   37,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 36,
																				Line:   37,
																			},
																			File:   "influxdb.flux",
																			Source: "token",
																			Start: ast.Position{
																				Column: 31,
																				Line:   37,
																			},
																		},
																	},
																	Name: "token",
																},
																Separator: nil,
																Value:     nil,
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   37,
																},
																File:   "influxdb.flux",
																Source: "influxdb.from(bucket, token)",
																Start: ast.Position{
																	Column: 9,
																	Line:   37,
																},
															},
														},
														Callee: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   37,
																	},
																	File:   "influxdb.flux",
																	Source: "influxdb.from",
																	Start: ast.Position{
																		Column: 9,
																		Line:   37,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 17,
																			Line:   37,
																		},
																		File:   "influxdb.flux",
																		Source: "influxdb",
																		Start: ast.Position{
																			Column: 9,
																			Line:   37,
																		},
																	},
																},
																Name: "influxdb",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   37,
																		},
																		File:   "influxdb.flux",
																		Source: "from",
																		Start: ast.Position{
																			Column: 18,
																			Line:   37,
																		},
																	},
																},
																Name: "from",
															},
															Rbrack: nil,
														},
														Lparen: nil,
														Rparen: nil,
													},
													Test: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 24,
																	Line:   36,
																},
																File:   "influxdb.flux",
																Source: "token != \"\"",
																Start: ast.Position{
																	Column: 13,
																	Line:   36,
																},
															},
														},
														Left: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   36,
																	},
																	File:   "influxdb.flux",
																	Source: "token",
																	Start: ast.Position{
																		Column: 13,
																		Line:   36,
																	},
																},
															},
															Name: "token",
														},
														Operator: 18,
														Right: &ast.StringLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   36,
																	},
																	File:   "influxdb.flux",
																	Source: "\"\"",
																	Start: ast.Position{
																		Column: 22,
																		Line:   36,
																	},
																},
															},
															Value: "",
														},
													},
													Tk_else: nil,
													Tk_if:   nil,
													Tk_then: nil,
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   39,
														},
														File:   "influxdb.flux",
														Source: "if host != \"\" then\n        influxdb.from(bucket, host)\n    else if token != \"\" then\n        influxdb.from(bucket, token)\n    else\n        influxdb.from(bucket)",
														Start: ast.Position{
															Column: 10,
															Line:   34,
														},
													},
												},
												Consequent: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 35,
																	Line:   35,
																},
																File:   "influxdb.flux",
																Source: "bucket, host",
																Start: ast.Position{
																	Column: 23,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   35,
																	},
																	File:   "influxdb.flux",
																	Source: "bucket",
																	Start: ast.Position{
																		Column: 23,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   35,
																		},
																		File:   "influxdb.flux",
																		Source: "bucket",
																		Start: ast.Position{
																			Column: 23,
																			Line:   35,
																		},
																	},
																},
																Name: "bucket",
															},
															Separator: nil,
															Value:     nil,
														}, &ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 35,
																		Line:   35,
																	},
																	File:   "influxdb.flux",
																	Source: "host",
																	Start: ast.Position{
																		Column: 31,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 35,
																			Line:   35,
																		},
																		File:   "influxdb.flux",
																		Source: "host",
																		Start: ast.Position{
																			Column: 31,
																			Line:   35,
																		},
																	},
																},
																Name: "host",
															},
															Separator: nil,
															Value:     nil,
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 36,
																Line:   35,
															},
															File:   "influxdb.flux",
															Source: "influxdb.from(bucket, host)",
															Start: ast.Position{
																Column: 9,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   35,
																},
																File:   "influxdb.flux",
																Source: "influxdb.from",
																Start: ast.Position{
																	Column: 9,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 17,
																		Line:   35,
																	},
																	File:   "influxdb.flux",
																	Source: "influxdb",
																	Start: ast.Position{
																		Column: 9,
																		Line:   35,
																	},
																},
															},
															Name: "influxdb",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   35,
																	},
																	File:   "influxdb.flux",
																	Source: "from",
																	Start: ast.Position{
																		Column: 18,
																		Line:   35,
																	},
																},
															},
															Name: "from",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
												Test: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   34,
															},
															File:   "influxdb.flux",
															Source: "host != \"\"",
															Start: ast.Position{
																Column: 13,
																Line:   34,
															},
														},
													},
													Left: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   34,
																},
																File:   "influxdb.flux",
																Source: "host",
																Start: ast.Position{
																	Column: 13,
																	Line:   34,
																},
															},
														},
														Name: "host",
													},
													Operator: 18,
													Right: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 23,
																	Line:   34,
																},
																File:   "influxdb.flux",
																Source: "\"\"",
																Start: ast.Position{
																	Column: 21,
																	Line:   34,
																},
															},
														},
														Value: "",
													},
												},
												Tk_else: nil,
												Tk_if:   nil,
												Tk_then: nil,
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   39,
													},
													File:   "influxdb.flux",
													Source: "if org != \"\" then\n        influxdb.from(bucket, org)\n    else if host != \"\" then\n        influxdb.from(bucket, host)\n    else if token != \"\" then\n        influxdb.from(bucket, token)\n    else\n        influxdb.from(bucket)",
													Start: ast.Position{
														Column: 10,
														Line:   32,
													},
												},
											},
											Consequent: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   33,
															},
															File:   "influxdb.flux",
															Source: "bucket, org",
															Start: ast.Position{
																Column: 23,
																Line:   33,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 29,
																	Line:   33,
																},
																File:   "influxdb.flux",
																Source: "bucket",
																Start: ast.Position{
																	Column: 23,
																	Line:   33,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   33,
																	},
																	File:   "influxdb.flux",
																	Source: "bucket",
																	Start: ast.Position{
																		Column: 23,
																		Line:   33,
																	},
																},
															},
															Name: "bucket",
														},
														Separator: nil,
														Value:     nil,
													}, &ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   33,
																},
																File:   "influxdb.flux",
																Source: "org",
																Start: ast.Position{
																	Column: 31,
																	Line:   33,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 34,
																		Line:   33,
																	},
																	File:   "influxdb.flux",
																	Source: "org",
																	Start: ast.Position{
																		Column: 31,
																		Line:   33,
																	},
																},
															},
															Name: "org",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   33,
														},
														File:   "influxdb.flux",
														Source: "influxdb.from(bucket, org)",
														Start: ast.Position{
															Column: 9,
															Line:   33,
														},
													},
												},
												Callee: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   33,
															},
															File:   "influxdb.flux",
															Source: "influxdb.from",
															Start: ast.Position{
																Column: 9,
																Line:   33,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   33,
																},
																File:   "influxdb.flux",
																Source: "influxdb",
																Start: ast.Position{
																	Column: 9,
																	Line:   33,
																},
															},
														},
														Name: "influxdb",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 22,
																	Line:   33,
																},
																File:   "influxdb.flux",
																Source: "from",
																Start: ast.Position{
																	Column: 18,
																	Line:   33,
																},
															},
														},
														Name: "from",
													},
													Rbrack: nil,
												},
												Lparen: nil,
												Rparen: nil,
											},
											Test: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   32,
														},
														File:   "influxdb.flux",
														Source: "org != \"\"",
														Start: ast.Position{
															Column: 13,
															Line:   32,
														},
													},
												},
												Left: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 16,
																Line:   32,
															},
															File:   "influxdb.flux",
															Source: "org",
															Start: ast.Position{
																Column: 13,
																Line:   32,
															},
														},
													},
													Name: "org",
												},
												Operator: 18,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   32,
															},
															File:   "influxdb.flux",
															Source: "\"\"",
															Start: ast.Position{
																Column: 20,
																Line:   32,
															},
														},
													},
													Value: "",
												},
											},
											Tk_else: nil,
											Tk_if:   nil,
											Tk_then: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   39,
												},
												File:   "influxdb.flux",
												Source: "if host != \"\" and token != \"\" then\n        influxdb.from(bucket, host, token)\n    else if org != \"\" then\n        influxdb.from(bucket, org)\n    else if host != \"\" then\n        influxdb.from(bucket, host)\n    else if token != \"\" then\n        influxdb.from(bucket, token)\n    else\n        influxdb.from(bucket)",
												Start: ast.Position{
													Column: 10,
													Line:   30,
												},
											},
										},
										Consequent: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   31,
														},
														File:   "influxdb.flux",
														Source: "bucket, host, token",
														Start: ast.Position{
															Column: 23,
															Line:   31,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 29,
																Line:   31,
															},
															File:   "influxdb.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 23,
																Line:   31,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 29,
																	Line:   31,
																},
																File:   "influxdb.flux",
																Source: "bucket",
																Start: ast.Position{
																	Column: 23,
																	Line:   31,
																},
															},
														},
														Name: "bucket",
													},
													Separator: nil,
													Value:     nil,
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   31,
															},
															File:   "influxdb.flux",
															Source: "host",
															Start: ast.Position{
																Column: 31,
																Line:   31,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 35,
																	Line:   31,
																},
																File:   "influxdb.flux",
																Source: "host",
																Start: ast.Position{
																	Column: 31,
																	Line:   31,
																},
															},
														},
														Name: "host",
													},
													Separator: nil,
													Value:     nil,
												}, &ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   31,
															},
															File:   "influxdb.flux",
															Source: "token",
															Start: ast.Position{
																Column: 37,
																Line:   31,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   31,
																},
																File:   "influxdb.flux",
																Source: "token",
																Start: ast.Position{
																	Column: 37,
																	Line:   31,
																},
															},
														},
														Name: "token",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   31,
													},
													File:   "influxdb.flux",
													Source: "influxdb.from(bucket, host, token)",
													Start: ast.Position{
														Column: 9,
														Line:   31,
													},
												},
											},
											Callee: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   31,
														},
														File:   "influxdb.flux",
														Source: "influxdb.from",
														Start: ast.Position{
															Column: 9,
															Line:   31,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 17,
																Line:   31,
															},
															File:   "influxdb.flux",
															Source: "influxdb",
															Start: ast.Position{
																Column: 9,
																Line:   31,
															},
														},
													},
													Name: "influxdb",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 22,
																Line:   31,
															},
															File:   "influxdb.flux",
															Source: "from",
															Start: ast.Position{
																Column: 18,
																Line:   31,
															},
														},
													},
													Name: "from",
												},
												Rbrack: nil,
											},
											Lparen: nil,
											Rparen: nil,
										},
										Test: &ast.LogicalExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   30,
													},
													File:   "influxdb.flux",
													Source: "host != \"\" and token != \"\"",
													Start: ast.Position{
														Column: 13,
														Line:   30,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 23,
															Line:   30,
														},
														File:   "influxdb.flux",
														Source: "host != \"\"",
														Start: ast.Position{
															Column: 13,
															Line:   30,
														},
													},
												},
												Left: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 17,
																Line:   30,
															},
															File:   "influxdb.flux",
															Source: "host",
															Start: ast.Position{
																Column: 13,
																Line:   30,
															},
														},
													},
													Name: "host",
												},
												Operator: 18,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 23,
																Line:   30,
															},
															File:   "influxdb.flux",
															Source: "\"\"",
															Start: ast.Position{
																Column: 21,
																Line:   30,
															},
														},
													},
													Value: "",
												},
											},
											Operator: 1,
											Right: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   30,
														},
														File:   "influxdb.flux",
														Source: "token != \"\"",
														Start: ast.Position{
															Column: 28,
															Line:   30,
														},
													},
												},
												Left: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 33,
																Line:   30,
															},
															File:   "influxdb.flux",
															Source: "token",
															Start: ast.Position{
																Column: 28,
																Line:   30,
															},
														},
													},
													Name: "token",
												},
												Operator: 18,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   30,
															},
															File:   "influxdb.flux",
															Source: "\"\"",
															Start: ast.Position{
																Column: 37,
																Line:   30,
															},
														},
													},
													Value: "",
												},
											},
										},
										Tk_else: nil,
										Tk_if:   nil,
										Tk_then: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   39,
											},
											File:   "influxdb.flux",
											Source: "if org != \"\" and host != \"\" then\n        influxdb.from(bucket, org, host)\n    else if host != \"\" and token != \"\" then\n        influxdb.from(bucket, host, token)\n    else if org != \"\" then\n        influxdb.from(bucket, org)\n    else if host != \"\" then\n        influxdb.from(bucket, host)\n    else if token != \"\" then\n        influxdb.from(bucket, token)\n    else\n        influxdb.from(bucket)",
											Start: ast.Position{
												Column: 10,
												Line:   28,
											},
										},
									},
									Consequent: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   29,
													},
													File:   "influxdb.flux",
													Source: "bucket, org, host",
													Start: ast.Position{
														Column: 23,
														Line:   29,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   29,
														},
														File:   "influxdb.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 23,
															Line:   29,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 29,
																Line:   29,
															},
															File:   "influxdb.flux",
															Source: "bucket",
															Start: ast.Position{
																Column: 23,
																Line:   29,
															},
														},
													},
													Name: "bucket",
												},
												Separator: nil,
												Value:     nil,
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   29,
														},
														File:   "influxdb.flux",
														Source: "org",
														Start: ast.Position{
															Column: 31,
															Line:   29,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   29,
															},
															File:   "influxdb.flux",
															Source: "org",
															Start: ast.Position{
																Column: 31,
																Line:   29,
															},
														},
													},
													Name: "org",
												},
												Separator: nil,
												Value:     nil,
											}, &ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 40,
															Line:   29,
														},
														File:   "influxdb.flux",
														Source: "host",
														Start: ast.Position{
															Column: 36,
															Line:   29,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 40,
																Line:   29,
															},
															File:   "influxdb.flux",
															Source: "host",
															Start: ast.Position{
																Column: 36,
																Line:   29,
															},
														},
													},
													Name: "host",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   29,
												},
												File:   "influxdb.flux",
												Source: "influxdb.from(bucket, org, host)",
												Start: ast.Position{
													Column: 9,
													Line:   29,
												},
											},
										},
										Callee: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   29,
													},
													File:   "influxdb.flux",
													Source: "influxdb.from",
													Start: ast.Position{
														Column: 9,
														Line:   29,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   29,
														},
														File:   "influxdb.flux",
														Source: "influxdb",
														Start: ast.Position{
															Column: 9,
															Line:   29,
														},
													},
												},
												Name: "influxdb",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   29,
														},
														File:   "influxdb.flux",
														Source: "from",
														Start: ast.Position{
															Column: 18,
															Line:   29,
														},
													},
												},
												Name: "from",
											},
											Rbrack: nil,
										},
										Lparen: nil,
										Rparen: nil,
									},
									Test: &ast.LogicalExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   28,
												},
												File:   "influxdb.flux",
												Source: "org != \"\" and host != \"\"",
												Start: ast.Position{
													Column: 13,
													Line:   28,
												},
											},
										},
										Left: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   28,
													},
													File:   "influxdb.flux",
													Source: "org != \"\"",
													Start: ast.Position{
														Column: 13,
														Line:   28,
													},
												},
											},
											Left: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 16,
															Line:   28,
														},
														File:   "influxdb.flux",
														Source: "org",
														Start: ast.Position{
															Column: 13,
															Line:   28,
														},
													},
												},
												Name: "org",
											},
											Operator: 18,
											Right: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 22,
															Line:   28,
														},
														File:   "influxdb.flux",
														Source: "\"\"",
														Start: ast.Position{
															Column: 20,
															Line:   28,
														},
													},
												},
												Value: "",
											},
										},
										Operator: 1,
										Right: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   28,
													},
													File:   "influxdb.flux",
													Source: "host != \"\"",
													Start: ast.Position{
														Column: 27,
														Line:   28,
													},
												},
											},
											Left: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 31,
															Line:   28,
														},
														File:   "influxdb.flux",
														Source: "host",
														Start: ast.Position{
															Column: 27,
															Line:   28,
														},
													},
												},
												Name: "host",
											},
											Operator: 18,
											Right: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   28,
														},
														File:   "influxdb.flux",
														Source: "\"\"",
														Start: ast.Position{
															Column: 35,
															Line:   28,
														},
													},
												},
												Value: "",
											},
										},
									},
									Tk_else: nil,
									Tk_if:   nil,
									Tk_then: nil,
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   39,
										},
										File:   "influxdb.flux",
										Source: "if org != \"\" and token != \"\" then\n        influxdb.from(bucket, org, token)\n    else if org != \"\" and host != \"\" then\n        influxdb.from(bucket, org, host)\n    else if host != \"\" and token != \"\" then\n        influxdb.from(bucket, host, token)\n    else if org != \"\" then\n        influxdb.from(bucket, org)\n    else if host != \"\" then\n        influxdb.from(bucket, host)\n    else if token != \"\" then\n        influxdb.from(bucket, token)\n    else\n        influxdb.from(bucket)",
										Start: ast.Position{
											Column: 10,
											Line:   26,
										},
									},
								},
								Consequent: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   27,
												},
												File:   "influxdb.flux",
												Source: "bucket, org, token",
												Start: ast.Position{
													Column: 23,
													Line:   27,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   27,
													},
													File:   "influxdb.flux",
													Source: "bucket",
													Start: ast.Position{
														Column: 23,
														Line:   27,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   27,
														},
														File:   "influxdb.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 23,
															Line:   27,
														},
													},
												},
												Name: "bucket",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   27,
													},
													File:   "influxdb.flux",
													Source: "org",
													Start: ast.Position{
														Column: 31,
														Line:   27,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   27,
														},
														File:   "influxdb.flux",
														Source: "org",
														Start: ast.Position{
															Column: 31,
															Line:   27,
														},
													},
												},
												Name: "org",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   27,
													},
													File:   "influxdb.flux",
													Source: "token",
													Start: ast.Position{
														Column: 36,
														Line:   27,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 41,
															Line:   27,
														},
														File:   "influxdb.flux",
														Source: "token",
														Start: ast.Position{
															Column: 36,
															Line:   27,
														},
													},
												},
												Name: "token",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 42,
												Line:   27,
											},
											File:   "influxdb.flux",
											Source: "influxdb.from(bucket, org, token)",
											Start: ast.Position{
												Column: 9,
												Line:   27,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   27,
												},
												File:   "influxdb.flux",
												Source: "influxdb.from",
												Start: ast.Position{
													Column: 9,
													Line:   27,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 17,
														Line:   27,
													},
													File:   "influxdb.flux",
													Source: "influxdb",
													Start: ast.Position{
														Column: 9,
														Line:   27,
													},
												},
											},
											Name: "influxdb",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   27,
													},
													File:   "influxdb.flux",
													Source: "from",
													Start: ast.Position{
														Column: 18,
														Line:   27,
													},
												},
											},
											Name: "from",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
								Test: &ast.LogicalExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   26,
											},
											File:   "influxdb.flux",
											Source: "org != \"\" and token != \"\"",
											Start: ast.Position{
												Column: 13,
												Line:   26,
											},
										},
									},
									Left: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   26,
												},
												File:   "influxdb.flux",
												Source: "org != \"\"",
												Start: ast.Position{
													Column: 13,
													Line:   26,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   26,
													},
													File:   "influxdb.flux",
													Source: "org",
													Start: ast.Position{
														Column: 13,
														Line:   26,
													},
												},
											},
											Name: "org",
										},
										Operator: 18,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 22,
														Line:   26,
													},
													File:   "influxdb.flux",
													Source: "\"\"",
													Start: ast.Position{
														Column: 20,
														Line:   26,
													},
												},
											},
											Value: "",
										},
									},
									Operator: 1,
									Right: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   26,
												},
												File:   "influxdb.flux",
												Source: "token != \"\"",
												Start: ast.Position{
													Column: 27,
													Line:   26,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 32,
														Line:   26,
													},
													File:   "influxdb.flux",
													Source: "token",
													Start: ast.Position{
														Column: 27,
														Line:   26,
													},
												},
											},
											Name: "token",
										},
										Operator: 18,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 38,
														Line:   26,
													},
													File:   "influxdb.flux",
													Source: "\"\"",
													Start: ast.Position{
														Column: 36,
														Line:   26,
													},
												},
											},
											Value: "",
										},
									},
								},
								Tk_else: nil,
								Tk_if:   nil,
								Tk_then: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   39,
									},
									File:   "influxdb.flux",
									Source: "if org != \"\" and host != \"\" and token != \"\" then\n        influxdb.from(bucket, org, host, token)\n    else if org != \"\" and token != \"\" then\n        influxdb.from(bucket, org, token)\n    else if org != \"\" and host != \"\" then\n        influxdb.from(bucket, org, host)\n    else if host != \"\" and token != \"\" then\n        influxdb.from(bucket, host, token)\n    else if org != \"\" then\n        influxdb.from(bucket, org)\n    else if host != \"\" then\n        influxdb.from(bucket, host)\n    else if token != \"\" then\n        influxdb.from(bucket, token)\n    else\n        influxdb.from(bucket)",
									Start: ast.Position{
										Column: 14,
										Line:   24,
									},
								},
							},
							Consequent: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   25,
											},
											File:   "influxdb.flux",
											Source: "bucket, org, host, token",
											Start: ast.Position{
												Column: 23,
												Line:   25,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   25,
												},
												File:   "influxdb.flux",
												Source: "bucket",
												Start: ast.Position{
													Column: 23,
													Line:   25,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 29,
														Line:   25,
													},
													File:   "influxdb.flux",
													Source: "bucket",
													Start: ast.Position{
														Column: 23,
														Line:   25,
													},
												},
											},
											Name: "bucket",
										},
										Separator: nil,
										Value:     nil,
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   25,
												},
												File:   "influxdb.flux",
												Source: "org",
												Start: ast.Position{
													Column: 31,
													Line:   25,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 34,
														Line:   25,
													},
													File:   "influxdb.flux",
													Source: "org",
													Start: ast.Position{
														Column: 31,
														Line:   25,
													},
												},
											},
											Name: "org",
										},
										Separator: nil,
										Value:     nil,
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   25,
												},
												File:   "influxdb.flux",
												Source: "host",
												Start: ast.Position{
													Column: 36,
													Line:   25,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   25,
													},
													File:   "influxdb.flux",
													Source: "host",
													Start: ast.Position{
														Column: 36,
														Line:   25,
													},
												},
											},
											Name: "host",
										},
										Separator: nil,
										Value:     nil,
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   25,
												},
												File:   "influxdb.flux",
												Source: "token",
												Start: ast.Position{
													Column: 42,
													Line:   25,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   25,
													},
													File:   "influxdb.flux",
													Source: "token",
													Start: ast.Position{
														Column: 42,
														Line:   25,
													},
												},
											},
											Name: "token",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   25,
										},
										File:   "influxdb.flux",
										Source: "influxdb.from(bucket, org, host, token)",
										Start: ast.Position{
											Column: 9,
											Line:   25,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   25,
											},
											File:   "influxdb.flux",
											Source: "influxdb.from",
											Start: ast.Position{
												Column: 9,
												Line:   25,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   25,
												},
												File:   "influxdb.flux",
												Source: "influxdb",
												Start: ast.Position{
													Column: 9,
													Line:   25,
												},
											},
										},
										Name: "influxdb",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   25,
												},
												File:   "influxdb.flux",
												Source: "from",
												Start: ast.Position{
													Column: 18,
													Line:   25,
												},
											},
										},
										Name: "from",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							Test: &ast.LogicalExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   24,
										},
										File:   "influxdb.flux",
										Source: "org != \"\" and host != \"\" and token != \"\"",
										Start: ast.Position{
											Column: 17,
											Line:   24,
										},
									},
								},
								Left: &ast.LogicalExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   24,
											},
											File:   "influxdb.flux",
											Source: "org != \"\" and host != \"\"",
											Start: ast.Position{
												Column: 17,
												Line:   24,
											},
										},
									},
									Left: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   24,
												},
												File:   "influxdb.flux",
												Source: "org != \"\"",
												Start: ast.Position{
													Column: 17,
													Line:   24,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   24,
													},
													File:   "influxdb.flux",
													Source: "org",
													Start: ast.Position{
														Column: 17,
														Line:   24,
													},
												},
											},
											Name: "org",
										},
										Operator: 18,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 26,
														Line:   24,
													},
													File:   "influxdb.flux",
													Source: "\"\"",
													Start: ast.Position{
														Column: 24,
														Line:   24,
													},
												},
											},
											Value: "",
										},
									},
									Operator: 1,
									Right: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   24,
												},
												File:   "influxdb.flux",
												Source: "host != \"\"",
												Start: ast.Position{
													Column: 31,
													Line:   24,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   24,
													},
													File:   "influxdb.flux",
													Source: "host",
													Start: ast.Position{
														Column: 31,
														Line:   24,
													},
												},
											},
											Name: "host",
										},
										Operator: 18,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   24,
													},
													File:   "influxdb.flux",
													Source: "\"\"",
													Start: ast.Position{
														Column: 39,
														Line:   24,
													},
												},
											},
											Value: "",
										},
									},
								},
								Operator: 1,
								Right: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 57,
												Line:   24,
											},
											File:   "influxdb.flux",
											Source: "token != \"\"",
											Start: ast.Position{
												Column: 46,
												Line:   24,
											},
										},
									},
									Left: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 51,
													Line:   24,
												},
												File:   "influxdb.flux",
												Source: "token",
												Start: ast.Position{
													Column: 46,
													Line:   24,
												},
											},
										},
										Name: "token",
									},
									Operator: 18,
									Right: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   24,
												},
												File:   "influxdb.flux",
												Source: "\"\"",
												Start: ast.Position{
													Column: 55,
													Line:   24,
												},
											},
										},
										Value: "",
									},
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 18,
											Line:   41,
										},
										File:   "influxdb.flux",
										Source: "source",
										Start: ast.Position{
											Column: 12,
											Line:   41,
										},
									},
								},
								Name: "source",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   41,
									},
									File:   "influxdb.flux",
									Source: "source |> range(start, stop)",
									Start: ast.Position{
										Column: 12,
										Line:   41,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   41,
											},
											File:   "influxdb.flux",
											Source: "start, stop",
											Start: ast.Position{
												Column: 28,
												Line:   41,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   41,
												},
												File:   "influxdb.flux",
												Source: "start",
												Start: ast.Position{
													Column: 28,
													Line:   41,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 33,
														Line:   41,
													},
													File:   "influxdb.flux",
													Source: "start",
													Start: ast.Position{
														Column: 28,
														Line:   41,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value:     nil,
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   41,
												},
												File:   "influxdb.flux",
												Source: "stop",
												Start: ast.Position{
													Column: 35,
													Line:   41,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   41,
													},
													File:   "influxdb.flux",
													Source: "stop",
													Start: ast.Position{
														Column: 35,
														Line:   41,
													},
												},
											},
											Name: "stop",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   41,
										},
										File:   "influxdb.flux",
										Source: "range(start, stop)",
										Start: ast.Position{
											Column: 22,
											Line:   41,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   41,
											},
											File:   "influxdb.flux",
											Source: "range",
											Start: ast.Position{
												Column: 22,
												Line:   41,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   41,
								},
								File:   "influxdb.flux",
								Source: "return source |> range(start, stop)",
								Start: ast.Position{
									Column: 5,
									Line:   41,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   17,
							},
							File:   "influxdb.flux",
							Source: "bucket",
							Start: ast.Position{
								Column: 9,
								Line:   17,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   17,
								},
								File:   "influxdb.flux",
								Source: "bucket",
								Start: ast.Position{
									Column: 9,
									Line:   17,
								},
							},
						},
						Name: "bucket",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   18,
							},
							File:   "influxdb.flux",
							Source: "start",
							Start: ast.Position{
								Column: 9,
								Line:   18,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   18,
								},
								File:   "influxdb.flux",
								Source: "start",
								Start: ast.Position{
									Column: 9,
									Line:   18,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   19,
							},
							File:   "influxdb.flux",
							Source: "stop=now()",
							Start: ast.Position{
								Column: 9,
								Line:   19,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   19,
								},
								File:   "influxdb.flux",
								Source: "stop",
								Start: ast.Position{
									Column: 9,
									Line:   19,
								},
							},
						},
						Name: "stop",
					},
					Separator: nil,
					Value: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   19,
								},
								File:   "influxdb.flux",
								Source: "now()",
								Start: ast.Position{
									Column: 14,
									Line:   19,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   19,
									},
									File:   "influxdb.flux",
									Source: "now",
									Start: ast.Position{
										Column: 14,
										Line:   19,
									},
								},
							},
							Name: "now",
						},
						Lparen: nil,
						Rparen: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   20,
							},
							File:   "influxdb.flux",
							Source: "org=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   20,
								},
								File:   "influxdb.flux",
								Source: "org",
								Start: ast.Position{
									Column: 9,
									Line:   20,
								},
							},
						},
						Name: "org",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   20,
								},
								File:   "influxdb.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 13,
									Line:   20,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   21,
							},
							File:   "influxdb.flux",
							Source: "host=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   21,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   21,
								},
								File:   "influxdb.flux",
								Source: "host",
								Start: ast.Position{
									Column: 9,
									Line:   21,
								},
							},
						},
						Name: "host",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   21,
								},
								File:   "influxdb.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 14,
									Line:   21,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   22,
							},
							File:   "influxdb.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   22,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   22,
								},
								File:   "influxdb.flux",
								Source: "token",
								Start: ast.Position{
									Column: 9,
									Line:   22,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   22,
								},
								File:   "influxdb.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 15,
									Line:   22,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   47,
					},
					File:   "influxdb.flux",
					Source: "_from = from",
					Start: ast.Position{
						Column: 1,
						Line:   47,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// _from allows us to reference the from function from\n"}, ast.Comment{Text: "// within the select call which has a function parameter\n"}, ast.Comment{Text: "// with the same name.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   47,
						},
						File:   "influxdb.flux",
						Source: "_from",
						Start: ast.Position{
							Column: 1,
							Line:   47,
						},
					},
				},
				Name: "_from",
			},
			Init: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   47,
						},
						File:   "influxdb.flux",
						Source: "from",
						Start: ast.Position{
							Column: 9,
							Line:   47,
						},
					},
				},
				Name: "from",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   99,
					},
					File:   "influxdb.flux",
					Source: "select = (\n        from,\n        start,\n        stop=now(),\n        m,\n        fields=[],\n        org=\"\",\n        host=\"\",\n        token=\"\",\n        where=(r) => true,\n) => {\n    bucket = from\n    tables = _from(\n        bucket,\n        start,\n        stop,\n        org,\n        host,\n        token,\n    )\n        |> filter(fn: (r) => r._measurement == m)\n        |> filter(fn: where)\n    nfields = length(arr: fields)\n    fn = if nfields == 0 then\n        (r) => true\n    else if nfields == 1 then\n        (r) => r._field == fields[0]\n    else if nfields == 2 then\n        (r) => r._field == fields[0] or r._field == fields[1]\n    else if nfields == 3 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n    else if nfields == 4 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n    else if nfields == 5 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n    else\n        (r) => contains(value: r._field, set: fields)\n\n    return tables\n        |> filter(fn)\n        |> v1.fieldsAsCols()\n        |> _mask(columns: [\"_measurement\", \"_start\", \"_stop\"])\n}",
					Start: ast.Position{
						Column: 1,
						Line:   57,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// select will select data from an influxdb instance within\n"}, ast.Comment{Text: "// the range between `start` and `stop` from the bucket specified by\n"}, ast.Comment{Text: "// the `from` parameter. It will select the specific measurement\n"}, ast.Comment{Text: "// and it will only include fields that are included in the list of\n"}, ast.Comment{Text: "// `fields`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// In order to filter by tags, the `where` function can be used to further\n"}, ast.Comment{Text: "// limit the amount of data selected.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   57,
						},
						File:   "influxdb.flux",
						Source: "select",
						Start: ast.Position{
							Column: 1,
							Line:   57,
						},
					},
				},
				Name: "select",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   99,
						},
						File:   "influxdb.flux",
						Source: "(\n        from,\n        start,\n        stop=now(),\n        m,\n        fields=[],\n        org=\"\",\n        host=\"\",\n        token=\"\",\n        where=(r) => true,\n) => {\n    bucket = from\n    tables = _from(\n        bucket,\n        start,\n        stop,\n        org,\n        host,\n        token,\n    )\n        |> filter(fn: (r) => r._measurement == m)\n        |> filter(fn: where)\n    nfields = length(arr: fields)\n    fn = if nfields == 0 then\n        (r) => true\n    else if nfields == 1 then\n        (r) => r._field == fields[0]\n    else if nfields == 2 then\n        (r) => r._field == fields[0] or r._field == fields[1]\n    else if nfields == 3 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n    else if nfields == 4 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n    else if nfields == 5 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n    else\n        (r) => contains(value: r._field, set: fields)\n\n    return tables\n        |> filter(fn)\n        |> v1.fieldsAsCols()\n        |> _mask(columns: [\"_measurement\", \"_start\", \"_stop\"])\n}",
						Start: ast.Position{
							Column: 10,
							Line:   57,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   99,
							},
							File:   "influxdb.flux",
							Source: "{\n    bucket = from\n    tables = _from(\n        bucket,\n        start,\n        stop,\n        org,\n        host,\n        token,\n    )\n        |> filter(fn: (r) => r._measurement == m)\n        |> filter(fn: where)\n    nfields = length(arr: fields)\n    fn = if nfields == 0 then\n        (r) => true\n    else if nfields == 1 then\n        (r) => r._field == fields[0]\n    else if nfields == 2 then\n        (r) => r._field == fields[0] or r._field == fields[1]\n    else if nfields == 3 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n    else if nfields == 4 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n    else if nfields == 5 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n    else\n        (r) => contains(value: r._field, set: fields)\n\n    return tables\n        |> filter(fn)\n        |> v1.fieldsAsCols()\n        |> _mask(columns: [\"_measurement\", \"_start\", \"_stop\"])\n}",
							Start: ast.Position{
								Column: 6,
								Line:   67,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   68,
								},
								File:   "influxdb.flux",
								Source: "bucket = from",
								Start: ast.Position{
									Column: 5,
									Line:   68,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   68,
									},
									File:   "influxdb.flux",
									Source: "bucket",
									Start: ast.Position{
										Column: 5,
										Line:   68,
									},
								},
							},
							Name: "bucket",
						},
						Init: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   68,
									},
									File:   "influxdb.flux",
									Source: "from",
									Start: ast.Position{
										Column: 14,
										Line:   68,
									},
								},
							},
							Name: "from",
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   78,
								},
								File:   "influxdb.flux",
								Source: "tables = _from(\n        bucket,\n        start,\n        stop,\n        org,\n        host,\n        token,\n    )\n        |> filter(fn: (r) => r._measurement == m)\n        |> filter(fn: where)",
								Start: ast.Position{
									Column: 5,
									Line:   69,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   69,
									},
									File:   "influxdb.flux",
									Source: "tables",
									Start: ast.Position{
										Column: 5,
										Line:   69,
									},
								},
							},
							Name: "tables",
						},
						Init: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   75,
												},
												File:   "influxdb.flux",
												Source: "bucket,\n        start,\n        stop,\n        org,\n        host,\n        token",
												Start: ast.Position{
													Column: 9,
													Line:   70,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 15,
														Line:   70,
													},
													File:   "influxdb.flux",
													Source: "bucket",
													Start: ast.Position{
														Column: 9,
														Line:   70,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   70,
														},
														File:   "influxdb.flux",
														Source: "bucket",
														Start: ast.Position{
															Column: 9,
															Line:   70,
														},
													},
												},
												Name: "bucket",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   71,
													},
													File:   "influxdb.flux",
													Source: "start",
													Start: ast.Position{
														Column: 9,
														Line:   71,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   71,
														},
														File:   "influxdb.flux",
														Source: "start",
														Start: ast.Position{
															Column: 9,
															Line:   71,
														},
													},
												},
												Name: "start",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   72,
													},
													File:   "influxdb.flux",
													Source: "stop",
													Start: ast.Position{
														Column: 9,
														Line:   72,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 13,
															Line:   72,
														},
														File:   "influxdb.flux",
														Source: "stop",
														Start: ast.Position{
															Column: 9,
															Line:   72,
														},
													},
												},
												Name: "stop",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 12,
														Line:   73,
													},
													File:   "influxdb.flux",
													Source: "org",
													Start: ast.Position{
														Column: 9,
														Line:   73,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 12,
															Line:   73,
														},
														File:   "influxdb.flux",
														Source: "org",
														Start: ast.Position{
															Column: 9,
															Line:   73,
														},
													},
												},
												Name: "org",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   74,
													},
													File:   "influxdb.flux",
													Source: "host",
													Start: ast.Position{
														Column: 9,
														Line:   74,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 13,
															Line:   74,
														},
														File:   "influxdb.flux",
														Source: "host",
														Start: ast.Position{
															Column: 9,
															Line:   74,
														},
													},
												},
												Name: "host",
											},
											Separator: nil,
											Value:     nil,
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   75,
													},
													File:   "influxdb.flux",
													Source: "token",
													Start: ast.Position{
														Column: 9,
														Line:   75,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 14,
															Line:   75,
														},
														File:   "influxdb.flux",
														Source: "token",
														Start: ast.Position{
															Column: 9,
															Line:   75,
														},
													},
												},
												Name: "token",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   76,
											},
											File:   "influxdb.flux",
											Source: "_from(\n        bucket,\n        start,\n        stop,\n        org,\n        host,\n        token,\n    )",
											Start: ast.Position{
												Column: 14,
												Line:   69,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   69,
												},
												File:   "influxdb.flux",
												Source: "_from",
												Start: ast.Position{
													Column: 14,
													Line:   69,
												},
											},
										},
										Name: "_from",
									},
									Lparen: nil,
									Rparen: nil,
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   77,
										},
										File:   "influxdb.flux",
										Source: "_from(\n        bucket,\n        start,\n        stop,\n        org,\n        host,\n        token,\n    )\n        |> filter(fn: (r) => r._measurement == m)",
										Start: ast.Position{
											Column: 14,
											Line:   69,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   77,
												},
												File:   "influxdb.flux",
												Source: "fn: (r) => r._measurement == m",
												Start: ast.Position{
													Column: 19,
													Line:   77,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   77,
													},
													File:   "influxdb.flux",
													Source: "fn: (r) => r._measurement == m",
													Start: ast.Position{
														Column: 19,
														Line:   77,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   77,
														},
														File:   "influxdb.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 19,
															Line:   77,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 49,
															Line:   77,
														},
														File:   "influxdb.flux",
														Source: "(r) => r._measurement == m",
														Start: ast.Position{
															Column: 23,
															Line:   77,
														},
													},
												},
												Body: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 49,
																Line:   77,
															},
															File:   "influxdb.flux",
															Source: "r._measurement == m",
															Start: ast.Position{
																Column: 30,
																Line:   77,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 44,
																	Line:   77,
																},
																File:   "influxdb.flux",
																Source: "r._measurement",
																Start: ast.Position{
																	Column: 30,
																	Line:   77,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 31,
																		Line:   77,
																	},
																	File:   "influxdb.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 30,
																		Line:   77,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   77,
																	},
																	File:   "influxdb.flux",
																	Source: "_measurement",
																	Start: ast.Position{
																		Column: 32,
																		Line:   77,
																	},
																},
															},
															Name: "_measurement",
														},
														Rbrack: nil,
													},
													Operator: 17,
													Right: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   77,
																},
																File:   "influxdb.flux",
																Source: "m",
																Start: ast.Position{
																	Column: 48,
																	Line:   77,
																},
															},
														},
														Name: "m",
													},
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   77,
															},
															File:   "influxdb.flux",
															Source: "r",
															Start: ast.Position{
																Column: 24,
																Line:   77,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   77,
																},
																File:   "influxdb.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 24,
																	Line:   77,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 50,
												Line:   77,
											},
											File:   "influxdb.flux",
											Source: "filter(fn: (r) => r._measurement == m)",
											Start: ast.Position{
												Column: 12,
												Line:   77,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   77,
												},
												File:   "influxdb.flux",
												Source: "filter",
												Start: ast.Position{
													Column: 12,
													Line:   77,
												},
											},
										},
										Name: "filter",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   78,
									},
									File:   "influxdb.flux",
									Source: "_from(\n        bucket,\n        start,\n        stop,\n        org,\n        host,\n        token,\n    )\n        |> filter(fn: (r) => r._measurement == m)\n        |> filter(fn: where)",
									Start: ast.Position{
										Column: 14,
										Line:   69,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   78,
											},
											File:   "influxdb.flux",
											Source: "fn: where",
											Start: ast.Position{
												Column: 19,
												Line:   78,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 28,
													Line:   78,
												},
												File:   "influxdb.flux",
												Source: "fn: where",
												Start: ast.Position{
													Column: 19,
													Line:   78,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   78,
													},
													File:   "influxdb.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 19,
														Line:   78,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 28,
														Line:   78,
													},
													File:   "influxdb.flux",
													Source: "where",
													Start: ast.Position{
														Column: 23,
														Line:   78,
													},
												},
											},
											Name: "where",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   78,
										},
										File:   "influxdb.flux",
										Source: "filter(fn: where)",
										Start: ast.Position{
											Column: 12,
											Line:   78,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   78,
											},
											File:   "influxdb.flux",
											Source: "filter",
											Start: ast.Position{
												Column: 12,
												Line:   78,
											},
										},
									},
									Name: "filter",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   79,
								},
								File:   "influxdb.flux",
								Source: "nfields = length(arr: fields)",
								Start: ast.Position{
									Column: 5,
									Line:   79,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   79,
									},
									File:   "influxdb.flux",
									Source: "nfields",
									Start: ast.Position{
										Column: 5,
										Line:   79,
									},
								},
							},
							Name: "nfields",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   79,
										},
										File:   "influxdb.flux",
										Source: "arr: fields",
										Start: ast.Position{
											Column: 22,
											Line:   79,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   79,
											},
											File:   "influxdb.flux",
											Source: "arr: fields",
											Start: ast.Position{
												Column: 22,
												Line:   79,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   79,
												},
												File:   "influxdb.flux",
												Source: "arr",
												Start: ast.Position{
													Column: 22,
													Line:   79,
												},
											},
										},
										Name: "arr",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 33,
													Line:   79,
												},
												File:   "influxdb.flux",
												Source: "fields",
												Start: ast.Position{
													Column: 27,
													Line:   79,
												},
											},
										},
										Name: "fields",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   79,
									},
									File:   "influxdb.flux",
									Source: "length(arr: fields)",
									Start: ast.Position{
										Column: 15,
										Line:   79,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   79,
										},
										File:   "influxdb.flux",
										Source: "length",
										Start: ast.Position{
											Column: 15,
											Line:   79,
										},
									},
								},
								Name: "length",
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   93,
								},
								File:   "influxdb.flux",
								Source: "fn = if nfields == 0 then\n        (r) => true\n    else if nfields == 1 then\n        (r) => r._field == fields[0]\n    else if nfields == 2 then\n        (r) => r._field == fields[0] or r._field == fields[1]\n    else if nfields == 3 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n    else if nfields == 4 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n    else if nfields == 5 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n    else\n        (r) => contains(value: r._field, set: fields)",
								Start: ast.Position{
									Column: 5,
									Line:   80,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   80,
									},
									File:   "influxdb.flux",
									Source: "fn",
									Start: ast.Position{
										Column: 5,
										Line:   80,
									},
								},
							},
							Name: "fn",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.ConditionalExpression{
								Alternate: &ast.ConditionalExpression{
									Alternate: &ast.ConditionalExpression{
										Alternate: &ast.ConditionalExpression{
											Alternate: &ast.ConditionalExpression{
												Alternate: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 54,
																Line:   93,
															},
															File:   "influxdb.flux",
															Source: "(r) => contains(value: r._field, set: fields)",
															Start: ast.Position{
																Column: 9,
																Line:   93,
															},
														},
													},
													Body: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 53,
																		Line:   93,
																	},
																	File:   "influxdb.flux",
																	Source: "value: r._field, set: fields",
																	Start: ast.Position{
																		Column: 25,
																		Line:   93,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 40,
																			Line:   93,
																		},
																		File:   "influxdb.flux",
																		Source: "value: r._field",
																		Start: ast.Position{
																			Column: 25,
																			Line:   93,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   93,
																			},
																			File:   "influxdb.flux",
																			Source: "value",
																			Start: ast.Position{
																				Column: 25,
																				Line:   93,
																			},
																		},
																	},
																	Name: "value",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 40,
																				Line:   93,
																			},
																			File:   "influxdb.flux",
																			Source: "r._field",
																			Start: ast.Position{
																				Column: 32,
																				Line:   93,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 33,
																					Line:   93,
																				},
																				File:   "influxdb.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 32,
																					Line:   93,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 40,
																					Line:   93,
																				},
																				File:   "influxdb.flux",
																				Source: "_field",
																				Start: ast.Position{
																					Column: 34,
																					Line:   93,
																				},
																			},
																		},
																		Name: "_field",
																	},
																	Rbrack: nil,
																},
															}, &ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 53,
																			Line:   93,
																		},
																		File:   "influxdb.flux",
																		Source: "set: fields",
																		Start: ast.Position{
																			Column: 42,
																			Line:   93,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 45,
																				Line:   93,
																			},
																			File:   "influxdb.flux",
																			Source: "set",
																			Start: ast.Position{
																				Column: 42,
																				Line:   93,
																			},
																		},
																	},
																	Name: "set",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 53,
																				Line:   93,
																			},
																			File:   "influxdb.flux",
																			Source: "fields",
																			Start: ast.Position{
																				Column: 47,
																				Line:   93,
																			},
																		},
																	},
																	Name: "fields",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 54,
																	Line:   93,
																},
																File:   "influxdb.flux",
																Source: "contains(value: r._field, set: fields)",
																Start: ast.Position{
																	Column: 16,
																	Line:   93,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   93,
																	},
																	File:   "influxdb.flux",
																	Source: "contains",
																	Start: ast.Position{
																		Column: 16,
																		Line:   93,
																	},
																},
															},
															Name: "contains",
														},
														Lparen: nil,
														Rparen: nil,
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 11,
																	Line:   93,
																},
																File:   "influxdb.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 10,
																	Line:   93,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 11,
																		Line:   93,
																	},
																	File:   "influxdb.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 10,
																		Line:   93,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 54,
															Line:   93,
														},
														File:   "influxdb.flux",
														Source: "if nfields == 5 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n    else\n        (r) => contains(value: r._field, set: fields)",
														Start: ast.Position{
															Column: 10,
															Line:   90,
														},
													},
												},
												Consequent: &ast.FunctionExpression{
													Arrow: nil,
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 137,
																Line:   91,
															},
															File:   "influxdb.flux",
															Source: "(r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]",
															Start: ast.Position{
																Column: 9,
																Line:   91,
															},
														},
													},
													Body: &ast.LogicalExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 137,
																	Line:   91,
																},
																File:   "influxdb.flux",
																Source: "r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]",
																Start: ast.Position{
																	Column: 16,
																	Line:   91,
																},
															},
														},
														Left: &ast.LogicalExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 112,
																		Line:   91,
																	},
																	File:   "influxdb.flux",
																	Source: "r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]",
																	Start: ast.Position{
																		Column: 16,
																		Line:   91,
																	},
																},
															},
															Left: &ast.LogicalExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 87,
																			Line:   91,
																		},
																		File:   "influxdb.flux",
																		Source: "r._field == fields[0] or r._field == fields[1] or r._field == fields[2]",
																		Start: ast.Position{
																			Column: 16,
																			Line:   91,
																		},
																	},
																},
																Left: &ast.LogicalExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 62,
																				Line:   91,
																			},
																			File:   "influxdb.flux",
																			Source: "r._field == fields[0] or r._field == fields[1]",
																			Start: ast.Position{
																				Column: 16,
																				Line:   91,
																			},
																		},
																	},
																	Left: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 37,
																					Line:   91,
																				},
																				File:   "influxdb.flux",
																				Source: "r._field == fields[0]",
																				Start: ast.Position{
																					Column: 16,
																					Line:   91,
																				},
																			},
																		},
																		Left: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 24,
																						Line:   91,
																					},
																					File:   "influxdb.flux",
																					Source: "r._field",
																					Start: ast.Position{
																						Column: 16,
																						Line:   91,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 17,
																							Line:   91,
																						},
																						File:   "influxdb.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 16,
																							Line:   91,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 24,
																							Line:   91,
																						},
																						File:   "influxdb.flux",
																						Source: "_field",
																						Start: ast.Position{
																							Column: 18,
																							Line:   91,
																						},
																					},
																				},
																				Name: "_field",
																			},
																			Rbrack: nil,
																		},
																		Operator: 17,
																		Right: &ast.IndexExpression{
																			Array: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 34,
																							Line:   91,
																						},
																						File:   "influxdb.flux",
																						Source: "fields",
																						Start: ast.Position{
																							Column: 28,
																							Line:   91,
																						},
																					},
																				},
																				Name: "fields",
																			},
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 37,
																						Line:   91,
																					},
																					File:   "influxdb.flux",
																					Source: "fields[0]",
																					Start: ast.Position{
																						Column: 28,
																						Line:   91,
																					},
																				},
																			},
																			Index: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 36,
																							Line:   91,
																						},
																						File:   "influxdb.flux",
																						Source: "0",
																						Start: ast.Position{
																							Column: 35,
																							Line:   91,
																						},
																					},
																				},
																				Value: int64(0),
																			},
																			Lbrack: nil,
																			Rbrack: nil,
																		},
																	},
																	Operator: 2,
																	Right: &ast.BinaryExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 62,
																					Line:   91,
																				},
																				File:   "influxdb.flux",
																				Source: "r._field == fields[1]",
																				Start: ast.Position{
																					Column: 41,
																					Line:   91,
																				},
																			},
																		},
																		Left: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 49,
																						Line:   91,
																					},
																					File:   "influxdb.flux",
																					Source: "r._field",
																					Start: ast.Position{
																						Column: 41,
																						Line:   91,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 42,
																							Line:   91,
																						},
																						File:   "influxdb.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 41,
																							Line:   91,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 49,
																							Line:   91,
																						},
																						File:   "influxdb.flux",
																						Source: "_field",
																						Start: ast.Position{
																							Column: 43,
																							Line:   91,
																						},
																					},
																				},
																				Name: "_field",
																			},
																			Rbrack: nil,
																		},
																		Operator: 17,
																		Right: &ast.IndexExpression{
																			Array: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 59,
																							Line:   91,
																						},
																						File:   "influxdb.flux",
																						Source: "fields",
																						Start: ast.Position{
																							Column: 53,
																							Line:   91,
																						},
																					},
																				},
																				Name: "fields",
																			},
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 62,
																						Line:   91,
																					},
																					File:   "influxdb.flux",
																					Source: "fields[1]",
																					Start: ast.Position{
																						Column: 53,
																						Line:   91,
																					},
																				},
																			},
																			Index: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 61,
																							Line:   91,
																						},
																						File:   "influxdb.flux",
																						Source: "1",
																						Start: ast.Position{
																							Column: 60,
																							Line:   91,
																						},
																					},
																				},
																				Value: int64(1),
																			},
																			Lbrack: nil,
																			Rbrack: nil,
																		},
																	},
																},
																Operator: 2,
																Right: &ast.BinaryExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 87,
																				Line:   91,
																			},
																			File:   "influxdb.flux",
																			Source: "r._field == fields[2]",
																			Start: ast.Position{
																				Column: 66,
																				Line:   91,
																			},
																		},
																	},
																	Left: &ast.MemberExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 74,
																					Line:   91,
																				},
																				File:   "influxdb.flux",
																				Source: "r._field",
																				Start: ast.Position{
																					Column: 66,
																					Line:   91,
																				},
																			},
																		},
																		Lbrack: nil,
																		Object: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 67,
																						Line:   91,
																					},
																					File:   "influxdb.flux",
																					Source: "r",
																					Start: ast.Position{
																						Column: 66,
																						Line:   91,
																					},
																				},
																			},
																			Name: "r",
																		},
																		Property: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 74,
																						Line:   91,
																					},
																					File:   "influxdb.flux",
																					Source: "_field",
																					Start: ast.Position{
																						Column: 68,
																						Line:   91,
																					},
																				},
																			},
																			Name: "_field",
																		},
																		Rbrack: nil,
																	},
																	Operator: 17,
																	Right: &ast.IndexExpression{
																		Array: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 84,
																						Line:   91,
																					},
																					File:   "influxdb.flux",
																					Source: "fields",
																					Start: ast.Position{
																						Column: 78,
																						Line:   91,
																					},
																				},
																			},
																			Name: "fields",
																		},
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 87,
																					Line:   91,
																				},
																				File:   "influxdb.flux",
																				Source: "fields[2]",
																				Start: ast.Position{
																					Column: 78,
																					Line:   91,
																				},
																			},
																		},
																		Index: &ast.IntegerLiteral{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 86,
																						Line:   91,
																					},
																					File:   "influxdb.flux",
																					Source: "2",
																					Start: ast.Position{
																						Column: 85,
																						Line:   91,
																					},
																				},
																			},
																			Value: int64(2),
																		},
																		Lbrack: nil,
																		Rbrack: nil,
																	},
																},
															},
															Operator: 2,
															Right: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 112,
																			Line:   91,
																		},
																		File:   "influxdb.flux",
																		Source: "r._field == fields[3]",
																		Start: ast.Position{
																			Column: 91,
																			Line:   91,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 99,
																				Line:   91,
																			},
																			File:   "influxdb.flux",
																			Source: "r._field",
																			Start: ast.Position{
																				Column: 91,
																				Line:   91,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 92,
																					Line:   91,
																				},
																				File:   "influxdb.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 91,
																					Line:   91,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 99,
																					Line:   91,
																				},
																				File:   "influxdb.flux",
																				Source: "_field",
																				Start: ast.Position{
																					Column: 93,
																					Line:   91,
																				},
																			},
																		},
																		Name: "_field",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.IndexExpression{
																	Array: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 109,
																					Line:   91,
																				},
																				File:   "influxdb.flux",
																				Source: "fields",
																				Start: ast.Position{
																					Column: 103,
																					Line:   91,
																				},
																			},
																		},
																		Name: "fields",
																	},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 112,
																				Line:   91,
																			},
																			File:   "influxdb.flux",
																			Source: "fields[3]",
																			Start: ast.Position{
																				Column: 103,
																				Line:   91,
																			},
																		},
																	},
																	Index: &ast.IntegerLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 111,
																					Line:   91,
																				},
																				File:   "influxdb.flux",
																				Source: "3",
																				Start: ast.Position{
																					Column: 110,
																					Line:   91,
																				},
																			},
																		},
																		Value: int64(3),
																	},
																	Lbrack: nil,
																	Rbrack: nil,
																},
															},
														},
														Operator: 2,
														Right: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 137,
																		Line:   91,
																	},
																	File:   "influxdb.flux",
																	Source: "r._field == fields[4]",
																	Start: ast.Position{
																		Column: 116,
																		Line:   91,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 124,
																			Line:   91,
																		},
																		File:   "influxdb.flux",
																		Source: "r._field",
																		Start: ast.Position{
																			Column: 116,
																			Line:   91,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 117,
																				Line:   91,
																			},
																			File:   "influxdb.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 116,
																				Line:   91,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 124,
																				Line:   91,
																			},
																			File:   "influxdb.flux",
																			Source: "_field",
																			Start: ast.Position{
																				Column: 118,
																				Line:   91,
																			},
																		},
																	},
																	Name: "_field",
																},
																Rbrack: nil,
															},
															Operator: 17,
															Right: &ast.IndexExpression{
																Array: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 134,
																				Line:   91,
																			},
																			File:   "influxdb.flux",
																			Source: "fields",
																			Start: ast.Position{
																				Column: 128,
																				Line:   91,
																			},
																		},
																	},
																	Name: "fields",
																},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 137,
																			Line:   91,
																		},
																		File:   "influxdb.flux",
																		Source: "fields[4]",
																		Start: ast.Position{
																			Column: 128,
																			Line:   91,
																		},
																	},
																},
																Index: &ast.IntegerLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 136,
																				Line:   91,
																			},
																			File:   "influxdb.flux",
																			Source: "4",
																			Start: ast.Position{
																				Column: 135,
																				Line:   91,
																			},
																		},
																	},
																	Value: int64(4),
																},
																Lbrack: nil,
																Rbrack: nil,
															},
														},
													},
													Lparen: nil,
													Params: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 11,
																	Line:   91,
																},
																File:   "influxdb.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 10,
																	Line:   91,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 11,
																		Line:   91,
																	},
																	File:   "influxdb.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 10,
																		Line:   91,
																	},
																},
															},
															Name: "r",
														},
														Separator: nil,
														Value:     nil,
													}},
													Rparan: nil,
												},
												Test: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   90,
															},
															File:   "influxdb.flux",
															Source: "nfields == 5",
															Start: ast.Position{
																Column: 13,
																Line:   90,
															},
														},
													},
													Left: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 20,
																	Line:   90,
																},
																File:   "influxdb.flux",
																Source: "nfields",
																Start: ast.Position{
																	Column: 13,
																	Line:   90,
																},
															},
														},
														Name: "nfields",
													},
													Operator: 17,
													Right: &ast.IntegerLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 25,
																	Line:   90,
																},
																File:   "influxdb.flux",
																Source: "5",
																Start: ast.Position{
																	Column: 24,
																	Line:   90,
																},
															},
														},
														Value: int64(5),
													},
												},
												Tk_else: nil,
												Tk_if:   nil,
												Tk_then: nil,
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   93,
													},
													File:   "influxdb.flux",
													Source: "if nfields == 4 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n    else if nfields == 5 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n    else\n        (r) => contains(value: r._field, set: fields)",
													Start: ast.Position{
														Column: 10,
														Line:   88,
													},
												},
											},
											Consequent: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 112,
															Line:   89,
														},
														File:   "influxdb.flux",
														Source: "(r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]",
														Start: ast.Position{
															Column: 9,
															Line:   89,
														},
													},
												},
												Body: &ast.LogicalExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 112,
																Line:   89,
															},
															File:   "influxdb.flux",
															Source: "r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]",
															Start: ast.Position{
																Column: 16,
																Line:   89,
															},
														},
													},
													Left: &ast.LogicalExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 87,
																	Line:   89,
																},
																File:   "influxdb.flux",
																Source: "r._field == fields[0] or r._field == fields[1] or r._field == fields[2]",
																Start: ast.Position{
																	Column: 16,
																	Line:   89,
																},
															},
														},
														Left: &ast.LogicalExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 62,
																		Line:   89,
																	},
																	File:   "influxdb.flux",
																	Source: "r._field == fields[0] or r._field == fields[1]",
																	Start: ast.Position{
																		Column: 16,
																		Line:   89,
																	},
																},
															},
															Left: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 37,
																			Line:   89,
																		},
																		File:   "influxdb.flux",
																		Source: "r._field == fields[0]",
																		Start: ast.Position{
																			Column: 16,
																			Line:   89,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 24,
																				Line:   89,
																			},
																			File:   "influxdb.flux",
																			Source: "r._field",
																			Start: ast.Position{
																				Column: 16,
																				Line:   89,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 17,
																					Line:   89,
																				},
																				File:   "influxdb.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 16,
																					Line:   89,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 24,
																					Line:   89,
																				},
																				File:   "influxdb.flux",
																				Source: "_field",
																				Start: ast.Position{
																					Column: 18,
																					Line:   89,
																				},
																			},
																		},
																		Name: "_field",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.IndexExpression{
																	Array: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 34,
																					Line:   89,
																				},
																				File:   "influxdb.flux",
																				Source: "fields",
																				Start: ast.Position{
																					Column: 28,
																					Line:   89,
																				},
																			},
																		},
																		Name: "fields",
																	},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 37,
																				Line:   89,
																			},
																			File:   "influxdb.flux",
																			Source: "fields[0]",
																			Start: ast.Position{
																				Column: 28,
																				Line:   89,
																			},
																		},
																	},
																	Index: &ast.IntegerLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 36,
																					Line:   89,
																				},
																				File:   "influxdb.flux",
																				Source: "0",
																				Start: ast.Position{
																					Column: 35,
																					Line:   89,
																				},
																			},
																		},
																		Value: int64(0),
																	},
																	Lbrack: nil,
																	Rbrack: nil,
																},
															},
															Operator: 2,
															Right: &ast.BinaryExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 62,
																			Line:   89,
																		},
																		File:   "influxdb.flux",
																		Source: "r._field == fields[1]",
																		Start: ast.Position{
																			Column: 41,
																			Line:   89,
																		},
																	},
																},
																Left: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 49,
																				Line:   89,
																			},
																			File:   "influxdb.flux",
																			Source: "r._field",
																			Start: ast.Position{
																				Column: 41,
																				Line:   89,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 42,
																					Line:   89,
																				},
																				File:   "influxdb.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 41,
																					Line:   89,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 49,
																					Line:   89,
																				},
																				File:   "influxdb.flux",
																				Source: "_field",
																				Start: ast.Position{
																					Column: 43,
																					Line:   89,
																				},
																			},
																		},
																		Name: "_field",
																	},
																	Rbrack: nil,
																},
																Operator: 17,
																Right: &ast.IndexExpression{
																	Array: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 59,
																					Line:   89,
																				},
																				File:   "influxdb.flux",
																				Source: "fields",
																				Start: ast.Position{
																					Column: 53,
																					Line:   89,
																				},
																			},
																		},
																		Name: "fields",
																	},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 62,
																				Line:   89,
																			},
																			File:   "influxdb.flux",
																			Source: "fields[1]",
																			Start: ast.Position{
																				Column: 53,
																				Line:   89,
																			},
																		},
																	},
																	Index: &ast.IntegerLiteral{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 61,
																					Line:   89,
																				},
																				File:   "influxdb.flux",
																				Source: "1",
																				Start: ast.Position{
																					Column: 60,
																					Line:   89,
																				},
																			},
																		},
																		Value: int64(1),
																	},
																	Lbrack: nil,
																	Rbrack: nil,
																},
															},
														},
														Operator: 2,
														Right: &ast.BinaryExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 87,
																		Line:   89,
																	},
																	File:   "influxdb.flux",
																	Source: "r._field == fields[2]",
																	Start: ast.Position{
																		Column: 66,
																		Line:   89,
																	},
																},
															},
															Left: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 74,
																			Line:   89,
																		},
																		File:   "influxdb.flux",
																		Source: "r._field",
																		Start: ast.Position{
																			Column: 66,
																			Line:   89,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 67,
																				Line:   89,
																			},
																			File:   "influxdb.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 66,
																				Line:   89,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 74,
																				Line:   89,
																			},
																			File:   "influxdb.flux",
																			Source: "_field",
																			Start: ast.Position{
																				Column: 68,
																				Line:   89,
																			},
																		},
																	},
																	Name: "_field",
																},
																Rbrack: nil,
															},
															Operator: 17,
															Right: &ast.IndexExpression{
																Array: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 84,
																				Line:   89,
																			},
																			File:   "influxdb.flux",
																			Source: "fields",
																			Start: ast.Position{
																				Column: 78,
																				Line:   89,
																			},
																		},
																	},
																	Name: "fields",
																},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 87,
																			Line:   89,
																		},
																		File:   "influxdb.flux",
																		Source: "fields[2]",
																		Start: ast.Position{
																			Column: 78,
																			Line:   89,
																		},
																	},
																},
																Index: &ast.IntegerLiteral{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 86,
																				Line:   89,
																			},
																			File:   "influxdb.flux",
																			Source: "2",
																			Start: ast.Position{
																				Column: 85,
																				Line:   89,
																			},
																		},
																	},
																	Value: int64(2),
																},
																Lbrack: nil,
																Rbrack: nil,
															},
														},
													},
													Operator: 2,
													Right: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 112,
																	Line:   89,
																},
																File:   "influxdb.flux",
																Source: "r._field == fields[3]",
																Start: ast.Position{
																	Column: 91,
																	Line:   89,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 99,
																		Line:   89,
																	},
																	File:   "influxdb.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 91,
																		Line:   89,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 92,
																			Line:   89,
																		},
																		File:   "influxdb.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 91,
																			Line:   89,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 99,
																			Line:   89,
																		},
																		File:   "influxdb.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 93,
																			Line:   89,
																		},
																	},
																},
																Name: "_field",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.IndexExpression{
															Array: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 109,
																			Line:   89,
																		},
																		File:   "influxdb.flux",
																		Source: "fields",
																		Start: ast.Position{
																			Column: 103,
																			Line:   89,
																		},
																	},
																},
																Name: "fields",
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 112,
																		Line:   89,
																	},
																	File:   "influxdb.flux",
																	Source: "fields[3]",
																	Start: ast.Position{
																		Column: 103,
																		Line:   89,
																	},
																},
															},
															Index: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 111,
																			Line:   89,
																		},
																		File:   "influxdb.flux",
																		Source: "3",
																		Start: ast.Position{
																			Column: 110,
																			Line:   89,
																		},
																	},
																},
																Value: int64(3),
															},
															Lbrack: nil,
															Rbrack: nil,
														},
													},
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 11,
																Line:   89,
															},
															File:   "influxdb.flux",
															Source: "r",
															Start: ast.Position{
																Column: 10,
																Line:   89,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 11,
																	Line:   89,
																},
																File:   "influxdb.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 10,
																	Line:   89,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
											Test: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   88,
														},
														File:   "influxdb.flux",
														Source: "nfields == 4",
														Start: ast.Position{
															Column: 13,
															Line:   88,
														},
													},
												},
												Left: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 20,
																Line:   88,
															},
															File:   "influxdb.flux",
															Source: "nfields",
															Start: ast.Position{
																Column: 13,
																Line:   88,
															},
														},
													},
													Name: "nfields",
												},
												Operator: 17,
												Right: &ast.IntegerLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 25,
																Line:   88,
															},
															File:   "influxdb.flux",
															Source: "4",
															Start: ast.Position{
																Column: 24,
																Line:   88,
															},
														},
													},
													Value: int64(4),
												},
											},
											Tk_else: nil,
											Tk_if:   nil,
											Tk_then: nil,
										},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   93,
												},
												File:   "influxdb.flux",
												Source: "if nfields == 3 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n    else if nfields == 4 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n    else if nfields == 5 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n    else\n        (r) => contains(value: r._field, set: fields)",
												Start: ast.Position{
													Column: 10,
													Line:   86,
												},
											},
										},
										Consequent: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   87,
													},
													File:   "influxdb.flux",
													Source: "(r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]",
													Start: ast.Position{
														Column: 9,
														Line:   87,
													},
												},
											},
											Body: &ast.LogicalExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 87,
															Line:   87,
														},
														File:   "influxdb.flux",
														Source: "r._field == fields[0] or r._field == fields[1] or r._field == fields[2]",
														Start: ast.Position{
															Column: 16,
															Line:   87,
														},
													},
												},
												Left: &ast.LogicalExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 62,
																Line:   87,
															},
															File:   "influxdb.flux",
															Source: "r._field == fields[0] or r._field == fields[1]",
															Start: ast.Position{
																Column: 16,
																Line:   87,
															},
														},
													},
													Left: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   87,
																},
																File:   "influxdb.flux",
																Source: "r._field == fields[0]",
																Start: ast.Position{
																	Column: 16,
																	Line:   87,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   87,
																	},
																	File:   "influxdb.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 16,
																		Line:   87,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 17,
																			Line:   87,
																		},
																		File:   "influxdb.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 16,
																			Line:   87,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   87,
																		},
																		File:   "influxdb.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 18,
																			Line:   87,
																		},
																	},
																},
																Name: "_field",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.IndexExpression{
															Array: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 34,
																			Line:   87,
																		},
																		File:   "influxdb.flux",
																		Source: "fields",
																		Start: ast.Position{
																			Column: 28,
																			Line:   87,
																		},
																	},
																},
																Name: "fields",
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   87,
																	},
																	File:   "influxdb.flux",
																	Source: "fields[0]",
																	Start: ast.Position{
																		Column: 28,
																		Line:   87,
																	},
																},
															},
															Index: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 36,
																			Line:   87,
																		},
																		File:   "influxdb.flux",
																		Source: "0",
																		Start: ast.Position{
																			Column: 35,
																			Line:   87,
																		},
																	},
																},
																Value: int64(0),
															},
															Lbrack: nil,
															Rbrack: nil,
														},
													},
													Operator: 2,
													Right: &ast.BinaryExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   87,
																},
																File:   "influxdb.flux",
																Source: "r._field == fields[1]",
																Start: ast.Position{
																	Column: 41,
																	Line:   87,
																},
															},
														},
														Left: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   87,
																	},
																	File:   "influxdb.flux",
																	Source: "r._field",
																	Start: ast.Position{
																		Column: 41,
																		Line:   87,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 42,
																			Line:   87,
																		},
																		File:   "influxdb.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 41,
																			Line:   87,
																		},
																	},
																},
																Name: "r",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 49,
																			Line:   87,
																		},
																		File:   "influxdb.flux",
																		Source: "_field",
																		Start: ast.Position{
																			Column: 43,
																			Line:   87,
																		},
																	},
																},
																Name: "_field",
															},
															Rbrack: nil,
														},
														Operator: 17,
														Right: &ast.IndexExpression{
															Array: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 59,
																			Line:   87,
																		},
																		File:   "influxdb.flux",
																		Source: "fields",
																		Start: ast.Position{
																			Column: 53,
																			Line:   87,
																		},
																	},
																},
																Name: "fields",
															},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 62,
																		Line:   87,
																	},
																	File:   "influxdb.flux",
																	Source: "fields[1]",
																	Start: ast.Position{
																		Column: 53,
																		Line:   87,
																	},
																},
															},
															Index: &ast.IntegerLiteral{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 61,
																			Line:   87,
																		},
																		File:   "influxdb.flux",
																		Source: "1",
																		Start: ast.Position{
																			Column: 60,
																			Line:   87,
																		},
																	},
																},
																Value: int64(1),
															},
															Lbrack: nil,
															Rbrack: nil,
														},
													},
												},
												Operator: 2,
												Right: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 87,
																Line:   87,
															},
															File:   "influxdb.flux",
															Source: "r._field == fields[2]",
															Start: ast.Position{
																Column: 66,
																Line:   87,
															},
														},
													},
													Left: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 74,
																	Line:   87,
																},
																File:   "influxdb.flux",
																Source: "r._field",
																Start: ast.Position{
																	Column: 66,
																	Line:   87,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 67,
																		Line:   87,
																	},
																	File:   "influxdb.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 66,
																		Line:   87,
																	},
																},
															},
															Name: "r",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 74,
																		Line:   87,
																	},
																	File:   "influxdb.flux",
																	Source: "_field",
																	Start: ast.Position{
																		Column: 68,
																		Line:   87,
																	},
																},
															},
															Name: "_field",
														},
														Rbrack: nil,
													},
													Operator: 17,
													Right: &ast.IndexExpression{
														Array: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 84,
																		Line:   87,
																	},
																	File:   "influxdb.flux",
																	Source: "fields",
																	Start: ast.Position{
																		Column: 78,
																		Line:   87,
																	},
																},
															},
															Name: "fields",
														},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 87,
																	Line:   87,
																},
																File:   "influxdb.flux",
																Source: "fields[2]",
																Start: ast.Position{
																	Column: 78,
																	Line:   87,
																},
															},
														},
														Index: &ast.IntegerLiteral{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 86,
																		Line:   87,
																	},
																	File:   "influxdb.flux",
																	Source: "2",
																	Start: ast.Position{
																		Column: 85,
																		Line:   87,
																	},
																},
															},
															Value: int64(2),
														},
														Lbrack: nil,
														Rbrack: nil,
													},
												},
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   87,
														},
														File:   "influxdb.flux",
														Source: "r",
														Start: ast.Position{
															Column: 10,
															Line:   87,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 11,
																Line:   87,
															},
															File:   "influxdb.flux",
															Source: "r",
															Start: ast.Position{
																Column: 10,
																Line:   87,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
										Test: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   86,
													},
													File:   "influxdb.flux",
													Source: "nfields == 3",
													Start: ast.Position{
														Column: 13,
														Line:   86,
													},
												},
											},
											Left: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   86,
														},
														File:   "influxdb.flux",
														Source: "nfields",
														Start: ast.Position{
															Column: 13,
															Line:   86,
														},
													},
												},
												Name: "nfields",
											},
											Operator: 17,
											Right: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 25,
															Line:   86,
														},
														File:   "influxdb.flux",
														Source: "3",
														Start: ast.Position{
															Column: 24,
															Line:   86,
														},
													},
												},
												Value: int64(3),
											},
										},
										Tk_else: nil,
										Tk_if:   nil,
										Tk_then: nil,
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 54,
												Line:   93,
											},
											File:   "influxdb.flux",
											Source: "if nfields == 2 then\n        (r) => r._field == fields[0] or r._field == fields[1]\n    else if nfields == 3 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n    else if nfields == 4 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n    else if nfields == 5 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n    else\n        (r) => contains(value: r._field, set: fields)",
											Start: ast.Position{
												Column: 10,
												Line:   84,
											},
										},
									},
									Consequent: &ast.FunctionExpression{
										Arrow: nil,
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 62,
													Line:   85,
												},
												File:   "influxdb.flux",
												Source: "(r) => r._field == fields[0] or r._field == fields[1]",
												Start: ast.Position{
													Column: 9,
													Line:   85,
												},
											},
										},
										Body: &ast.LogicalExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 62,
														Line:   85,
													},
													File:   "influxdb.flux",
													Source: "r._field == fields[0] or r._field == fields[1]",
													Start: ast.Position{
														Column: 16,
														Line:   85,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 37,
															Line:   85,
														},
														File:   "influxdb.flux",
														Source: "r._field == fields[0]",
														Start: ast.Position{
															Column: 16,
															Line:   85,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 24,
																Line:   85,
															},
															File:   "influxdb.flux",
															Source: "r._field",
															Start: ast.Position{
																Column: 16,
																Line:   85,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 17,
																	Line:   85,
																},
																File:   "influxdb.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 16,
																	Line:   85,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 24,
																	Line:   85,
																},
																File:   "influxdb.flux",
																Source: "_field",
																Start: ast.Position{
																	Column: 18,
																	Line:   85,
																},
															},
														},
														Name: "_field",
													},
													Rbrack: nil,
												},
												Operator: 17,
												Right: &ast.IndexExpression{
													Array: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 34,
																	Line:   85,
																},
																File:   "influxdb.flux",
																Source: "fields",
																Start: ast.Position{
																	Column: 28,
																	Line:   85,
																},
															},
														},
														Name: "fields",
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   85,
															},
															File:   "influxdb.flux",
															Source: "fields[0]",
															Start: ast.Position{
																Column: 28,
																Line:   85,
															},
														},
													},
													Index: &ast.IntegerLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 36,
																	Line:   85,
																},
																File:   "influxdb.flux",
																Source: "0",
																Start: ast.Position{
																	Column: 35,
																	Line:   85,
																},
															},
														},
														Value: int64(0),
													},
													Lbrack: nil,
													Rbrack: nil,
												},
											},
											Operator: 2,
											Right: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   85,
														},
														File:   "influxdb.flux",
														Source: "r._field == fields[1]",
														Start: ast.Position{
															Column: 41,
															Line:   85,
														},
													},
												},
												Left: &ast.MemberExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 49,
																Line:   85,
															},
															File:   "influxdb.flux",
															Source: "r._field",
															Start: ast.Position{
																Column: 41,
																Line:   85,
															},
														},
													},
													Lbrack: nil,
													Object: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 42,
																	Line:   85,
																},
																File:   "influxdb.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 41,
																	Line:   85,
																},
															},
														},
														Name: "r",
													},
													Property: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   85,
																},
																File:   "influxdb.flux",
																Source: "_field",
																Start: ast.Position{
																	Column: 43,
																	Line:   85,
																},
															},
														},
														Name: "_field",
													},
													Rbrack: nil,
												},
												Operator: 17,
												Right: &ast.IndexExpression{
													Array: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 59,
																	Line:   85,
																},
																File:   "influxdb.flux",
																Source: "fields",
																Start: ast.Position{
																	Column: 53,
																	Line:   85,
																},
															},
														},
														Name: "fields",
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 62,
																Line:   85,
															},
															File:   "influxdb.flux",
															Source: "fields[1]",
															Start: ast.Position{
																Column: 53,
																Line:   85,
															},
														},
													},
													Index: &ast.IntegerLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 61,
																	Line:   85,
																},
																File:   "influxdb.flux",
																Source: "1",
																Start: ast.Position{
																	Column: 60,
																	Line:   85,
																},
															},
														},
														Value: int64(1),
													},
													Lbrack: nil,
													Rbrack: nil,
												},
											},
										},
										Lparen: nil,
										Params: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   85,
													},
													File:   "influxdb.flux",
													Source: "r",
													Start: ast.Position{
														Column: 10,
														Line:   85,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   85,
														},
														File:   "influxdb.flux",
														Source: "r",
														Start: ast.Position{
															Column: 10,
															Line:   85,
														},
													},
												},
												Name: "r",
											},
											Separator: nil,
											Value:     nil,
										}},
										Rparan: nil,
									},
									Test: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   84,
												},
												File:   "influxdb.flux",
												Source: "nfields == 2",
												Start: ast.Position{
													Column: 13,
													Line:   84,
												},
											},
										},
										Left: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 20,
														Line:   84,
													},
													File:   "influxdb.flux",
													Source: "nfields",
													Start: ast.Position{
														Column: 13,
														Line:   84,
													},
												},
											},
											Name: "nfields",
										},
										Operator: 17,
										Right: &ast.IntegerLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   84,
													},
													File:   "influxdb.flux",
													Source: "2",
													Start: ast.Position{
														Column: 24,
														Line:   84,
													},
												},
											},
											Value: int64(2),
										},
									},
									Tk_else: nil,
									Tk_if:   nil,
									Tk_then: nil,
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 54,
											Line:   93,
										},
										File:   "influxdb.flux",
										Source: "if nfields == 1 then\n        (r) => r._field == fields[0]\n    else if nfields == 2 then\n        (r) => r._field == fields[0] or r._field == fields[1]\n    else if nfields == 3 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n    else if nfields == 4 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n    else if nfields == 5 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n    else\n        (r) => contains(value: r._field, set: fields)",
										Start: ast.Position{
											Column: 10,
											Line:   82,
										},
									},
								},
								Consequent: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   83,
											},
											File:   "influxdb.flux",
											Source: "(r) => r._field == fields[0]",
											Start: ast.Position{
												Column: 9,
												Line:   83,
											},
										},
									},
									Body: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 37,
													Line:   83,
												},
												File:   "influxdb.flux",
												Source: "r._field == fields[0]",
												Start: ast.Position{
													Column: 16,
													Line:   83,
												},
											},
										},
										Left: &ast.MemberExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 24,
														Line:   83,
													},
													File:   "influxdb.flux",
													Source: "r._field",
													Start: ast.Position{
														Column: 16,
														Line:   83,
													},
												},
											},
											Lbrack: nil,
											Object: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 17,
															Line:   83,
														},
														File:   "influxdb.flux",
														Source: "r",
														Start: ast.Position{
															Column: 16,
															Line:   83,
														},
													},
												},
												Name: "r",
											},
											Property: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   83,
														},
														File:   "influxdb.flux",
														Source: "_field",
														Start: ast.Position{
															Column: 18,
															Line:   83,
														},
													},
												},
												Name: "_field",
											},
											Rbrack: nil,
										},
										Operator: 17,
										Right: &ast.IndexExpression{
											Array: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   83,
														},
														File:   "influxdb.flux",
														Source: "fields",
														Start: ast.Position{
															Column: 28,
															Line:   83,
														},
													},
												},
												Name: "fields",
											},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 37,
														Line:   83,
													},
													File:   "influxdb.flux",
													Source: "fields[0]",
													Start: ast.Position{
														Column: 28,
														Line:   83,
													},
												},
											},
											Index: &ast.IntegerLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   83,
														},
														File:   "influxdb.flux",
														Source: "0",
														Start: ast.Position{
															Column: 35,
															Line:   83,
														},
													},
												},
												Value: int64(0),
											},
											Lbrack: nil,
											Rbrack: nil,
										},
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   83,
												},
												File:   "influxdb.flux",
												Source: "r",
												Start: ast.Position{
													Column: 10,
													Line:   83,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   83,
													},
													File:   "influxdb.flux",
													Source: "r",
													Start: ast.Position{
														Column: 10,
														Line:   83,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
								Test: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   82,
											},
											File:   "influxdb.flux",
											Source: "nfields == 1",
											Start: ast.Position{
												Column: 13,
												Line:   82,
											},
										},
									},
									Left: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   82,
												},
												File:   "influxdb.flux",
												Source: "nfields",
												Start: ast.Position{
													Column: 13,
													Line:   82,
												},
											},
										},
										Name: "nfields",
									},
									Operator: 17,
									Right: &ast.IntegerLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   82,
												},
												File:   "influxdb.flux",
												Source: "1",
												Start: ast.Position{
													Column: 24,
													Line:   82,
												},
											},
										},
										Value: int64(1),
									},
								},
								Tk_else: nil,
								Tk_if:   nil,
								Tk_then: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   93,
									},
									File:   "influxdb.flux",
									Source: "if nfields == 0 then\n        (r) => true\n    else if nfields == 1 then\n        (r) => r._field == fields[0]\n    else if nfields == 2 then\n        (r) => r._field == fields[0] or r._field == fields[1]\n    else if nfields == 3 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2]\n    else if nfields == 4 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3]\n    else if nfields == 5 then\n        (r) => r._field == fields[0] or r._field == fields[1] or r._field == fields[2] or r._field == fields[3] or r._field == fields[4]\n    else\n        (r) => contains(value: r._field, set: fields)",
									Start: ast.Position{
										Column: 10,
										Line:   80,
									},
								},
							},
							Consequent: &ast.FunctionExpression{
								Arrow: nil,
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 20,
											Line:   81,
										},
										File:   "influxdb.flux",
										Source: "(r) => true",
										Start: ast.Position{
											Column: 9,
											Line:   81,
										},
									},
								},
								Body: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   81,
											},
											File:   "influxdb.flux",
											Source: "true",
											Start: ast.Position{
												Column: 16,
												Line:   81,
											},
										},
									},
									Name: "true",
								},
								Lparen: nil,
								Params: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   81,
											},
											File:   "influxdb.flux",
											Source: "r",
											Start: ast.Position{
												Column: 10,
												Line:   81,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   81,
												},
												File:   "influxdb.flux",
												Source: "r",
												Start: ast.Position{
													Column: 10,
													Line:   81,
												},
											},
										},
										Name: "r",
									},
									Separator: nil,
									Value:     nil,
								}},
								Rparan: nil,
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   80,
										},
										File:   "influxdb.flux",
										Source: "nfields == 0",
										Start: ast.Position{
											Column: 13,
											Line:   80,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   80,
											},
											File:   "influxdb.flux",
											Source: "nfields",
											Start: ast.Position{
												Column: 13,
												Line:   80,
											},
										},
									},
									Name: "nfields",
								},
								Operator: 17,
								Right: &ast.IntegerLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   80,
											},
											File:   "influxdb.flux",
											Source: "0",
											Start: ast.Position{
												Column: 24,
												Line:   80,
											},
										},
									},
									Value: int64(0),
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.PipeExpression{
									Argument: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   95,
												},
												File:   "influxdb.flux",
												Source: "tables",
												Start: ast.Position{
													Column: 12,
													Line:   95,
												},
											},
										},
										Name: "tables",
									},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   96,
											},
											File:   "influxdb.flux",
											Source: "tables\n        |> filter(fn)",
											Start: ast.Position{
												Column: 12,
												Line:   95,
											},
										},
									},
									Call: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   96,
													},
													File:   "influxdb.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 19,
														Line:   96,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 21,
															Line:   96,
														},
														File:   "influxdb.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 19,
															Line:   96,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 21,
																Line:   96,
															},
															File:   "influxdb.flux",
															Source: "fn",
															Start: ast.Position{
																Column: 19,
																Line:   96,
															},
														},
													},
													Name: "fn",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   96,
												},
												File:   "influxdb.flux",
												Source: "filter(fn)",
												Start: ast.Position{
													Column: 12,
													Line:   96,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   96,
													},
													File:   "influxdb.flux",
													Source: "filter",
													Start: ast.Position{
														Column: 12,
														Line:   96,
													},
												},
											},
											Name: "filter",
										},
										Lparen: nil,
										Rparen: nil,
									},
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   97,
										},
										File:   "influxdb.flux",
										Source: "tables\n        |> filter(fn)\n        |> v1.fieldsAsCols()",
										Start: ast.Position{
											Column: 12,
											Line:   95,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   97,
											},
											File:   "influxdb.flux",
											Source: "v1.fieldsAsCols()",
											Start: ast.Position{
												Column: 12,
												Line:   97,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 27,
													Line:   97,
												},
												File:   "influxdb.flux",
												Source: "v1.fieldsAsCols",
												Start: ast.Position{
													Column: 12,
													Line:   97,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 14,
														Line:   97,
													},
													File:   "influxdb.flux",
													Source: "v1",
													Start: ast.Position{
														Column: 12,
														Line:   97,
													},
												},
											},
											Name: "v1",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 27,
														Line:   97,
													},
													File:   "influxdb.flux",
													Source: "fieldsAsCols",
													Start: ast.Position{
														Column: 15,
														Line:   97,
													},
												},
											},
											Name: "fieldsAsCols",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   98,
									},
									File:   "influxdb.flux",
									Source: "tables\n        |> filter(fn)\n        |> v1.fieldsAsCols()\n        |> _mask(columns: [\"_measurement\", \"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 12,
										Line:   95,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 62,
												Line:   98,
											},
											File:   "influxdb.flux",
											Source: "columns: [\"_measurement\", \"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 18,
												Line:   98,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 62,
													Line:   98,
												},
												File:   "influxdb.flux",
												Source: "columns: [\"_measurement\", \"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 18,
													Line:   98,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 25,
														Line:   98,
													},
													File:   "influxdb.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 18,
														Line:   98,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 62,
														Line:   98,
													},
													File:   "influxdb.flux",
													Source: "[\"_measurement\", \"_start\", \"_stop\"]",
													Start: ast.Position{
														Column: 27,
														Line:   98,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   98,
														},
														File:   "influxdb.flux",
														Source: "\"_measurement\"",
														Start: ast.Position{
															Column: 28,
															Line:   98,
														},
													},
												},
												Value: "_measurement",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   98,
														},
														File:   "influxdb.flux",
														Source: "\"_start\"",
														Start: ast.Position{
															Column: 44,
															Line:   98,
														},
													},
												},
												Value: "_start",
											}, &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   98,
														},
														File:   "influxdb.flux",
														Source: "\"_stop\"",
														Start: ast.Position{
															Column: 54,
															Line:   98,
														},
													},
												},
												Value: "_stop",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   98,
										},
										File:   "influxdb.flux",
										Source: "_mask(columns: [\"_measurement\", \"_start\", \"_stop\"])",
										Start: ast.Position{
											Column: 12,
											Line:   98,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   98,
											},
											File:   "influxdb.flux",
											Source: "_mask",
											Start: ast.Position{
												Column: 12,
												Line:   98,
											},
										},
									},
									Name: "_mask",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   98,
								},
								File:   "influxdb.flux",
								Source: "return tables\n        |> filter(fn)\n        |> v1.fieldsAsCols()\n        |> _mask(columns: [\"_measurement\", \"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 5,
									Line:   95,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   58,
							},
							File:   "influxdb.flux",
							Source: "from",
							Start: ast.Position{
								Column: 9,
								Line:   58,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   58,
								},
								File:   "influxdb.flux",
								Source: "from",
								Start: ast.Position{
									Column: 9,
									Line:   58,
								},
							},
						},
						Name: "from",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   59,
							},
							File:   "influxdb.flux",
							Source: "start",
							Start: ast.Position{
								Column: 9,
								Line:   59,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   59,
								},
								File:   "influxdb.flux",
								Source: "start",
								Start: ast.Position{
									Column: 9,
									Line:   59,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   60,
							},
							File:   "influxdb.flux",
							Source: "stop=now()",
							Start: ast.Position{
								Column: 9,
								Line:   60,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   60,
								},
								File:   "influxdb.flux",
								Source: "stop",
								Start: ast.Position{
									Column: 9,
									Line:   60,
								},
							},
						},
						Name: "stop",
					},
					Separator: nil,
					Value: &ast.CallExpression{
						Arguments: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   60,
								},
								File:   "influxdb.flux",
								Source: "now()",
								Start: ast.Position{
									Column: 14,
									Line:   60,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   60,
									},
									File:   "influxdb.flux",
									Source: "now",
									Start: ast.Position{
										Column: 14,
										Line:   60,
									},
								},
							},
							Name: "now",
						},
						Lparen: nil,
						Rparen: nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 10,
								Line:   61,
							},
							File:   "influxdb.flux",
							Source: "m",
							Start: ast.Position{
								Column: 9,
								Line:   61,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 10,
									Line:   61,
								},
								File:   "influxdb.flux",
								Source: "m",
								Start: ast.Position{
									Column: 9,
									Line:   61,
								},
							},
						},
						Name: "m",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   62,
							},
							File:   "influxdb.flux",
							Source: "fields=[]",
							Start: ast.Position{
								Column: 9,
								Line:   62,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   62,
								},
								File:   "influxdb.flux",
								Source: "fields",
								Start: ast.Position{
									Column: 9,
									Line:   62,
								},
							},
						},
						Name: "fields",
					},
					Separator: nil,
					Value: &ast.ArrayExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   62,
								},
								File:   "influxdb.flux",
								Source: "[]",
								Start: ast.Position{
									Column: 16,
									Line:   62,
								},
							},
						},
						Elements: []ast.Expression{},
						Lbrack:   nil,
						Rbrack:   nil,
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 15,
								Line:   63,
							},
							File:   "influxdb.flux",
							Source: "org=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   63,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   63,
								},
								File:   "influxdb.flux",
								Source: "org",
								Start: ast.Position{
									Column: 9,
									Line:   63,
								},
							},
						},
						Name: "org",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   63,
								},
								File:   "influxdb.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 13,
									Line:   63,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   64,
							},
							File:   "influxdb.flux",
							Source: "host=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   64,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   64,
								},
								File:   "influxdb.flux",
								Source: "host",
								Start: ast.Position{
									Column: 9,
									Line:   64,
								},
							},
						},
						Name: "host",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   64,
								},
								File:   "influxdb.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 14,
									Line:   64,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   65,
							},
							File:   "influxdb.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   65,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   65,
								},
								File:   "influxdb.flux",
								Source: "token",
								Start: ast.Position{
									Column: 9,
									Line:   65,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   65,
								},
								File:   "influxdb.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 15,
									Line:   65,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   66,
							},
							File:   "influxdb.flux",
							Source: "where=(r) => true",
							Start: ast.Position{
								Column: 9,
								Line:   66,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   66,
								},
								File:   "influxdb.flux",
								Source: "where",
								Start: ast.Position{
									Column: 9,
									Line:   66,
								},
							},
						},
						Name: "where",
					},
					Separator: nil,
					Value: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   66,
								},
								File:   "influxdb.flux",
								Source: "(r) => true",
								Start: ast.Position{
									Column: 15,
									Line:   66,
								},
							},
						},
						Body: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 26,
										Line:   66,
									},
									File:   "influxdb.flux",
									Source: "true",
									Start: ast.Position{
										Column: 22,
										Line:   66,
									},
								},
							},
							Name: "true",
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 17,
										Line:   66,
									},
									File:   "influxdb.flux",
									Source: "r",
									Start: ast.Position{
										Column: 16,
										Line:   66,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   66,
										},
										File:   "influxdb.flux",
										Source: "r",
										Start: ast.Position{
											Column: 16,
											Line:   66,
										},
									},
								},
								Name: "r",
							},
							Separator: nil,
							Value:     nil,
						}},
						Rparan: nil,
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 29,
						Line:   4,
					},
					File:   "influxdb.flux",
					Source: "import \"influxdata/influxdb\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 29,
							Line:   4,
						},
						File:   "influxdb.flux",
						Source: "\"influxdata/influxdb\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "influxdata/influxdb",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 32,
						Line:   5,
					},
					File:   "influxdb.flux",
					Source: "import \"influxdata/influxdb/v1\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 32,
							Line:   5,
						},
						File:   "influxdb.flux",
						Source: "\"influxdata/influxdb/v1\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "influxdata/influxdb/v1",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "influxdb.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   1,
					},
					File:   "influxdb.flux",
					Source: "package influxdb",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   1,
						},
						File:   "influxdb.flux",
						Source: "influxdb",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "influxdb",
			},
		},
	}},
	Package: "influxdb",
	Path:    "contrib/jsternberg/influxdb",
}
