// DO NOT EDIT: This file is autogenerated via the builtin command.

package date

import (
	ast "github.com/influxdata/flux/ast"
	parser "github.com/influxdata/flux/internal/parser"
)

var FluxTestPackages = []*ast.Package{&ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 130,
					Line:   37,
				},
				File:   "hour_duration_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"\nt_duration_hour = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.hour(t: duration(v: r._value))}))\n\ntest _duration_hour = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_hour})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "hour_duration_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "hour_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "hour_duration_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "hour_duration_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "hour_duration_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "hour_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "hour_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "hour_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "hour_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "hour_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "hour_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,23\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 78,
						Line:   35,
					},
					File:   "hour_duration_test.flux",
					Source: "t_duration_hour = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.hour(t: duration(v: r._value))}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   33,
						},
						File:   "hour_duration_test.flux",
						Source: "t_duration_hour",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_duration_hour",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 78,
							Line:   35,
						},
						File:   "hour_duration_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.hour(t: duration(v: r._value))}))",
						Start: ast.Position{
							Column: 19,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   33,
									},
									File:   "hour_duration_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 33,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "hour_duration_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 33,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "hour_duration_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "hour_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "hour_duration_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "hour_duration_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "hour_duration_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "hour_duration_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 78,
								Line:   35,
							},
							File:   "hour_duration_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.hour(t: duration(v: r._value))}))",
							Start: ast.Position{
								Column: 33,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 77,
										Line:   35,
									},
									File:   "hour_duration_test.flux",
									Source: "fn: (r) => ({r with _value: date.hour(t: duration(v: r._value))})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   35,
										},
										File:   "hour_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.hour(t: duration(v: r._value))})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "hour_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   35,
											},
											File:   "hour_duration_test.flux",
											Source: "(r) => ({r with _value: date.hour(t: duration(v: r._value))})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 77,
													Line:   35,
												},
												File:   "hour_duration_test.flux",
												Source: "({r with _value: date.hour(t: duration(v: r._value))})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 76,
														Line:   35,
													},
													File:   "hour_duration_test.flux",
													Source: "{r with _value: date.hour(t: duration(v: r._value))}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 75,
															Line:   35,
														},
														File:   "hour_duration_test.flux",
														Source: "_value: date.hour(t: duration(v: r._value))",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "hour_duration_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 74,
																	Line:   35,
																},
																File:   "hour_duration_test.flux",
																Source: "t: duration(v: r._value)",
																Start: ast.Position{
																	Column: 50,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 74,
																		Line:   35,
																	},
																	File:   "hour_duration_test.flux",
																	Source: "t: duration(v: r._value)",
																	Start: ast.Position{
																		Column: 50,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 51,
																			Line:   35,
																		},
																		File:   "hour_duration_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 50,
																			Line:   35,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 73,
																				Line:   35,
																			},
																			File:   "hour_duration_test.flux",
																			Source: "v: r._value",
																			Start: ast.Position{
																				Column: 62,
																				Line:   35,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 73,
																					Line:   35,
																				},
																				File:   "hour_duration_test.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 62,
																					Line:   35,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 63,
																						Line:   35,
																					},
																					File:   "hour_duration_test.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 62,
																						Line:   35,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 73,
																						Line:   35,
																					},
																					File:   "hour_duration_test.flux",
																					Source: "r._value",
																					Start: ast.Position{
																						Column: 65,
																						Line:   35,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 66,
																							Line:   35,
																						},
																						File:   "hour_duration_test.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 65,
																							Line:   35,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 73,
																							Line:   35,
																						},
																						File:   "hour_duration_test.flux",
																						Source: "_value",
																						Start: ast.Position{
																							Column: 67,
																							Line:   35,
																						},
																					},
																				},
																				Name: "_value",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 74,
																			Line:   35,
																		},
																		File:   "hour_duration_test.flux",
																		Source: "duration(v: r._value)",
																		Start: ast.Position{
																			Column: 53,
																			Line:   35,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 61,
																				Line:   35,
																			},
																			File:   "hour_duration_test.flux",
																			Source: "duration",
																			Start: ast.Position{
																				Column: 53,
																				Line:   35,
																			},
																		},
																	},
																	Name: "duration",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 75,
																Line:   35,
															},
															File:   "hour_duration_test.flux",
															Source: "date.hour(t: duration(v: r._value))",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   35,
																},
																File:   "hour_duration_test.flux",
																Source: "date.hour",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   35,
																	},
																	File:   "hour_duration_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   35,
																	},
																	File:   "hour_duration_test.flux",
																	Source: "hour",
																	Start: ast.Position{
																		Column: 45,
																		Line:   35,
																	},
																},
															},
															Name: "hour",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "hour_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "hour_duration_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "hour_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 78,
									Line:   35,
								},
								File:   "hour_duration_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.hour(t: duration(v: r._value))}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "hour_duration_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   33,
							},
							File:   "hour_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 20,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   33,
								},
								File:   "hour_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 20,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   33,
							},
							File:   "hour_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 26,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 130,
							Line:   37,
						},
						File:   "hour_duration_test.flux",
						Source: "_duration_hour = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_hour})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 20,
								Line:   37,
							},
							File:   "hour_duration_test.flux",
							Source: "_duration_hour",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_duration_hour",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 130,
								Line:   37,
							},
							File:   "hour_duration_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_hour})",
							Start: ast.Position{
								Column: 23,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 130,
									Line:   37,
								},
								File:   "hour_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_hour})",
								Start: ast.Position{
									Column: 29,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 129,
										Line:   37,
									},
									File:   "hour_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_hour}",
									Start: ast.Position{
										Column: 30,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   37,
										},
										File:   "hour_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 31,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 36,
												Line:   37,
											},
											File:   "hour_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 31,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   37,
												},
												File:   "hour_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 58,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   37,
													},
													File:   "hour_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 58,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   37,
														},
														File:   "hour_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 58,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 69,
															Line:   37,
														},
														File:   "hour_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 63,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   37,
											},
											File:   "hour_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 38,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 57,
													Line:   37,
												},
												File:   "hour_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 38,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 45,
														Line:   37,
													},
													File:   "hour_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 38,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   37,
													},
													File:   "hour_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 46,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 107,
											Line:   37,
										},
										File:   "hour_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 72,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 76,
												Line:   37,
											},
											File:   "hour_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 72,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 106,
													Line:   37,
												},
												File:   "hour_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 94,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 106,
														Line:   37,
													},
													File:   "hour_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 94,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 97,
															Line:   37,
														},
														File:   "hour_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 94,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 106,
															Line:   37,
														},
														File:   "hour_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 99,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 107,
												Line:   37,
											},
											File:   "hour_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 78,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 93,
													Line:   37,
												},
												File:   "hour_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 78,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 85,
														Line:   37,
													},
													File:   "hour_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 78,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 93,
														Line:   37,
													},
													File:   "hour_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 86,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 128,
											Line:   37,
										},
										File:   "hour_duration_test.flux",
										Source: "fn: t_duration_hour",
										Start: ast.Position{
											Column: 109,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 111,
												Line:   37,
											},
											File:   "hour_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 109,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 128,
												Line:   37,
											},
											File:   "hour_duration_test.flux",
											Source: "t_duration_hour",
											Start: ast.Position{
												Column: 113,
												Line:   37,
											},
										},
									},
									Name: "t_duration_hour",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 130,
						Line:   37,
					},
					File:   "hour_duration_test.flux",
					Source: "test _duration_hour = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_hour})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "hour_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "hour_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "hour_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "hour_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "hour_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "hour_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "hour_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 122,
					Line:   73,
				},
				File:   "hour_time_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T00:53:00Z,_m,FF,1\n,,0,2018-05-22T01:53:00Z,_m,FF,1\n,,0,2018-05-22T02:53:10Z,_m,FF,1\n,,0,2018-05-22T03:53:20Z,_m,FF,1\n,,0,2018-05-22T04:53:30Z,_m,FF,1\n,,0,2018-05-22T05:53:40Z,_m,FF,1\n,,0,2018-05-22T06:53:50Z,_m,FF,1\n,,1,2018-05-22T07:53:00Z,_m,QQ,1\n,,1,2018-05-22T08:53:10Z,_m,QQ,1\n,,1,2018-05-22T09:53:20Z,_m,QQ,1\n,,1,2018-05-22T10:53:30Z,_m,QQ,1\n,,1,2018-05-22T11:53:40Z,_m,QQ,1\n,,1,2018-05-22T12:53:50Z,_m,QQ,1\n,,1,2018-05-22T13:54:00Z,_m,QQ,1\n,,1,2018-05-22T14:54:10Z,_m,QQ,1\n,,1,2018-05-22T15:54:20Z,_m,QQ,1\n,,2,2018-05-22T16:53:00Z,_m,RR,1\n,,2,2018-05-22T17:53:10Z,_m,RR,1\n,,2,2018-05-22T18:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T20:53:40Z,_m,SR,1\n,,3,2018-05-22T21:53:50Z,_m,SR,1\n,,3,2018-05-22T22:53:00Z,_m,SR,1\n,,3,2018-05-22T23:53:50Z,_m,SR,1\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T00:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T01:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T02:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T03:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T04:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T05:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T06:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T07:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T08:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T09:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T10:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T11:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T12:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T13:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T14:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T15:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T16:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T17:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T18:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T21:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T22:53:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T23:53:50Z,23\n\"\nt_time_hour = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.hour(t: r._time)}))\n\ntest _time_hour = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_hour})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "hour_time_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "hour_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "hour_time_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "hour_time_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "hour_time_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   38,
					},
					File:   "hour_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T00:53:00Z,_m,FF,1\n,,0,2018-05-22T01:53:00Z,_m,FF,1\n,,0,2018-05-22T02:53:10Z,_m,FF,1\n,,0,2018-05-22T03:53:20Z,_m,FF,1\n,,0,2018-05-22T04:53:30Z,_m,FF,1\n,,0,2018-05-22T05:53:40Z,_m,FF,1\n,,0,2018-05-22T06:53:50Z,_m,FF,1\n,,1,2018-05-22T07:53:00Z,_m,QQ,1\n,,1,2018-05-22T08:53:10Z,_m,QQ,1\n,,1,2018-05-22T09:53:20Z,_m,QQ,1\n,,1,2018-05-22T10:53:30Z,_m,QQ,1\n,,1,2018-05-22T11:53:40Z,_m,QQ,1\n,,1,2018-05-22T12:53:50Z,_m,QQ,1\n,,1,2018-05-22T13:54:00Z,_m,QQ,1\n,,1,2018-05-22T14:54:10Z,_m,QQ,1\n,,1,2018-05-22T15:54:20Z,_m,QQ,1\n,,2,2018-05-22T16:53:00Z,_m,RR,1\n,,2,2018-05-22T17:53:10Z,_m,RR,1\n,,2,2018-05-22T18:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T20:53:40Z,_m,SR,1\n,,3,2018-05-22T21:53:50Z,_m,SR,1\n,,3,2018-05-22T22:53:00Z,_m,SR,1\n,,3,2018-05-22T23:53:50Z,_m,SR,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "hour_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   38,
						},
						File:   "hour_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T00:53:00Z,_m,FF,1\n,,0,2018-05-22T01:53:00Z,_m,FF,1\n,,0,2018-05-22T02:53:10Z,_m,FF,1\n,,0,2018-05-22T03:53:20Z,_m,FF,1\n,,0,2018-05-22T04:53:30Z,_m,FF,1\n,,0,2018-05-22T05:53:40Z,_m,FF,1\n,,0,2018-05-22T06:53:50Z,_m,FF,1\n,,1,2018-05-22T07:53:00Z,_m,QQ,1\n,,1,2018-05-22T08:53:10Z,_m,QQ,1\n,,1,2018-05-22T09:53:20Z,_m,QQ,1\n,,1,2018-05-22T10:53:30Z,_m,QQ,1\n,,1,2018-05-22T11:53:40Z,_m,QQ,1\n,,1,2018-05-22T12:53:50Z,_m,QQ,1\n,,1,2018-05-22T13:54:00Z,_m,QQ,1\n,,1,2018-05-22T14:54:10Z,_m,QQ,1\n,,1,2018-05-22T15:54:20Z,_m,QQ,1\n,,2,2018-05-22T16:53:00Z,_m,RR,1\n,,2,2018-05-22T17:53:10Z,_m,RR,1\n,,2,2018-05-22T18:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T20:53:40Z,_m,SR,1\n,,3,2018-05-22T21:53:50Z,_m,SR,1\n,,3,2018-05-22T22:53:00Z,_m,SR,1\n,,3,2018-05-22T23:53:50Z,_m,SR,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T00:53:00Z,_m,FF,1\n,,0,2018-05-22T01:53:00Z,_m,FF,1\n,,0,2018-05-22T02:53:10Z,_m,FF,1\n,,0,2018-05-22T03:53:20Z,_m,FF,1\n,,0,2018-05-22T04:53:30Z,_m,FF,1\n,,0,2018-05-22T05:53:40Z,_m,FF,1\n,,0,2018-05-22T06:53:50Z,_m,FF,1\n,,1,2018-05-22T07:53:00Z,_m,QQ,1\n,,1,2018-05-22T08:53:10Z,_m,QQ,1\n,,1,2018-05-22T09:53:20Z,_m,QQ,1\n,,1,2018-05-22T10:53:30Z,_m,QQ,1\n,,1,2018-05-22T11:53:40Z,_m,QQ,1\n,,1,2018-05-22T12:53:50Z,_m,QQ,1\n,,1,2018-05-22T13:54:00Z,_m,QQ,1\n,,1,2018-05-22T14:54:10Z,_m,QQ,1\n,,1,2018-05-22T15:54:20Z,_m,QQ,1\n,,2,2018-05-22T16:53:00Z,_m,RR,1\n,,2,2018-05-22T17:53:10Z,_m,RR,1\n,,2,2018-05-22T18:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T20:53:40Z,_m,SR,1\n,,3,2018-05-22T21:53:50Z,_m,SR,1\n,,3,2018-05-22T22:53:00Z,_m,SR,1\n,,3,2018-05-22T23:53:50Z,_m,SR,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   68,
					},
					File:   "hour_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T00:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T01:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T02:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T03:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T04:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T05:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T06:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T07:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T08:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T09:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T10:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T11:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T12:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T13:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T14:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T15:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T16:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T17:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T18:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T21:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T22:53:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T23:53:50Z,23\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   39,
						},
						File:   "hour_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   39,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   68,
						},
						File:   "hour_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T00:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T01:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T02:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T03:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T04:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T05:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T06:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T07:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T08:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T09:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T10:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T11:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T12:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T13:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T14:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T15:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T16:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T17:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T18:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T21:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T22:53:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T23:53:50Z,23\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   39,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T00:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T01:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T02:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T03:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T04:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T05:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T06:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T07:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T08:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T09:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T10:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T11:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T12:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T13:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T14:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T15:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T16:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T17:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T18:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T21:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T22:53:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T23:53:50Z,23\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 64,
						Line:   71,
					},
					File:   "hour_time_test.flux",
					Source: "t_time_hour = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.hour(t: r._time)}))",
					Start: ast.Position{
						Column: 1,
						Line:   69,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   69,
						},
						File:   "hour_time_test.flux",
						Source: "t_time_hour",
						Start: ast.Position{
							Column: 1,
							Line:   69,
						},
					},
				},
				Name: "t_time_hour",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 64,
							Line:   71,
						},
						File:   "hour_time_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.hour(t: r._time)}))",
						Start: ast.Position{
							Column: 15,
							Line:   69,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   69,
									},
									File:   "hour_time_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 29,
										Line:   69,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   70,
								},
								File:   "hour_time_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 29,
									Line:   69,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   70,
										},
										File:   "hour_time_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   70,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   70,
											},
											File:   "hour_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   70,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   70,
												},
												File:   "hour_time_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   70,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   70,
												},
												File:   "hour_time_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   70,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   70,
									},
									File:   "hour_time_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   70,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   70,
										},
										File:   "hour_time_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   70,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 64,
								Line:   71,
							},
							File:   "hour_time_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.hour(t: r._time)}))",
							Start: ast.Position{
								Column: 29,
								Line:   69,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   71,
									},
									File:   "hour_time_test.flux",
									Source: "fn: (r) => ({r with _value: date.hour(t: r._time)})",
									Start: ast.Position{
										Column: 12,
										Line:   71,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 63,
											Line:   71,
										},
										File:   "hour_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.hour(t: r._time)})",
										Start: ast.Position{
											Column: 12,
											Line:   71,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   71,
											},
											File:   "hour_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   71,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 63,
												Line:   71,
											},
											File:   "hour_time_test.flux",
											Source: "(r) => ({r with _value: date.hour(t: r._time)})",
											Start: ast.Position{
												Column: 16,
												Line:   71,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 63,
													Line:   71,
												},
												File:   "hour_time_test.flux",
												Source: "({r with _value: date.hour(t: r._time)})",
												Start: ast.Position{
													Column: 23,
													Line:   71,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 62,
														Line:   71,
													},
													File:   "hour_time_test.flux",
													Source: "{r with _value: date.hour(t: r._time)}",
													Start: ast.Position{
														Column: 24,
														Line:   71,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 61,
															Line:   71,
														},
														File:   "hour_time_test.flux",
														Source: "_value: date.hour(t: r._time)",
														Start: ast.Position{
															Column: 32,
															Line:   71,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   71,
															},
															File:   "hour_time_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   71,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 60,
																	Line:   71,
																},
																File:   "hour_time_test.flux",
																Source: "t: r._time",
																Start: ast.Position{
																	Column: 50,
																	Line:   71,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 60,
																		Line:   71,
																	},
																	File:   "hour_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 50,
																		Line:   71,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 51,
																			Line:   71,
																		},
																		File:   "hour_time_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 50,
																			Line:   71,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 60,
																			Line:   71,
																		},
																		File:   "hour_time_test.flux",
																		Source: "r._time",
																		Start: ast.Position{
																			Column: 53,
																			Line:   71,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 54,
																				Line:   71,
																			},
																			File:   "hour_time_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 53,
																				Line:   71,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 60,
																				Line:   71,
																			},
																			File:   "hour_time_test.flux",
																			Source: "_time",
																			Start: ast.Position{
																				Column: 55,
																				Line:   71,
																			},
																		},
																	},
																	Name: "_time",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 61,
																Line:   71,
															},
															File:   "hour_time_test.flux",
															Source: "date.hour(t: r._time)",
															Start: ast.Position{
																Column: 40,
																Line:   71,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 49,
																	Line:   71,
																},
																File:   "hour_time_test.flux",
																Source: "date.hour",
																Start: ast.Position{
																	Column: 40,
																	Line:   71,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   71,
																	},
																	File:   "hour_time_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   71,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 49,
																		Line:   71,
																	},
																	File:   "hour_time_test.flux",
																	Source: "hour",
																	Start: ast.Position{
																		Column: 45,
																		Line:   71,
																	},
																},
															},
															Name: "hour",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   71,
														},
														File:   "hour_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   71,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   71,
												},
												File:   "hour_time_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   71,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   71,
													},
													File:   "hour_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   71,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 64,
									Line:   71,
								},
								File:   "hour_time_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.hour(t: r._time)}))",
								Start: ast.Position{
									Column: 8,
									Line:   71,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   71,
									},
									File:   "hour_time_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   71,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   69,
							},
							File:   "hour_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 16,
								Line:   69,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   69,
								},
								File:   "hour_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 16,
									Line:   69,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   69,
							},
							File:   "hour_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 22,
								Line:   69,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 122,
							Line:   73,
						},
						File:   "hour_time_test.flux",
						Source: "_time_hour = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_hour})",
						Start: ast.Position{
							Column: 6,
							Line:   73,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   73,
							},
							File:   "hour_time_test.flux",
							Source: "_time_hour",
							Start: ast.Position{
								Column: 6,
								Line:   73,
							},
						},
					},
					Name: "_time_hour",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 122,
								Line:   73,
							},
							File:   "hour_time_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_hour})",
							Start: ast.Position{
								Column: 19,
								Line:   73,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 122,
									Line:   73,
								},
								File:   "hour_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_hour})",
								Start: ast.Position{
									Column: 25,
									Line:   73,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 121,
										Line:   73,
									},
									File:   "hour_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_hour}",
									Start: ast.Position{
										Column: 26,
										Line:   73,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   73,
										},
										File:   "hour_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 27,
											Line:   73,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 32,
												Line:   73,
											},
											File:   "hour_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 27,
												Line:   73,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   73,
												},
												File:   "hour_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 54,
													Line:   73,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   73,
													},
													File:   "hour_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 54,
														Line:   73,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 57,
															Line:   73,
														},
														File:   "hour_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 54,
															Line:   73,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   73,
														},
														File:   "hour_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 59,
															Line:   73,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   73,
											},
											File:   "hour_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 34,
												Line:   73,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 53,
													Line:   73,
												},
												File:   "hour_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 34,
													Line:   73,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   73,
													},
													File:   "hour_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 34,
														Line:   73,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 53,
														Line:   73,
													},
													File:   "hour_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 42,
														Line:   73,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 103,
											Line:   73,
										},
										File:   "hour_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 68,
											Line:   73,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   73,
											},
											File:   "hour_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 68,
												Line:   73,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 102,
													Line:   73,
												},
												File:   "hour_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 90,
													Line:   73,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 102,
														Line:   73,
													},
													File:   "hour_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 90,
														Line:   73,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 93,
															Line:   73,
														},
														File:   "hour_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 90,
															Line:   73,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 102,
															Line:   73,
														},
														File:   "hour_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 95,
															Line:   73,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 103,
												Line:   73,
											},
											File:   "hour_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 74,
												Line:   73,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 89,
													Line:   73,
												},
												File:   "hour_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 74,
													Line:   73,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 81,
														Line:   73,
													},
													File:   "hour_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 74,
														Line:   73,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 89,
														Line:   73,
													},
													File:   "hour_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 82,
														Line:   73,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 120,
											Line:   73,
										},
										File:   "hour_time_test.flux",
										Source: "fn: t_time_hour",
										Start: ast.Position{
											Column: 105,
											Line:   73,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 107,
												Line:   73,
											},
											File:   "hour_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 105,
												Line:   73,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 120,
												Line:   73,
											},
											File:   "hour_time_test.flux",
											Source: "t_time_hour",
											Start: ast.Position{
												Column: 109,
												Line:   73,
											},
										},
									},
									Name: "t_time_hour",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 122,
						Line:   73,
					},
					File:   "hour_time_test.flux",
					Source: "test _time_hour = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_hour})",
					Start: ast.Position{
						Column: 1,
						Line:   73,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "hour_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "hour_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "hour_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "hour_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "hour_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "hour_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "hour_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 144,
					Line:   37,
				},
				File:   "microsecond_duration_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"\nt_duration_microsecond = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.microsecond(t: duration(v: r._value))}))\n\ntest _duration_microsecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_microsecond})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "microsecond_duration_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "microsecond_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "microsecond_duration_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "microsecond_duration_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "microsecond_duration_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "microsecond_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "microsecond_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "microsecond_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "microsecond_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "microsecond_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "microsecond_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 85,
						Line:   35,
					},
					File:   "microsecond_duration_test.flux",
					Source: "t_duration_microsecond = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.microsecond(t: duration(v: r._value))}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   33,
						},
						File:   "microsecond_duration_test.flux",
						Source: "t_duration_microsecond",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_duration_microsecond",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   35,
						},
						File:   "microsecond_duration_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.microsecond(t: duration(v: r._value))}))",
						Start: ast.Position{
							Column: 26,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   33,
									},
									File:   "microsecond_duration_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 40,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "microsecond_duration_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 40,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "microsecond_duration_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "microsecond_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "microsecond_duration_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "microsecond_duration_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "microsecond_duration_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "microsecond_duration_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   35,
							},
							File:   "microsecond_duration_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.microsecond(t: duration(v: r._value))}))",
							Start: ast.Position{
								Column: 40,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   35,
									},
									File:   "microsecond_duration_test.flux",
									Source: "fn: (r) => ({r with _value: date.microsecond(t: duration(v: r._value))})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   35,
										},
										File:   "microsecond_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.microsecond(t: duration(v: r._value))})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "microsecond_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   35,
											},
											File:   "microsecond_duration_test.flux",
											Source: "(r) => ({r with _value: date.microsecond(t: duration(v: r._value))})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 84,
													Line:   35,
												},
												File:   "microsecond_duration_test.flux",
												Source: "({r with _value: date.microsecond(t: duration(v: r._value))})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 83,
														Line:   35,
													},
													File:   "microsecond_duration_test.flux",
													Source: "{r with _value: date.microsecond(t: duration(v: r._value))}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   35,
														},
														File:   "microsecond_duration_test.flux",
														Source: "_value: date.microsecond(t: duration(v: r._value))",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "microsecond_duration_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 81,
																	Line:   35,
																},
																File:   "microsecond_duration_test.flux",
																Source: "t: duration(v: r._value)",
																Start: ast.Position{
																	Column: 57,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 81,
																		Line:   35,
																	},
																	File:   "microsecond_duration_test.flux",
																	Source: "t: duration(v: r._value)",
																	Start: ast.Position{
																		Column: 57,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   35,
																		},
																		File:   "microsecond_duration_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 57,
																			Line:   35,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 80,
																				Line:   35,
																			},
																			File:   "microsecond_duration_test.flux",
																			Source: "v: r._value",
																			Start: ast.Position{
																				Column: 69,
																				Line:   35,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 80,
																					Line:   35,
																				},
																				File:   "microsecond_duration_test.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 69,
																					Line:   35,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 70,
																						Line:   35,
																					},
																					File:   "microsecond_duration_test.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 69,
																						Line:   35,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 80,
																						Line:   35,
																					},
																					File:   "microsecond_duration_test.flux",
																					Source: "r._value",
																					Start: ast.Position{
																						Column: 72,
																						Line:   35,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 73,
																							Line:   35,
																						},
																						File:   "microsecond_duration_test.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 72,
																							Line:   35,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 80,
																							Line:   35,
																						},
																						File:   "microsecond_duration_test.flux",
																						Source: "_value",
																						Start: ast.Position{
																							Column: 74,
																							Line:   35,
																						},
																					},
																				},
																				Name: "_value",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 81,
																			Line:   35,
																		},
																		File:   "microsecond_duration_test.flux",
																		Source: "duration(v: r._value)",
																		Start: ast.Position{
																			Column: 60,
																			Line:   35,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 68,
																				Line:   35,
																			},
																			File:   "microsecond_duration_test.flux",
																			Source: "duration",
																			Start: ast.Position{
																				Column: 60,
																				Line:   35,
																			},
																		},
																	},
																	Name: "duration",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 82,
																Line:   35,
															},
															File:   "microsecond_duration_test.flux",
															Source: "date.microsecond(t: duration(v: r._value))",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   35,
																},
																File:   "microsecond_duration_test.flux",
																Source: "date.microsecond",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   35,
																	},
																	File:   "microsecond_duration_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   35,
																	},
																	File:   "microsecond_duration_test.flux",
																	Source: "microsecond",
																	Start: ast.Position{
																		Column: 45,
																		Line:   35,
																	},
																},
															},
															Name: "microsecond",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "microsecond_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "microsecond_duration_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "microsecond_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   35,
								},
								File:   "microsecond_duration_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.microsecond(t: duration(v: r._value))}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "microsecond_duration_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   33,
							},
							File:   "microsecond_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 27,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   33,
								},
								File:   "microsecond_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 27,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   33,
							},
							File:   "microsecond_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 33,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 144,
							Line:   37,
						},
						File:   "microsecond_duration_test.flux",
						Source: "_duration_microsecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_microsecond})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   37,
							},
							File:   "microsecond_duration_test.flux",
							Source: "_duration_microsecond",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_duration_microsecond",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 144,
								Line:   37,
							},
							File:   "microsecond_duration_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_microsecond})",
							Start: ast.Position{
								Column: 30,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 144,
									Line:   37,
								},
								File:   "microsecond_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_microsecond})",
								Start: ast.Position{
									Column: 36,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 143,
										Line:   37,
									},
									File:   "microsecond_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_microsecond}",
									Start: ast.Position{
										Column: 37,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   37,
										},
										File:   "microsecond_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 38,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   37,
											},
											File:   "microsecond_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 38,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   37,
												},
												File:   "microsecond_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 65,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 76,
														Line:   37,
													},
													File:   "microsecond_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 65,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   37,
														},
														File:   "microsecond_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 65,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 76,
															Line:   37,
														},
														File:   "microsecond_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 70,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   37,
											},
											File:   "microsecond_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 45,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 64,
													Line:   37,
												},
												File:   "microsecond_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 45,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   37,
													},
													File:   "microsecond_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 45,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   37,
													},
													File:   "microsecond_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 53,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 114,
											Line:   37,
										},
										File:   "microsecond_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 79,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 83,
												Line:   37,
											},
											File:   "microsecond_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 79,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 113,
													Line:   37,
												},
												File:   "microsecond_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 101,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 113,
														Line:   37,
													},
													File:   "microsecond_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 101,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 104,
															Line:   37,
														},
														File:   "microsecond_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 101,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 113,
															Line:   37,
														},
														File:   "microsecond_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 106,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 114,
												Line:   37,
											},
											File:   "microsecond_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 85,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 100,
													Line:   37,
												},
												File:   "microsecond_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 85,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 92,
														Line:   37,
													},
													File:   "microsecond_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 85,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 100,
														Line:   37,
													},
													File:   "microsecond_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 93,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 142,
											Line:   37,
										},
										File:   "microsecond_duration_test.flux",
										Source: "fn: t_duration_microsecond",
										Start: ast.Position{
											Column: 116,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 118,
												Line:   37,
											},
											File:   "microsecond_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 116,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 142,
												Line:   37,
											},
											File:   "microsecond_duration_test.flux",
											Source: "t_duration_microsecond",
											Start: ast.Position{
												Column: 120,
												Line:   37,
											},
										},
									},
									Name: "t_duration_microsecond",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 144,
						Line:   37,
					},
					File:   "microsecond_duration_test.flux",
					Source: "test _duration_microsecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_microsecond})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "microsecond_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "microsecond_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "microsecond_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "microsecond_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "microsecond_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "microsecond_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "microsecond_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 136,
					Line:   55,
				},
				File:   "microsecond_time_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748\n\"\nt_time_microsecond = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.microsecond(t: r._time)}))\n\ntest _time_microsecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_microsecond})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "microsecond_time_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "microsecond_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "microsecond_time_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "microsecond_time_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "microsecond_time_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   29,
					},
					File:   "microsecond_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "microsecond_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   29,
						},
						File:   "microsecond_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   50,
					},
					File:   "microsecond_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "microsecond_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   50,
						},
						File:   "microsecond_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 71,
						Line:   53,
					},
					File:   "microsecond_time_test.flux",
					Source: "t_time_microsecond = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.microsecond(t: r._time)}))",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   51,
						},
						File:   "microsecond_time_test.flux",
						Source: "t_time_microsecond",
						Start: ast.Position{
							Column: 1,
							Line:   51,
						},
					},
				},
				Name: "t_time_microsecond",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 71,
							Line:   53,
						},
						File:   "microsecond_time_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.microsecond(t: r._time)}))",
						Start: ast.Position{
							Column: 22,
							Line:   51,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   51,
									},
									File:   "microsecond_time_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 36,
										Line:   51,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   52,
								},
								File:   "microsecond_time_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 36,
									Line:   51,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   52,
										},
										File:   "microsecond_time_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   52,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   52,
											},
											File:   "microsecond_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   52,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   52,
												},
												File:   "microsecond_time_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   52,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   52,
												},
												File:   "microsecond_time_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   52,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   52,
									},
									File:   "microsecond_time_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   52,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   52,
										},
										File:   "microsecond_time_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   52,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   53,
							},
							File:   "microsecond_time_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.microsecond(t: r._time)}))",
							Start: ast.Position{
								Column: 36,
								Line:   51,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   53,
									},
									File:   "microsecond_time_test.flux",
									Source: "fn: (r) => ({r with _value: date.microsecond(t: r._time)})",
									Start: ast.Position{
										Column: 12,
										Line:   53,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   53,
										},
										File:   "microsecond_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.microsecond(t: r._time)})",
										Start: ast.Position{
											Column: 12,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   53,
											},
											File:   "microsecond_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   53,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   53,
											},
											File:   "microsecond_time_test.flux",
											Source: "(r) => ({r with _value: date.microsecond(t: r._time)})",
											Start: ast.Position{
												Column: 16,
												Line:   53,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   53,
												},
												File:   "microsecond_time_test.flux",
												Source: "({r with _value: date.microsecond(t: r._time)})",
												Start: ast.Position{
													Column: 23,
													Line:   53,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   53,
													},
													File:   "microsecond_time_test.flux",
													Source: "{r with _value: date.microsecond(t: r._time)}",
													Start: ast.Position{
														Column: 24,
														Line:   53,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   53,
														},
														File:   "microsecond_time_test.flux",
														Source: "_value: date.microsecond(t: r._time)",
														Start: ast.Position{
															Column: 32,
															Line:   53,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   53,
															},
															File:   "microsecond_time_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   53,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 67,
																	Line:   53,
																},
																File:   "microsecond_time_test.flux",
																Source: "t: r._time",
																Start: ast.Position{
																	Column: 57,
																	Line:   53,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 67,
																		Line:   53,
																	},
																	File:   "microsecond_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 57,
																		Line:   53,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   53,
																		},
																		File:   "microsecond_time_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 57,
																			Line:   53,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 67,
																			Line:   53,
																		},
																		File:   "microsecond_time_test.flux",
																		Source: "r._time",
																		Start: ast.Position{
																			Column: 60,
																			Line:   53,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 61,
																				Line:   53,
																			},
																			File:   "microsecond_time_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 60,
																				Line:   53,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 67,
																				Line:   53,
																			},
																			File:   "microsecond_time_test.flux",
																			Source: "_time",
																			Start: ast.Position{
																				Column: 62,
																				Line:   53,
																			},
																		},
																	},
																	Name: "_time",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   53,
															},
															File:   "microsecond_time_test.flux",
															Source: "date.microsecond(t: r._time)",
															Start: ast.Position{
																Column: 40,
																Line:   53,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   53,
																},
																File:   "microsecond_time_test.flux",
																Source: "date.microsecond",
																Start: ast.Position{
																	Column: 40,
																	Line:   53,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   53,
																	},
																	File:   "microsecond_time_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   53,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   53,
																	},
																	File:   "microsecond_time_test.flux",
																	Source: "microsecond",
																	Start: ast.Position{
																		Column: 45,
																		Line:   53,
																	},
																},
															},
															Name: "microsecond",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   53,
														},
														File:   "microsecond_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   53,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   53,
												},
												File:   "microsecond_time_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   53,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   53,
													},
													File:   "microsecond_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   53,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   53,
								},
								File:   "microsecond_time_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.microsecond(t: r._time)}))",
								Start: ast.Position{
									Column: 8,
									Line:   53,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   53,
									},
									File:   "microsecond_time_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   53,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   51,
							},
							File:   "microsecond_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   51,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   51,
								},
								File:   "microsecond_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   51,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   51,
							},
							File:   "microsecond_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   51,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 136,
							Line:   55,
						},
						File:   "microsecond_time_test.flux",
						Source: "_time_microsecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_microsecond})",
						Start: ast.Position{
							Column: 6,
							Line:   55,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   55,
							},
							File:   "microsecond_time_test.flux",
							Source: "_time_microsecond",
							Start: ast.Position{
								Column: 6,
								Line:   55,
							},
						},
					},
					Name: "_time_microsecond",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 136,
								Line:   55,
							},
							File:   "microsecond_time_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_microsecond})",
							Start: ast.Position{
								Column: 26,
								Line:   55,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 136,
									Line:   55,
								},
								File:   "microsecond_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_microsecond})",
								Start: ast.Position{
									Column: 32,
									Line:   55,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 135,
										Line:   55,
									},
									File:   "microsecond_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_microsecond}",
									Start: ast.Position{
										Column: 33,
										Line:   55,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   55,
										},
										File:   "microsecond_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 34,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   55,
											},
											File:   "microsecond_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 34,
												Line:   55,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 72,
													Line:   55,
												},
												File:   "microsecond_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 61,
													Line:   55,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 72,
														Line:   55,
													},
													File:   "microsecond_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 61,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   55,
														},
														File:   "microsecond_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 61,
															Line:   55,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   55,
														},
														File:   "microsecond_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 66,
															Line:   55,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   55,
											},
											File:   "microsecond_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 41,
												Line:   55,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   55,
												},
												File:   "microsecond_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 41,
													Line:   55,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   55,
													},
													File:   "microsecond_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 41,
														Line:   55,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   55,
													},
													File:   "microsecond_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 49,
														Line:   55,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 110,
											Line:   55,
										},
										File:   "microsecond_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 75,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   55,
											},
											File:   "microsecond_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 75,
												Line:   55,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 109,
													Line:   55,
												},
												File:   "microsecond_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 97,
													Line:   55,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 109,
														Line:   55,
													},
													File:   "microsecond_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 97,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 100,
															Line:   55,
														},
														File:   "microsecond_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 97,
															Line:   55,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 109,
															Line:   55,
														},
														File:   "microsecond_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 102,
															Line:   55,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   55,
											},
											File:   "microsecond_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 81,
												Line:   55,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 96,
													Line:   55,
												},
												File:   "microsecond_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 81,
													Line:   55,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   55,
													},
													File:   "microsecond_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 81,
														Line:   55,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 96,
														Line:   55,
													},
													File:   "microsecond_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 89,
														Line:   55,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 134,
											Line:   55,
										},
										File:   "microsecond_time_test.flux",
										Source: "fn: t_time_microsecond",
										Start: ast.Position{
											Column: 112,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 114,
												Line:   55,
											},
											File:   "microsecond_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 112,
												Line:   55,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 134,
												Line:   55,
											},
											File:   "microsecond_time_test.flux",
											Source: "t_time_microsecond",
											Start: ast.Position{
												Column: 116,
												Line:   55,
											},
										},
									},
									Name: "t_time_microsecond",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 136,
						Line:   55,
					},
					File:   "microsecond_time_test.flux",
					Source: "test _time_microsecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_microsecond})",
					Start: ast.Position{
						Column: 1,
						Line:   55,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "microsecond_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "microsecond_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "microsecond_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "microsecond_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "microsecond_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "microsecond_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "microsecond_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 144,
					Line:   37,
				},
				File:   "millisecond_duration_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"\nt_duration_millisecond = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.millisecond(t: duration(v: r._value))}))\n\ntest _duration_millisecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_millisecond})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "millisecond_duration_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "millisecond_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "millisecond_duration_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "millisecond_duration_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "millisecond_duration_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "millisecond_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "millisecond_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "millisecond_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "millisecond_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "millisecond_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "millisecond_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 85,
						Line:   35,
					},
					File:   "millisecond_duration_test.flux",
					Source: "t_duration_millisecond = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.millisecond(t: duration(v: r._value))}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 23,
							Line:   33,
						},
						File:   "millisecond_duration_test.flux",
						Source: "t_duration_millisecond",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_duration_millisecond",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 85,
							Line:   35,
						},
						File:   "millisecond_duration_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.millisecond(t: duration(v: r._value))}))",
						Start: ast.Position{
							Column: 26,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   33,
									},
									File:   "millisecond_duration_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 40,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "millisecond_duration_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 40,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "millisecond_duration_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "millisecond_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "millisecond_duration_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "millisecond_duration_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "millisecond_duration_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "millisecond_duration_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 85,
								Line:   35,
							},
							File:   "millisecond_duration_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.millisecond(t: duration(v: r._value))}))",
							Start: ast.Position{
								Column: 40,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 84,
										Line:   35,
									},
									File:   "millisecond_duration_test.flux",
									Source: "fn: (r) => ({r with _value: date.millisecond(t: duration(v: r._value))})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 84,
											Line:   35,
										},
										File:   "millisecond_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.millisecond(t: duration(v: r._value))})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "millisecond_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 84,
												Line:   35,
											},
											File:   "millisecond_duration_test.flux",
											Source: "(r) => ({r with _value: date.millisecond(t: duration(v: r._value))})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 84,
													Line:   35,
												},
												File:   "millisecond_duration_test.flux",
												Source: "({r with _value: date.millisecond(t: duration(v: r._value))})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 83,
														Line:   35,
													},
													File:   "millisecond_duration_test.flux",
													Source: "{r with _value: date.millisecond(t: duration(v: r._value))}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 82,
															Line:   35,
														},
														File:   "millisecond_duration_test.flux",
														Source: "_value: date.millisecond(t: duration(v: r._value))",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "millisecond_duration_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 81,
																	Line:   35,
																},
																File:   "millisecond_duration_test.flux",
																Source: "t: duration(v: r._value)",
																Start: ast.Position{
																	Column: 57,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 81,
																		Line:   35,
																	},
																	File:   "millisecond_duration_test.flux",
																	Source: "t: duration(v: r._value)",
																	Start: ast.Position{
																		Column: 57,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   35,
																		},
																		File:   "millisecond_duration_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 57,
																			Line:   35,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 80,
																				Line:   35,
																			},
																			File:   "millisecond_duration_test.flux",
																			Source: "v: r._value",
																			Start: ast.Position{
																				Column: 69,
																				Line:   35,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 80,
																					Line:   35,
																				},
																				File:   "millisecond_duration_test.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 69,
																					Line:   35,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 70,
																						Line:   35,
																					},
																					File:   "millisecond_duration_test.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 69,
																						Line:   35,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 80,
																						Line:   35,
																					},
																					File:   "millisecond_duration_test.flux",
																					Source: "r._value",
																					Start: ast.Position{
																						Column: 72,
																						Line:   35,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 73,
																							Line:   35,
																						},
																						File:   "millisecond_duration_test.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 72,
																							Line:   35,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 80,
																							Line:   35,
																						},
																						File:   "millisecond_duration_test.flux",
																						Source: "_value",
																						Start: ast.Position{
																							Column: 74,
																							Line:   35,
																						},
																					},
																				},
																				Name: "_value",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 81,
																			Line:   35,
																		},
																		File:   "millisecond_duration_test.flux",
																		Source: "duration(v: r._value)",
																		Start: ast.Position{
																			Column: 60,
																			Line:   35,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 68,
																				Line:   35,
																			},
																			File:   "millisecond_duration_test.flux",
																			Source: "duration",
																			Start: ast.Position{
																				Column: 60,
																				Line:   35,
																			},
																		},
																	},
																	Name: "duration",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 82,
																Line:   35,
															},
															File:   "millisecond_duration_test.flux",
															Source: "date.millisecond(t: duration(v: r._value))",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   35,
																},
																File:   "millisecond_duration_test.flux",
																Source: "date.millisecond",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   35,
																	},
																	File:   "millisecond_duration_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   35,
																	},
																	File:   "millisecond_duration_test.flux",
																	Source: "millisecond",
																	Start: ast.Position{
																		Column: 45,
																		Line:   35,
																	},
																},
															},
															Name: "millisecond",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "millisecond_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "millisecond_duration_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "millisecond_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 85,
									Line:   35,
								},
								File:   "millisecond_duration_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.millisecond(t: duration(v: r._value))}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "millisecond_duration_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   33,
							},
							File:   "millisecond_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 27,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   33,
								},
								File:   "millisecond_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 27,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   33,
							},
							File:   "millisecond_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 33,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 144,
							Line:   37,
						},
						File:   "millisecond_duration_test.flux",
						Source: "_duration_millisecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_millisecond})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   37,
							},
							File:   "millisecond_duration_test.flux",
							Source: "_duration_millisecond",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_duration_millisecond",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 144,
								Line:   37,
							},
							File:   "millisecond_duration_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_millisecond})",
							Start: ast.Position{
								Column: 30,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 144,
									Line:   37,
								},
								File:   "millisecond_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_millisecond})",
								Start: ast.Position{
									Column: 36,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 143,
										Line:   37,
									},
									File:   "millisecond_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_millisecond}",
									Start: ast.Position{
										Column: 37,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 77,
											Line:   37,
										},
										File:   "millisecond_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 38,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   37,
											},
											File:   "millisecond_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 38,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 76,
													Line:   37,
												},
												File:   "millisecond_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 65,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 76,
														Line:   37,
													},
													File:   "millisecond_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 65,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   37,
														},
														File:   "millisecond_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 65,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 76,
															Line:   37,
														},
														File:   "millisecond_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 70,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   37,
											},
											File:   "millisecond_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 45,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 64,
													Line:   37,
												},
												File:   "millisecond_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 45,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   37,
													},
													File:   "millisecond_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 45,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   37,
													},
													File:   "millisecond_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 53,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 114,
											Line:   37,
										},
										File:   "millisecond_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 79,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 83,
												Line:   37,
											},
											File:   "millisecond_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 79,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 113,
													Line:   37,
												},
												File:   "millisecond_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 101,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 113,
														Line:   37,
													},
													File:   "millisecond_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 101,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 104,
															Line:   37,
														},
														File:   "millisecond_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 101,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 113,
															Line:   37,
														},
														File:   "millisecond_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 106,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 114,
												Line:   37,
											},
											File:   "millisecond_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 85,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 100,
													Line:   37,
												},
												File:   "millisecond_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 85,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 92,
														Line:   37,
													},
													File:   "millisecond_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 85,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 100,
														Line:   37,
													},
													File:   "millisecond_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 93,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 142,
											Line:   37,
										},
										File:   "millisecond_duration_test.flux",
										Source: "fn: t_duration_millisecond",
										Start: ast.Position{
											Column: 116,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 118,
												Line:   37,
											},
											File:   "millisecond_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 116,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 142,
												Line:   37,
											},
											File:   "millisecond_duration_test.flux",
											Source: "t_duration_millisecond",
											Start: ast.Position{
												Column: 120,
												Line:   37,
											},
										},
									},
									Name: "t_duration_millisecond",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 144,
						Line:   37,
					},
					File:   "millisecond_duration_test.flux",
					Source: "test _duration_millisecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_millisecond})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "millisecond_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "millisecond_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "millisecond_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "millisecond_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "millisecond_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "millisecond_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "millisecond_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 136,
					Line:   55,
				},
				File:   "millisecond_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823\n\"\nt_time_millisecond = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.millisecond(t: r._time)}))\n\ntest _time_millisecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_millisecond})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "millisecond_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "millisecond_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "millisecond_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "millisecond_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "millisecond_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   29,
					},
					File:   "millisecond_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "millisecond_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   29,
						},
						File:   "millisecond_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   50,
					},
					File:   "millisecond_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "millisecond_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   50,
						},
						File:   "millisecond_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 71,
						Line:   53,
					},
					File:   "millisecond_test.flux",
					Source: "t_time_millisecond = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.millisecond(t: r._time)}))",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   51,
						},
						File:   "millisecond_test.flux",
						Source: "t_time_millisecond",
						Start: ast.Position{
							Column: 1,
							Line:   51,
						},
					},
				},
				Name: "t_time_millisecond",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 71,
							Line:   53,
						},
						File:   "millisecond_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.millisecond(t: r._time)}))",
						Start: ast.Position{
							Column: 22,
							Line:   51,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   51,
									},
									File:   "millisecond_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 36,
										Line:   51,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   52,
								},
								File:   "millisecond_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 36,
									Line:   51,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   52,
										},
										File:   "millisecond_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   52,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   52,
											},
											File:   "millisecond_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   52,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   52,
												},
												File:   "millisecond_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   52,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   52,
												},
												File:   "millisecond_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   52,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   52,
									},
									File:   "millisecond_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   52,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   52,
										},
										File:   "millisecond_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   52,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   53,
							},
							File:   "millisecond_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.millisecond(t: r._time)}))",
							Start: ast.Position{
								Column: 36,
								Line:   51,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 70,
										Line:   53,
									},
									File:   "millisecond_test.flux",
									Source: "fn: (r) => ({r with _value: date.millisecond(t: r._time)})",
									Start: ast.Position{
										Column: 12,
										Line:   53,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 70,
											Line:   53,
										},
										File:   "millisecond_test.flux",
										Source: "fn: (r) => ({r with _value: date.millisecond(t: r._time)})",
										Start: ast.Position{
											Column: 12,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   53,
											},
											File:   "millisecond_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   53,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 70,
												Line:   53,
											},
											File:   "millisecond_test.flux",
											Source: "(r) => ({r with _value: date.millisecond(t: r._time)})",
											Start: ast.Position{
												Column: 16,
												Line:   53,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   53,
												},
												File:   "millisecond_test.flux",
												Source: "({r with _value: date.millisecond(t: r._time)})",
												Start: ast.Position{
													Column: 23,
													Line:   53,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 69,
														Line:   53,
													},
													File:   "millisecond_test.flux",
													Source: "{r with _value: date.millisecond(t: r._time)}",
													Start: ast.Position{
														Column: 24,
														Line:   53,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   53,
														},
														File:   "millisecond_test.flux",
														Source: "_value: date.millisecond(t: r._time)",
														Start: ast.Position{
															Column: 32,
															Line:   53,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   53,
															},
															File:   "millisecond_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   53,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 67,
																	Line:   53,
																},
																File:   "millisecond_test.flux",
																Source: "t: r._time",
																Start: ast.Position{
																	Column: 57,
																	Line:   53,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 67,
																		Line:   53,
																	},
																	File:   "millisecond_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 57,
																		Line:   53,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 58,
																			Line:   53,
																		},
																		File:   "millisecond_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 57,
																			Line:   53,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 67,
																			Line:   53,
																		},
																		File:   "millisecond_test.flux",
																		Source: "r._time",
																		Start: ast.Position{
																			Column: 60,
																			Line:   53,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 61,
																				Line:   53,
																			},
																			File:   "millisecond_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 60,
																				Line:   53,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 67,
																				Line:   53,
																			},
																			File:   "millisecond_test.flux",
																			Source: "_time",
																			Start: ast.Position{
																				Column: 62,
																				Line:   53,
																			},
																		},
																	},
																	Name: "_time",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 68,
																Line:   53,
															},
															File:   "millisecond_test.flux",
															Source: "date.millisecond(t: r._time)",
															Start: ast.Position{
																Column: 40,
																Line:   53,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 56,
																	Line:   53,
																},
																File:   "millisecond_test.flux",
																Source: "date.millisecond",
																Start: ast.Position{
																	Column: 40,
																	Line:   53,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   53,
																	},
																	File:   "millisecond_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   53,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 56,
																		Line:   53,
																	},
																	File:   "millisecond_test.flux",
																	Source: "millisecond",
																	Start: ast.Position{
																		Column: 45,
																		Line:   53,
																	},
																},
															},
															Name: "millisecond",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   53,
														},
														File:   "millisecond_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   53,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   53,
												},
												File:   "millisecond_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   53,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   53,
													},
													File:   "millisecond_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   53,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   53,
								},
								File:   "millisecond_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.millisecond(t: r._time)}))",
								Start: ast.Position{
									Column: 8,
									Line:   53,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   53,
									},
									File:   "millisecond_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   53,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   51,
							},
							File:   "millisecond_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   51,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   51,
								},
								File:   "millisecond_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   51,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   51,
							},
							File:   "millisecond_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   51,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 136,
							Line:   55,
						},
						File:   "millisecond_test.flux",
						Source: "_time_millisecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_millisecond})",
						Start: ast.Position{
							Column: 6,
							Line:   55,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   55,
							},
							File:   "millisecond_test.flux",
							Source: "_time_millisecond",
							Start: ast.Position{
								Column: 6,
								Line:   55,
							},
						},
					},
					Name: "_time_millisecond",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 136,
								Line:   55,
							},
							File:   "millisecond_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_millisecond})",
							Start: ast.Position{
								Column: 26,
								Line:   55,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 136,
									Line:   55,
								},
								File:   "millisecond_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_millisecond})",
								Start: ast.Position{
									Column: 32,
									Line:   55,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 135,
										Line:   55,
									},
									File:   "millisecond_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_millisecond}",
									Start: ast.Position{
										Column: 33,
										Line:   55,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   55,
										},
										File:   "millisecond_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 34,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   55,
											},
											File:   "millisecond_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 34,
												Line:   55,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 72,
													Line:   55,
												},
												File:   "millisecond_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 61,
													Line:   55,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 72,
														Line:   55,
													},
													File:   "millisecond_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 61,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   55,
														},
														File:   "millisecond_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 61,
															Line:   55,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   55,
														},
														File:   "millisecond_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 66,
															Line:   55,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   55,
											},
											File:   "millisecond_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 41,
												Line:   55,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   55,
												},
												File:   "millisecond_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 41,
													Line:   55,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   55,
													},
													File:   "millisecond_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 41,
														Line:   55,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   55,
													},
													File:   "millisecond_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 49,
														Line:   55,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 110,
											Line:   55,
										},
										File:   "millisecond_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 75,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   55,
											},
											File:   "millisecond_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 75,
												Line:   55,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 109,
													Line:   55,
												},
												File:   "millisecond_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 97,
													Line:   55,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 109,
														Line:   55,
													},
													File:   "millisecond_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 97,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 100,
															Line:   55,
														},
														File:   "millisecond_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 97,
															Line:   55,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 109,
															Line:   55,
														},
														File:   "millisecond_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 102,
															Line:   55,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   55,
											},
											File:   "millisecond_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 81,
												Line:   55,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 96,
													Line:   55,
												},
												File:   "millisecond_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 81,
													Line:   55,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   55,
													},
													File:   "millisecond_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 81,
														Line:   55,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 96,
														Line:   55,
													},
													File:   "millisecond_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 89,
														Line:   55,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 134,
											Line:   55,
										},
										File:   "millisecond_test.flux",
										Source: "fn: t_time_millisecond",
										Start: ast.Position{
											Column: 112,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 114,
												Line:   55,
											},
											File:   "millisecond_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 112,
												Line:   55,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 134,
												Line:   55,
											},
											File:   "millisecond_test.flux",
											Source: "t_time_millisecond",
											Start: ast.Position{
												Column: 116,
												Line:   55,
											},
										},
									},
									Name: "t_time_millisecond",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 136,
						Line:   55,
					},
					File:   "millisecond_test.flux",
					Source: "test _time_millisecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_millisecond})",
					Start: ast.Position{
						Column: 1,
						Line:   55,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "millisecond_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "millisecond_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "millisecond_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "millisecond_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "millisecond_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "millisecond_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "millisecond_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 134,
					Line:   37,
				},
				File:   "minute_duration_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"\nt_duration_minute = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.minute(t: duration(v: r._value))}))\n\ntest _duration_minute = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_minute})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "minute_duration_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "minute_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "minute_duration_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "minute_duration_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "minute_duration_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "minute_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "minute_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "minute_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "minute_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "minute_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "minute_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 80,
						Line:   35,
					},
					File:   "minute_duration_test.flux",
					Source: "t_duration_minute = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.minute(t: duration(v: r._value))}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   33,
						},
						File:   "minute_duration_test.flux",
						Source: "t_duration_minute",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_duration_minute",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 80,
							Line:   35,
						},
						File:   "minute_duration_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.minute(t: duration(v: r._value))}))",
						Start: ast.Position{
							Column: 21,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   33,
									},
									File:   "minute_duration_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 35,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "minute_duration_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 35,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "minute_duration_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "minute_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "minute_duration_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "minute_duration_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "minute_duration_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "minute_duration_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 80,
								Line:   35,
							},
							File:   "minute_duration_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.minute(t: duration(v: r._value))}))",
							Start: ast.Position{
								Column: 35,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 79,
										Line:   35,
									},
									File:   "minute_duration_test.flux",
									Source: "fn: (r) => ({r with _value: date.minute(t: duration(v: r._value))})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 79,
											Line:   35,
										},
										File:   "minute_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.minute(t: duration(v: r._value))})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "minute_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   35,
											},
											File:   "minute_duration_test.flux",
											Source: "(r) => ({r with _value: date.minute(t: duration(v: r._value))})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   35,
												},
												File:   "minute_duration_test.flux",
												Source: "({r with _value: date.minute(t: duration(v: r._value))})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   35,
													},
													File:   "minute_duration_test.flux",
													Source: "{r with _value: date.minute(t: duration(v: r._value))}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   35,
														},
														File:   "minute_duration_test.flux",
														Source: "_value: date.minute(t: duration(v: r._value))",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "minute_duration_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 76,
																	Line:   35,
																},
																File:   "minute_duration_test.flux",
																Source: "t: duration(v: r._value)",
																Start: ast.Position{
																	Column: 52,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 76,
																		Line:   35,
																	},
																	File:   "minute_duration_test.flux",
																	Source: "t: duration(v: r._value)",
																	Start: ast.Position{
																		Column: 52,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 53,
																			Line:   35,
																		},
																		File:   "minute_duration_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 52,
																			Line:   35,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 75,
																				Line:   35,
																			},
																			File:   "minute_duration_test.flux",
																			Source: "v: r._value",
																			Start: ast.Position{
																				Column: 64,
																				Line:   35,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 75,
																					Line:   35,
																				},
																				File:   "minute_duration_test.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 64,
																					Line:   35,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 65,
																						Line:   35,
																					},
																					File:   "minute_duration_test.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 64,
																						Line:   35,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 75,
																						Line:   35,
																					},
																					File:   "minute_duration_test.flux",
																					Source: "r._value",
																					Start: ast.Position{
																						Column: 67,
																						Line:   35,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 68,
																							Line:   35,
																						},
																						File:   "minute_duration_test.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 67,
																							Line:   35,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 75,
																							Line:   35,
																						},
																						File:   "minute_duration_test.flux",
																						Source: "_value",
																						Start: ast.Position{
																							Column: 69,
																							Line:   35,
																						},
																					},
																				},
																				Name: "_value",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 76,
																			Line:   35,
																		},
																		File:   "minute_duration_test.flux",
																		Source: "duration(v: r._value)",
																		Start: ast.Position{
																			Column: 55,
																			Line:   35,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 63,
																				Line:   35,
																			},
																			File:   "minute_duration_test.flux",
																			Source: "duration",
																			Start: ast.Position{
																				Column: 55,
																				Line:   35,
																			},
																		},
																	},
																	Name: "duration",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   35,
															},
															File:   "minute_duration_test.flux",
															Source: "date.minute(t: duration(v: r._value))",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   35,
																},
																File:   "minute_duration_test.flux",
																Source: "date.minute",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   35,
																	},
																	File:   "minute_duration_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 51,
																		Line:   35,
																	},
																	File:   "minute_duration_test.flux",
																	Source: "minute",
																	Start: ast.Position{
																		Column: 45,
																		Line:   35,
																	},
																},
															},
															Name: "minute",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "minute_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "minute_duration_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "minute_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   35,
								},
								File:   "minute_duration_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.minute(t: duration(v: r._value))}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "minute_duration_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   33,
							},
							File:   "minute_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 22,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   33,
								},
								File:   "minute_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 22,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   33,
							},
							File:   "minute_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 134,
							Line:   37,
						},
						File:   "minute_duration_test.flux",
						Source: "_duration_minute = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_minute})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   37,
							},
							File:   "minute_duration_test.flux",
							Source: "_duration_minute",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_duration_minute",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 134,
								Line:   37,
							},
							File:   "minute_duration_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_minute})",
							Start: ast.Position{
								Column: 25,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 134,
									Line:   37,
								},
								File:   "minute_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_minute})",
								Start: ast.Position{
									Column: 31,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 133,
										Line:   37,
									},
									File:   "minute_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_minute}",
									Start: ast.Position{
										Column: 32,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   37,
										},
										File:   "minute_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 33,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   37,
											},
											File:   "minute_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 33,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   37,
												},
												File:   "minute_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 60,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 71,
														Line:   37,
													},
													File:   "minute_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 60,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   37,
														},
														File:   "minute_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 60,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   37,
														},
														File:   "minute_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 65,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   37,
											},
											File:   "minute_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 40,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   37,
												},
												File:   "minute_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 40,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   37,
													},
													File:   "minute_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 40,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   37,
													},
													File:   "minute_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 48,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 109,
											Line:   37,
										},
										File:   "minute_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 74,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   37,
											},
											File:   "minute_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 74,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 108,
													Line:   37,
												},
												File:   "minute_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 96,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 108,
														Line:   37,
													},
													File:   "minute_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 96,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 99,
															Line:   37,
														},
														File:   "minute_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 96,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 108,
															Line:   37,
														},
														File:   "minute_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 101,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 109,
												Line:   37,
											},
											File:   "minute_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 80,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   37,
												},
												File:   "minute_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 80,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   37,
													},
													File:   "minute_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 80,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 95,
														Line:   37,
													},
													File:   "minute_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 88,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 132,
											Line:   37,
										},
										File:   "minute_duration_test.flux",
										Source: "fn: t_duration_minute",
										Start: ast.Position{
											Column: 111,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 113,
												Line:   37,
											},
											File:   "minute_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 111,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 132,
												Line:   37,
											},
											File:   "minute_duration_test.flux",
											Source: "t_duration_minute",
											Start: ast.Position{
												Column: 115,
												Line:   37,
											},
										},
									},
									Name: "t_duration_minute",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 134,
						Line:   37,
					},
					File:   "minute_duration_test.flux",
					Source: "test _duration_minute = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_minute})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "minute_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "minute_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "minute_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "minute_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "minute_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "minute_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "minute_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 126,
					Line:   69,
				},
				File:   "minute_time_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00Z,_m,FF,1\n,,0,2018-05-22T19:02:00Z,_m,FF,1\n,,0,2018-05-22T19:03:00Z,_m,FF,1\n,,0,2018-05-22T19:04:00Z,_m,FF,1\n,,0,2018-05-22T19:05:00Z,_m,FF,1\n,,0,2018-05-22T19:06:00Z,_m,FF,1\n,,1,2018-05-22T19:07:00Z,_m,QQ,1\n,,1,2018-05-22T19:08:00Z,_m,QQ,1\n,,1,2018-05-22T19:09:00Z,_m,QQ,1\n,,1,2018-05-22T19:10:00Z,_m,QQ,1\n,,1,2018-05-22T19:13:00Z,_m,QQ,1\n,,1,2018-05-22T19:15:00Z,_m,QQ,1\n,,1,2018-05-22T19:20:00Z,_m,QQ,1\n,,1,2018-05-22T19:23:00Z,_m,QQ,1\n,,1,2018-05-22T19:25:00Z,_m,QQ,1\n,,2,2018-05-22T19:28:00Z,_m,RR,1\n,,2,2018-05-22T19:36:00Z,_m,RR,1\n,,2,2018-05-22T19:38:00Z,_m,RR,1\n,,2,2018-05-22T19:47:00Z,_m,RR,1\n,,3,2018-05-22T19:48:00Z,_m,SR,1\n,,3,2018-05-22T19:59:00Z,_m,SR,1\n,,3,2018-05-22T20:00:00Z,_m,SR,1\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00Z,15\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00Z,23\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00Z,25\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:28:00Z,28\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:36:00Z,36\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:38:00Z,38\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:47:00Z,47\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:48:00Z,48\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:59:00Z,59\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:00:00Z,00\n\"\nt_time_minute = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.minute(t: r._time)}))\n\ntest _time_minute = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_minute})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "minute_time_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "minute_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "minute_time_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "minute_time_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "minute_time_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   36,
					},
					File:   "minute_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00Z,_m,FF,1\n,,0,2018-05-22T19:02:00Z,_m,FF,1\n,,0,2018-05-22T19:03:00Z,_m,FF,1\n,,0,2018-05-22T19:04:00Z,_m,FF,1\n,,0,2018-05-22T19:05:00Z,_m,FF,1\n,,0,2018-05-22T19:06:00Z,_m,FF,1\n,,1,2018-05-22T19:07:00Z,_m,QQ,1\n,,1,2018-05-22T19:08:00Z,_m,QQ,1\n,,1,2018-05-22T19:09:00Z,_m,QQ,1\n,,1,2018-05-22T19:10:00Z,_m,QQ,1\n,,1,2018-05-22T19:13:00Z,_m,QQ,1\n,,1,2018-05-22T19:15:00Z,_m,QQ,1\n,,1,2018-05-22T19:20:00Z,_m,QQ,1\n,,1,2018-05-22T19:23:00Z,_m,QQ,1\n,,1,2018-05-22T19:25:00Z,_m,QQ,1\n,,2,2018-05-22T19:28:00Z,_m,RR,1\n,,2,2018-05-22T19:36:00Z,_m,RR,1\n,,2,2018-05-22T19:38:00Z,_m,RR,1\n,,2,2018-05-22T19:47:00Z,_m,RR,1\n,,3,2018-05-22T19:48:00Z,_m,SR,1\n,,3,2018-05-22T19:59:00Z,_m,SR,1\n,,3,2018-05-22T20:00:00Z,_m,SR,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "minute_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   36,
						},
						File:   "minute_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00Z,_m,FF,1\n,,0,2018-05-22T19:02:00Z,_m,FF,1\n,,0,2018-05-22T19:03:00Z,_m,FF,1\n,,0,2018-05-22T19:04:00Z,_m,FF,1\n,,0,2018-05-22T19:05:00Z,_m,FF,1\n,,0,2018-05-22T19:06:00Z,_m,FF,1\n,,1,2018-05-22T19:07:00Z,_m,QQ,1\n,,1,2018-05-22T19:08:00Z,_m,QQ,1\n,,1,2018-05-22T19:09:00Z,_m,QQ,1\n,,1,2018-05-22T19:10:00Z,_m,QQ,1\n,,1,2018-05-22T19:13:00Z,_m,QQ,1\n,,1,2018-05-22T19:15:00Z,_m,QQ,1\n,,1,2018-05-22T19:20:00Z,_m,QQ,1\n,,1,2018-05-22T19:23:00Z,_m,QQ,1\n,,1,2018-05-22T19:25:00Z,_m,QQ,1\n,,2,2018-05-22T19:28:00Z,_m,RR,1\n,,2,2018-05-22T19:36:00Z,_m,RR,1\n,,2,2018-05-22T19:38:00Z,_m,RR,1\n,,2,2018-05-22T19:47:00Z,_m,RR,1\n,,3,2018-05-22T19:48:00Z,_m,SR,1\n,,3,2018-05-22T19:59:00Z,_m,SR,1\n,,3,2018-05-22T20:00:00Z,_m,SR,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00Z,_m,FF,1\n,,0,2018-05-22T19:02:00Z,_m,FF,1\n,,0,2018-05-22T19:03:00Z,_m,FF,1\n,,0,2018-05-22T19:04:00Z,_m,FF,1\n,,0,2018-05-22T19:05:00Z,_m,FF,1\n,,0,2018-05-22T19:06:00Z,_m,FF,1\n,,1,2018-05-22T19:07:00Z,_m,QQ,1\n,,1,2018-05-22T19:08:00Z,_m,QQ,1\n,,1,2018-05-22T19:09:00Z,_m,QQ,1\n,,1,2018-05-22T19:10:00Z,_m,QQ,1\n,,1,2018-05-22T19:13:00Z,_m,QQ,1\n,,1,2018-05-22T19:15:00Z,_m,QQ,1\n,,1,2018-05-22T19:20:00Z,_m,QQ,1\n,,1,2018-05-22T19:23:00Z,_m,QQ,1\n,,1,2018-05-22T19:25:00Z,_m,QQ,1\n,,2,2018-05-22T19:28:00Z,_m,RR,1\n,,2,2018-05-22T19:36:00Z,_m,RR,1\n,,2,2018-05-22T19:38:00Z,_m,RR,1\n,,2,2018-05-22T19:47:00Z,_m,RR,1\n,,3,2018-05-22T19:48:00Z,_m,SR,1\n,,3,2018-05-22T19:59:00Z,_m,SR,1\n,,3,2018-05-22T20:00:00Z,_m,SR,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   64,
					},
					File:   "minute_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00Z,15\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00Z,23\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00Z,25\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:28:00Z,28\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:36:00Z,36\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:38:00Z,38\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:47:00Z,47\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:48:00Z,48\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:59:00Z,59\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:00:00Z,00\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   37,
						},
						File:   "minute_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   37,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   64,
						},
						File:   "minute_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00Z,15\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00Z,23\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00Z,25\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:28:00Z,28\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:36:00Z,36\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:38:00Z,38\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:47:00Z,47\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:48:00Z,48\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:59:00Z,59\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:00:00Z,00\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   37,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00Z,15\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00Z,23\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00Z,25\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:28:00Z,28\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:36:00Z,36\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:38:00Z,38\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:47:00Z,47\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:48:00Z,48\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:59:00Z,59\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T20:00:00Z,00\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 66,
						Line:   67,
					},
					File:   "minute_time_test.flux",
					Source: "t_time_minute = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.minute(t: r._time)}))",
					Start: ast.Position{
						Column: 1,
						Line:   65,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   65,
						},
						File:   "minute_time_test.flux",
						Source: "t_time_minute",
						Start: ast.Position{
							Column: 1,
							Line:   65,
						},
					},
				},
				Name: "t_time_minute",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 66,
							Line:   67,
						},
						File:   "minute_time_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.minute(t: r._time)}))",
						Start: ast.Position{
							Column: 17,
							Line:   65,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   65,
									},
									File:   "minute_time_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 31,
										Line:   65,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   66,
								},
								File:   "minute_time_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 31,
									Line:   65,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   66,
										},
										File:   "minute_time_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   66,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   66,
											},
											File:   "minute_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   66,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   66,
												},
												File:   "minute_time_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   66,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   66,
												},
												File:   "minute_time_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   66,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   66,
									},
									File:   "minute_time_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   66,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   66,
										},
										File:   "minute_time_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   66,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   67,
							},
							File:   "minute_time_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.minute(t: r._time)}))",
							Start: ast.Position{
								Column: 31,
								Line:   65,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   67,
									},
									File:   "minute_time_test.flux",
									Source: "fn: (r) => ({r with _value: date.minute(t: r._time)})",
									Start: ast.Position{
										Column: 12,
										Line:   67,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   67,
										},
										File:   "minute_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.minute(t: r._time)})",
										Start: ast.Position{
											Column: 12,
											Line:   67,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   67,
											},
											File:   "minute_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   67,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   67,
											},
											File:   "minute_time_test.flux",
											Source: "(r) => ({r with _value: date.minute(t: r._time)})",
											Start: ast.Position{
												Column: 16,
												Line:   67,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   67,
												},
												File:   "minute_time_test.flux",
												Source: "({r with _value: date.minute(t: r._time)})",
												Start: ast.Position{
													Column: 23,
													Line:   67,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   67,
													},
													File:   "minute_time_test.flux",
													Source: "{r with _value: date.minute(t: r._time)}",
													Start: ast.Position{
														Column: 24,
														Line:   67,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   67,
														},
														File:   "minute_time_test.flux",
														Source: "_value: date.minute(t: r._time)",
														Start: ast.Position{
															Column: 32,
															Line:   67,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   67,
															},
															File:   "minute_time_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   67,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   67,
																},
																File:   "minute_time_test.flux",
																Source: "t: r._time",
																Start: ast.Position{
																	Column: 52,
																	Line:   67,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 62,
																		Line:   67,
																	},
																	File:   "minute_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 52,
																		Line:   67,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 53,
																			Line:   67,
																		},
																		File:   "minute_time_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 52,
																			Line:   67,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 62,
																			Line:   67,
																		},
																		File:   "minute_time_test.flux",
																		Source: "r._time",
																		Start: ast.Position{
																			Column: 55,
																			Line:   67,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   67,
																			},
																			File:   "minute_time_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 55,
																				Line:   67,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 62,
																				Line:   67,
																			},
																			File:   "minute_time_test.flux",
																			Source: "_time",
																			Start: ast.Position{
																				Column: 57,
																				Line:   67,
																			},
																		},
																	},
																	Name: "_time",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 63,
																Line:   67,
															},
															File:   "minute_time_test.flux",
															Source: "date.minute(t: r._time)",
															Start: ast.Position{
																Column: 40,
																Line:   67,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   67,
																},
																File:   "minute_time_test.flux",
																Source: "date.minute",
																Start: ast.Position{
																	Column: 40,
																	Line:   67,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   67,
																	},
																	File:   "minute_time_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   67,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 51,
																		Line:   67,
																	},
																	File:   "minute_time_test.flux",
																	Source: "minute",
																	Start: ast.Position{
																		Column: 45,
																		Line:   67,
																	},
																},
															},
															Name: "minute",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   67,
														},
														File:   "minute_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   67,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   67,
												},
												File:   "minute_time_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   67,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   67,
													},
													File:   "minute_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   67,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   67,
								},
								File:   "minute_time_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.minute(t: r._time)}))",
								Start: ast.Position{
									Column: 8,
									Line:   67,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   67,
									},
									File:   "minute_time_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   67,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   65,
							},
							File:   "minute_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 18,
								Line:   65,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   65,
								},
								File:   "minute_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 18,
									Line:   65,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   65,
							},
							File:   "minute_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   65,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 126,
							Line:   69,
						},
						File:   "minute_time_test.flux",
						Source: "_time_minute = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_minute})",
						Start: ast.Position{
							Column: 6,
							Line:   69,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   69,
							},
							File:   "minute_time_test.flux",
							Source: "_time_minute",
							Start: ast.Position{
								Column: 6,
								Line:   69,
							},
						},
					},
					Name: "_time_minute",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 126,
								Line:   69,
							},
							File:   "minute_time_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_minute})",
							Start: ast.Position{
								Column: 21,
								Line:   69,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 126,
									Line:   69,
								},
								File:   "minute_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_minute})",
								Start: ast.Position{
									Column: 27,
									Line:   69,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 125,
										Line:   69,
									},
									File:   "minute_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_minute}",
									Start: ast.Position{
										Column: 28,
										Line:   69,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   69,
										},
										File:   "minute_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 29,
											Line:   69,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   69,
											},
											File:   "minute_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 29,
												Line:   69,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   69,
												},
												File:   "minute_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 56,
													Line:   69,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   69,
													},
													File:   "minute_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 56,
														Line:   69,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 59,
															Line:   69,
														},
														File:   "minute_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 56,
															Line:   69,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   69,
														},
														File:   "minute_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 61,
															Line:   69,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   69,
											},
											File:   "minute_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 36,
												Line:   69,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 55,
													Line:   69,
												},
												File:   "minute_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 36,
													Line:   69,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   69,
													},
													File:   "minute_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 36,
														Line:   69,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   69,
													},
													File:   "minute_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 44,
														Line:   69,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 105,
											Line:   69,
										},
										File:   "minute_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 70,
											Line:   69,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   69,
											},
											File:   "minute_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 70,
												Line:   69,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 104,
													Line:   69,
												},
												File:   "minute_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 92,
													Line:   69,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 104,
														Line:   69,
													},
													File:   "minute_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 92,
														Line:   69,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 95,
															Line:   69,
														},
														File:   "minute_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 92,
															Line:   69,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 104,
															Line:   69,
														},
														File:   "minute_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 97,
															Line:   69,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 105,
												Line:   69,
											},
											File:   "minute_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 76,
												Line:   69,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 91,
													Line:   69,
												},
												File:   "minute_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 76,
													Line:   69,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 83,
														Line:   69,
													},
													File:   "minute_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 76,
														Line:   69,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 91,
														Line:   69,
													},
													File:   "minute_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 84,
														Line:   69,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 124,
											Line:   69,
										},
										File:   "minute_time_test.flux",
										Source: "fn: t_time_minute",
										Start: ast.Position{
											Column: 107,
											Line:   69,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 109,
												Line:   69,
											},
											File:   "minute_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 107,
												Line:   69,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 124,
												Line:   69,
											},
											File:   "minute_time_test.flux",
											Source: "t_time_minute",
											Start: ast.Position{
												Column: 111,
												Line:   69,
											},
										},
									},
									Name: "t_time_minute",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 126,
						Line:   69,
					},
					File:   "minute_time_test.flux",
					Source: "test _time_minute = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_minute})",
					Start: ast.Position{
						Column: 1,
						Line:   69,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "minute_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "minute_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "minute_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "minute_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "minute_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "minute_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "minute_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 140,
					Line:   37,
				},
				File:   "month_day_duration_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"\nt_duration_month_day = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.monthDay(t: duration(v: r._value))}))\n\ntest _duration_month_day = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month_day})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "month_day_duration_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "month_day_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "month_day_duration_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "month_day_duration_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "month_day_duration_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "month_day_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "month_day_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "month_day_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "month_day_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "month_day_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "month_day_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,31\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 82,
						Line:   35,
					},
					File:   "month_day_duration_test.flux",
					Source: "t_duration_month_day = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.monthDay(t: duration(v: r._value))}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 21,
							Line:   33,
						},
						File:   "month_day_duration_test.flux",
						Source: "t_duration_month_day",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_duration_month_day",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 82,
							Line:   35,
						},
						File:   "month_day_duration_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.monthDay(t: duration(v: r._value))}))",
						Start: ast.Position{
							Column: 24,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   33,
									},
									File:   "month_day_duration_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 38,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "month_day_duration_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 38,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "month_day_duration_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "month_day_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "month_day_duration_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "month_day_duration_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "month_day_duration_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "month_day_duration_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 82,
								Line:   35,
							},
							File:   "month_day_duration_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.monthDay(t: duration(v: r._value))}))",
							Start: ast.Position{
								Column: 38,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 81,
										Line:   35,
									},
									File:   "month_day_duration_test.flux",
									Source: "fn: (r) => ({r with _value: date.monthDay(t: duration(v: r._value))})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 81,
											Line:   35,
										},
										File:   "month_day_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.monthDay(t: duration(v: r._value))})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "month_day_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   35,
											},
											File:   "month_day_duration_test.flux",
											Source: "(r) => ({r with _value: date.monthDay(t: duration(v: r._value))})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 81,
													Line:   35,
												},
												File:   "month_day_duration_test.flux",
												Source: "({r with _value: date.monthDay(t: duration(v: r._value))})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 80,
														Line:   35,
													},
													File:   "month_day_duration_test.flux",
													Source: "{r with _value: date.monthDay(t: duration(v: r._value))}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 79,
															Line:   35,
														},
														File:   "month_day_duration_test.flux",
														Source: "_value: date.monthDay(t: duration(v: r._value))",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "month_day_duration_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 78,
																	Line:   35,
																},
																File:   "month_day_duration_test.flux",
																Source: "t: duration(v: r._value)",
																Start: ast.Position{
																	Column: 54,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 78,
																		Line:   35,
																	},
																	File:   "month_day_duration_test.flux",
																	Source: "t: duration(v: r._value)",
																	Start: ast.Position{
																		Column: 54,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 55,
																			Line:   35,
																		},
																		File:   "month_day_duration_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 54,
																			Line:   35,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 77,
																				Line:   35,
																			},
																			File:   "month_day_duration_test.flux",
																			Source: "v: r._value",
																			Start: ast.Position{
																				Column: 66,
																				Line:   35,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 77,
																					Line:   35,
																				},
																				File:   "month_day_duration_test.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 66,
																					Line:   35,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 67,
																						Line:   35,
																					},
																					File:   "month_day_duration_test.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 66,
																						Line:   35,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 77,
																						Line:   35,
																					},
																					File:   "month_day_duration_test.flux",
																					Source: "r._value",
																					Start: ast.Position{
																						Column: 69,
																						Line:   35,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 70,
																							Line:   35,
																						},
																						File:   "month_day_duration_test.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 69,
																							Line:   35,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 77,
																							Line:   35,
																						},
																						File:   "month_day_duration_test.flux",
																						Source: "_value",
																						Start: ast.Position{
																							Column: 71,
																							Line:   35,
																						},
																					},
																				},
																				Name: "_value",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 78,
																			Line:   35,
																		},
																		File:   "month_day_duration_test.flux",
																		Source: "duration(v: r._value)",
																		Start: ast.Position{
																			Column: 57,
																			Line:   35,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 65,
																				Line:   35,
																			},
																			File:   "month_day_duration_test.flux",
																			Source: "duration",
																			Start: ast.Position{
																				Column: 57,
																				Line:   35,
																			},
																		},
																	},
																	Name: "duration",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 79,
																Line:   35,
															},
															File:   "month_day_duration_test.flux",
															Source: "date.monthDay(t: duration(v: r._value))",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 53,
																	Line:   35,
																},
																File:   "month_day_duration_test.flux",
																Source: "date.monthDay",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   35,
																	},
																	File:   "month_day_duration_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 53,
																		Line:   35,
																	},
																	File:   "month_day_duration_test.flux",
																	Source: "monthDay",
																	Start: ast.Position{
																		Column: 45,
																		Line:   35,
																	},
																},
															},
															Name: "monthDay",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "month_day_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "month_day_duration_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "month_day_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 82,
									Line:   35,
								},
								File:   "month_day_duration_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.monthDay(t: duration(v: r._value))}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "month_day_duration_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   33,
							},
							File:   "month_day_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 25,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   33,
								},
								File:   "month_day_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 25,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   33,
							},
							File:   "month_day_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 31,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 140,
							Line:   37,
						},
						File:   "month_day_duration_test.flux",
						Source: "_duration_month_day = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month_day})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   37,
							},
							File:   "month_day_duration_test.flux",
							Source: "_duration_month_day",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_duration_month_day",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 140,
								Line:   37,
							},
							File:   "month_day_duration_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month_day})",
							Start: ast.Position{
								Column: 28,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 140,
									Line:   37,
								},
								File:   "month_day_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month_day})",
								Start: ast.Position{
									Column: 34,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 139,
										Line:   37,
									},
									File:   "month_day_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month_day}",
									Start: ast.Position{
										Column: 35,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 75,
											Line:   37,
										},
										File:   "month_day_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 36,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   37,
											},
											File:   "month_day_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 36,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 74,
													Line:   37,
												},
												File:   "month_day_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 63,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 74,
														Line:   37,
													},
													File:   "month_day_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 63,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 66,
															Line:   37,
														},
														File:   "month_day_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 63,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 74,
															Line:   37,
														},
														File:   "month_day_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 68,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   37,
											},
											File:   "month_day_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 43,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 62,
													Line:   37,
												},
												File:   "month_day_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 43,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   37,
													},
													File:   "month_day_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 43,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 62,
														Line:   37,
													},
													File:   "month_day_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 51,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 112,
											Line:   37,
										},
										File:   "month_day_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 77,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 81,
												Line:   37,
											},
											File:   "month_day_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 77,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 111,
													Line:   37,
												},
												File:   "month_day_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 99,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 111,
														Line:   37,
													},
													File:   "month_day_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 99,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 102,
															Line:   37,
														},
														File:   "month_day_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 99,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 111,
															Line:   37,
														},
														File:   "month_day_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 104,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 112,
												Line:   37,
											},
											File:   "month_day_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 83,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 98,
													Line:   37,
												},
												File:   "month_day_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 83,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 90,
														Line:   37,
													},
													File:   "month_day_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 83,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 98,
														Line:   37,
													},
													File:   "month_day_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 91,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 138,
											Line:   37,
										},
										File:   "month_day_duration_test.flux",
										Source: "fn: t_duration_month_day",
										Start: ast.Position{
											Column: 114,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 116,
												Line:   37,
											},
											File:   "month_day_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 114,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 138,
												Line:   37,
											},
											File:   "month_day_duration_test.flux",
											Source: "t_duration_month_day",
											Start: ast.Position{
												Column: 118,
												Line:   37,
											},
										},
									},
									Name: "t_duration_month_day",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 140,
						Line:   37,
					},
					File:   "month_day_duration_test.flux",
					Source: "test _duration_month_day = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month_day})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "month_day_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "month_day_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "month_day_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "month_day_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "month_day_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "month_day_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "month_day_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 132,
					Line:   87,
				},
				File:   "month_day_time_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-01T19:53:00Z,_m,FF,1\n,,0,2018-05-02T19:53:10Z,_m,FF,1\n,,0,2018-05-03T19:53:20Z,_m,FF,1\n,,0,2018-05-04T19:53:30Z,_m,FF,1\n,,0,2018-05-05T19:53:40Z,_m,FF,1\n,,0,2018-05-06T19:53:50Z,_m,FF,1\n,,1,2018-05-07T19:53:00Z,_m,QQ,1\n,,1,2018-05-08T19:53:10Z,_m,QQ,1\n,,1,2018-05-09T19:53:20Z,_m,QQ,1\n,,1,2018-05-10T19:53:30Z,_m,QQ,1\n,,1,2018-05-11T19:53:40Z,_m,QQ,1\n,,1,2018-05-12T19:53:50Z,_m,QQ,1\n,,1,2018-05-13T19:54:00Z,_m,QQ,1\n,,1,2018-05-14T19:54:10Z,_m,QQ,1\n,,1,2018-05-15T19:54:20Z,_m,QQ,1\n,,2,2018-05-16T19:53:00Z,_m,RR,1\n,,2,2018-05-17T19:53:10Z,_m,RR,1\n,,2,2018-05-18T19:53:20Z,_m,RR,1\n,,2,2018-05-19T19:53:30Z,_m,RR,1\n,,3,2018-05-20T19:53:40Z,_m,SR,1\n,,3,2018-05-21T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-23T19:54:00Z,_m,SR,1\n,,3,2018-05-24T19:54:00Z,_m,SR,1\n,,3,2018-05-25T19:54:00Z,_m,SR,1\n,,3,2018-05-26T19:54:00Z,_m,SR,1\n,,3,2018-05-27T19:54:00Z,_m,SR,1\n,,3,2018-05-28T19:54:00Z,_m,SR,1\n,,3,2018-05-29T19:54:00Z,_m,SR,1\n,,3,2018-05-30T19:54:00Z,_m,SR,1\n,,3,2018-05-31T19:54:00Z,_m,SR,1\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-01T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-02T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-03T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-04T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-05T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-06T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-07T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-08T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-09T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-10T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-11T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-12T19:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-13T19:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-14T19:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-15T19:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-16T19:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-17T19:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-18T19:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-19T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-20T19:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-21T19:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-23T19:54:00Z,23\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-24T19:54:00Z,24\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-25T19:54:00Z,25\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-26T19:54:00Z,26\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-27T19:54:00Z,27\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-28T19:54:00Z,28\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-29T19:54:00Z,29\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-30T19:54:00Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-31T19:54:00Z,31\n\"\nt_time_month_day = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.monthDay(t: r._time)}))\n\ntest _time_month_day = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month_day})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "month_day_time_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "month_day_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "month_day_time_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "month_day_time_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "month_day_time_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   45,
					},
					File:   "month_day_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-01T19:53:00Z,_m,FF,1\n,,0,2018-05-02T19:53:10Z,_m,FF,1\n,,0,2018-05-03T19:53:20Z,_m,FF,1\n,,0,2018-05-04T19:53:30Z,_m,FF,1\n,,0,2018-05-05T19:53:40Z,_m,FF,1\n,,0,2018-05-06T19:53:50Z,_m,FF,1\n,,1,2018-05-07T19:53:00Z,_m,QQ,1\n,,1,2018-05-08T19:53:10Z,_m,QQ,1\n,,1,2018-05-09T19:53:20Z,_m,QQ,1\n,,1,2018-05-10T19:53:30Z,_m,QQ,1\n,,1,2018-05-11T19:53:40Z,_m,QQ,1\n,,1,2018-05-12T19:53:50Z,_m,QQ,1\n,,1,2018-05-13T19:54:00Z,_m,QQ,1\n,,1,2018-05-14T19:54:10Z,_m,QQ,1\n,,1,2018-05-15T19:54:20Z,_m,QQ,1\n,,2,2018-05-16T19:53:00Z,_m,RR,1\n,,2,2018-05-17T19:53:10Z,_m,RR,1\n,,2,2018-05-18T19:53:20Z,_m,RR,1\n,,2,2018-05-19T19:53:30Z,_m,RR,1\n,,3,2018-05-20T19:53:40Z,_m,SR,1\n,,3,2018-05-21T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-23T19:54:00Z,_m,SR,1\n,,3,2018-05-24T19:54:00Z,_m,SR,1\n,,3,2018-05-25T19:54:00Z,_m,SR,1\n,,3,2018-05-26T19:54:00Z,_m,SR,1\n,,3,2018-05-27T19:54:00Z,_m,SR,1\n,,3,2018-05-28T19:54:00Z,_m,SR,1\n,,3,2018-05-29T19:54:00Z,_m,SR,1\n,,3,2018-05-30T19:54:00Z,_m,SR,1\n,,3,2018-05-31T19:54:00Z,_m,SR,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "month_day_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   45,
						},
						File:   "month_day_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-01T19:53:00Z,_m,FF,1\n,,0,2018-05-02T19:53:10Z,_m,FF,1\n,,0,2018-05-03T19:53:20Z,_m,FF,1\n,,0,2018-05-04T19:53:30Z,_m,FF,1\n,,0,2018-05-05T19:53:40Z,_m,FF,1\n,,0,2018-05-06T19:53:50Z,_m,FF,1\n,,1,2018-05-07T19:53:00Z,_m,QQ,1\n,,1,2018-05-08T19:53:10Z,_m,QQ,1\n,,1,2018-05-09T19:53:20Z,_m,QQ,1\n,,1,2018-05-10T19:53:30Z,_m,QQ,1\n,,1,2018-05-11T19:53:40Z,_m,QQ,1\n,,1,2018-05-12T19:53:50Z,_m,QQ,1\n,,1,2018-05-13T19:54:00Z,_m,QQ,1\n,,1,2018-05-14T19:54:10Z,_m,QQ,1\n,,1,2018-05-15T19:54:20Z,_m,QQ,1\n,,2,2018-05-16T19:53:00Z,_m,RR,1\n,,2,2018-05-17T19:53:10Z,_m,RR,1\n,,2,2018-05-18T19:53:20Z,_m,RR,1\n,,2,2018-05-19T19:53:30Z,_m,RR,1\n,,3,2018-05-20T19:53:40Z,_m,SR,1\n,,3,2018-05-21T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-23T19:54:00Z,_m,SR,1\n,,3,2018-05-24T19:54:00Z,_m,SR,1\n,,3,2018-05-25T19:54:00Z,_m,SR,1\n,,3,2018-05-26T19:54:00Z,_m,SR,1\n,,3,2018-05-27T19:54:00Z,_m,SR,1\n,,3,2018-05-28T19:54:00Z,_m,SR,1\n,,3,2018-05-29T19:54:00Z,_m,SR,1\n,,3,2018-05-30T19:54:00Z,_m,SR,1\n,,3,2018-05-31T19:54:00Z,_m,SR,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-01T19:53:00Z,_m,FF,1\n,,0,2018-05-02T19:53:10Z,_m,FF,1\n,,0,2018-05-03T19:53:20Z,_m,FF,1\n,,0,2018-05-04T19:53:30Z,_m,FF,1\n,,0,2018-05-05T19:53:40Z,_m,FF,1\n,,0,2018-05-06T19:53:50Z,_m,FF,1\n,,1,2018-05-07T19:53:00Z,_m,QQ,1\n,,1,2018-05-08T19:53:10Z,_m,QQ,1\n,,1,2018-05-09T19:53:20Z,_m,QQ,1\n,,1,2018-05-10T19:53:30Z,_m,QQ,1\n,,1,2018-05-11T19:53:40Z,_m,QQ,1\n,,1,2018-05-12T19:53:50Z,_m,QQ,1\n,,1,2018-05-13T19:54:00Z,_m,QQ,1\n,,1,2018-05-14T19:54:10Z,_m,QQ,1\n,,1,2018-05-15T19:54:20Z,_m,QQ,1\n,,2,2018-05-16T19:53:00Z,_m,RR,1\n,,2,2018-05-17T19:53:10Z,_m,RR,1\n,,2,2018-05-18T19:53:20Z,_m,RR,1\n,,2,2018-05-19T19:53:30Z,_m,RR,1\n,,3,2018-05-20T19:53:40Z,_m,SR,1\n,,3,2018-05-21T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n,,3,2018-05-23T19:54:00Z,_m,SR,1\n,,3,2018-05-24T19:54:00Z,_m,SR,1\n,,3,2018-05-25T19:54:00Z,_m,SR,1\n,,3,2018-05-26T19:54:00Z,_m,SR,1\n,,3,2018-05-27T19:54:00Z,_m,SR,1\n,,3,2018-05-28T19:54:00Z,_m,SR,1\n,,3,2018-05-29T19:54:00Z,_m,SR,1\n,,3,2018-05-30T19:54:00Z,_m,SR,1\n,,3,2018-05-31T19:54:00Z,_m,SR,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   82,
					},
					File:   "month_day_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-01T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-02T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-03T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-04T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-05T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-06T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-07T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-08T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-09T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-10T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-11T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-12T19:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-13T19:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-14T19:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-15T19:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-16T19:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-17T19:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-18T19:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-19T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-20T19:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-21T19:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-23T19:54:00Z,23\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-24T19:54:00Z,24\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-25T19:54:00Z,25\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-26T19:54:00Z,26\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-27T19:54:00Z,27\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-28T19:54:00Z,28\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-29T19:54:00Z,29\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-30T19:54:00Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-31T19:54:00Z,31\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   46,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   46,
						},
						File:   "month_day_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   46,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   82,
						},
						File:   "month_day_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-01T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-02T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-03T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-04T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-05T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-06T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-07T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-08T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-09T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-10T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-11T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-12T19:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-13T19:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-14T19:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-15T19:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-16T19:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-17T19:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-18T19:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-19T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-20T19:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-21T19:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-23T19:54:00Z,23\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-24T19:54:00Z,24\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-25T19:54:00Z,25\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-26T19:54:00Z,26\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-27T19:54:00Z,27\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-28T19:54:00Z,28\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-29T19:54:00Z,29\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-30T19:54:00Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-31T19:54:00Z,31\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   46,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-01T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-02T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-03T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-04T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-05T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-06T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-07T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-08T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-09T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-10T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-11T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-12T19:53:50Z,12\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-13T19:54:00Z,13\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-14T19:54:10Z,14\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-15T19:54:20Z,15\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-16T19:53:00Z,16\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-17T19:53:10Z,17\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-18T19:53:20Z,18\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-19T19:53:30Z,19\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-20T19:53:40Z,20\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-21T19:53:50Z,21\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,22\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-23T19:54:00Z,23\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-24T19:54:00Z,24\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-25T19:54:00Z,25\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-26T19:54:00Z,26\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-27T19:54:00Z,27\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-28T19:54:00Z,28\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-29T19:54:00Z,29\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-30T19:54:00Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-31T19:54:00Z,31\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 68,
						Line:   85,
					},
					File:   "month_day_time_test.flux",
					Source: "t_time_month_day = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.monthDay(t: r._time)}))",
					Start: ast.Position{
						Column: 1,
						Line:   83,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   83,
						},
						File:   "month_day_time_test.flux",
						Source: "t_time_month_day",
						Start: ast.Position{
							Column: 1,
							Line:   83,
						},
					},
				},
				Name: "t_time_month_day",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 68,
							Line:   85,
						},
						File:   "month_day_time_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.monthDay(t: r._time)}))",
						Start: ast.Position{
							Column: 20,
							Line:   83,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   83,
									},
									File:   "month_day_time_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 34,
										Line:   83,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   84,
								},
								File:   "month_day_time_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 34,
									Line:   83,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   84,
										},
										File:   "month_day_time_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   84,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   84,
											},
											File:   "month_day_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   84,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   84,
												},
												File:   "month_day_time_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   84,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   84,
												},
												File:   "month_day_time_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   84,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   84,
									},
									File:   "month_day_time_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   84,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   84,
										},
										File:   "month_day_time_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   84,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   85,
							},
							File:   "month_day_time_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.monthDay(t: r._time)}))",
							Start: ast.Position{
								Column: 34,
								Line:   83,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 67,
										Line:   85,
									},
									File:   "month_day_time_test.flux",
									Source: "fn: (r) => ({r with _value: date.monthDay(t: r._time)})",
									Start: ast.Position{
										Column: 12,
										Line:   85,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   85,
										},
										File:   "month_day_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.monthDay(t: r._time)})",
										Start: ast.Position{
											Column: 12,
											Line:   85,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   85,
											},
											File:   "month_day_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   85,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   85,
											},
											File:   "month_day_time_test.flux",
											Source: "(r) => ({r with _value: date.monthDay(t: r._time)})",
											Start: ast.Position{
												Column: 16,
												Line:   85,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   85,
												},
												File:   "month_day_time_test.flux",
												Source: "({r with _value: date.monthDay(t: r._time)})",
												Start: ast.Position{
													Column: 23,
													Line:   85,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   85,
													},
													File:   "month_day_time_test.flux",
													Source: "{r with _value: date.monthDay(t: r._time)}",
													Start: ast.Position{
														Column: 24,
														Line:   85,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   85,
														},
														File:   "month_day_time_test.flux",
														Source: "_value: date.monthDay(t: r._time)",
														Start: ast.Position{
															Column: 32,
															Line:   85,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   85,
															},
															File:   "month_day_time_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   85,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 64,
																	Line:   85,
																},
																File:   "month_day_time_test.flux",
																Source: "t: r._time",
																Start: ast.Position{
																	Column: 54,
																	Line:   85,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 64,
																		Line:   85,
																	},
																	File:   "month_day_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 54,
																		Line:   85,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 55,
																			Line:   85,
																		},
																		File:   "month_day_time_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 54,
																			Line:   85,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 64,
																			Line:   85,
																		},
																		File:   "month_day_time_test.flux",
																		Source: "r._time",
																		Start: ast.Position{
																			Column: 57,
																			Line:   85,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 58,
																				Line:   85,
																			},
																			File:   "month_day_time_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 57,
																				Line:   85,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 64,
																				Line:   85,
																			},
																			File:   "month_day_time_test.flux",
																			Source: "_time",
																			Start: ast.Position{
																				Column: 59,
																				Line:   85,
																			},
																		},
																	},
																	Name: "_time",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 65,
																Line:   85,
															},
															File:   "month_day_time_test.flux",
															Source: "date.monthDay(t: r._time)",
															Start: ast.Position{
																Column: 40,
																Line:   85,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 53,
																	Line:   85,
																},
																File:   "month_day_time_test.flux",
																Source: "date.monthDay",
																Start: ast.Position{
																	Column: 40,
																	Line:   85,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   85,
																	},
																	File:   "month_day_time_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   85,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 53,
																		Line:   85,
																	},
																	File:   "month_day_time_test.flux",
																	Source: "monthDay",
																	Start: ast.Position{
																		Column: 45,
																		Line:   85,
																	},
																},
															},
															Name: "monthDay",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   85,
														},
														File:   "month_day_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   85,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   85,
												},
												File:   "month_day_time_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   85,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   85,
													},
													File:   "month_day_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   85,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   85,
								},
								File:   "month_day_time_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.monthDay(t: r._time)}))",
								Start: ast.Position{
									Column: 8,
									Line:   85,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   85,
									},
									File:   "month_day_time_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   85,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   83,
							},
							File:   "month_day_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   83,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   83,
								},
								File:   "month_day_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   83,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   83,
							},
							File:   "month_day_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   83,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 132,
							Line:   87,
						},
						File:   "month_day_time_test.flux",
						Source: "_time_month_day = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month_day})",
						Start: ast.Position{
							Column: 6,
							Line:   87,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   87,
							},
							File:   "month_day_time_test.flux",
							Source: "_time_month_day",
							Start: ast.Position{
								Column: 6,
								Line:   87,
							},
						},
					},
					Name: "_time_month_day",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 132,
								Line:   87,
							},
							File:   "month_day_time_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month_day})",
							Start: ast.Position{
								Column: 24,
								Line:   87,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 132,
									Line:   87,
								},
								File:   "month_day_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month_day})",
								Start: ast.Position{
									Column: 30,
									Line:   87,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 131,
										Line:   87,
									},
									File:   "month_day_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month_day}",
									Start: ast.Position{
										Column: 31,
										Line:   87,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   87,
										},
										File:   "month_day_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 32,
											Line:   87,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   87,
											},
											File:   "month_day_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 32,
												Line:   87,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   87,
												},
												File:   "month_day_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 59,
													Line:   87,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   87,
													},
													File:   "month_day_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 59,
														Line:   87,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   87,
														},
														File:   "month_day_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 59,
															Line:   87,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   87,
														},
														File:   "month_day_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 64,
															Line:   87,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   87,
											},
											File:   "month_day_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 39,
												Line:   87,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   87,
												},
												File:   "month_day_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 39,
													Line:   87,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   87,
													},
													File:   "month_day_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 39,
														Line:   87,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   87,
													},
													File:   "month_day_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 47,
														Line:   87,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 108,
											Line:   87,
										},
										File:   "month_day_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 73,
											Line:   87,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   87,
											},
											File:   "month_day_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 73,
												Line:   87,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 107,
													Line:   87,
												},
												File:   "month_day_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 95,
													Line:   87,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 107,
														Line:   87,
													},
													File:   "month_day_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 95,
														Line:   87,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 98,
															Line:   87,
														},
														File:   "month_day_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 95,
															Line:   87,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 107,
															Line:   87,
														},
														File:   "month_day_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 100,
															Line:   87,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   87,
											},
											File:   "month_day_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 79,
												Line:   87,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   87,
												},
												File:   "month_day_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 79,
													Line:   87,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   87,
													},
													File:   "month_day_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 79,
														Line:   87,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 94,
														Line:   87,
													},
													File:   "month_day_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 87,
														Line:   87,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 130,
											Line:   87,
										},
										File:   "month_day_time_test.flux",
										Source: "fn: t_time_month_day",
										Start: ast.Position{
											Column: 110,
											Line:   87,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 112,
												Line:   87,
											},
											File:   "month_day_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 110,
												Line:   87,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 130,
												Line:   87,
											},
											File:   "month_day_time_test.flux",
											Source: "t_time_month_day",
											Start: ast.Position{
												Column: 114,
												Line:   87,
											},
										},
									},
									Name: "t_time_month_day",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 132,
						Line:   87,
					},
					File:   "month_day_time_test.flux",
					Source: "test _time_month_day = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month_day})",
					Start: ast.Position{
						Column: 1,
						Line:   87,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "month_day_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "month_day_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "month_day_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "month_day_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "month_day_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "month_day_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "month_day_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 132,
					Line:   37,
				},
				File:   "month_duration_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"\nt_duration_month = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.month(t: duration(v: r._value))}))\n\ntest _duration_month = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "month_duration_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "month_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "month_duration_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "month_duration_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "month_duration_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "month_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "month_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "month_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "month_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "month_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "month_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,12\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 79,
						Line:   35,
					},
					File:   "month_duration_test.flux",
					Source: "t_duration_month = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.month(t: duration(v: r._value))}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   33,
						},
						File:   "month_duration_test.flux",
						Source: "t_duration_month",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_duration_month",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 79,
							Line:   35,
						},
						File:   "month_duration_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.month(t: duration(v: r._value))}))",
						Start: ast.Position{
							Column: 20,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   33,
									},
									File:   "month_duration_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 34,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "month_duration_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 34,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "month_duration_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "month_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "month_duration_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "month_duration_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "month_duration_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "month_duration_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 79,
								Line:   35,
							},
							File:   "month_duration_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.month(t: duration(v: r._value))}))",
							Start: ast.Position{
								Column: 34,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 78,
										Line:   35,
									},
									File:   "month_duration_test.flux",
									Source: "fn: (r) => ({r with _value: date.month(t: duration(v: r._value))})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 78,
											Line:   35,
										},
										File:   "month_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.month(t: duration(v: r._value))})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "month_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   35,
											},
											File:   "month_duration_test.flux",
											Source: "(r) => ({r with _value: date.month(t: duration(v: r._value))})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 78,
													Line:   35,
												},
												File:   "month_duration_test.flux",
												Source: "({r with _value: date.month(t: duration(v: r._value))})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 77,
														Line:   35,
													},
													File:   "month_duration_test.flux",
													Source: "{r with _value: date.month(t: duration(v: r._value))}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 76,
															Line:   35,
														},
														File:   "month_duration_test.flux",
														Source: "_value: date.month(t: duration(v: r._value))",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "month_duration_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 75,
																	Line:   35,
																},
																File:   "month_duration_test.flux",
																Source: "t: duration(v: r._value)",
																Start: ast.Position{
																	Column: 51,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 75,
																		Line:   35,
																	},
																	File:   "month_duration_test.flux",
																	Source: "t: duration(v: r._value)",
																	Start: ast.Position{
																		Column: 51,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 52,
																			Line:   35,
																		},
																		File:   "month_duration_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 51,
																			Line:   35,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 74,
																				Line:   35,
																			},
																			File:   "month_duration_test.flux",
																			Source: "v: r._value",
																			Start: ast.Position{
																				Column: 63,
																				Line:   35,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 74,
																					Line:   35,
																				},
																				File:   "month_duration_test.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 63,
																					Line:   35,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 64,
																						Line:   35,
																					},
																					File:   "month_duration_test.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 63,
																						Line:   35,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 74,
																						Line:   35,
																					},
																					File:   "month_duration_test.flux",
																					Source: "r._value",
																					Start: ast.Position{
																						Column: 66,
																						Line:   35,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 67,
																							Line:   35,
																						},
																						File:   "month_duration_test.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 66,
																							Line:   35,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 74,
																							Line:   35,
																						},
																						File:   "month_duration_test.flux",
																						Source: "_value",
																						Start: ast.Position{
																							Column: 68,
																							Line:   35,
																						},
																					},
																				},
																				Name: "_value",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 75,
																			Line:   35,
																		},
																		File:   "month_duration_test.flux",
																		Source: "duration(v: r._value)",
																		Start: ast.Position{
																			Column: 54,
																			Line:   35,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 62,
																				Line:   35,
																			},
																			File:   "month_duration_test.flux",
																			Source: "duration",
																			Start: ast.Position{
																				Column: 54,
																				Line:   35,
																			},
																		},
																	},
																	Name: "duration",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 76,
																Line:   35,
															},
															File:   "month_duration_test.flux",
															Source: "date.month(t: duration(v: r._value))",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   35,
																},
																File:   "month_duration_test.flux",
																Source: "date.month",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   35,
																	},
																	File:   "month_duration_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 50,
																		Line:   35,
																	},
																	File:   "month_duration_test.flux",
																	Source: "month",
																	Start: ast.Position{
																		Column: 45,
																		Line:   35,
																	},
																},
															},
															Name: "month",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "month_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "month_duration_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "month_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   35,
								},
								File:   "month_duration_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.month(t: duration(v: r._value))}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "month_duration_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "month_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 21,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 26,
									Line:   33,
								},
								File:   "month_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 21,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   33,
							},
							File:   "month_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 27,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 132,
							Line:   37,
						},
						File:   "month_duration_test.flux",
						Source: "_duration_month = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   37,
							},
							File:   "month_duration_test.flux",
							Source: "_duration_month",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_duration_month",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 132,
								Line:   37,
							},
							File:   "month_duration_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month})",
							Start: ast.Position{
								Column: 24,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 132,
									Line:   37,
								},
								File:   "month_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month})",
								Start: ast.Position{
									Column: 30,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 131,
										Line:   37,
									},
									File:   "month_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month}",
									Start: ast.Position{
										Column: 31,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 71,
											Line:   37,
										},
										File:   "month_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 32,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 37,
												Line:   37,
											},
											File:   "month_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 32,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 70,
													Line:   37,
												},
												File:   "month_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 59,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 70,
														Line:   37,
													},
													File:   "month_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 59,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   37,
														},
														File:   "month_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 59,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 70,
															Line:   37,
														},
														File:   "month_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 64,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 71,
												Line:   37,
											},
											File:   "month_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 39,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 58,
													Line:   37,
												},
												File:   "month_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 39,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   37,
													},
													File:   "month_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 39,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 58,
														Line:   37,
													},
													File:   "month_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 47,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 108,
											Line:   37,
										},
										File:   "month_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 73,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 77,
												Line:   37,
											},
											File:   "month_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 73,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 107,
													Line:   37,
												},
												File:   "month_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 95,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 107,
														Line:   37,
													},
													File:   "month_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 95,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 98,
															Line:   37,
														},
														File:   "month_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 95,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 107,
															Line:   37,
														},
														File:   "month_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 100,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   37,
											},
											File:   "month_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 79,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 94,
													Line:   37,
												},
												File:   "month_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 79,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   37,
													},
													File:   "month_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 79,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 94,
														Line:   37,
													},
													File:   "month_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 87,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 130,
											Line:   37,
										},
										File:   "month_duration_test.flux",
										Source: "fn: t_duration_month",
										Start: ast.Position{
											Column: 110,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 112,
												Line:   37,
											},
											File:   "month_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 110,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 130,
												Line:   37,
											},
											File:   "month_duration_test.flux",
											Source: "t_duration_month",
											Start: ast.Position{
												Column: 114,
												Line:   37,
											},
										},
									},
									Name: "t_duration_month",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 132,
						Line:   37,
					},
					File:   "month_duration_test.flux",
					Source: "test _duration_month = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_month})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "month_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "month_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "month_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "month_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "month_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "month_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "month_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 124,
					Line:   49,
				},
				File:   "month_time_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,12\n\"\nt_time_month = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.month(t: r._time)}))\n\ntest _time_month = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "month_time_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "month_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "month_time_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "month_time_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "month_time_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   26,
					},
					File:   "month_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "month_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   26,
						},
						File:   "month_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "month_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,12\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   27,
						},
						File:   "month_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   27,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "month_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,12\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   27,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,3\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,5\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,6\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,7\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,8\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,9\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,11\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,12\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 65,
						Line:   47,
					},
					File:   "month_time_test.flux",
					Source: "t_time_month = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.month(t: r._time)}))",
					Start: ast.Position{
						Column: 1,
						Line:   45,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   45,
						},
						File:   "month_time_test.flux",
						Source: "t_time_month",
						Start: ast.Position{
							Column: 1,
							Line:   45,
						},
					},
				},
				Name: "t_time_month",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 65,
							Line:   47,
						},
						File:   "month_time_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.month(t: r._time)}))",
						Start: ast.Position{
							Column: 16,
							Line:   45,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   45,
									},
									File:   "month_time_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 30,
										Line:   45,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   46,
								},
								File:   "month_time_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 30,
									Line:   45,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   46,
										},
										File:   "month_time_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   46,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   46,
											},
											File:   "month_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   46,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   46,
												},
												File:   "month_time_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   46,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   46,
												},
												File:   "month_time_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   46,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   46,
									},
									File:   "month_time_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   46,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   46,
										},
										File:   "month_time_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   46,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   47,
							},
							File:   "month_time_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.month(t: r._time)}))",
							Start: ast.Position{
								Column: 30,
								Line:   45,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   47,
									},
									File:   "month_time_test.flux",
									Source: "fn: (r) => ({r with _value: date.month(t: r._time)})",
									Start: ast.Position{
										Column: 12,
										Line:   47,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   47,
										},
										File:   "month_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.month(t: r._time)})",
										Start: ast.Position{
											Column: 12,
											Line:   47,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   47,
											},
											File:   "month_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   47,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 64,
												Line:   47,
											},
											File:   "month_time_test.flux",
											Source: "(r) => ({r with _value: date.month(t: r._time)})",
											Start: ast.Position{
												Column: 16,
												Line:   47,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 64,
													Line:   47,
												},
												File:   "month_time_test.flux",
												Source: "({r with _value: date.month(t: r._time)})",
												Start: ast.Position{
													Column: 23,
													Line:   47,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 63,
														Line:   47,
													},
													File:   "month_time_test.flux",
													Source: "{r with _value: date.month(t: r._time)}",
													Start: ast.Position{
														Column: 24,
														Line:   47,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 62,
															Line:   47,
														},
														File:   "month_time_test.flux",
														Source: "_value: date.month(t: r._time)",
														Start: ast.Position{
															Column: 32,
															Line:   47,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   47,
															},
															File:   "month_time_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   47,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 61,
																	Line:   47,
																},
																File:   "month_time_test.flux",
																Source: "t: r._time",
																Start: ast.Position{
																	Column: 51,
																	Line:   47,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 61,
																		Line:   47,
																	},
																	File:   "month_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 51,
																		Line:   47,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 52,
																			Line:   47,
																		},
																		File:   "month_time_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 51,
																			Line:   47,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 61,
																			Line:   47,
																		},
																		File:   "month_time_test.flux",
																		Source: "r._time",
																		Start: ast.Position{
																			Column: 54,
																			Line:   47,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 55,
																				Line:   47,
																			},
																			File:   "month_time_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 54,
																				Line:   47,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 61,
																				Line:   47,
																			},
																			File:   "month_time_test.flux",
																			Source: "_time",
																			Start: ast.Position{
																				Column: 56,
																				Line:   47,
																			},
																		},
																	},
																	Name: "_time",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 62,
																Line:   47,
															},
															File:   "month_time_test.flux",
															Source: "date.month(t: r._time)",
															Start: ast.Position{
																Column: 40,
																Line:   47,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 50,
																	Line:   47,
																},
																File:   "month_time_test.flux",
																Source: "date.month",
																Start: ast.Position{
																	Column: 40,
																	Line:   47,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   47,
																	},
																	File:   "month_time_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   47,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 50,
																		Line:   47,
																	},
																	File:   "month_time_test.flux",
																	Source: "month",
																	Start: ast.Position{
																		Column: 45,
																		Line:   47,
																	},
																},
															},
															Name: "month",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   47,
														},
														File:   "month_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   47,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   47,
												},
												File:   "month_time_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   47,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   47,
													},
													File:   "month_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   47,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   47,
								},
								File:   "month_time_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.month(t: r._time)}))",
								Start: ast.Position{
									Column: 8,
									Line:   47,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   47,
									},
									File:   "month_time_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   47,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   45,
							},
							File:   "month_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 17,
								Line:   45,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   45,
								},
								File:   "month_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 17,
									Line:   45,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   45,
							},
							File:   "month_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 23,
								Line:   45,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 124,
							Line:   49,
						},
						File:   "month_time_test.flux",
						Source: "_time_month = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month})",
						Start: ast.Position{
							Column: 6,
							Line:   49,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   49,
							},
							File:   "month_time_test.flux",
							Source: "_time_month",
							Start: ast.Position{
								Column: 6,
								Line:   49,
							},
						},
					},
					Name: "_time_month",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 124,
								Line:   49,
							},
							File:   "month_time_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month})",
							Start: ast.Position{
								Column: 20,
								Line:   49,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 124,
									Line:   49,
								},
								File:   "month_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month})",
								Start: ast.Position{
									Column: 26,
									Line:   49,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 123,
										Line:   49,
									},
									File:   "month_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month}",
									Start: ast.Position{
										Column: 27,
										Line:   49,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 67,
											Line:   49,
										},
										File:   "month_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 28,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   49,
											},
											File:   "month_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 28,
												Line:   49,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   49,
												},
												File:   "month_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 55,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 66,
														Line:   49,
													},
													File:   "month_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 55,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 58,
															Line:   49,
														},
														File:   "month_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 55,
															Line:   49,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 66,
															Line:   49,
														},
														File:   "month_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 60,
															Line:   49,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 67,
												Line:   49,
											},
											File:   "month_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 35,
												Line:   49,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   49,
												},
												File:   "month_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 35,
													Line:   49,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   49,
													},
													File:   "month_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 35,
														Line:   49,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 54,
														Line:   49,
													},
													File:   "month_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 43,
														Line:   49,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 104,
											Line:   49,
										},
										File:   "month_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 69,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   49,
											},
											File:   "month_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 69,
												Line:   49,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 103,
													Line:   49,
												},
												File:   "month_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 91,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 103,
														Line:   49,
													},
													File:   "month_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 91,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 94,
															Line:   49,
														},
														File:   "month_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 91,
															Line:   49,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 103,
															Line:   49,
														},
														File:   "month_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 96,
															Line:   49,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 104,
												Line:   49,
											},
											File:   "month_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 75,
												Line:   49,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 90,
													Line:   49,
												},
												File:   "month_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 75,
													Line:   49,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   49,
													},
													File:   "month_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 75,
														Line:   49,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 90,
														Line:   49,
													},
													File:   "month_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 83,
														Line:   49,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 122,
											Line:   49,
										},
										File:   "month_time_test.flux",
										Source: "fn: t_time_month",
										Start: ast.Position{
											Column: 106,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 108,
												Line:   49,
											},
											File:   "month_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 106,
												Line:   49,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 122,
												Line:   49,
											},
											File:   "month_time_test.flux",
											Source: "t_time_month",
											Start: ast.Position{
												Column: 110,
												Line:   49,
											},
										},
									},
									Name: "t_time_month",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 124,
						Line:   49,
					},
					File:   "month_time_test.flux",
					Source: "test _time_month = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_month})",
					Start: ast.Position{
						Column: 1,
						Line:   49,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "month_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "month_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "month_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "month_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "month_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "month_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "month_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 134,
					Line:   37,
				},
				File:   "nanosecond_duration_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999997\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999998\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,2\n\"\nt_time_nanosecond = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.nanosecond(t: duration(v: r._value))}))\n\ntest _time_nanosecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "nanosecond_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "nanosecond_duration_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "nanosecond_duration_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999997\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999998\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999997\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999998\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,2\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,999999997\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,999999998\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,999999999\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 84,
						Line:   35,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "t_time_nanosecond = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.nanosecond(t: duration(v: r._value))}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   33,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "t_time_nanosecond",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_time_nanosecond",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 84,
							Line:   35,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.nanosecond(t: duration(v: r._value))}))",
						Start: ast.Position{
							Column: 21,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   33,
									},
									File:   "nanosecond_duration_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 35,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "nanosecond_duration_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 35,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "nanosecond_duration_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "nanosecond_duration_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "nanosecond_duration_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "nanosecond_duration_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "nanosecond_duration_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 84,
								Line:   35,
							},
							File:   "nanosecond_duration_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.nanosecond(t: duration(v: r._value))}))",
							Start: ast.Position{
								Column: 35,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 83,
										Line:   35,
									},
									File:   "nanosecond_duration_test.flux",
									Source: "fn: (r) => ({r with _value: date.nanosecond(t: duration(v: r._value))})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 83,
											Line:   35,
										},
										File:   "nanosecond_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.nanosecond(t: duration(v: r._value))})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 83,
												Line:   35,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "(r) => ({r with _value: date.nanosecond(t: duration(v: r._value))})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 83,
													Line:   35,
												},
												File:   "nanosecond_duration_test.flux",
												Source: "({r with _value: date.nanosecond(t: duration(v: r._value))})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 82,
														Line:   35,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "{r with _value: date.nanosecond(t: duration(v: r._value))}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 81,
															Line:   35,
														},
														File:   "nanosecond_duration_test.flux",
														Source: "_value: date.nanosecond(t: duration(v: r._value))",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "nanosecond_duration_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 80,
																	Line:   35,
																},
																File:   "nanosecond_duration_test.flux",
																Source: "t: duration(v: r._value)",
																Start: ast.Position{
																	Column: 56,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 80,
																		Line:   35,
																	},
																	File:   "nanosecond_duration_test.flux",
																	Source: "t: duration(v: r._value)",
																	Start: ast.Position{
																		Column: 56,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   35,
																		},
																		File:   "nanosecond_duration_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 56,
																			Line:   35,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 79,
																				Line:   35,
																			},
																			File:   "nanosecond_duration_test.flux",
																			Source: "v: r._value",
																			Start: ast.Position{
																				Column: 68,
																				Line:   35,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 79,
																					Line:   35,
																				},
																				File:   "nanosecond_duration_test.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 68,
																					Line:   35,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 69,
																						Line:   35,
																					},
																					File:   "nanosecond_duration_test.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 68,
																						Line:   35,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 79,
																						Line:   35,
																					},
																					File:   "nanosecond_duration_test.flux",
																					Source: "r._value",
																					Start: ast.Position{
																						Column: 71,
																						Line:   35,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 72,
																							Line:   35,
																						},
																						File:   "nanosecond_duration_test.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 71,
																							Line:   35,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 79,
																							Line:   35,
																						},
																						File:   "nanosecond_duration_test.flux",
																						Source: "_value",
																						Start: ast.Position{
																							Column: 73,
																							Line:   35,
																						},
																					},
																				},
																				Name: "_value",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 80,
																			Line:   35,
																		},
																		File:   "nanosecond_duration_test.flux",
																		Source: "duration(v: r._value)",
																		Start: ast.Position{
																			Column: 59,
																			Line:   35,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 67,
																				Line:   35,
																			},
																			File:   "nanosecond_duration_test.flux",
																			Source: "duration",
																			Start: ast.Position{
																				Column: 59,
																				Line:   35,
																			},
																		},
																	},
																	Name: "duration",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 81,
																Line:   35,
															},
															File:   "nanosecond_duration_test.flux",
															Source: "date.nanosecond(t: duration(v: r._value))",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   35,
																},
																File:   "nanosecond_duration_test.flux",
																Source: "date.nanosecond",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   35,
																	},
																	File:   "nanosecond_duration_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   35,
																	},
																	File:   "nanosecond_duration_test.flux",
																	Source: "nanosecond",
																	Start: ast.Position{
																		Column: 45,
																		Line:   35,
																	},
																},
															},
															Name: "nanosecond",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "nanosecond_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "nanosecond_duration_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 84,
									Line:   35,
								},
								File:   "nanosecond_duration_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.nanosecond(t: duration(v: r._value))}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "nanosecond_duration_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   33,
							},
							File:   "nanosecond_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 22,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   33,
								},
								File:   "nanosecond_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 22,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   33,
							},
							File:   "nanosecond_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 134,
							Line:   37,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "_time_nanosecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   37,
							},
							File:   "nanosecond_duration_test.flux",
							Source: "_time_nanosecond",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_time_nanosecond",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 134,
								Line:   37,
							},
							File:   "nanosecond_duration_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
							Start: ast.Position{
								Column: 25,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 134,
									Line:   37,
								},
								File:   "nanosecond_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
								Start: ast.Position{
									Column: 31,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 133,
										Line:   37,
									},
									File:   "nanosecond_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond}",
									Start: ast.Position{
										Column: 32,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   37,
										},
										File:   "nanosecond_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 33,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   37,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 33,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   37,
												},
												File:   "nanosecond_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 60,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 71,
														Line:   37,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 60,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   37,
														},
														File:   "nanosecond_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 60,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   37,
														},
														File:   "nanosecond_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 65,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   37,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 40,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   37,
												},
												File:   "nanosecond_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 40,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   37,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 40,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   37,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 48,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 109,
											Line:   37,
										},
										File:   "nanosecond_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 74,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   37,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 74,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 108,
													Line:   37,
												},
												File:   "nanosecond_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 96,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 108,
														Line:   37,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 96,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 99,
															Line:   37,
														},
														File:   "nanosecond_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 96,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 108,
															Line:   37,
														},
														File:   "nanosecond_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 101,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 109,
												Line:   37,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 80,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   37,
												},
												File:   "nanosecond_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 80,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   37,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 80,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 95,
														Line:   37,
													},
													File:   "nanosecond_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 88,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 132,
											Line:   37,
										},
										File:   "nanosecond_duration_test.flux",
										Source: "fn: t_time_nanosecond",
										Start: ast.Position{
											Column: 111,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 113,
												Line:   37,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 111,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 132,
												Line:   37,
											},
											File:   "nanosecond_duration_test.flux",
											Source: "t_time_nanosecond",
											Start: ast.Position{
												Column: 115,
												Line:   37,
											},
										},
									},
									Name: "t_time_nanosecond",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 134,
						Line:   37,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "test _time_nanosecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "nanosecond_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "nanosecond_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "nanosecond_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 134,
					Line:   55,
				},
				File:   "nanosecond_time_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819212\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691723\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182316\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816341\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423456\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342357\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823471\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284314\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375238\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847562\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983472\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938413\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103483\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432256\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748524\n\"\nt_time_nanosecond = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.nanosecond(t: r._time)}))\n\ntest _time_nanosecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "nanosecond_time_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "nanosecond_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "nanosecond_time_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "nanosecond_time_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "nanosecond_time_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   29,
					},
					File:   "nanosecond_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "nanosecond_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   29,
						},
						File:   "nanosecond_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,1\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,1\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,1\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,1\n,,1,2018-05-22T19:07:00.819823471Z,_m,QQ,1\n,,1,2018-05-22T19:08:00.587284314Z,_m,QQ,1\n,,1,2018-05-22T19:09:00.984375238Z,_m,QQ,1\n,,1,2018-05-22T19:10:00.723847562Z,_m,QQ,1\n,,1,2018-05-22T19:13:00.192983472Z,_m,QQ,1\n,,1,2018-05-22T19:15:00.712938413Z,_m,QQ,1\n,,1,2018-05-22T19:20:00.062103483Z,_m,QQ,1\n,,1,2018-05-22T19:23:00.786432256Z,_m,QQ,1\n,,1,2018-05-22T19:25:00.823748524Z,_m,QQ,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   50,
					},
					File:   "nanosecond_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819212\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691723\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182316\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816341\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423456\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342357\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823471\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284314\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375238\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847562\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983472\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938413\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103483\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432256\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748524\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   30,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   30,
						},
						File:   "nanosecond_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   30,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   50,
						},
						File:   "nanosecond_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819212\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691723\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182316\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816341\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423456\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342357\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823471\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284314\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375238\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847562\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983472\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938413\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103483\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432256\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748524\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   30,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,254819212\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,748691723\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,947182316\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,538816341\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,676423456\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,982342357\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:07:00.819823471Z,819823471\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:08:00.587284314Z,587284314\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:09:00.984375238Z,984375238\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:10:00.723847562Z,723847562\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:13:00.192983472Z,192983472\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:15:00.712938413Z,712938413\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:20:00.062103483Z,062103483\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:23:00.786432256Z,786432256\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:25:00.823748524Z,823748524\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 70,
						Line:   53,
					},
					File:   "nanosecond_time_test.flux",
					Source: "t_time_nanosecond = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.nanosecond(t: r._time)}))",
					Start: ast.Position{
						Column: 1,
						Line:   51,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   51,
						},
						File:   "nanosecond_time_test.flux",
						Source: "t_time_nanosecond",
						Start: ast.Position{
							Column: 1,
							Line:   51,
						},
					},
				},
				Name: "t_time_nanosecond",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 70,
							Line:   53,
						},
						File:   "nanosecond_time_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.nanosecond(t: r._time)}))",
						Start: ast.Position{
							Column: 21,
							Line:   51,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   51,
									},
									File:   "nanosecond_time_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 35,
										Line:   51,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   52,
								},
								File:   "nanosecond_time_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 35,
									Line:   51,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   52,
										},
										File:   "nanosecond_time_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   52,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   52,
											},
											File:   "nanosecond_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   52,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   52,
												},
												File:   "nanosecond_time_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   52,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   52,
												},
												File:   "nanosecond_time_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   52,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   52,
									},
									File:   "nanosecond_time_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   52,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   52,
										},
										File:   "nanosecond_time_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   52,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 70,
								Line:   53,
							},
							File:   "nanosecond_time_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.nanosecond(t: r._time)}))",
							Start: ast.Position{
								Column: 35,
								Line:   51,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 69,
										Line:   53,
									},
									File:   "nanosecond_time_test.flux",
									Source: "fn: (r) => ({r with _value: date.nanosecond(t: r._time)})",
									Start: ast.Position{
										Column: 12,
										Line:   53,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   53,
										},
										File:   "nanosecond_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.nanosecond(t: r._time)})",
										Start: ast.Position{
											Column: 12,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   53,
											},
											File:   "nanosecond_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   53,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   53,
											},
											File:   "nanosecond_time_test.flux",
											Source: "(r) => ({r with _value: date.nanosecond(t: r._time)})",
											Start: ast.Position{
												Column: 16,
												Line:   53,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 69,
													Line:   53,
												},
												File:   "nanosecond_time_test.flux",
												Source: "({r with _value: date.nanosecond(t: r._time)})",
												Start: ast.Position{
													Column: 23,
													Line:   53,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   53,
													},
													File:   "nanosecond_time_test.flux",
													Source: "{r with _value: date.nanosecond(t: r._time)}",
													Start: ast.Position{
														Column: 24,
														Line:   53,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   53,
														},
														File:   "nanosecond_time_test.flux",
														Source: "_value: date.nanosecond(t: r._time)",
														Start: ast.Position{
															Column: 32,
															Line:   53,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   53,
															},
															File:   "nanosecond_time_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   53,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 66,
																	Line:   53,
																},
																File:   "nanosecond_time_test.flux",
																Source: "t: r._time",
																Start: ast.Position{
																	Column: 56,
																	Line:   53,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 66,
																		Line:   53,
																	},
																	File:   "nanosecond_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 56,
																		Line:   53,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 57,
																			Line:   53,
																		},
																		File:   "nanosecond_time_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 56,
																			Line:   53,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 66,
																			Line:   53,
																		},
																		File:   "nanosecond_time_test.flux",
																		Source: "r._time",
																		Start: ast.Position{
																			Column: 59,
																			Line:   53,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 60,
																				Line:   53,
																			},
																			File:   "nanosecond_time_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 59,
																				Line:   53,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 66,
																				Line:   53,
																			},
																			File:   "nanosecond_time_test.flux",
																			Source: "_time",
																			Start: ast.Position{
																				Column: 61,
																				Line:   53,
																			},
																		},
																	},
																	Name: "_time",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 67,
																Line:   53,
															},
															File:   "nanosecond_time_test.flux",
															Source: "date.nanosecond(t: r._time)",
															Start: ast.Position{
																Column: 40,
																Line:   53,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 55,
																	Line:   53,
																},
																File:   "nanosecond_time_test.flux",
																Source: "date.nanosecond",
																Start: ast.Position{
																	Column: 40,
																	Line:   53,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   53,
																	},
																	File:   "nanosecond_time_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   53,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 55,
																		Line:   53,
																	},
																	File:   "nanosecond_time_test.flux",
																	Source: "nanosecond",
																	Start: ast.Position{
																		Column: 45,
																		Line:   53,
																	},
																},
															},
															Name: "nanosecond",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   53,
														},
														File:   "nanosecond_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   53,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   53,
												},
												File:   "nanosecond_time_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   53,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   53,
													},
													File:   "nanosecond_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   53,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 70,
									Line:   53,
								},
								File:   "nanosecond_time_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.nanosecond(t: r._time)}))",
								Start: ast.Position{
									Column: 8,
									Line:   53,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   53,
									},
									File:   "nanosecond_time_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   53,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   51,
							},
							File:   "nanosecond_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 22,
								Line:   51,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   51,
								},
								File:   "nanosecond_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 22,
									Line:   51,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   51,
							},
							File:   "nanosecond_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   51,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 134,
							Line:   55,
						},
						File:   "nanosecond_time_test.flux",
						Source: "_time_nanosecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
						Start: ast.Position{
							Column: 6,
							Line:   55,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   55,
							},
							File:   "nanosecond_time_test.flux",
							Source: "_time_nanosecond",
							Start: ast.Position{
								Column: 6,
								Line:   55,
							},
						},
					},
					Name: "_time_nanosecond",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 134,
								Line:   55,
							},
							File:   "nanosecond_time_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
							Start: ast.Position{
								Column: 25,
								Line:   55,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 134,
									Line:   55,
								},
								File:   "nanosecond_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
								Start: ast.Position{
									Column: 31,
									Line:   55,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 133,
										Line:   55,
									},
									File:   "nanosecond_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond}",
									Start: ast.Position{
										Column: 32,
										Line:   55,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   55,
										},
										File:   "nanosecond_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 33,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   55,
											},
											File:   "nanosecond_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 33,
												Line:   55,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   55,
												},
												File:   "nanosecond_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 60,
													Line:   55,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 71,
														Line:   55,
													},
													File:   "nanosecond_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 60,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   55,
														},
														File:   "nanosecond_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 60,
															Line:   55,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   55,
														},
														File:   "nanosecond_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 65,
															Line:   55,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   55,
											},
											File:   "nanosecond_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 40,
												Line:   55,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   55,
												},
												File:   "nanosecond_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 40,
													Line:   55,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   55,
													},
													File:   "nanosecond_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 40,
														Line:   55,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   55,
													},
													File:   "nanosecond_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 48,
														Line:   55,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 109,
											Line:   55,
										},
										File:   "nanosecond_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 74,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   55,
											},
											File:   "nanosecond_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 74,
												Line:   55,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 108,
													Line:   55,
												},
												File:   "nanosecond_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 96,
													Line:   55,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 108,
														Line:   55,
													},
													File:   "nanosecond_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 96,
														Line:   55,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 99,
															Line:   55,
														},
														File:   "nanosecond_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 96,
															Line:   55,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 108,
															Line:   55,
														},
														File:   "nanosecond_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 101,
															Line:   55,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 109,
												Line:   55,
											},
											File:   "nanosecond_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 80,
												Line:   55,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   55,
												},
												File:   "nanosecond_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 80,
													Line:   55,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   55,
													},
													File:   "nanosecond_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 80,
														Line:   55,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 95,
														Line:   55,
													},
													File:   "nanosecond_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 88,
														Line:   55,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 132,
											Line:   55,
										},
										File:   "nanosecond_time_test.flux",
										Source: "fn: t_time_nanosecond",
										Start: ast.Position{
											Column: 111,
											Line:   55,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 113,
												Line:   55,
											},
											File:   "nanosecond_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 111,
												Line:   55,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 132,
												Line:   55,
											},
											File:   "nanosecond_time_test.flux",
											Source: "t_time_nanosecond",
											Start: ast.Position{
												Column: 115,
												Line:   55,
											},
										},
									},
									Name: "t_time_nanosecond",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 134,
						Line:   55,
					},
					File:   "nanosecond_time_test.flux",
					Source: "test _time_nanosecond = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_nanosecond})",
					Start: ast.Position{
						Column: 1,
						Line:   55,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "nanosecond_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "nanosecond_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "nanosecond_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "nanosecond_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "nanosecond_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "nanosecond_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "nanosecond_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 136,
					Line:   37,
				},
				File:   "quarter_duration_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"\nt_duration_quarter = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.quarter(t: duration(v: r._value))}))\n\ntest _duration_quarter = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_quarter})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "quarter_duration_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "quarter_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "quarter_duration_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "quarter_duration_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "quarter_duration_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "quarter_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "quarter_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "quarter_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "quarter_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "quarter_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "quarter_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,4\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 81,
						Line:   35,
					},
					File:   "quarter_duration_test.flux",
					Source: "t_duration_quarter = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.quarter(t: duration(v: r._value))}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   33,
						},
						File:   "quarter_duration_test.flux",
						Source: "t_duration_quarter",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_duration_quarter",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 81,
							Line:   35,
						},
						File:   "quarter_duration_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.quarter(t: duration(v: r._value))}))",
						Start: ast.Position{
							Column: 22,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   33,
									},
									File:   "quarter_duration_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 36,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "quarter_duration_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 36,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "quarter_duration_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "quarter_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "quarter_duration_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "quarter_duration_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "quarter_duration_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "quarter_duration_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 81,
								Line:   35,
							},
							File:   "quarter_duration_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.quarter(t: duration(v: r._value))}))",
							Start: ast.Position{
								Column: 36,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 80,
										Line:   35,
									},
									File:   "quarter_duration_test.flux",
									Source: "fn: (r) => ({r with _value: date.quarter(t: duration(v: r._value))})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   35,
										},
										File:   "quarter_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.quarter(t: duration(v: r._value))})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "quarter_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   35,
											},
											File:   "quarter_duration_test.flux",
											Source: "(r) => ({r with _value: date.quarter(t: duration(v: r._value))})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 80,
													Line:   35,
												},
												File:   "quarter_duration_test.flux",
												Source: "({r with _value: date.quarter(t: duration(v: r._value))})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   35,
													},
													File:   "quarter_duration_test.flux",
													Source: "{r with _value: date.quarter(t: duration(v: r._value))}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 78,
															Line:   35,
														},
														File:   "quarter_duration_test.flux",
														Source: "_value: date.quarter(t: duration(v: r._value))",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "quarter_duration_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 77,
																	Line:   35,
																},
																File:   "quarter_duration_test.flux",
																Source: "t: duration(v: r._value)",
																Start: ast.Position{
																	Column: 53,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 77,
																		Line:   35,
																	},
																	File:   "quarter_duration_test.flux",
																	Source: "t: duration(v: r._value)",
																	Start: ast.Position{
																		Column: 53,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 54,
																			Line:   35,
																		},
																		File:   "quarter_duration_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 53,
																			Line:   35,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 76,
																				Line:   35,
																			},
																			File:   "quarter_duration_test.flux",
																			Source: "v: r._value",
																			Start: ast.Position{
																				Column: 65,
																				Line:   35,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 76,
																					Line:   35,
																				},
																				File:   "quarter_duration_test.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 65,
																					Line:   35,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 66,
																						Line:   35,
																					},
																					File:   "quarter_duration_test.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 65,
																						Line:   35,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 76,
																						Line:   35,
																					},
																					File:   "quarter_duration_test.flux",
																					Source: "r._value",
																					Start: ast.Position{
																						Column: 68,
																						Line:   35,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 69,
																							Line:   35,
																						},
																						File:   "quarter_duration_test.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 68,
																							Line:   35,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 76,
																							Line:   35,
																						},
																						File:   "quarter_duration_test.flux",
																						Source: "_value",
																						Start: ast.Position{
																							Column: 70,
																							Line:   35,
																						},
																					},
																				},
																				Name: "_value",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 77,
																			Line:   35,
																		},
																		File:   "quarter_duration_test.flux",
																		Source: "duration(v: r._value)",
																		Start: ast.Position{
																			Column: 56,
																			Line:   35,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 64,
																				Line:   35,
																			},
																			File:   "quarter_duration_test.flux",
																			Source: "duration",
																			Start: ast.Position{
																				Column: 56,
																				Line:   35,
																			},
																		},
																	},
																	Name: "duration",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 78,
																Line:   35,
															},
															File:   "quarter_duration_test.flux",
															Source: "date.quarter(t: duration(v: r._value))",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 52,
																	Line:   35,
																},
																File:   "quarter_duration_test.flux",
																Source: "date.quarter",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   35,
																	},
																	File:   "quarter_duration_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 52,
																		Line:   35,
																	},
																	File:   "quarter_duration_test.flux",
																	Source: "quarter",
																	Start: ast.Position{
																		Column: 45,
																		Line:   35,
																	},
																},
															},
															Name: "quarter",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "quarter_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "quarter_duration_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "quarter_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 81,
									Line:   35,
								},
								File:   "quarter_duration_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.quarter(t: duration(v: r._value))}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "quarter_duration_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   33,
							},
							File:   "quarter_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 23,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   33,
								},
								File:   "quarter_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 23,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   33,
							},
							File:   "quarter_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 29,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 136,
							Line:   37,
						},
						File:   "quarter_duration_test.flux",
						Source: "_duration_quarter = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_quarter})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   37,
							},
							File:   "quarter_duration_test.flux",
							Source: "_duration_quarter",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_duration_quarter",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 136,
								Line:   37,
							},
							File:   "quarter_duration_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_quarter})",
							Start: ast.Position{
								Column: 26,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 136,
									Line:   37,
								},
								File:   "quarter_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_quarter})",
								Start: ast.Position{
									Column: 32,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 135,
										Line:   37,
									},
									File:   "quarter_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_quarter}",
									Start: ast.Position{
										Column: 33,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 73,
											Line:   37,
										},
										File:   "quarter_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 34,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 39,
												Line:   37,
											},
											File:   "quarter_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 34,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 72,
													Line:   37,
												},
												File:   "quarter_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 61,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 72,
														Line:   37,
													},
													File:   "quarter_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 61,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   37,
														},
														File:   "quarter_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 61,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 72,
															Line:   37,
														},
														File:   "quarter_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 66,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 73,
												Line:   37,
											},
											File:   "quarter_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 41,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   37,
												},
												File:   "quarter_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 41,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 48,
														Line:   37,
													},
													File:   "quarter_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 41,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 60,
														Line:   37,
													},
													File:   "quarter_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 49,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 110,
											Line:   37,
										},
										File:   "quarter_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 75,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   37,
											},
											File:   "quarter_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 75,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 109,
													Line:   37,
												},
												File:   "quarter_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 97,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 109,
														Line:   37,
													},
													File:   "quarter_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 97,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 100,
															Line:   37,
														},
														File:   "quarter_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 97,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 109,
															Line:   37,
														},
														File:   "quarter_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 102,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   37,
											},
											File:   "quarter_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 81,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 96,
													Line:   37,
												},
												File:   "quarter_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 81,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 88,
														Line:   37,
													},
													File:   "quarter_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 81,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 96,
														Line:   37,
													},
													File:   "quarter_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 89,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 134,
											Line:   37,
										},
										File:   "quarter_duration_test.flux",
										Source: "fn: t_duration_quarter",
										Start: ast.Position{
											Column: 112,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 114,
												Line:   37,
											},
											File:   "quarter_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 112,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 134,
												Line:   37,
											},
											File:   "quarter_duration_test.flux",
											Source: "t_duration_quarter",
											Start: ast.Position{
												Column: 116,
												Line:   37,
											},
										},
									},
									Name: "t_duration_quarter",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 136,
						Line:   37,
					},
					File:   "quarter_duration_test.flux",
					Source: "test _duration_quarter = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_quarter})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "quarter_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "quarter_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "quarter_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "quarter_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "quarter_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "quarter_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "quarter_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 128,
					Line:   49,
				},
				File:   "quarter_time_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,2\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,4\n\"\nt_time_quarter = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.quarter(t: r._time)}))\n\ntest _time_quarter = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_quarter})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "quarter_time_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "quarter_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "quarter_time_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "quarter_time_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "quarter_time_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   26,
					},
					File:   "quarter_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "quarter_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   26,
						},
						File:   "quarter_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-01-22T19:53:00Z,_m,FF,1\n,,0,2018-02-22T19:53:10Z,_m,FF,1\n,,0,2018-03-22T19:53:20Z,_m,FF,1\n,,0,2018-04-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-06-22T19:53:50Z,_m,FF,1\n,,1,2018-07-22T19:53:00Z,_m,QQ,1\n,,1,2018-08-22T19:53:10Z,_m,QQ,1\n,,1,2018-09-22T19:53:20Z,_m,QQ,1\n,,1,2018-10-22T19:53:30Z,_m,QQ,1\n,,1,2018-11-22T19:53:40Z,_m,QQ,1\n,,1,2018-12-22T19:53:50Z,_m,QQ,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   44,
					},
					File:   "quarter_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,2\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,4\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   27,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   27,
						},
						File:   "quarter_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   27,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   44,
						},
						File:   "quarter_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,2\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,4\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   27,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-01-22T19:53:00Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-02-22T19:53:10Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-03-22T19:53:20Z,1\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-04-22T19:53:30Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,2\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-06-22T19:53:50Z,2\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-07-22T19:53:00Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-08-22T19:53:10Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-09-22T19:53:20Z,3\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-10-22T19:53:30Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-11-22T19:53:40Z,4\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-12-22T19:53:50Z,4\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 67,
						Line:   47,
					},
					File:   "quarter_time_test.flux",
					Source: "t_time_quarter = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.quarter(t: r._time)}))",
					Start: ast.Position{
						Column: 1,
						Line:   45,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   45,
						},
						File:   "quarter_time_test.flux",
						Source: "t_time_quarter",
						Start: ast.Position{
							Column: 1,
							Line:   45,
						},
					},
				},
				Name: "t_time_quarter",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 67,
							Line:   47,
						},
						File:   "quarter_time_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.quarter(t: r._time)}))",
						Start: ast.Position{
							Column: 18,
							Line:   45,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   45,
									},
									File:   "quarter_time_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 32,
										Line:   45,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   46,
								},
								File:   "quarter_time_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 32,
									Line:   45,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   46,
										},
										File:   "quarter_time_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   46,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   46,
											},
											File:   "quarter_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   46,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   46,
												},
												File:   "quarter_time_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   46,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   46,
												},
												File:   "quarter_time_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   46,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   46,
									},
									File:   "quarter_time_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   46,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   46,
										},
										File:   "quarter_time_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   46,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 67,
								Line:   47,
							},
							File:   "quarter_time_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.quarter(t: r._time)}))",
							Start: ast.Position{
								Column: 32,
								Line:   45,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 66,
										Line:   47,
									},
									File:   "quarter_time_test.flux",
									Source: "fn: (r) => ({r with _value: date.quarter(t: r._time)})",
									Start: ast.Position{
										Column: 12,
										Line:   47,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   47,
										},
										File:   "quarter_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.quarter(t: r._time)})",
										Start: ast.Position{
											Column: 12,
											Line:   47,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   47,
											},
											File:   "quarter_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   47,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   47,
											},
											File:   "quarter_time_test.flux",
											Source: "(r) => ({r with _value: date.quarter(t: r._time)})",
											Start: ast.Position{
												Column: 16,
												Line:   47,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   47,
												},
												File:   "quarter_time_test.flux",
												Source: "({r with _value: date.quarter(t: r._time)})",
												Start: ast.Position{
													Column: 23,
													Line:   47,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   47,
													},
													File:   "quarter_time_test.flux",
													Source: "{r with _value: date.quarter(t: r._time)}",
													Start: ast.Position{
														Column: 24,
														Line:   47,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 64,
															Line:   47,
														},
														File:   "quarter_time_test.flux",
														Source: "_value: date.quarter(t: r._time)",
														Start: ast.Position{
															Column: 32,
															Line:   47,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   47,
															},
															File:   "quarter_time_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   47,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 63,
																	Line:   47,
																},
																File:   "quarter_time_test.flux",
																Source: "t: r._time",
																Start: ast.Position{
																	Column: 53,
																	Line:   47,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 63,
																		Line:   47,
																	},
																	File:   "quarter_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 53,
																		Line:   47,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 54,
																			Line:   47,
																		},
																		File:   "quarter_time_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 53,
																			Line:   47,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 63,
																			Line:   47,
																		},
																		File:   "quarter_time_test.flux",
																		Source: "r._time",
																		Start: ast.Position{
																			Column: 56,
																			Line:   47,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 57,
																				Line:   47,
																			},
																			File:   "quarter_time_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 56,
																				Line:   47,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 63,
																				Line:   47,
																			},
																			File:   "quarter_time_test.flux",
																			Source: "_time",
																			Start: ast.Position{
																				Column: 58,
																				Line:   47,
																			},
																		},
																	},
																	Name: "_time",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 64,
																Line:   47,
															},
															File:   "quarter_time_test.flux",
															Source: "date.quarter(t: r._time)",
															Start: ast.Position{
																Column: 40,
																Line:   47,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 52,
																	Line:   47,
																},
																File:   "quarter_time_test.flux",
																Source: "date.quarter",
																Start: ast.Position{
																	Column: 40,
																	Line:   47,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   47,
																	},
																	File:   "quarter_time_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   47,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 52,
																		Line:   47,
																	},
																	File:   "quarter_time_test.flux",
																	Source: "quarter",
																	Start: ast.Position{
																		Column: 45,
																		Line:   47,
																	},
																},
															},
															Name: "quarter",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   47,
														},
														File:   "quarter_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   47,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   47,
												},
												File:   "quarter_time_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   47,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   47,
													},
													File:   "quarter_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   47,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 67,
									Line:   47,
								},
								File:   "quarter_time_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.quarter(t: r._time)}))",
								Start: ast.Position{
									Column: 8,
									Line:   47,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   47,
									},
									File:   "quarter_time_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   47,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   45,
							},
							File:   "quarter_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 19,
								Line:   45,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   45,
								},
								File:   "quarter_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 19,
									Line:   45,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   45,
							},
							File:   "quarter_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 25,
								Line:   45,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 128,
							Line:   49,
						},
						File:   "quarter_time_test.flux",
						Source: "_time_quarter = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_quarter})",
						Start: ast.Position{
							Column: 6,
							Line:   49,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   49,
							},
							File:   "quarter_time_test.flux",
							Source: "_time_quarter",
							Start: ast.Position{
								Column: 6,
								Line:   49,
							},
						},
					},
					Name: "_time_quarter",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 128,
								Line:   49,
							},
							File:   "quarter_time_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_quarter})",
							Start: ast.Position{
								Column: 22,
								Line:   49,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 128,
									Line:   49,
								},
								File:   "quarter_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_quarter})",
								Start: ast.Position{
									Column: 28,
									Line:   49,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 127,
										Line:   49,
									},
									File:   "quarter_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_quarter}",
									Start: ast.Position{
										Column: 29,
										Line:   49,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 69,
											Line:   49,
										},
										File:   "quarter_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 30,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 35,
												Line:   49,
											},
											File:   "quarter_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 30,
												Line:   49,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 68,
													Line:   49,
												},
												File:   "quarter_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 57,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 68,
														Line:   49,
													},
													File:   "quarter_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 57,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   49,
														},
														File:   "quarter_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 57,
															Line:   49,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 68,
															Line:   49,
														},
														File:   "quarter_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 62,
															Line:   49,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 69,
												Line:   49,
											},
											File:   "quarter_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 37,
												Line:   49,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 56,
													Line:   49,
												},
												File:   "quarter_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 37,
													Line:   49,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 44,
														Line:   49,
													},
													File:   "quarter_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 37,
														Line:   49,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 56,
														Line:   49,
													},
													File:   "quarter_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 45,
														Line:   49,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 106,
											Line:   49,
										},
										File:   "quarter_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 71,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 75,
												Line:   49,
											},
											File:   "quarter_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 71,
												Line:   49,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 105,
													Line:   49,
												},
												File:   "quarter_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 93,
													Line:   49,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 105,
														Line:   49,
													},
													File:   "quarter_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 93,
														Line:   49,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 96,
															Line:   49,
														},
														File:   "quarter_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 93,
															Line:   49,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 105,
															Line:   49,
														},
														File:   "quarter_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 98,
															Line:   49,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 106,
												Line:   49,
											},
											File:   "quarter_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 77,
												Line:   49,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 92,
													Line:   49,
												},
												File:   "quarter_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 77,
													Line:   49,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 84,
														Line:   49,
													},
													File:   "quarter_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 77,
														Line:   49,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 92,
														Line:   49,
													},
													File:   "quarter_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 85,
														Line:   49,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 126,
											Line:   49,
										},
										File:   "quarter_time_test.flux",
										Source: "fn: t_time_quarter",
										Start: ast.Position{
											Column: 108,
											Line:   49,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 110,
												Line:   49,
											},
											File:   "quarter_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 108,
												Line:   49,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 126,
												Line:   49,
											},
											File:   "quarter_time_test.flux",
											Source: "t_time_quarter",
											Start: ast.Position{
												Column: 112,
												Line:   49,
											},
										},
									},
									Name: "t_time_quarter",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 128,
						Line:   49,
					},
					File:   "quarter_time_test.flux",
					Source: "test _time_quarter = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_quarter})",
					Start: ast.Position{
						Column: 1,
						Line:   49,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "quarter_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "quarter_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "quarter_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "quarter_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "quarter_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "quarter_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "quarter_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 134,
					Line:   37,
				},
				File:   "second_duration_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"\nt_duration_second = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.second(t: duration(v: r._value))}))\n\ntest _duration_second = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_second})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "second_duration_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "second_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "second_duration_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "second_duration_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "second_duration_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   20,
					},
					File:   "second_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "second_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   20,
						},
						File:   "second_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:01:00.254819212Z,_m,FF,-3\n,,0,2018-05-22T19:02:00.748691723Z,_m,FF,-2\n,,0,2018-05-22T19:03:00.947182316Z,_m,FF,-1\n,,0,2018-05-22T19:04:00.538816341Z,_m,FF,0\n,,0,2018-05-22T19:05:00.676423456Z,_m,FF,1\n,,0,2018-05-22T19:06:00.982342357Z,_m,FF,2\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   32,
					},
					File:   "second_duration_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   21,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   21,
						},
						File:   "second_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   21,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   32,
						},
						File:   "second_duration_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   21,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:01:00.254819212Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:02:00.748691723Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:03:00.947182316Z,59\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:04:00.538816341Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:05:00.676423456Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:06:00.982342357Z,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 80,
						Line:   35,
					},
					File:   "second_duration_test.flux",
					Source: "t_duration_second = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.second(t: duration(v: r._value))}))",
					Start: ast.Position{
						Column: 1,
						Line:   33,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   33,
						},
						File:   "second_duration_test.flux",
						Source: "t_duration_second",
						Start: ast.Position{
							Column: 1,
							Line:   33,
						},
					},
				},
				Name: "t_duration_second",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 80,
							Line:   35,
						},
						File:   "second_duration_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.second(t: duration(v: r._value))}))",
						Start: ast.Position{
							Column: 21,
							Line:   33,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   33,
									},
									File:   "second_duration_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 35,
										Line:   33,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   34,
								},
								File:   "second_duration_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 35,
									Line:   33,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   34,
										},
										File:   "second_duration_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   34,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   34,
											},
											File:   "second_duration_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   34,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   34,
												},
												File:   "second_duration_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   34,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   34,
												},
												File:   "second_duration_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   34,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   34,
									},
									File:   "second_duration_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   34,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   34,
										},
										File:   "second_duration_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   34,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 80,
								Line:   35,
							},
							File:   "second_duration_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.second(t: duration(v: r._value))}))",
							Start: ast.Position{
								Column: 35,
								Line:   33,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 79,
										Line:   35,
									},
									File:   "second_duration_test.flux",
									Source: "fn: (r) => ({r with _value: date.second(t: duration(v: r._value))})",
									Start: ast.Position{
										Column: 12,
										Line:   35,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 79,
											Line:   35,
										},
										File:   "second_duration_test.flux",
										Source: "fn: (r) => ({r with _value: date.second(t: duration(v: r._value))})",
										Start: ast.Position{
											Column: 12,
											Line:   35,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   35,
											},
											File:   "second_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   35,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   35,
											},
											File:   "second_duration_test.flux",
											Source: "(r) => ({r with _value: date.second(t: duration(v: r._value))})",
											Start: ast.Position{
												Column: 16,
												Line:   35,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   35,
												},
												File:   "second_duration_test.flux",
												Source: "({r with _value: date.second(t: duration(v: r._value))})",
												Start: ast.Position{
													Column: 23,
													Line:   35,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 78,
														Line:   35,
													},
													File:   "second_duration_test.flux",
													Source: "{r with _value: date.second(t: duration(v: r._value))}",
													Start: ast.Position{
														Column: 24,
														Line:   35,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 77,
															Line:   35,
														},
														File:   "second_duration_test.flux",
														Source: "_value: date.second(t: duration(v: r._value))",
														Start: ast.Position{
															Column: 32,
															Line:   35,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   35,
															},
															File:   "second_duration_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   35,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 76,
																	Line:   35,
																},
																File:   "second_duration_test.flux",
																Source: "t: duration(v: r._value)",
																Start: ast.Position{
																	Column: 52,
																	Line:   35,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 76,
																		Line:   35,
																	},
																	File:   "second_duration_test.flux",
																	Source: "t: duration(v: r._value)",
																	Start: ast.Position{
																		Column: 52,
																		Line:   35,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 53,
																			Line:   35,
																		},
																		File:   "second_duration_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 52,
																			Line:   35,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 75,
																				Line:   35,
																			},
																			File:   "second_duration_test.flux",
																			Source: "v: r._value",
																			Start: ast.Position{
																				Column: 64,
																				Line:   35,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 75,
																					Line:   35,
																				},
																				File:   "second_duration_test.flux",
																				Source: "v: r._value",
																				Start: ast.Position{
																					Column: 64,
																					Line:   35,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 65,
																						Line:   35,
																					},
																					File:   "second_duration_test.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 64,
																						Line:   35,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.MemberExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 75,
																						Line:   35,
																					},
																					File:   "second_duration_test.flux",
																					Source: "r._value",
																					Start: ast.Position{
																						Column: 67,
																						Line:   35,
																					},
																				},
																			},
																			Lbrack: nil,
																			Object: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 68,
																							Line:   35,
																						},
																						File:   "second_duration_test.flux",
																						Source: "r",
																						Start: ast.Position{
																							Column: 67,
																							Line:   35,
																						},
																					},
																				},
																				Name: "r",
																			},
																			Property: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 75,
																							Line:   35,
																						},
																						File:   "second_duration_test.flux",
																						Source: "_value",
																						Start: ast.Position{
																							Column: 69,
																							Line:   35,
																						},
																					},
																				},
																				Name: "_value",
																			},
																			Rbrack: nil,
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 76,
																			Line:   35,
																		},
																		File:   "second_duration_test.flux",
																		Source: "duration(v: r._value)",
																		Start: ast.Position{
																			Column: 55,
																			Line:   35,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 63,
																				Line:   35,
																			},
																			File:   "second_duration_test.flux",
																			Source: "duration",
																			Start: ast.Position{
																				Column: 55,
																				Line:   35,
																			},
																		},
																	},
																	Name: "duration",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 77,
																Line:   35,
															},
															File:   "second_duration_test.flux",
															Source: "date.second(t: duration(v: r._value))",
															Start: ast.Position{
																Column: 40,
																Line:   35,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   35,
																},
																File:   "second_duration_test.flux",
																Source: "date.second",
																Start: ast.Position{
																	Column: 40,
																	Line:   35,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   35,
																	},
																	File:   "second_duration_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   35,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 51,
																		Line:   35,
																	},
																	File:   "second_duration_test.flux",
																	Source: "second",
																	Start: ast.Position{
																		Column: 45,
																		Line:   35,
																	},
																},
															},
															Name: "second",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   35,
														},
														File:   "second_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   35,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   35,
												},
												File:   "second_duration_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   35,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   35,
													},
													File:   "second_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   35,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   35,
								},
								File:   "second_duration_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.second(t: duration(v: r._value))}))",
								Start: ast.Position{
									Column: 8,
									Line:   35,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   35,
									},
									File:   "second_duration_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   35,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   33,
							},
							File:   "second_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 22,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   33,
								},
								File:   "second_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 22,
									Line:   33,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   33,
							},
							File:   "second_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 28,
								Line:   33,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 134,
							Line:   37,
						},
						File:   "second_duration_test.flux",
						Source: "_duration_second = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_second})",
						Start: ast.Position{
							Column: 6,
							Line:   37,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   37,
							},
							File:   "second_duration_test.flux",
							Source: "_duration_second",
							Start: ast.Position{
								Column: 6,
								Line:   37,
							},
						},
					},
					Name: "_duration_second",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 134,
								Line:   37,
							},
							File:   "second_duration_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_second})",
							Start: ast.Position{
								Column: 25,
								Line:   37,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 134,
									Line:   37,
								},
								File:   "second_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_second})",
								Start: ast.Position{
									Column: 31,
									Line:   37,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 133,
										Line:   37,
									},
									File:   "second_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_second}",
									Start: ast.Position{
										Column: 32,
										Line:   37,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 72,
											Line:   37,
										},
										File:   "second_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 33,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   37,
											},
											File:   "second_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 33,
												Line:   37,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 71,
													Line:   37,
												},
												File:   "second_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 60,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 71,
														Line:   37,
													},
													File:   "second_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 60,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   37,
														},
														File:   "second_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 60,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 71,
															Line:   37,
														},
														File:   "second_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 65,
															Line:   37,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 72,
												Line:   37,
											},
											File:   "second_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 40,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   37,
												},
												File:   "second_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 40,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   37,
													},
													File:   "second_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 40,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 59,
														Line:   37,
													},
													File:   "second_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 48,
														Line:   37,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 109,
											Line:   37,
										},
										File:   "second_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 74,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 78,
												Line:   37,
											},
											File:   "second_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 74,
												Line:   37,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 108,
													Line:   37,
												},
												File:   "second_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 96,
													Line:   37,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 108,
														Line:   37,
													},
													File:   "second_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 96,
														Line:   37,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 99,
															Line:   37,
														},
														File:   "second_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 96,
															Line:   37,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 108,
															Line:   37,
														},
														File:   "second_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 101,
															Line:   37,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 109,
												Line:   37,
											},
											File:   "second_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 80,
												Line:   37,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 95,
													Line:   37,
												},
												File:   "second_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 80,
													Line:   37,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 87,
														Line:   37,
													},
													File:   "second_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 80,
														Line:   37,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 95,
														Line:   37,
													},
													File:   "second_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 88,
														Line:   37,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 132,
											Line:   37,
										},
										File:   "second_duration_test.flux",
										Source: "fn: t_duration_second",
										Start: ast.Position{
											Column: 111,
											Line:   37,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 113,
												Line:   37,
											},
											File:   "second_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 111,
												Line:   37,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 132,
												Line:   37,
											},
											File:   "second_duration_test.flux",
											Source: "t_duration_second",
											Start: ast.Position{
												Column: 115,
												Line:   37,
											},
										},
									},
									Name: "t_duration_second",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 134,
						Line:   37,
					},
					File:   "second_duration_test.flux",
					Source: "test _duration_second = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_second})",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "second_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "second_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "second_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "second_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "second_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "second_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "second_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 126,
					Line:   69,
				},
				File:   "second_time_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00Z,_m,FF,1\n,,0,2018-05-22T19:53:10Z,_m,FF,1\n,,0,2018-05-22T19:53:20Z,_m,FF,1\n,,0,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-05-22T19:53:50Z,_m,FF,1\n,,1,2018-05-22T19:53:00Z,_m,QQ,1\n,,1,2018-05-22T19:53:10Z,_m,QQ,1\n,,1,2018-05-22T19:53:20Z,_m,QQ,1\n,,1,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-22T19:53:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,1,2018-05-22T19:54:10Z,_m,QQ,1\n,,1,2018-05-22T19:54:20Z,_m,QQ,1\n,,2,2018-05-22T19:53:00Z,_m,RR,1\n,,2,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-22T19:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T19:53:40Z,_m,SR,1\n,,3,2018-05-22T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n\"\noutData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:10Z,10\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:20Z,20\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:30Z,30\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,40\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:20Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:30Z,30\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:40Z,40\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:00Z,0\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:10Z,10\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:40Z,40\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:50Z,50\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,0\n\"\nt_time_second = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.second(t: r._time)}))\n\ntest _time_second = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_second})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "second_time_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "second_time_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "second_time_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "second_time_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "second_time_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   36,
					},
					File:   "second_time_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00Z,_m,FF,1\n,,0,2018-05-22T19:53:10Z,_m,FF,1\n,,0,2018-05-22T19:53:20Z,_m,FF,1\n,,0,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-05-22T19:53:50Z,_m,FF,1\n,,1,2018-05-22T19:53:00Z,_m,QQ,1\n,,1,2018-05-22T19:53:10Z,_m,QQ,1\n,,1,2018-05-22T19:53:20Z,_m,QQ,1\n,,1,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-22T19:53:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,1,2018-05-22T19:54:10Z,_m,QQ,1\n,,1,2018-05-22T19:54:20Z,_m,QQ,1\n,,2,2018-05-22T19:53:00Z,_m,RR,1\n,,2,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-22T19:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T19:53:40Z,_m,SR,1\n,,3,2018-05-22T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "second_time_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   36,
						},
						File:   "second_time_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00Z,_m,FF,1\n,,0,2018-05-22T19:53:10Z,_m,FF,1\n,,0,2018-05-22T19:53:20Z,_m,FF,1\n,,0,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-05-22T19:53:50Z,_m,FF,1\n,,1,2018-05-22T19:53:00Z,_m,QQ,1\n,,1,2018-05-22T19:53:10Z,_m,QQ,1\n,,1,2018-05-22T19:53:20Z,_m,QQ,1\n,,1,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-22T19:53:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,1,2018-05-22T19:54:10Z,_m,QQ,1\n,,1,2018-05-22T19:54:20Z,_m,QQ,1\n,,2,2018-05-22T19:53:00Z,_m,RR,1\n,,2,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-22T19:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T19:53:40Z,_m,SR,1\n,,3,2018-05-22T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,double\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00Z,_m,FF,1\n,,0,2018-05-22T19:53:10Z,_m,FF,1\n,,0,2018-05-22T19:53:20Z,_m,FF,1\n,,0,2018-05-22T19:53:30Z,_m,FF,1\n,,0,2018-05-22T19:53:40Z,_m,FF,1\n,,0,2018-05-22T19:53:50Z,_m,FF,1\n,,1,2018-05-22T19:53:00Z,_m,QQ,1\n,,1,2018-05-22T19:53:10Z,_m,QQ,1\n,,1,2018-05-22T19:53:20Z,_m,QQ,1\n,,1,2018-05-22T19:53:30Z,_m,QQ,1\n,,1,2018-05-22T19:53:40Z,_m,QQ,1\n,,1,2018-05-22T19:53:50Z,_m,QQ,1\n,,1,2018-05-22T19:54:00Z,_m,QQ,1\n,,1,2018-05-22T19:54:10Z,_m,QQ,1\n,,1,2018-05-22T19:54:20Z,_m,QQ,1\n,,2,2018-05-22T19:53:00Z,_m,RR,1\n,,2,2018-05-22T19:53:10Z,_m,RR,1\n,,2,2018-05-22T19:53:20Z,_m,RR,1\n,,2,2018-05-22T19:53:30Z,_m,RR,1\n,,3,2018-05-22T19:53:40Z,_m,SR,1\n,,3,2018-05-22T19:53:50Z,_m,SR,1\n,,3,2018-05-22T19:54:00Z,_m,SR,1\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   64,
					},
					File:   "second_time_test.flux",
					Source: "outData = \"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:10Z,10\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:20Z,20\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:30Z,30\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,40\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:20Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:30Z,30\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:40Z,40\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:00Z,0\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:10Z,10\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:40Z,40\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:50Z,50\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,0\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   37,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   37,
						},
						File:   "second_time_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   37,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   64,
						},
						File:   "second_time_test.flux",
						Source: "\"\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:10Z,10\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:20Z,20\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:30Z,30\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,40\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:20Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:30Z,30\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:40Z,40\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:00Z,0\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:10Z,10\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:40Z,40\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:50Z,50\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,0\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   37,
						},
					},
				},
				Value: "\n#group,false,false,true,true,true,true,false,false\n#datatype,string,long,dateTime:RFC3339,dateTime:RFC3339,string,string,dateTime:RFC3339,long\n#default,_result,,,,,,,\n,result,table,_start,_stop,_field,_measurement,_time,_value\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:00Z,0\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:10Z,10\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:20Z,20\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:30Z,30\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:40Z,40\n,,0,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,FF,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:20Z,20\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:30Z,30\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:40Z,40\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:53:50Z,50\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:00Z,0\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:10Z,10\n,,1,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,QQ,_m,2018-05-22T19:54:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:00Z,0\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:10Z,10\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:20Z,20\n,,2,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,RR,_m,2018-05-22T19:53:30Z,30\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:40Z,40\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:53:50Z,50\n,,3,2018-01-01T00:00:00Z,2030-01-01T00:00:00Z,SR,_m,2018-05-22T19:54:00Z,0\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 66,
						Line:   67,
					},
					File:   "second_time_test.flux",
					Source: "t_time_second = (table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.second(t: r._time)}))",
					Start: ast.Position{
						Column: 1,
						Line:   65,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   65,
						},
						File:   "second_time_test.flux",
						Source: "t_time_second",
						Start: ast.Position{
							Column: 1,
							Line:   65,
						},
					},
				},
				Name: "t_time_second",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 66,
							Line:   67,
						},
						File:   "second_time_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.second(t: r._time)}))",
						Start: ast.Position{
							Column: 17,
							Line:   65,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   65,
									},
									File:   "second_time_test.flux",
									Source: "table",
									Start: ast.Position{
										Column: 31,
										Line:   65,
									},
								},
							},
							Name: "table",
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   66,
								},
								File:   "second_time_test.flux",
								Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)",
								Start: ast.Position{
									Column: 31,
									Line:   65,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   66,
										},
										File:   "second_time_test.flux",
										Source: "start: 2018-01-01T00:00:00Z",
										Start: ast.Position{
											Column: 14,
											Line:   66,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   66,
											},
											File:   "second_time_test.flux",
											Source: "start: 2018-01-01T00:00:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   66,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   66,
												},
												File:   "second_time_test.flux",
												Source: "start",
												Start: ast.Position{
													Column: 14,
													Line:   66,
												},
											},
										},
										Name: "start",
									},
									Separator: nil,
									Value: &ast.DateTimeLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   66,
												},
												File:   "second_time_test.flux",
												Source: "2018-01-01T00:00:00Z",
												Start: ast.Position{
													Column: 21,
													Line:   66,
												},
											},
										},
										Value: parser.MustParseTime("2018-01-01T00:00:00Z"),
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   66,
									},
									File:   "second_time_test.flux",
									Source: "range(start: 2018-01-01T00:00:00Z)",
									Start: ast.Position{
										Column: 8,
										Line:   66,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 13,
											Line:   66,
										},
										File:   "second_time_test.flux",
										Source: "range",
										Start: ast.Position{
											Column: 8,
											Line:   66,
										},
									},
								},
								Name: "range",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 66,
								Line:   67,
							},
							File:   "second_time_test.flux",
							Source: "table\n    |> range(start: 2018-01-01T00:00:00Z)\n    |> map(fn: (r) => ({r with _value: date.second(t: r._time)}))",
							Start: ast.Position{
								Column: 31,
								Line:   65,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 65,
										Line:   67,
									},
									File:   "second_time_test.flux",
									Source: "fn: (r) => ({r with _value: date.second(t: r._time)})",
									Start: ast.Position{
										Column: 12,
										Line:   67,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 65,
											Line:   67,
										},
										File:   "second_time_test.flux",
										Source: "fn: (r) => ({r with _value: date.second(t: r._time)})",
										Start: ast.Position{
											Column: 12,
											Line:   67,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   67,
											},
											File:   "second_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   67,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 65,
												Line:   67,
											},
											File:   "second_time_test.flux",
											Source: "(r) => ({r with _value: date.second(t: r._time)})",
											Start: ast.Position{
												Column: 16,
												Line:   67,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   67,
												},
												File:   "second_time_test.flux",
												Source: "({r with _value: date.second(t: r._time)})",
												Start: ast.Position{
													Column: 23,
													Line:   67,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 64,
														Line:   67,
													},
													File:   "second_time_test.flux",
													Source: "{r with _value: date.second(t: r._time)}",
													Start: ast.Position{
														Column: 24,
														Line:   67,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 63,
															Line:   67,
														},
														File:   "second_time_test.flux",
														Source: "_value: date.second(t: r._time)",
														Start: ast.Position{
															Column: 32,
															Line:   67,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   67,
															},
															File:   "second_time_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   67,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 62,
																	Line:   67,
																},
																File:   "second_time_test.flux",
																Source: "t: r._time",
																Start: ast.Position{
																	Column: 52,
																	Line:   67,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 62,
																		Line:   67,
																	},
																	File:   "second_time_test.flux",
																	Source: "t: r._time",
																	Start: ast.Position{
																		Column: 52,
																		Line:   67,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 53,
																			Line:   67,
																		},
																		File:   "second_time_test.flux",
																		Source: "t",
																		Start: ast.Position{
																			Column: 52,
																			Line:   67,
																		},
																	},
																},
																Name: "t",
															},
															Separator: nil,
															Value: &ast.MemberExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 62,
																			Line:   67,
																		},
																		File:   "second_time_test.flux",
																		Source: "r._time",
																		Start: ast.Position{
																			Column: 55,
																			Line:   67,
																		},
																	},
																},
																Lbrack: nil,
																Object: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 56,
																				Line:   67,
																			},
																			File:   "second_time_test.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 55,
																				Line:   67,
																			},
																		},
																	},
																	Name: "r",
																},
																Property: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 62,
																				Line:   67,
																			},
																			File:   "second_time_test.flux",
																			Source: "_time",
																			Start: ast.Position{
																				Column: 57,
																				Line:   67,
																			},
																		},
																	},
																	Name: "_time",
																},
																Rbrack: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 63,
																Line:   67,
															},
															File:   "second_time_test.flux",
															Source: "date.second(t: r._time)",
															Start: ast.Position{
																Column: 40,
																Line:   67,
															},
														},
													},
													Callee: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 51,
																	Line:   67,
																},
																File:   "second_time_test.flux",
																Source: "date.second",
																Start: ast.Position{
																	Column: 40,
																	Line:   67,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 44,
																		Line:   67,
																	},
																	File:   "second_time_test.flux",
																	Source: "date",
																	Start: ast.Position{
																		Column: 40,
																		Line:   67,
																	},
																},
															},
															Name: "date",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 51,
																		Line:   67,
																	},
																	File:   "second_time_test.flux",
																	Source: "second",
																	Start: ast.Position{
																		Column: 45,
																		Line:   67,
																	},
																},
															},
															Name: "second",
														},
														Rbrack: nil,
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   67,
														},
														File:   "second_time_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   67,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   67,
												},
												File:   "second_time_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   67,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   67,
													},
													File:   "second_time_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   67,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 66,
									Line:   67,
								},
								File:   "second_time_test.flux",
								Source: "map(fn: (r) => ({r with _value: date.second(t: r._time)}))",
								Start: ast.Position{
									Column: 8,
									Line:   67,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   67,
									},
									File:   "second_time_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   67,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   65,
							},
							File:   "second_time_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 18,
								Line:   65,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   65,
								},
								File:   "second_time_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 18,
									Line:   65,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 26,
								Line:   65,
							},
							File:   "second_time_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 24,
								Line:   65,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 126,
							Line:   69,
						},
						File:   "second_time_test.flux",
						Source: "_time_second = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_second})",
						Start: ast.Position{
							Column: 6,
							Line:   69,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   69,
							},
							File:   "second_time_test.flux",
							Source: "_time_second",
							Start: ast.Position{
								Column: 6,
								Line:   69,
							},
						},
					},
					Name: "_time_second",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 126,
								Line:   69,
							},
							File:   "second_time_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_second})",
							Start: ast.Position{
								Column: 21,
								Line:   69,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 126,
									Line:   69,
								},
								File:   "second_time_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_second})",
								Start: ast.Position{
									Column: 27,
									Line:   69,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 125,
										Line:   69,
									},
									File:   "second_time_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_second}",
									Start: ast.Position{
										Column: 28,
										Line:   69,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 68,
											Line:   69,
										},
										File:   "second_time_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 29,
											Line:   69,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   69,
											},
											File:   "second_time_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 29,
												Line:   69,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 67,
													Line:   69,
												},
												File:   "second_time_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 56,
													Line:   69,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 67,
														Line:   69,
													},
													File:   "second_time_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 56,
														Line:   69,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 59,
															Line:   69,
														},
														File:   "second_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 56,
															Line:   69,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 67,
															Line:   69,
														},
														File:   "second_time_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 61,
															Line:   69,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 68,
												Line:   69,
											},
											File:   "second_time_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 36,
												Line:   69,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 55,
													Line:   69,
												},
												File:   "second_time_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 36,
													Line:   69,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 43,
														Line:   69,
													},
													File:   "second_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 36,
														Line:   69,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 55,
														Line:   69,
													},
													File:   "second_time_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 44,
														Line:   69,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 105,
											Line:   69,
										},
										File:   "second_time_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 70,
											Line:   69,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   69,
											},
											File:   "second_time_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 70,
												Line:   69,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 104,
													Line:   69,
												},
												File:   "second_time_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 92,
													Line:   69,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 104,
														Line:   69,
													},
													File:   "second_time_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 92,
														Line:   69,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 95,
															Line:   69,
														},
														File:   "second_time_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 92,
															Line:   69,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 104,
															Line:   69,
														},
														File:   "second_time_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 97,
															Line:   69,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 105,
												Line:   69,
											},
											File:   "second_time_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 76,
												Line:   69,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 91,
													Line:   69,
												},
												File:   "second_time_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 76,
													Line:   69,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 83,
														Line:   69,
													},
													File:   "second_time_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 76,
														Line:   69,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 91,
														Line:   69,
													},
													File:   "second_time_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 84,
														Line:   69,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 124,
											Line:   69,
										},
										File:   "second_time_test.flux",
										Source: "fn: t_time_second",
										Start: ast.Position{
											Column: 107,
											Line:   69,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 109,
												Line:   69,
											},
											File:   "second_time_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 107,
												Line:   69,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 124,
												Line:   69,
											},
											File:   "second_time_test.flux",
											Source: "t_time_second",
											Start: ast.Position{
												Column: 111,
												Line:   69,
											},
										},
									},
									Name: "t_time_second",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 126,
						Line:   69,
					},
					File:   "second_time_test.flux",
					Source: "test _time_second = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_second})",
					Start: ast.Position{
						Column: 1,
						Line:   69,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "second_time_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "second_time_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "second_time_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "second_time_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "second_time_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "second_time_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "second_time_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 138,
					Line:   40,
				},
				File:   "truncate_duration_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00.000000000Z,_m,FF,-3600000000000\n,,0,2018-05-22T19:53:10.000000000Z,_m,FF,-7200000000000\n,,0,2018-05-22T19:53:20.000000000Z,_m,FF,-10800000000000\n,,0,2018-05-22T19:53:30.000000000Z,_m,FF,0\n,,0,2018-05-22T19:53:40.000000000Z,_m,FF,3600000000000\n,,0,2018-05-22T19:53:50.000000000Z,_m,FF,7200000000000\n,,0,2018-05-22T19:54:00.000000000Z,_m,FF,10800000000000\n\"\noutData = \"\n#datatype,string,long,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_field,_measurement,_time,_value\n,,0,FF,_m,2018-05-22T19:53:00.000000000Z,1893452400000000000\n,,0,FF,_m,2018-05-22T19:53:10.000000000Z,1893448800000000000\n,,0,FF,_m,2018-05-22T19:53:20.000000000Z,1893445200000000000\n,,0,FF,_m,2018-05-22T19:53:30.000000000Z,1893456000000000000\n,,0,FF,_m,2018-05-22T19:53:40.000000000Z,1893459600000000000\n,,0,FF,_m,2018-05-22T19:53:50.000000000Z,1893463200000000000\n,,0,FF,_m,2018-05-22T19:54:00.000000000Z,1893466800000000000\n\"\nt_duration_truncate = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> map(fn: (r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))}))\n\ntest _duration_truncate = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_truncate})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   7,
						},
						File:   "truncate_duration_test.flux",
						Source: "now = () => 2030-01-01T00:00:00Z",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 11,
								Line:   7,
							},
							File:   "truncate_duration_test.flux",
							Source: "now",
							Start: ast.Position{
								Column: 8,
								Line:   7,
							},
						},
					},
					Name: "now",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   7,
							},
							File:   "truncate_duration_test.flux",
							Source: "() => 2030-01-01T00:00:00Z",
							Start: ast.Position{
								Column: 14,
								Line:   7,
							},
						},
					},
					Body: &ast.DateTimeLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   7,
								},
								File:   "truncate_duration_test.flux",
								Source: "2030-01-01T00:00:00Z",
								Start: ast.Position{
									Column: 20,
									Line:   7,
								},
							},
						},
						Value: parser.MustParseTime("2030-01-01T00:00:00Z"),
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 40,
						Line:   7,
					},
					File:   "truncate_duration_test.flux",
					Source: "option now = () => 2030-01-01T00:00:00Z",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   21,
					},
					File:   "truncate_duration_test.flux",
					Source: "inData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00.000000000Z,_m,FF,-3600000000000\n,,0,2018-05-22T19:53:10.000000000Z,_m,FF,-7200000000000\n,,0,2018-05-22T19:53:20.000000000Z,_m,FF,-10800000000000\n,,0,2018-05-22T19:53:30.000000000Z,_m,FF,0\n,,0,2018-05-22T19:53:40.000000000Z,_m,FF,3600000000000\n,,0,2018-05-22T19:53:50.000000000Z,_m,FF,7200000000000\n,,0,2018-05-22T19:54:00.000000000Z,_m,FF,10800000000000\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   9,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   9,
						},
						File:   "truncate_duration_test.flux",
						Source: "inData",
						Start: ast.Position{
							Column: 1,
							Line:   9,
						},
					},
				},
				Name: "inData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   21,
						},
						File:   "truncate_duration_test.flux",
						Source: "\"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00.000000000Z,_m,FF,-3600000000000\n,,0,2018-05-22T19:53:10.000000000Z,_m,FF,-7200000000000\n,,0,2018-05-22T19:53:20.000000000Z,_m,FF,-10800000000000\n,,0,2018-05-22T19:53:30.000000000Z,_m,FF,0\n,,0,2018-05-22T19:53:40.000000000Z,_m,FF,3600000000000\n,,0,2018-05-22T19:53:50.000000000Z,_m,FF,7200000000000\n,,0,2018-05-22T19:54:00.000000000Z,_m,FF,10800000000000\n\"",
						Start: ast.Position{
							Column: 10,
							Line:   9,
						},
					},
				},
				Value: "\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00.000000000Z,_m,FF,-3600000000000\n,,0,2018-05-22T19:53:10.000000000Z,_m,FF,-7200000000000\n,,0,2018-05-22T19:53:20.000000000Z,_m,FF,-10800000000000\n,,0,2018-05-22T19:53:30.000000000Z,_m,FF,0\n,,0,2018-05-22T19:53:40.000000000Z,_m,FF,3600000000000\n,,0,2018-05-22T19:53:50.000000000Z,_m,FF,7200000000000\n,,0,2018-05-22T19:54:00.000000000Z,_m,FF,10800000000000\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   34,
					},
					File:   "truncate_duration_test.flux",
					Source: "outData = \"\n#datatype,string,long,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_field,_measurement,_time,_value\n,,0,FF,_m,2018-05-22T19:53:00.000000000Z,1893452400000000000\n,,0,FF,_m,2018-05-22T19:53:10.000000000Z,1893448800000000000\n,,0,FF,_m,2018-05-22T19:53:20.000000000Z,1893445200000000000\n,,0,FF,_m,2018-05-22T19:53:30.000000000Z,1893456000000000000\n,,0,FF,_m,2018-05-22T19:53:40.000000000Z,1893459600000000000\n,,0,FF,_m,2018-05-22T19:53:50.000000000Z,1893463200000000000\n,,0,FF,_m,2018-05-22T19:54:00.000000000Z,1893466800000000000\n\"",
					Start: ast.Position{
						Column: 1,
						Line:   22,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   22,
						},
						File:   "truncate_duration_test.flux",
						Source: "outData",
						Start: ast.Position{
							Column: 1,
							Line:   22,
						},
					},
				},
				Name: "outData",
			},
			Init: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   34,
						},
						File:   "truncate_duration_test.flux",
						Source: "\"\n#datatype,string,long,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_field,_measurement,_time,_value\n,,0,FF,_m,2018-05-22T19:53:00.000000000Z,1893452400000000000\n,,0,FF,_m,2018-05-22T19:53:10.000000000Z,1893448800000000000\n,,0,FF,_m,2018-05-22T19:53:20.000000000Z,1893445200000000000\n,,0,FF,_m,2018-05-22T19:53:30.000000000Z,1893456000000000000\n,,0,FF,_m,2018-05-22T19:53:40.000000000Z,1893459600000000000\n,,0,FF,_m,2018-05-22T19:53:50.000000000Z,1893463200000000000\n,,0,FF,_m,2018-05-22T19:54:00.000000000Z,1893466800000000000\n\"",
						Start: ast.Position{
							Column: 11,
							Line:   22,
						},
					},
				},
				Value: "\n#datatype,string,long,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_field,_measurement,_time,_value\n,,0,FF,_m,2018-05-22T19:53:00.000000000Z,1893452400000000000\n,,0,FF,_m,2018-05-22T19:53:10.000000000Z,1893448800000000000\n,,0,FF,_m,2018-05-22T19:53:20.000000000Z,1893445200000000000\n,,0,FF,_m,2018-05-22T19:53:30.000000000Z,1893456000000000000\n,,0,FF,_m,2018-05-22T19:53:40.000000000Z,1893459600000000000\n,,0,FF,_m,2018-05-22T19:53:50.000000000Z,1893463200000000000\n,,0,FF,_m,2018-05-22T19:54:00.000000000Z,1893466800000000000\n",
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 100,
						Line:   38,
					},
					File:   "truncate_duration_test.flux",
					Source: "t_duration_truncate = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> map(fn: (r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))}))",
					Start: ast.Position{
						Column: 1,
						Line:   35,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   35,
						},
						File:   "truncate_duration_test.flux",
						Source: "t_duration_truncate",
						Start: ast.Position{
							Column: 1,
							Line:   35,
						},
					},
				},
				Name: "t_duration_truncate",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 100,
							Line:   38,
						},
						File:   "truncate_duration_test.flux",
						Source: "(table=<-) => table\n    |> range(start: 2018-05-22T19:53:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> map(fn: (r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))}))",
						Start: ast.Position{
							Column: 23,
							Line:   35,
						},
					},
				},
				Body: &ast.PipeExpression{
					Argument: &ast.PipeExpression{
						Argument: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   35,
										},
										File:   "truncate_duration_test.flux",
										Source: "table",
										Start: ast.Position{
											Column: 37,
											Line:   35,
										},
									},
								},
								Name: "table",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   36,
									},
									File:   "truncate_duration_test.flux",
									Source: "table\n    |> range(start: 2018-05-22T19:53:00Z)",
									Start: ast.Position{
										Column: 37,
										Line:   35,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   36,
											},
											File:   "truncate_duration_test.flux",
											Source: "start: 2018-05-22T19:53:00Z",
											Start: ast.Position{
												Column: 14,
												Line:   36,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   36,
												},
												File:   "truncate_duration_test.flux",
												Source: "start: 2018-05-22T19:53:00Z",
												Start: ast.Position{
													Column: 14,
													Line:   36,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   36,
													},
													File:   "truncate_duration_test.flux",
													Source: "start",
													Start: ast.Position{
														Column: 14,
														Line:   36,
													},
												},
											},
											Name: "start",
										},
										Separator: nil,
										Value: &ast.DateTimeLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   36,
													},
													File:   "truncate_duration_test.flux",
													Source: "2018-05-22T19:53:00Z",
													Start: ast.Position{
														Column: 21,
														Line:   36,
													},
												},
											},
											Value: parser.MustParseTime("2018-05-22T19:53:00Z"),
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   36,
										},
										File:   "truncate_duration_test.flux",
										Source: "range(start: 2018-05-22T19:53:00Z)",
										Start: ast.Position{
											Column: 8,
											Line:   36,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   36,
											},
											File:   "truncate_duration_test.flux",
											Source: "range",
											Start: ast.Position{
												Column: 8,
												Line:   36,
											},
										},
									},
									Name: "range",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   37,
								},
								File:   "truncate_duration_test.flux",
								Source: "table\n    |> range(start: 2018-05-22T19:53:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])",
								Start: ast.Position{
									Column: 37,
									Line:   35,
								},
							},
						},
						Call: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   37,
										},
										File:   "truncate_duration_test.flux",
										Source: "columns: [\"_start\", \"_stop\"]",
										Start: ast.Position{
											Column: 13,
											Line:   37,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 41,
												Line:   37,
											},
											File:   "truncate_duration_test.flux",
											Source: "columns: [\"_start\", \"_stop\"]",
											Start: ast.Position{
												Column: 13,
												Line:   37,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   37,
												},
												File:   "truncate_duration_test.flux",
												Source: "columns",
												Start: ast.Position{
													Column: 13,
													Line:   37,
												},
											},
										},
										Name: "columns",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   37,
												},
												File:   "truncate_duration_test.flux",
												Source: "[\"_start\", \"_stop\"]",
												Start: ast.Position{
													Column: 22,
													Line:   37,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   37,
													},
													File:   "truncate_duration_test.flux",
													Source: "\"_start\"",
													Start: ast.Position{
														Column: 23,
														Line:   37,
													},
												},
											},
											Value: "_start",
										}, &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   37,
													},
													File:   "truncate_duration_test.flux",
													Source: "\"_stop\"",
													Start: ast.Position{
														Column: 33,
														Line:   37,
													},
												},
											},
											Value: "_stop",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   37,
									},
									File:   "truncate_duration_test.flux",
									Source: "drop(columns: [\"_start\", \"_stop\"])",
									Start: ast.Position{
										Column: 8,
										Line:   37,
									},
								},
							},
							Callee: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 12,
											Line:   37,
										},
										File:   "truncate_duration_test.flux",
										Source: "drop",
										Start: ast.Position{
											Column: 8,
											Line:   37,
										},
									},
								},
								Name: "drop",
							},
							Lparen: nil,
							Rparen: nil,
						},
					},
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 100,
								Line:   38,
							},
							File:   "truncate_duration_test.flux",
							Source: "table\n    |> range(start: 2018-05-22T19:53:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> map(fn: (r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))}))",
							Start: ast.Position{
								Column: 37,
								Line:   35,
							},
						},
					},
					Call: &ast.CallExpression{
						Arguments: []ast.Expression{&ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 99,
										Line:   38,
									},
									File:   "truncate_duration_test.flux",
									Source: "fn: (r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))})",
									Start: ast.Position{
										Column: 12,
										Line:   38,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 99,
											Line:   38,
										},
										File:   "truncate_duration_test.flux",
										Source: "fn: (r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))})",
										Start: ast.Position{
											Column: 12,
											Line:   38,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 14,
												Line:   38,
											},
											File:   "truncate_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 12,
												Line:   38,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.FunctionExpression{
									Arrow: nil,
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 99,
												Line:   38,
											},
											File:   "truncate_duration_test.flux",
											Source: "(r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))})",
											Start: ast.Position{
												Column: 16,
												Line:   38,
											},
										},
									},
									Body: &ast.ParenExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 99,
													Line:   38,
												},
												File:   "truncate_duration_test.flux",
												Source: "({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))})",
												Start: ast.Position{
													Column: 23,
													Line:   38,
												},
											},
										},
										Expression: &ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 98,
														Line:   38,
													},
													File:   "truncate_duration_test.flux",
													Source: "{r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))}",
													Start: ast.Position{
														Column: 24,
														Line:   38,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 97,
															Line:   38,
														},
														File:   "truncate_duration_test.flux",
														Source: "_value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))",
														Start: ast.Position{
															Column: 32,
															Line:   38,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 38,
																Line:   38,
															},
															File:   "truncate_duration_test.flux",
															Source: "_value",
															Start: ast.Position{
																Column: 32,
																Line:   38,
															},
														},
													},
													Name: "_value",
												},
												Separator: nil,
												Value: &ast.CallExpression{
													Arguments: []ast.Expression{&ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 96,
																	Line:   38,
																},
																File:   "truncate_duration_test.flux",
																Source: "v: date.truncate(t: duration(v: r._value), unit: 1s)",
																Start: ast.Position{
																	Column: 44,
																	Line:   38,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 96,
																		Line:   38,
																	},
																	File:   "truncate_duration_test.flux",
																	Source: "v: date.truncate(t: duration(v: r._value), unit: 1s)",
																	Start: ast.Position{
																		Column: 44,
																		Line:   38,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 45,
																			Line:   38,
																		},
																		File:   "truncate_duration_test.flux",
																		Source: "v",
																		Start: ast.Position{
																			Column: 44,
																			Line:   38,
																		},
																	},
																},
																Name: "v",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 95,
																				Line:   38,
																			},
																			File:   "truncate_duration_test.flux",
																			Source: "t: duration(v: r._value), unit: 1s",
																			Start: ast.Position{
																				Column: 61,
																				Line:   38,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 85,
																					Line:   38,
																				},
																				File:   "truncate_duration_test.flux",
																				Source: "t: duration(v: r._value)",
																				Start: ast.Position{
																					Column: 61,
																					Line:   38,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 62,
																						Line:   38,
																					},
																					File:   "truncate_duration_test.flux",
																					Source: "t",
																					Start: ast.Position{
																						Column: 61,
																						Line:   38,
																					},
																				},
																			},
																			Name: "t",
																		},
																		Separator: nil,
																		Value: &ast.CallExpression{
																			Arguments: []ast.Expression{&ast.ObjectExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 84,
																							Line:   38,
																						},
																						File:   "truncate_duration_test.flux",
																						Source: "v: r._value",
																						Start: ast.Position{
																							Column: 73,
																							Line:   38,
																						},
																					},
																				},
																				Lbrace: nil,
																				Properties: []*ast.Property{&ast.Property{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 84,
																								Line:   38,
																							},
																							File:   "truncate_duration_test.flux",
																							Source: "v: r._value",
																							Start: ast.Position{
																								Column: 73,
																								Line:   38,
																							},
																						},
																					},
																					Comma: nil,
																					Key: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 74,
																									Line:   38,
																								},
																								File:   "truncate_duration_test.flux",
																								Source: "v",
																								Start: ast.Position{
																									Column: 73,
																									Line:   38,
																								},
																							},
																						},
																						Name: "v",
																					},
																					Separator: nil,
																					Value: &ast.MemberExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 84,
																									Line:   38,
																								},
																								File:   "truncate_duration_test.flux",
																								Source: "r._value",
																								Start: ast.Position{
																									Column: 76,
																									Line:   38,
																								},
																							},
																						},
																						Lbrack: nil,
																						Object: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 77,
																										Line:   38,
																									},
																									File:   "truncate_duration_test.flux",
																									Source: "r",
																									Start: ast.Position{
																										Column: 76,
																										Line:   38,
																									},
																								},
																							},
																							Name: "r",
																						},
																						Property: &ast.Identifier{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 84,
																										Line:   38,
																									},
																									File:   "truncate_duration_test.flux",
																									Source: "_value",
																									Start: ast.Position{
																										Column: 78,
																										Line:   38,
																									},
																								},
																							},
																							Name: "_value",
																						},
																						Rbrack: nil,
																					},
																				}},
																				Rbrace: nil,
																				With:   nil,
																			}},
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 85,
																						Line:   38,
																					},
																					File:   "truncate_duration_test.flux",
																					Source: "duration(v: r._value)",
																					Start: ast.Position{
																						Column: 64,
																						Line:   38,
																					},
																				},
																			},
																			Callee: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 72,
																							Line:   38,
																						},
																						File:   "truncate_duration_test.flux",
																						Source: "duration",
																						Start: ast.Position{
																							Column: 64,
																							Line:   38,
																						},
																					},
																				},
																				Name: "duration",
																			},
																			Lparen: nil,
																			Rparen: nil,
																		},
																	}, &ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 95,
																					Line:   38,
																				},
																				File:   "truncate_duration_test.flux",
																				Source: "unit: 1s",
																				Start: ast.Position{
																					Column: 87,
																					Line:   38,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 91,
																						Line:   38,
																					},
																					File:   "truncate_duration_test.flux",
																					Source: "unit",
																					Start: ast.Position{
																						Column: 87,
																						Line:   38,
																					},
																				},
																			},
																			Name: "unit",
																		},
																		Separator: nil,
																		Value: &ast.DurationLiteral{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 95,
																						Line:   38,
																					},
																					File:   "truncate_duration_test.flux",
																					Source: "1s",
																					Start: ast.Position{
																						Column: 93,
																						Line:   38,
																					},
																				},
																			},
																			Values: []ast.Duration{ast.Duration{
																				Magnitude: int64(1),
																				Unit:      "s",
																			}},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 96,
																			Line:   38,
																		},
																		File:   "truncate_duration_test.flux",
																		Source: "date.truncate(t: duration(v: r._value), unit: 1s)",
																		Start: ast.Position{
																			Column: 47,
																			Line:   38,
																		},
																	},
																},
																Callee: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 60,
																				Line:   38,
																			},
																			File:   "truncate_duration_test.flux",
																			Source: "date.truncate",
																			Start: ast.Position{
																				Column: 47,
																				Line:   38,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 51,
																					Line:   38,
																				},
																				File:   "truncate_duration_test.flux",
																				Source: "date",
																				Start: ast.Position{
																					Column: 47,
																					Line:   38,
																				},
																			},
																		},
																		Name: "date",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 60,
																					Line:   38,
																				},
																				File:   "truncate_duration_test.flux",
																				Source: "truncate",
																				Start: ast.Position{
																					Column: 52,
																					Line:   38,
																				},
																			},
																		},
																		Name: "truncate",
																	},
																	Rbrack: nil,
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With:   nil,
													}},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 97,
																Line:   38,
															},
															File:   "truncate_duration_test.flux",
															Source: "int(v: date.truncate(t: duration(v: r._value), unit: 1s))",
															Start: ast.Position{
																Column: 40,
																Line:   38,
															},
														},
													},
													Callee: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 43,
																	Line:   38,
																},
																File:   "truncate_duration_test.flux",
																Source: "int",
																Start: ast.Position{
																	Column: 40,
																	Line:   38,
																},
															},
														},
														Name: "int",
													},
													Lparen: nil,
													Rparen: nil,
												},
											}},
											Rbrace: nil,
											With: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 26,
															Line:   38,
														},
														File:   "truncate_duration_test.flux",
														Source: "r",
														Start: ast.Position{
															Column: 25,
															Line:   38,
														},
													},
												},
												Name: "r",
											},
										},
										Lparen: nil,
										Rparen: nil,
									},
									Lparen: nil,
									Params: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   38,
												},
												File:   "truncate_duration_test.flux",
												Source: "r",
												Start: ast.Position{
													Column: 17,
													Line:   38,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 18,
														Line:   38,
													},
													File:   "truncate_duration_test.flux",
													Source: "r",
													Start: ast.Position{
														Column: 17,
														Line:   38,
													},
												},
											},
											Name: "r",
										},
										Separator: nil,
										Value:     nil,
									}},
									Rparan: nil,
								},
							}},
							Rbrace: nil,
							With:   nil,
						}},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 100,
									Line:   38,
								},
								File:   "truncate_duration_test.flux",
								Source: "map(fn: (r) => ({r with _value: int(v: date.truncate(t: duration(v: r._value), unit: 1s))}))",
								Start: ast.Position{
									Column: 8,
									Line:   38,
								},
							},
						},
						Callee: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 11,
										Line:   38,
									},
									File:   "truncate_duration_test.flux",
									Source: "map",
									Start: ast.Position{
										Column: 8,
										Line:   38,
									},
								},
							},
							Name: "map",
						},
						Lparen: nil,
						Rparen: nil,
					},
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   35,
							},
							File:   "truncate_duration_test.flux",
							Source: "table=<-",
							Start: ast.Position{
								Column: 24,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   35,
								},
								File:   "truncate_duration_test.flux",
								Source: "table",
								Start: ast.Position{
									Column: 24,
									Line:   35,
								},
							},
						},
						Name: "table",
					},
					Separator: nil,
					Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   35,
							},
							File:   "truncate_duration_test.flux",
							Source: "<-",
							Start: ast.Position{
								Column: 30,
								Line:   35,
							},
						},
					}},
				}},
				Rparan: nil,
			},
		}, &ast.TestStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 138,
							Line:   40,
						},
						File:   "truncate_duration_test.flux",
						Source: "_duration_truncate = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_truncate})",
						Start: ast.Position{
							Column: 6,
							Line:   40,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 24,
								Line:   40,
							},
							File:   "truncate_duration_test.flux",
							Source: "_duration_truncate",
							Start: ast.Position{
								Column: 6,
								Line:   40,
							},
						},
					},
					Name: "_duration_truncate",
				},
				Init: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 138,
								Line:   40,
							},
							File:   "truncate_duration_test.flux",
							Source: "() => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_truncate})",
							Start: ast.Position{
								Column: 27,
								Line:   40,
							},
						},
					},
					Body: &ast.ParenExpression{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 138,
									Line:   40,
								},
								File:   "truncate_duration_test.flux",
								Source: "({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_truncate})",
								Start: ast.Position{
									Column: 33,
									Line:   40,
								},
							},
						},
						Expression: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 137,
										Line:   40,
									},
									File:   "truncate_duration_test.flux",
									Source: "{input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_truncate}",
									Start: ast.Position{
										Column: 34,
										Line:   40,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   40,
										},
										File:   "truncate_duration_test.flux",
										Source: "input: testing.loadStorage(csv: inData)",
										Start: ast.Position{
											Column: 35,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   40,
											},
											File:   "truncate_duration_test.flux",
											Source: "input",
											Start: ast.Position{
												Column: 35,
												Line:   40,
											},
										},
									},
									Name: "input",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 73,
													Line:   40,
												},
												File:   "truncate_duration_test.flux",
												Source: "csv: inData",
												Start: ast.Position{
													Column: 62,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 73,
														Line:   40,
													},
													File:   "truncate_duration_test.flux",
													Source: "csv: inData",
													Start: ast.Position{
														Column: 62,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   40,
														},
														File:   "truncate_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 62,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 73,
															Line:   40,
														},
														File:   "truncate_duration_test.flux",
														Source: "inData",
														Start: ast.Position{
															Column: 67,
															Line:   40,
														},
													},
												},
												Name: "inData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 74,
												Line:   40,
											},
											File:   "truncate_duration_test.flux",
											Source: "testing.loadStorage(csv: inData)",
											Start: ast.Position{
												Column: 42,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   40,
												},
												File:   "truncate_duration_test.flux",
												Source: "testing.loadStorage",
												Start: ast.Position{
													Column: 42,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 49,
														Line:   40,
													},
													File:   "truncate_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 42,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   40,
													},
													File:   "truncate_duration_test.flux",
													Source: "loadStorage",
													Start: ast.Position{
														Column: 50,
														Line:   40,
													},
												},
											},
											Name: "loadStorage",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 111,
											Line:   40,
										},
										File:   "truncate_duration_test.flux",
										Source: "want: testing.loadMem(csv: outData)",
										Start: ast.Position{
											Column: 76,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 80,
												Line:   40,
											},
											File:   "truncate_duration_test.flux",
											Source: "want",
											Start: ast.Position{
												Column: 76,
												Line:   40,
											},
										},
									},
									Name: "want",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 110,
													Line:   40,
												},
												File:   "truncate_duration_test.flux",
												Source: "csv: outData",
												Start: ast.Position{
													Column: 98,
													Line:   40,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 110,
														Line:   40,
													},
													File:   "truncate_duration_test.flux",
													Source: "csv: outData",
													Start: ast.Position{
														Column: 98,
														Line:   40,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 101,
															Line:   40,
														},
														File:   "truncate_duration_test.flux",
														Source: "csv",
														Start: ast.Position{
															Column: 98,
															Line:   40,
														},
													},
												},
												Name: "csv",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 110,
															Line:   40,
														},
														File:   "truncate_duration_test.flux",
														Source: "outData",
														Start: ast.Position{
															Column: 103,
															Line:   40,
														},
													},
												},
												Name: "outData",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 111,
												Line:   40,
											},
											File:   "truncate_duration_test.flux",
											Source: "testing.loadMem(csv: outData)",
											Start: ast.Position{
												Column: 82,
												Line:   40,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 97,
													Line:   40,
												},
												File:   "truncate_duration_test.flux",
												Source: "testing.loadMem",
												Start: ast.Position{
													Column: 82,
													Line:   40,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 89,
														Line:   40,
													},
													File:   "truncate_duration_test.flux",
													Source: "testing",
													Start: ast.Position{
														Column: 82,
														Line:   40,
													},
												},
											},
											Name: "testing",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 97,
														Line:   40,
													},
													File:   "truncate_duration_test.flux",
													Source: "loadMem",
													Start: ast.Position{
														Column: 90,
														Line:   40,
													},
												},
											},
											Name: "loadMem",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 136,
											Line:   40,
										},
										File:   "truncate_duration_test.flux",
										Source: "fn: t_duration_truncate",
										Start: ast.Position{
											Column: 113,
											Line:   40,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 115,
												Line:   40,
											},
											File:   "truncate_duration_test.flux",
											Source: "fn",
											Start: ast.Position{
												Column: 113,
												Line:   40,
											},
										},
									},
									Name: "fn",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 136,
												Line:   40,
											},
											File:   "truncate_duration_test.flux",
											Source: "t_duration_truncate",
											Start: ast.Position{
												Column: 117,
												Line:   40,
											},
										},
									},
									Name: "t_duration_truncate",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
						Lparen: nil,
						Rparen: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{},
					Rparan: nil,
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 138,
						Line:   40,
					},
					File:   "truncate_duration_test.flux",
					Source: "test _duration_truncate = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_duration_truncate})",
					Start: ast.Position{
						Column: 1,
						Line:   40,
					},
				},
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   4,
					},
					File:   "truncate_duration_test.flux",
					Source: "import \"testing\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   4,
						},
						File:   "truncate_duration_test.flux",
						Source: "\"testing\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "testing",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "truncate_duration_test.flux",
					Source: "import \"date\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "truncate_duration_test.flux",
						Source: "\"date\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "date",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "truncate_duration_test.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   1,
					},
					File:   "truncate_duration_test.flux",
					Source: "package date_test",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   1,
						},
						File:   "truncate_duration_test.flux",
						Source: "date_test",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "date_test",
			},
		},
	}, &ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 130,
					Line:   38,
				},
				File:   "truncate_time_test.flux",
				Source: "package date_test\n\n\nimport \"testing\"\nimport \"date\"\n\noption now = () => 2030-01-01T00:00:00Z\n\ninData = \"\n#datatype,string,long,dateTime:RFC3339,string,string,long\n#group,false,false,false,true,true,false\n#default,_result,,,,,\n,result,table,_time,_measurement,_field,_value\n,,0,2018-05-22T19:53:00.000000000Z,_m,FF,1\n,,0,2018-05-22T19:53:10.000000000Z,_m,FF,1\n,,0,2018-05-22T19:53:20.000000000Z,_m,FF,1\n,,0,2018-05-22T19:53:30.000000000Z,_m,FF,1\n,,0,2018-05-22T19:53:40.000000000Z,_m,FF,1\n,,0,2018-05-22T19:53:50.000000000Z,_m,FF,1\n\"\noutData = \"\n#datatype,string,long,string,string,dateTime:RFC3339,long\n#group,false,false,true,true,false,false\n#default,_result,,,,,\n,result,table,_field,_measurement,_time,_value\n,,0,FF,_m,2018-05-22T19:00:00.000000000Z,1\n,,0,FF,_m,2018-05-22T19:00:00.000000000Z,1\n,,0,FF,_m,2018-05-22T19:00:00.000000000Z,1\n,,0,FF,_m,2018-05-22T19:00:00.000000000Z,1\n,,0,FF,_m,2018-05-22T19:00:00.000000000Z,1\n,,0,FF,_m,2018-05-22T19:00:00.000000000Z,1\n\"\nt_time_truncate = (table=<-) => table\n    |> range(start: 2018-05-22T19:53:00Z)\n    |> drop(columns: [\"_start\", \"_stop\"])\n    |> map(fn: (r) => ({r with _time: date.truncate(t: r._time, unit: 1h)}))\n\ntest _time_truncate = () => ({input: testing.loadStorage(csv: inData), want: testing.loadMem(csv: outData), fn: t_time_truncate})",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
					