// DO NOT EDIT: This file is autogenerated via the builtin command.

package http

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 62,
					Line:   109,
				},
				File:   "http.flux",
				Source: "package http\n\n\nimport \"experimental\"\n\n// post submits an HTTP POST request to the specified URL with headers and data\n// and returns the HTTP Status Code\n//\n// ## Parameters\n//\n// - `url` is the URL to POST to\n// - `headers` are the headers to include with the POST request\n//\n//      Header keys with special characters:\n//          Wrap header keys that contain special characters in double quotes (\"\").\n//\n// - `data` is the data body to include with the POST request\n//\n// ## Send the last reported status to a URL\n//\n// ```\n// import \"json\"\n// import \"http\"\n//\n// lastReported =\n//  from(bucket: \"example-bucket\")\n//    |> range(start: -1m)\n//    |> filter(fn: (r) => r._measurement == \"statuses\")\n//    |> last()\n//    |> findColumn(fn: (key) => true, column: \"_level\")\n//\n//  http.post(\n//  url: \"http://myawsomeurl.com/api/notify\",\n//  headers: {\n//    Authorization: \"Bearer mySuPerSecRetTokEn\",\n//    \"Content-type\": \"application/json\"\n//  },\n//  data: json.encode(v: lastReported[0])\n// )\n// ```\n//\nbuiltin post : (url: string, ?headers: A, ?data: bytes) => int where A: Record\n\n// basicAuth returns a Base64-encoded basic authentication header\n// using a specified username and password combination.\n//\n// ## Parameters\n//\n// - `u` is the username to use in the basic authentication header.\n// - `p` is the password to use in the basic authentication header.\n//\n// ## Set a basic authentication header in an HTTP POST request\n//\n// ```\n// import \"json\"\n//\n// from(bucket: \"example-bucket\")\n//   |> range(start: -1h)\n//   |> map(fn: (r) => ({\n//       r with _value: json.encode(v: r._value)\n//   }))\n// ```\n//\nbuiltin basicAuth : (u: string, p: string) => string\n\n// pathEscape() escapes special characters in a string (including /)\n// and replaces non-ASCII characters with hexadecimal representations (%XX).\n//\n// ## Parameters\n//\n// - `inputString` is the string to escape.\n//\n// ## Set a basic authentication header in an HTTP POST request\n//\n// ```\n// import \"http\"\n//\n// data\n//   |> map(fn: (r) => ({ r with\n//     path: http.pathEscape(inputString: r.path)\n//   }))\n// ```\n//\nbuiltin pathEscape : (inputString: string) => string\n\n// endpoint sends output data\n// to an HTTP URL using the POST request method.\n//\n// ## Parameters\n//\n// - `url` is the URL to POST to.\n// - `mapFn` is a function that builds the record used to generate the POST request.\n//     - mapFn accepts a table row (r) and returns a record that must include the following fields:\n//          - `headers`\n//          - `data`\n//\n// See influxdata/influxdb/monitor.notify\nendpoint = (url) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(v: 200 == post(url: url, headers: obj.headers, data: obj.data)),\n            }\n        },\n    )\n    |> experimental.group(mode: \"extend\", columns: [\"_sent\"])",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// post submits an HTTP POST request to the specified URL with headers and data\n"}, ast.Comment{Text: "// and returns the HTTP Status Code\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `url` is the URL to POST to\n"}, ast.Comment{Text: "// - `headers` are the headers to include with the POST request\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Header keys with special characters:\n"}, ast.Comment{Text: "//          Wrap header keys that contain special characters in double quotes (\"\").\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `data` is the data body to include with the POST request\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Send the last reported status to a URL\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"json\"\n"}, ast.Comment{Text: "// import \"http\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// lastReported =\n"}, ast.Comment{Text: "//  from(bucket: \"example-bucket\")\n"}, ast.Comment{Text: "//    |> range(start: -1m)\n"}, ast.Comment{Text: "//    |> filter(fn: (r) => r._measurement == \"statuses\")\n"}, ast.Comment{Text: "//    |> last()\n"}, ast.Comment{Text: "//    |> findColumn(fn: (key) => true, column: \"_level\")\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//  http.post(\n"}, ast.Comment{Text: "//  url: \"http://myawsomeurl.com/api/notify\",\n"}, ast.Comment{Text: "//  headers: {\n"}, ast.Comment{Text: "//    Authorization: \"Bearer mySuPerSecRetTokEn\",\n"}, ast.Comment{Text: "//    \"Content-type\": \"application/json\"\n"}, ast.Comment{Text: "//  },\n"}, ast.Comment{Text: "//  data: json.encode(v: lastReported[0])\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   43,
					},
					File:   "http.flux",
					Source: "builtin post",
					Start: ast.Position{
						Column: 1,
						Line:   43,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   43,
						},
						File:   "http.flux",
						Source: "post",
						Start: ast.Position{
							Column: 9,
							Line:   43,
						},
					},
				},
				Name: "post",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 79,
							Line:   43,
						},
						File:   "http.flux",
						Source: "(url: string, ?headers: A, ?data: bytes) => int where A: Record",
						Start: ast.Position{
							Column: 16,
							Line:   43,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 79,
								Line:   43,
							},
							File:   "http.flux",
							Source: "A: Record",
							Start: ast.Position{
								Column: 70,
								Line:   43,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 79,
									Line:   43,
								},
								File:   "http.flux",
								Source: "Record",
								Start: ast.Position{
									Column: 73,
									Line:   43,
								},
							},
						},
						Name: "Record",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   43,
								},
								File:   "http.flux",
								Source: "A",
								Start: ast.Position{
									Column: 70,
									Line:   43,
								},
							},
						},
						Name: "A",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 63,
								Line:   43,
							},
							File:   "http.flux",
							Source: "(url: string, ?headers: A, ?data: bytes) => int",
							Start: ast.Position{
								Column: 16,
								Line:   43,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   43,
								},
								File:   "http.flux",
								Source: "url: string",
								Start: ast.Position{
									Column: 17,
									Line:   43,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   43,
									},
									File:   "http.flux",
									Source: "url",
									Start: ast.Position{
										Column: 17,
										Line:   43,
									},
								},
							},
							Name: "url",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   43,
									},
									File:   "http.flux",
									Source: "string",
									Start: ast.Position{
										Column: 22,
										Line:   43,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   43,
										},
										File:   "http.flux",
										Source: "string",
										Start: ast.Position{
											Column: 22,
											Line:   43,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   43,
								},
								File:   "http.flux",
								Source: "?headers: A",
								Start: ast.Position{
									Column: 30,
									Line:   43,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   43,
									},
									File:   "http.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 31,
										Line:   43,
									},
								},
							},
							Name: "headers",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   43,
									},
									File:   "http.flux",
									Source: "A",
									Start: ast.Position{
										Column: 40,
										Line:   43,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   43,
										},
										File:   "http.flux",
										Source: "A",
										Start: ast.Position{
											Column: 40,
											Line:   43,
										},
									},
								},
								Name: "A",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 55,
									Line:   43,
								},
								File:   "http.flux",
								Source: "?data: bytes",
								Start: ast.Position{
									Column: 43,
									Line:   43,
								},
							},
						},
						Kind: "Optional",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   43,
									},
									File:   "http.flux",
									Source: "data",
									Start: ast.Position{
										Column: 44,
										Line:   43,
									},
								},
							},
							Name: "data",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 55,
										Line:   43,
									},
									File:   "http.flux",
									Source: "bytes",
									Start: ast.Position{
										Column: 50,
										Line:   43,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 55,
											Line:   43,
										},
										File:   "http.flux",
										Source: "bytes",
										Start: ast.Position{
											Column: 50,
											Line:   43,
										},
									},
								},
								Name: "bytes",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 63,
									Line:   43,
								},
								File:   "http.flux",
								Source: "int",
								Start: ast.Position{
									Column: 60,
									Line:   43,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   43,
									},
									File:   "http.flux",
									Source: "int",
									Start: ast.Position{
										Column: 60,
										Line:   43,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// basicAuth returns a Base64-encoded basic authentication header\n"}, ast.Comment{Text: "// using a specified username and password combination.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `u` is the username to use in the basic authentication header.\n"}, ast.Comment{Text: "// - `p` is the password to use in the basic authentication header.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Set a basic authentication header in an HTTP POST request\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"json\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// from(bucket: \"example-bucket\")\n"}, ast.Comment{Text: "//   |> range(start: -1h)\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with _value: json.encode(v: r._value)\n"}, ast.Comment{Text: "//   }))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   65,
					},
					File:   "http.flux",
					Source: "builtin basicAuth",
					Start: ast.Position{
						Column: 1,
						Line:   65,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   65,
						},
						File:   "http.flux",
						Source: "basicAuth",
						Start: ast.Position{
							Column: 9,
							Line:   65,
						},
					},
				},
				Name: "basicAuth",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 53,
							Line:   65,
						},
						File:   "http.flux",
						Source: "(u: string, p: string) => string",
						Start: ast.Position{
							Column: 21,
							Line:   65,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   65,
							},
							File:   "http.flux",
							Source: "(u: string, p: string) => string",
							Start: ast.Position{
								Column: 21,
								Line:   65,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   65,
								},
								File:   "http.flux",
								Source: "u: string",
								Start: ast.Position{
									Column: 22,
									Line:   65,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   65,
									},
									File:   "http.flux",
									Source: "u",
									Start: ast.Position{
										Column: 22,
										Line:   65,
									},
								},
							},
							Name: "u",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   65,
									},
									File:   "http.flux",
									Source: "string",
									Start: ast.Position{
										Column: 25,
										Line:   65,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   65,
										},
										File:   "http.flux",
										Source: "string",
										Start: ast.Position{
											Column: 25,
											Line:   65,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   65,
								},
								File:   "http.flux",
								Source: "p: string",
								Start: ast.Position{
									Column: 33,
									Line:   65,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   65,
									},
									File:   "http.flux",
									Source: "p",
									Start: ast.Position{
										Column: 33,
										Line:   65,
									},
								},
							},
							Name: "p",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   65,
									},
									File:   "http.flux",
									Source: "string",
									Start: ast.Position{
										Column: 36,
										Line:   65,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   65,
										},
										File:   "http.flux",
										Source: "string",
										Start: ast.Position{
											Column: 36,
											Line:   65,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   65,
								},
								File:   "http.flux",
								Source: "string",
								Start: ast.Position{
									Column: 47,
									Line:   65,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   65,
									},
									File:   "http.flux",
									Source: "string",
									Start: ast.Position{
										Column: 47,
										Line:   65,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// pathEscape() escapes special characters in a string (including /)\n"}, ast.Comment{Text: "// and replaces non-ASCII characters with hexadecimal representations (%XX).\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `inputString` is the string to escape.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Set a basic authentication header in an HTTP POST request\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"http\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({ r with\n"}, ast.Comment{Text: "//     path: http.pathEscape(inputString: r.path)\n"}, ast.Comment{Text: "//   }))\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   85,
					},
					File:   "http.flux",
					Source: "builtin pathEscape",
					Start: ast.Position{
						Column: 1,
						Line:   85,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   85,
						},
						File:   "http.flux",
						Source: "pathEscape",
						Start: ast.Position{
							Column: 9,
							Line:   85,
						},
					},
				},
				Name: "pathEscape",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 53,
							Line:   85,
						},
						File:   "http.flux",
						Source: "(inputString: string) => string",
						Start: ast.Position{
							Column: 22,
							Line:   85,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   85,
							},
							File:   "http.flux",
							Source: "(inputString: string) => string",
							Start: ast.Position{
								Column: 22,
								Line:   85,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   85,
								},
								File:   "http.flux",
								Source: "inputString: string",
								Start: ast.Position{
									Column: 23,
									Line:   85,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 34,
										Line:   85,
									},
									File:   "http.flux",
									Source: "inputString",
									Start: ast.Position{
										Column: 23,
										Line:   85,
									},
								},
							},
							Name: "inputString",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   85,
									},
									File:   "http.flux",
									Source: "string",
									Start: ast.Position{
										Column: 36,
										Line:   85,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 42,
											Line:   85,
										},
										File:   "http.flux",
										Source: "string",
										Start: ast.Position{
											Column: 36,
											Line:   85,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   85,
								},
								File:   "http.flux",
								Source: "string",
								Start: ast.Position{
									Column: 47,
									Line:   85,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 53,
										Line:   85,
									},
									File:   "http.flux",
									Source: "string",
									Start: ast.Position{
										Column: 47,
										Line:   85,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 62,
						Line:   109,
					},
					File:   "http.flux",
					Source: "endpoint = (url) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(v: 200 == post(url: url, headers: obj.headers, data: obj.data)),\n            }\n        },\n    )\n    |> experimental.group(mode: \"extend\", columns: [\"_sent\"])",
					Start: ast.Position{
						Column: 1,
						Line:   99,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// endpoint sends output data\n"}, ast.Comment{Text: "// to an HTTP URL using the POST request method.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `url` is the URL to POST to.\n"}, ast.Comment{Text: "// - `mapFn` is a function that builds the record used to generate the POST request.\n"}, ast.Comment{Text: "//     - mapFn accepts a table row (r) and returns a record that must include the following fields:\n"}, ast.Comment{Text: "//          - `headers`\n"}, ast.Comment{Text: "//          - `data`\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// See influxdata/influxdb/monitor.notify\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   99,
						},
						File:   "http.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   99,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 62,
							Line:   109,
						},
						File:   "http.flux",
						Source: "(url) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(v: 200 == post(url: url, headers: obj.headers, data: obj.data)),\n            }\n        },\n    )\n    |> experimental.group(mode: \"extend\", columns: [\"_sent\"])",
						Start: ast.Position{
							Column: 12,
							Line:   99,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 62,
								Line:   109,
							},
							File:   "http.flux",
							Source: "(mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(v: 200 == post(url: url, headers: obj.headers, data: obj.data)),\n            }\n        },\n    )\n    |> experimental.group(mode: \"extend\", columns: [\"_sent\"])",
							Start: ast.Position{
								Column: 21,
								Line:   99,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 62,
									Line:   109,
								},
								File:   "http.flux",
								Source: "(tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(v: 200 == post(url: url, headers: obj.headers, data: obj.data)),\n            }\n        },\n    )\n    |> experimental.group(mode: \"extend\", columns: [\"_sent\"])",
								Start: ast.Position{
									Column: 32,
									Line:   99,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.PipeExpression{
								Argument: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 53,
												Line:   99,
											},
											File:   "http.flux",
											Source: "tables",
											Start: ast.Position{
												Column: 47,
												Line:   99,
											},
										},
									},
									Name: "tables",
								},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   108,
										},
										File:   "http.flux",
										Source: "tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(v: 200 == post(url: url, headers: obj.headers, data: obj.data)),\n            }\n        },\n    )",
										Start: ast.Position{
											Column: 47,
											Line:   99,
										},
									},
								},
								Call: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   107,
												},
												File:   "http.flux",
												Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(v: 200 == post(url: url, headers: obj.headers, data: obj.data)),\n            }\n        }",
												Start: ast.Position{
													Column: 9,
													Line:   101,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   107,
													},
													File:   "http.flux",
													Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(v: 200 == post(url: url, headers: obj.headers, data: obj.data)),\n            }\n        }",
													Start: ast.Position{
														Column: 9,
														Line:   101,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 11,
															Line:   101,
														},
														File:   "http.flux",
														Source: "fn",
														Start: ast.Position{
															Column: 9,
															Line:   101,
														},
													},
												},
												Name: "fn",
											},
											Separator: nil,
											Value: &ast.FunctionExpression{
												Arrow: nil,
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   107,
														},
														File:   "http.flux",
														Source: "(r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(v: 200 == post(url: url, headers: obj.headers, data: obj.data)),\n            }\n        }",
														Start: ast.Position{
															Column: 13,
															Line:   101,
														},
													},
												},
												Body: &ast.Block{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 10,
																Line:   107,
															},
															File:   "http.flux",
															Source: "{\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(v: 200 == post(url: url, headers: obj.headers, data: obj.data)),\n            }\n        }",
															Start: ast.Position{
																Column: 20,
																Line:   101,
															},
														},
													},
													Body: []ast.Statement{&ast.VariableAssignment{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   102,
																},
																File:   "http.flux",
																Source: "obj = mapFn(r: r)",
																Start: ast.Position{
																	Column: 13,
																	Line:   102,
																},
															},
														},
														ID: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 16,
																		Line:   102,
																	},
																	File:   "http.flux",
																	Source: "obj",
																	Start: ast.Position{
																		Column: 13,
																		Line:   102,
																	},
																},
															},
															Name: "obj",
														},
														Init: &ast.CallExpression{
															Arguments: []ast.Expression{&ast.ObjectExpression{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   102,
																		},
																		File:   "http.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 25,
																			Line:   102,
																		},
																	},
																},
																Lbrace: nil,
																Properties: []*ast.Property{&ast.Property{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   102,
																			},
																			File:   "http.flux",
																			Source: "r: r",
																			Start: ast.Position{
																				Column: 25,
																				Line:   102,
																			},
																		},
																	},
																	Comma: nil,
																	Key: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 26,
																					Line:   102,
																				},
																				File:   "http.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 25,
																					Line:   102,
																				},
																			},
																		},
																		Name: "r",
																	},
																	Separator: nil,
																	Value: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 29,
																					Line:   102,
																				},
																				File:   "http.flux",
																				Source: "r",
																				Start: ast.Position{
																					Column: 28,
																					Line:   102,
																				},
																			},
																		},
																		Name: "r",
																	},
																}},
																Rbrace: nil,
																With:   nil,
															}},
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   102,
																	},
																	File:   "http.flux",
																	Source: "mapFn(r: r)",
																	Start: ast.Position{
																		Column: 19,
																		Line:   102,
																	},
																},
															},
															Callee: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 24,
																			Line:   102,
																		},
																		File:   "http.flux",
																		Source: "mapFn",
																		Start: ast.Position{
																			Column: 19,
																			Line:   102,
																		},
																	},
																},
																Name: "mapFn",
															},
															Lparen: nil,
															Rparen: nil,
														},
													}, &ast.ReturnStatement{
														Argument: &ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 14,
																		Line:   106,
																	},
																	File:   "http.flux",
																	Source: "{r with\n                _sent: string(v: 200 == post(url: url, headers: obj.headers, data: obj.data)),\n            }",
																	Start: ast.Position{
																		Column: 20,
																		Line:   104,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 94,
																			Line:   105,
																		},
																		File:   "http.flux",
																		Source: "_sent: string(v: 200 == post(url: url, headers: obj.headers, data: obj.data))",
																		Start: ast.Position{
																			Column: 17,
																			Line:   105,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 22,
																				Line:   105,
																			},
																			File:   "http.flux",
																			Source: "_sent",
																			Start: ast.Position{
																				Column: 17,
																				Line:   105,
																			},
																		},
																	},
																	Name: "_sent",
																},
																Separator: nil,
																Value: &ast.CallExpression{
																	Arguments: []ast.Expression{&ast.ObjectExpression{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 93,
																					Line:   105,
																				},
																				File:   "http.flux",
																				Source: "v: 200 == post(url: url, headers: obj.headers, data: obj.data)",
																				Start: ast.Position{
																					Column: 31,
																					Line:   105,
																				},
																			},
																		},
																		Lbrace: nil,
																		Properties: []*ast.Property{&ast.Property{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 93,
																						Line:   105,
																					},
																					File:   "http.flux",
																					Source: "v: 200 == post(url: url, headers: obj.headers, data: obj.data)",
																					Start: ast.Position{
																						Column: 31,
																						Line:   105,
																					},
																				},
																			},
																			Comma: nil,
																			Key: &ast.Identifier{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 32,
																							Line:   105,
																						},
																						File:   "http.flux",
																						Source: "v",
																						Start: ast.Position{
																							Column: 31,
																							Line:   105,
																						},
																					},
																				},
																				Name: "v",
																			},
																			Separator: nil,
																			Value: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 93,
																							Line:   105,
																						},
																						File:   "http.flux",
																						Source: "200 == post(url: url, headers: obj.headers, data: obj.data)",
																						Start: ast.Position{
																							Column: 34,
																							Line:   105,
																						},
																					},
																				},
																				Left: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 37,
																								Line:   105,
																							},
																							File:   "http.flux",
																							Source: "200",
																							Start: ast.Position{
																								Column: 34,
																								Line:   105,
																							},
																						},
																					},
																					Value: int64(200),
																				},
																				Operator: 17,
																				Right: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 92,
																									Line:   105,
																								},
																								File:   "http.flux",
																								Source: "url: url, headers: obj.headers, data: obj.data",
																								Start: ast.Position{
																									Column: 46,
																									Line:   105,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 54,
																										Line:   105,
																									},
																									File:   "http.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 46,
																										Line:   105,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 49,
																											Line:   105,
																										},
																										File:   "http.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 46,
																											Line:   105,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 54,
																											Line:   105,
																										},
																										File:   "http.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 51,
																											Line:   105,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 76,
																										Line:   105,
																									},
																									File:   "http.flux",
																									Source: "headers: obj.headers",
																									Start: ast.Position{
																										Column: 56,
																										Line:   105,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 63,
																											Line:   105,
																										},
																										File:   "http.flux",
																										Source: "headers",
																										Start: ast.Position{
																											Column: 56,
																											Line:   105,
																										},
																									},
																								},
																								Name: "headers",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 76,
																											Line:   105,
																										},
																										File:   "http.flux",
																										Source: "obj.headers",
																										Start: ast.Position{
																											Column: 65,
																											Line:   105,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 68,
																												Line:   105,
																											},
																											File:   "http.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 65,
																												Line:   105,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 76,
																												Line:   105,
																											},
																											File:   "http.flux",
																											Source: "headers",
																											Start: ast.Position{
																												Column: 69,
																												Line:   105,
																											},
																										},
																									},
																									Name: "headers",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 92,
																										Line:   105,
																									},
																									File:   "http.flux",
																									Source: "data: obj.data",
																									Start: ast.Position{
																										Column: 78,
																										Line:   105,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 82,
																											Line:   105,
																										},
																										File:   "http.flux",
																										Source: "data",
																										Start: ast.Position{
																											Column: 78,
																											Line:   105,
																										},
																									},
																								},
																								Name: "data",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 92,
																											Line:   105,
																										},
																										File:   "http.flux",
																										Source: "obj.data",
																										Start: ast.Position{
																											Column: 84,
																											Line:   105,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 87,
																												Line:   105,
																											},
																											File:   "http.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 84,
																												Line:   105,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 92,
																												Line:   105,
																											},
																											File:   "http.flux",
																											Source: "data",
																											Start: ast.Position{
																												Column: 88,
																												Line:   105,
																											},
																										},
																									},
																									Name: "data",
																								},
																								Rbrack: nil,
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 93,
																								Line:   105,
																							},
																							File:   "http.flux",
																							Source: "post(url: url, headers: obj.headers, data: obj.data)",
																							Start: ast.Position{
																								Column: 41,
																								Line:   105,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 45,
																									Line:   105,
																								},
																								File:   "http.flux",
																								Source: "post",
																								Start: ast.Position{
																									Column: 41,
																									Line:   105,
																								},
																							},
																						},
																						Name: "post",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																			},
																		}},
																		Rbrace: nil,
																		With:   nil,
																	}},
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 94,
																				Line:   105,
																			},
																			File:   "http.flux",
																			Source: "string(v: 200 == post(url: url, headers: obj.headers, data: obj.data))",
																			Start: ast.Position{
																				Column: 24,
																				Line:   105,
																			},
																		},
																	},
																	Callee: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 30,
																					Line:   105,
																				},
																				File:   "http.flux",
																				Source: "string",
																				Start: ast.Position{
																					Column: 24,
																					Line:   105,
																				},
																			},
																		},
																		Name: "string",
																	},
																	Lparen: nil,
																	Rparen: nil,
																},
															}},
															Rbrace: nil,
															With: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   104,
																		},
																		File:   "http.flux",
																		Source: "r",
																		Start: ast.Position{
																			Column: 21,
																			Line:   104,
																		},
																	},
																},
																Name: "r",
															},
														},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   106,
																},
																File:   "http.flux",
																Source: "return {r with\n                _sent: string(v: 200 == post(url: url, headers: obj.headers, data: obj.data)),\n            }",
																Start: ast.Position{
																	Column: 13,
																	Line:   104,
																},
															},
														},
													}},
													Lbrace: nil,
													Rbrace: nil,
												},
												Lparen: nil,
												Params: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   101,
															},
															File:   "http.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   101,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 15,
																	Line:   101,
																},
																File:   "http.flux",
																Source: "r",
																Start: ast.Position{
																	Column: 14,
																	Line:   101,
																},
															},
														},
														Name: "r",
													},
													Separator: nil,
													Value:     nil,
												}},
												Rparan: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 6,
												Line:   108,
											},
											File:   "http.flux",
											Source: "map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(v: 200 == post(url: url, headers: obj.headers, data: obj.data)),\n            }\n        },\n    )",
											Start: ast.Position{
												Column: 8,
												Line:   100,
											},
										},
									},
									Callee: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 11,
													Line:   100,
												},
												File:   "http.flux",
												Source: "map",
												Start: ast.Position{
													Column: 8,
													Line:   100,
												},
											},
										},
										Name: "map",
									},
									Lparen: nil,
									Rparen: nil,
								},
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 62,
										Line:   109,
									},
									File:   "http.flux",
									Source: "tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(v: 200 == post(url: url, headers: obj.headers, data: obj.data)),\n            }\n        },\n    )\n    |> experimental.group(mode: \"extend\", columns: [\"_sent\"])",
									Start: ast.Position{
										Column: 47,
										Line:   99,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 61,
												Line:   109,
											},
											File:   "http.flux",
											Source: "mode: \"extend\", columns: [\"_sent\"]",
											Start: ast.Position{
												Column: 27,
												Line:   109,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 41,
													Line:   109,
												},
												File:   "http.flux",
												Source: "mode: \"extend\"",
												Start: ast.Position{
													Column: 27,
													Line:   109,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 31,
														Line:   109,
													},
													File:   "http.flux",
													Source: "mode",
													Start: ast.Position{
														Column: 27,
														Line:   109,
													},
												},
											},
											Name: "mode",
										},
										Separator: nil,
										Value: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 41,
														Line:   109,
													},
													File:   "http.flux",
													Source: "\"extend\"",
													Start: ast.Position{
														Column: 33,
														Line:   109,
													},
												},
											},
											Value: "extend",
										},
									}, &ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 61,
													Line:   109,
												},
												File:   "http.flux",
												Source: "columns: [\"_sent\"]",
												Start: ast.Position{
													Column: 43,
													Line:   109,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 50,
														Line:   109,
													},
													File:   "http.flux",
													Source: "columns",
													Start: ast.Position{
														Column: 43,
														Line:   109,
													},
												},
											},
											Name: "columns",
										},
										Separator: nil,
										Value: &ast.ArrayExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 61,
														Line:   109,
													},
													File:   "http.flux",
													Source: "[\"_sent\"]",
													Start: ast.Position{
														Column: 52,
														Line:   109,
													},
												},
											},
											Elements: []ast.Expression{&ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 60,
															Line:   109,
														},
														File:   "http.flux",
														Source: "\"_sent\"",
														Start: ast.Position{
															Column: 53,
															Line:   109,
														},
													},
												},
												Value: "_sent",
											}},
											Lbrack: nil,
											Rbrack: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 62,
											Line:   109,
										},
										File:   "http.flux",
										Source: "experimental.group(mode: \"extend\", columns: [\"_sent\"])",
										Start: ast.Position{
											Column: 8,
											Line:   109,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 26,
												Line:   109,
											},
											File:   "http.flux",
											Source: "experimental.group",
											Start: ast.Position{
												Column: 8,
												Line:   109,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 20,
													Line:   109,
												},
												File:   "http.flux",
												Source: "experimental",
												Start: ast.Position{
													Column: 8,
													Line:   109,
												},
											},
										},
										Name: "experimental",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 26,
													Line:   109,
												},
												File:   "http.flux",
												Source: "group",
												Start: ast.Position{
													Column: 21,
													Line:   109,
												},
											},
										},
										Name: "group",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   99,
									},
									File:   "http.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 33,
										Line:   99,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   99,
										},
										File:   "http.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 33,
											Line:   99,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   99,
									},
									File:   "http.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 40,
										Line:   99,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   99,
								},
								File:   "http.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 22,
									Line:   99,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   99,
									},
									File:   "http.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 22,
										Line:   99,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   99,
							},
							File:   "http.flux",
							Source: "url",
							Start: ast.Position{
								Column: 13,
								Line:   99,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   99,
								},
								File:   "http.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   99,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 22,
						Line:   5,
					},
					File:   "http.flux",
					Source: "import \"experimental\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 22,
							Line:   5,
						},
						File:   "http.flux",
						Source: "\"experimental\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "experimental",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "http.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Package http provides functions for transferring data using the HTTP protocol.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   2,
					},
					File:   "http.flux",
					Source: "package http",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   2,
						},
						File:   "http.flux",
						Source: "http",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "http",
			},
		},
	}},
	Package: "http",
	Path:    "http",
}
