// DO NOT EDIT: This file is autogenerated via the builtin command.

package slack

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 6,
					Line:   142,
				},
				File:   "slack.flux",
				Source: "package slack\n\n\nimport \"http\"\nimport \"json\"\n\nbuiltin validateColorString : (color: string) => string\n\noption defaultURL = \"https://slack.com/api/chat.postMessage\"\n\n// message sends a single message to a Slack channel.\n// The function works with either with the chat.postMessage API or with a Slack webhook.\n//\n// ## Parameters\n//\n// - `url` is the URL of the slack endpoint.\n//\n//      Defaults to: \"https://slack.com/api/chat.postMessage\", if one uses the webhook api this must be acquired as part of the slack API setup.\n//      This URL will be secret. Don't worry about secrets for the initial implementation.\n//\n// - `token` is the api token string.\n//\n//      Defaults to: \"\", and can be ignored if one uses the webhook api URL.\n//\n// - `channel` is the name of channel in which to post the message. No default.\n// - `text` is the text to display.\n// - `color` is the color to give message: one of good, warning, and danger, or any hex rgb color value ex. #439FE0.\n//\n// ## Send the last reported status to Slack using a Slack webhook\n//\n// ```\n// import \"slack\"\n//\n// lastReported =\n//   from(bucket: \"example-bucket\")\n//     |> range(start: -1m)\n//     |> filter(fn: (r) => r._measurement == \"statuses\")\n//     |> last()\n//     |> findRecord(fn: (key) => true, idx: 0)\n//\n// slack.message(\n//   url: \"https://hooks.slack.com/services/EXAMPLE-WEBHOOK-URL\",\n//   channel: \"#system-status\",\n//   text: \"The last reported status was \\\"${lastReported.status}\\\".\"\n//   color: \"warning\"\n// )\n// ```\n//\n// ## Send the last reported status to Slack using chat.postMessage API\n//\n// ```\n// import \"slack\"\n//\n// lastReported =\n//   from(bucket: \"example-bucket\")\n//     |> range(start: -1m)\n//     |> filter(fn: (r) => r._measurement == \"statuses\")\n//     |> tableFind(fn: (key) => true)\n//     |> getRecord(idx: 0)\n//\n// slack.message(\n//   url: \"https://slack.com/api/chat.postMessage\",\n//   token: \"mySuPerSecRetTokEn\",\n//   channel: \"#system-status\",\n//   text: \"The last reported status was \\\"${lastReported.status}\\\".\"\n//   color: \"warning\"\n// )\n// ```\n//\nmessage = (\n        url=defaultURL,\n        token=\"\",\n        channel,\n        text,\n        color,\n) => {\n    attachments = [\n        {color: validateColorString(color), text: string(v: text), mrkdwn_in: [\"text\"]},\n    ]\n    data = {\n        channel: channel,\n        attachments: attachments,\n    }\n    headers = {\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url, data: enc)\n}\n\n// endpoint sends a message to Slack that includes output data.\n//\n// ## Parameters\n//\n// - `url` is the API URL of the slack endpoint. Defaults to https://slack.com/api/chat.postMessage.\n//\n//      If using a Slack webhook, you’ll receive a Slack webhook URL when you create an incoming webhook.\n//\n// - `token` is the Slack API token used to interact with Slack. Defaults to \"\".\n// - `Usage`: slack.endpoint is a factory function that outputs another function. The output function requires a mapFn parameter.\n// - `mapFn` is a function that builds the record used to generate the POST request. Requires an r parameter.\n//\n// ## Send critical statuses to a Slack endpoint\n//\n// ```\n// import \"slack\"\n//\n// toSlack = slack.endpoint(url: https://hooks.slack.com/services/EXAMPLE-WEBHOOK-URL)\n//\n// crit_statuses = from(bucket: \"example-bucket\")\n//   |> range(start: -1m)\n//   |> filter(fn: (r) => r._measurement == \"statuses\" and r.status == \"crit\")\n//\n// crit_statuses\n//   |> toSlack(mapFn: (r) => ({\n//       channel: \"Alerts\",\n//       text: r._message,\n//       color: \"danger\",\n//    })\n//   )()\n// ```\nendpoint = (url=defaultURL, token=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 28,
						Line:   8,
					},
					File:   "slack.flux",
					Source: "builtin validateColorString",
					Start: ast.Position{
						Column: 1,
						Line:   8,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 28,
							Line:   8,
						},
						File:   "slack.flux",
						Source: "validateColorString",
						Start: ast.Position{
							Column: 9,
							Line:   8,
						},
					},
				},
				Name: "validateColorString",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 56,
							Line:   8,
						},
						File:   "slack.flux",
						Source: "(color: string) => string",
						Start: ast.Position{
							Column: 31,
							Line:   8,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 56,
								Line:   8,
							},
							File:   "slack.flux",
							Source: "(color: string) => string",
							Start: ast.Position{
								Column: 31,
								Line:   8,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 45,
									Line:   8,
								},
								File:   "slack.flux",
								Source: "color: string",
								Start: ast.Position{
									Column: 32,
									Line:   8,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   8,
									},
									File:   "slack.flux",
									Source: "color",
									Start: ast.Position{
										Column: 32,
										Line:   8,
									},
								},
							},
							Name: "color",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 45,
										Line:   8,
									},
									File:   "slack.flux",
									Source: "string",
									Start: ast.Position{
										Column: 39,
										Line:   8,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 45,
											Line:   8,
										},
										File:   "slack.flux",
										Source: "string",
										Start: ast.Position{
											Column: 39,
											Line:   8,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 56,
									Line:   8,
								},
								File:   "slack.flux",
								Source: "string",
								Start: ast.Position{
									Column: 50,
									Line:   8,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 56,
										Line:   8,
									},
									File:   "slack.flux",
									Source: "string",
									Start: ast.Position{
										Column: 50,
										Line:   8,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.OptionStatement{
			Assignment: &ast.VariableAssignment{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 61,
							Line:   10,
						},
						File:   "slack.flux",
						Source: "defaultURL = \"https://slack.com/api/chat.postMessage\"",
						Start: ast.Position{
							Column: 8,
							Line:   10,
						},
					},
				},
				ID: &ast.Identifier{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   10,
							},
							File:   "slack.flux",
							Source: "defaultURL",
							Start: ast.Position{
								Column: 8,
								Line:   10,
							},
						},
					},
					Name: "defaultURL",
				},
				Init: &ast.StringLiteral{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 61,
								Line:   10,
							},
							File:   "slack.flux",
							Source: "\"https://slack.com/api/chat.postMessage\"",
							Start: ast.Position{
								Column: 21,
								Line:   10,
							},
						},
					},
					Value: "https://slack.com/api/chat.postMessage",
				},
			},
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 61,
						Line:   10,
					},
					File:   "slack.flux",
					Source: "option defaultURL = \"https://slack.com/api/chat.postMessage\"",
					Start: ast.Position{
						Column: 1,
						Line:   10,
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   92,
					},
					File:   "slack.flux",
					Source: "message = (\n        url=defaultURL,\n        token=\"\",\n        channel,\n        text,\n        color,\n) => {\n    attachments = [\n        {color: validateColorString(color), text: string(v: text), mrkdwn_in: [\"text\"]},\n    ]\n    data = {\n        channel: channel,\n        attachments: attachments,\n    }\n    headers = {\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url, data: enc)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   71,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// message sends a single message to a Slack channel.\n"}, ast.Comment{Text: "// The function works with either with the chat.postMessage API or with a Slack webhook.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `url` is the URL of the slack endpoint.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Defaults to: \"https://slack.com/api/chat.postMessage\", if one uses the webhook api this must be acquired as part of the slack API setup.\n"}, ast.Comment{Text: "//      This URL will be secret. Don't worry about secrets for the initial implementation.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `token` is the api token string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      Defaults to: \"\", and can be ignored if one uses the webhook api URL.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `channel` is the name of channel in which to post the message. No default.\n"}, ast.Comment{Text: "// - `text` is the text to display.\n"}, ast.Comment{Text: "// - `color` is the color to give message: one of good, warning, and danger, or any hex rgb color value ex. #439FE0.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Send the last reported status to Slack using a Slack webhook\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"slack\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// lastReported =\n"}, ast.Comment{Text: "//   from(bucket: \"example-bucket\")\n"}, ast.Comment{Text: "//     |> range(start: -1m)\n"}, ast.Comment{Text: "//     |> filter(fn: (r) => r._measurement == \"statuses\")\n"}, ast.Comment{Text: "//     |> last()\n"}, ast.Comment{Text: "//     |> findRecord(fn: (key) => true, idx: 0)\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// slack.message(\n"}, ast.Comment{Text: "//   url: \"https://hooks.slack.com/services/EXAMPLE-WEBHOOK-URL\",\n"}, ast.Comment{Text: "//   channel: \"#system-status\",\n"}, ast.Comment{Text: "//   text: \"The last reported status was \\\"${lastReported.status}\\\".\"\n"}, ast.Comment{Text: "//   color: \"warning\"\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Send the last reported status to Slack using chat.postMessage API\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"slack\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// lastReported =\n"}, ast.Comment{Text: "//   from(bucket: \"example-bucket\")\n"}, ast.Comment{Text: "//     |> range(start: -1m)\n"}, ast.Comment{Text: "//     |> filter(fn: (r) => r._measurement == \"statuses\")\n"}, ast.Comment{Text: "//     |> tableFind(fn: (key) => true)\n"}, ast.Comment{Text: "//     |> getRecord(idx: 0)\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// slack.message(\n"}, ast.Comment{Text: "//   url: \"https://slack.com/api/chat.postMessage\",\n"}, ast.Comment{Text: "//   token: \"mySuPerSecRetTokEn\",\n"}, ast.Comment{Text: "//   channel: \"#system-status\",\n"}, ast.Comment{Text: "//   text: \"The last reported status was \\\"${lastReported.status}\\\".\"\n"}, ast.Comment{Text: "//   color: \"warning\"\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   71,
						},
						File:   "slack.flux",
						Source: "message",
						Start: ast.Position{
							Column: 1,
							Line:   71,
						},
					},
				},
				Name: "message",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   92,
						},
						File:   "slack.flux",
						Source: "(\n        url=defaultURL,\n        token=\"\",\n        channel,\n        text,\n        color,\n) => {\n    attachments = [\n        {color: validateColorString(color), text: string(v: text), mrkdwn_in: [\"text\"]},\n    ]\n    data = {\n        channel: channel,\n        attachments: attachments,\n    }\n    headers = {\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url, data: enc)\n}",
						Start: ast.Position{
							Column: 11,
							Line:   71,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   92,
							},
							File:   "slack.flux",
							Source: "{\n    attachments = [\n        {color: validateColorString(color), text: string(v: text), mrkdwn_in: [\"text\"]},\n    ]\n    data = {\n        channel: channel,\n        attachments: attachments,\n    }\n    headers = {\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }\n    enc = json.encode(v: data)\n\n    return http.post(headers: headers, url: url, data: enc)\n}",
							Start: ast.Position{
								Column: 6,
								Line:   77,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   80,
								},
								File:   "slack.flux",
								Source: "attachments = [\n        {color: validateColorString(color), text: string(v: text), mrkdwn_in: [\"text\"]},\n    ]",
								Start: ast.Position{
									Column: 5,
									Line:   78,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 16,
										Line:   78,
									},
									File:   "slack.flux",
									Source: "attachments",
									Start: ast.Position{
										Column: 5,
										Line:   78,
									},
								},
							},
							Name: "attachments",
						},
						Init: &ast.ArrayExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   80,
									},
									File:   "slack.flux",
									Source: "[\n        {color: validateColorString(color), text: string(v: text), mrkdwn_in: [\"text\"]},\n    ]",
									Start: ast.Position{
										Column: 19,
										Line:   78,
									},
								},
							},
							Elements: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 88,
											Line:   79,
										},
										File:   "slack.flux",
										Source: "{color: validateColorString(color), text: string(v: text), mrkdwn_in: [\"text\"]}",
										Start: ast.Position{
											Column: 9,
											Line:   79,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   79,
											},
											File:   "slack.flux",
											Source: "color: validateColorString(color)",
											Start: ast.Position{
												Column: 10,
												Line:   79,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   79,
												},
												File:   "slack.flux",
												Source: "color",
												Start: ast.Position{
													Column: 10,
													Line:   79,
												},
											},
										},
										Name: "color",
									},
									Separator: nil,
									Value: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 42,
														Line:   79,
													},
													File:   "slack.flux",
													Source: "color",
													Start: ast.Position{
														Column: 37,
														Line:   79,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   79,
														},
														File:   "slack.flux",
														Source: "color",
														Start: ast.Position{
															Column: 37,
															Line:   79,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 42,
																Line:   79,
															},
															File:   "slack.flux",
															Source: "color",
															Start: ast.Position{
																Column: 37,
																Line:   79,
															},
														},
													},
													Name: "color",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   79,
												},
												File:   "slack.flux",
												Source: "validateColorString(color)",
												Start: ast.Position{
													Column: 17,
													Line:   79,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 36,
														Line:   79,
													},
													File:   "slack.flux",
													Source: "validateColorString",
													Start: ast.Position{
														Column: 17,
														Line:   79,
													},
												},
											},
											Name: "validateColorString",
										},
										Lparen: nil,
										Rparen: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   79,
											},
											File:   "slack.flux",
											Source: "text: string(v: text)",
											Start: ast.Position{
												Column: 45,
												Line:   79,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   79,
												},
												File:   "slack.flux",
												Source: "text",
												Start: ast.Position{
													Column: 45,
													Line:   79,
												},
											},
										},
										Name: "text",
									},
									Separator: nil,
									Value: &ast.CallExpression{
										Arguments: []ast.Expression{&ast.ObjectExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   79,
													},
													File:   "slack.flux",
													Source: "v: text",
													Start: ast.Position{
														Column: 58,
														Line:   79,
													},
												},
											},
											Lbrace: nil,
											Properties: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   79,
														},
														File:   "slack.flux",
														Source: "v: text",
														Start: ast.Position{
															Column: 58,
															Line:   79,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 59,
																Line:   79,
															},
															File:   "slack.flux",
															Source: "v",
															Start: ast.Position{
																Column: 58,
																Line:   79,
															},
														},
													},
													Name: "v",
												},
												Separator: nil,
												Value: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 65,
																Line:   79,
															},
															File:   "slack.flux",
															Source: "text",
															Start: ast.Position{
																Column: 61,
																Line:   79,
															},
														},
													},
													Name: "text",
												},
											}},
											Rbrace: nil,
											With:   nil,
										}},
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 66,
													Line:   79,
												},
												File:   "slack.flux",
												Source: "string(v: text)",
												Start: ast.Position{
													Column: 51,
													Line:   79,
												},
											},
										},
										Callee: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 57,
														Line:   79,
													},
													File:   "slack.flux",
													Source: "string",
													Start: ast.Position{
														Column: 51,
														Line:   79,
													},
												},
											},
											Name: "string",
										},
										Lparen: nil,
										Rparen: nil,
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 87,
												Line:   79,
											},
											File:   "slack.flux",
											Source: "mrkdwn_in: [\"text\"]",
											Start: ast.Position{
												Column: 68,
												Line:   79,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 77,
													Line:   79,
												},
												File:   "slack.flux",
												Source: "mrkdwn_in",
												Start: ast.Position{
													Column: 68,
													Line:   79,
												},
											},
										},
										Name: "mrkdwn_in",
									},
									Separator: nil,
									Value: &ast.ArrayExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 87,
													Line:   79,
												},
												File:   "slack.flux",
												Source: "[\"text\"]",
												Start: ast.Position{
													Column: 79,
													Line:   79,
												},
											},
										},
										Elements: []ast.Expression{&ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 86,
														Line:   79,
													},
													File:   "slack.flux",
													Source: "\"text\"",
													Start: ast.Position{
														Column: 80,
														Line:   79,
													},
												},
											},
											Value: "text",
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							Lbrack: nil,
							Rbrack: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   84,
								},
								File:   "slack.flux",
								Source: "data = {\n        channel: channel,\n        attachments: attachments,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   81,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   81,
									},
									File:   "slack.flux",
									Source: "data",
									Start: ast.Position{
										Column: 5,
										Line:   81,
									},
								},
							},
							Name: "data",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   84,
									},
									File:   "slack.flux",
									Source: "{\n        channel: channel,\n        attachments: attachments,\n    }",
									Start: ast.Position{
										Column: 12,
										Line:   81,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   82,
										},
										File:   "slack.flux",
										Source: "channel: channel",
										Start: ast.Position{
											Column: 9,
											Line:   82,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   82,
											},
											File:   "slack.flux",
											Source: "channel",
											Start: ast.Position{
												Column: 9,
												Line:   82,
											},
										},
									},
									Name: "channel",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   82,
											},
											File:   "slack.flux",
											Source: "channel",
											Start: ast.Position{
												Column: 18,
												Line:   82,
											},
										},
									},
									Name: "channel",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   83,
										},
										File:   "slack.flux",
										Source: "attachments: attachments",
										Start: ast.Position{
											Column: 9,
											Line:   83,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 20,
												Line:   83,
											},
											File:   "slack.flux",
											Source: "attachments",
											Start: ast.Position{
												Column: 9,
												Line:   83,
											},
										},
									},
									Name: "attachments",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 33,
												Line:   83,
											},
											File:   "slack.flux",
											Source: "attachments",
											Start: ast.Position{
												Column: 22,
												Line:   83,
											},
										},
									},
									Name: "attachments",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   88,
								},
								File:   "slack.flux",
								Source: "headers = {\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   85,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   85,
									},
									File:   "slack.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   85,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   88,
									},
									File:   "slack.flux",
									Source: "{\n        \"Authorization\": \"Bearer \" + token,\n        \"Content-Type\": \"application/json\",\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   85,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   86,
										},
										File:   "slack.flux",
										Source: "\"Authorization\": \"Bearer \" + token",
										Start: ast.Position{
											Column: 9,
											Line:   86,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   86,
											},
											File:   "slack.flux",
											Source: "\"Authorization\"",
											Start: ast.Position{
												Column: 9,
												Line:   86,
											},
										},
									},
									Value: "Authorization",
								},
								Separator: nil,
								Value: &ast.BinaryExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   86,
											},
											File:   "slack.flux",
											Source: "\"Bearer \" + token",
											Start: ast.Position{
												Column: 26,
												Line:   86,
											},
										},
									},
									Left: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 35,
													Line:   86,
												},
												File:   "slack.flux",
												Source: "\"Bearer \"",
												Start: ast.Position{
													Column: 26,
													Line:   86,
												},
											},
										},
										Value: "Bearer ",
									},
									Operator: 5,
									Right: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   86,
												},
												File:   "slack.flux",
												Source: "token",
												Start: ast.Position{
													Column: 38,
													Line:   86,
												},
											},
										},
										Name: "token",
									},
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   87,
										},
										File:   "slack.flux",
										Source: "\"Content-Type\": \"application/json\"",
										Start: ast.Position{
											Column: 9,
											Line:   87,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   87,
											},
											File:   "slack.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   87,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   87,
											},
											File:   "slack.flux",
											Source: "\"application/json\"",
											Start: ast.Position{
												Column: 25,
												Line:   87,
											},
										},
									},
									Value: "application/json",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   89,
								},
								File:   "slack.flux",
								Source: "enc = json.encode(v: data)",
								Start: ast.Position{
									Column: 5,
									Line:   89,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 8,
										Line:   89,
									},
									File:   "slack.flux",
									Source: "enc",
									Start: ast.Position{
										Column: 5,
										Line:   89,
									},
								},
							},
							Name: "enc",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 30,
											Line:   89,
										},
										File:   "slack.flux",
										Source: "v: data",
										Start: ast.Position{
											Column: 23,
											Line:   89,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 30,
												Line:   89,
											},
											File:   "slack.flux",
											Source: "v: data",
											Start: ast.Position{
												Column: 23,
												Line:   89,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 24,
													Line:   89,
												},
												File:   "slack.flux",
												Source: "v",
												Start: ast.Position{
													Column: 23,
													Line:   89,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 30,
													Line:   89,
												},
												File:   "slack.flux",
												Source: "data",
												Start: ast.Position{
													Column: 26,
													Line:   89,
												},
											},
										},
										Name: "data",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   89,
									},
									File:   "slack.flux",
									Source: "json.encode(v: data)",
									Start: ast.Position{
										Column: 11,
										Line:   89,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   89,
										},
										File:   "slack.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 11,
											Line:   89,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   89,
											},
											File:   "slack.flux",
											Source: "json",
											Start: ast.Position{
												Column: 11,
												Line:   89,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   89,
											},
											File:   "slack.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 16,
												Line:   89,
											},
										},
									},
									Name: "encode",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 59,
											Line:   91,
										},
										File:   "slack.flux",
										Source: "headers: headers, url: url, data: enc",
										Start: ast.Position{
											Column: 22,
											Line:   91,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   91,
											},
											File:   "slack.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   91,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   91,
												},
												File:   "slack.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   91,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   91,
												},
												File:   "slack.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   91,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   91,
											},
											File:   "slack.flux",
											Source: "url: url",
											Start: ast.Position{
												Column: 40,
												Line:   91,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   91,
												},
												File:   "slack.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   91,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   91,
												},
												File:   "slack.flux",
												Source: "url",
												Start: ast.Position{
													Column: 45,
													Line:   91,
												},
											},
										},
										Name: "url",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 59,
												Line:   91,
											},
											File:   "slack.flux",
											Source: "data: enc",
											Start: ast.Position{
												Column: 50,
												Line:   91,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   91,
												},
												File:   "slack.flux",
												Source: "data",
												Start: ast.Position{
													Column: 50,
													Line:   91,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 59,
													Line:   91,
												},
												File:   "slack.flux",
												Source: "enc",
												Start: ast.Position{
													Column: 56,
													Line:   91,
												},
											},
										},
										Name: "enc",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   91,
									},
									File:   "slack.flux",
									Source: "http.post(headers: headers, url: url, data: enc)",
									Start: ast.Position{
										Column: 12,
										Line:   91,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   91,
										},
										File:   "slack.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   91,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   91,
											},
											File:   "slack.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   91,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   91,
											},
											File:   "slack.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   91,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   91,
								},
								File:   "slack.flux",
								Source: "return http.post(headers: headers, url: url, data: enc)",
								Start: ast.Position{
									Column: 5,
									Line:   91,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 23,
								Line:   72,
							},
							File:   "slack.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 9,
								Line:   72,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   72,
								},
								File:   "slack.flux",
								Source: "url",
								Start: ast.Position{
									Column: 9,
									Line:   72,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   72,
								},
								File:   "slack.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 13,
									Line:   72,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   73,
							},
							File:   "slack.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   73,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   73,
								},
								File:   "slack.flux",
								Source: "token",
								Start: ast.Position{
									Column: 9,
									Line:   73,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   73,
								},
								File:   "slack.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 15,
									Line:   73,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   74,
							},
							File:   "slack.flux",
							Source: "channel",
							Start: ast.Position{
								Column: 9,
								Line:   74,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   74,
								},
								File:   "slack.flux",
								Source: "channel",
								Start: ast.Position{
									Column: 9,
									Line:   74,
								},
							},
						},
						Name: "channel",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   75,
							},
							File:   "slack.flux",
							Source: "text",
							Start: ast.Position{
								Column: 9,
								Line:   75,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   75,
								},
								File:   "slack.flux",
								Source: "text",
								Start: ast.Position{
									Column: 9,
									Line:   75,
								},
							},
						},
						Name: "text",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   76,
							},
							File:   "slack.flux",
							Source: "color",
							Start: ast.Position{
								Column: 9,
								Line:   76,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   76,
								},
								File:   "slack.flux",
								Source: "color",
								Start: ast.Position{
									Column: 9,
									Line:   76,
								},
							},
						},
						Name: "color",
					},
					Separator: nil,
					Value:     nil,
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   142,
					},
					File:   "slack.flux",
					Source: "endpoint = (url=defaultURL, token=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   125,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// endpoint sends a message to Slack that includes output data.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `url` is the API URL of the slack endpoint. Defaults to https://slack.com/api/chat.postMessage.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//      If using a Slack webhook, you’ll receive a Slack webhook URL when you create an incoming webhook.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `token` is the Slack API token used to interact with Slack. Defaults to \"\".\n"}, ast.Comment{Text: "// - `Usage`: slack.endpoint is a factory function that outputs another function. The output function requires a mapFn parameter.\n"}, ast.Comment{Text: "// - `mapFn` is a function that builds the record used to generate the POST request. Requires an r parameter.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Send critical statuses to a Slack endpoint\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"slack\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// toSlack = slack.endpoint(url: https://hooks.slack.com/services/EXAMPLE-WEBHOOK-URL)\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// crit_statuses = from(bucket: \"example-bucket\")\n"}, ast.Comment{Text: "//   |> range(start: -1m)\n"}, ast.Comment{Text: "//   |> filter(fn: (r) => r._measurement == \"statuses\" and r.status == \"crit\")\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// crit_statuses\n"}, ast.Comment{Text: "//   |> toSlack(mapFn: (r) => ({\n"}, ast.Comment{Text: "//       channel: \"Alerts\",\n"}, ast.Comment{Text: "//       text: r._message,\n"}, ast.Comment{Text: "//       color: \"danger\",\n"}, ast.Comment{Text: "//    })\n"}, ast.Comment{Text: "//   )()\n"}, ast.Comment{Text: "// ```\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   125,
						},
						File:   "slack.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   125,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   142,
						},
						File:   "slack.flux",
						Source: "(url=defaultURL, token=\"\") => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
						Start: ast.Position{
							Column: 12,
							Line:   125,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   142,
							},
							File:   "slack.flux",
							Source: "(mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
							Start: ast.Position{
								Column: 42,
								Line:   125,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   142,
								},
								File:   "slack.flux",
								Source: "(tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
								Start: ast.Position{
									Column: 53,
									Line:   125,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 74,
											Line:   125,
										},
										File:   "slack.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 68,
											Line:   125,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   142,
									},
									File:   "slack.flux",
									Source: "tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
									Start: ast.Position{
										Column: 68,
										Line:   125,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   141,
											},
											File:   "slack.flux",
											Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100,\n                ),\n            }\n        }",
											Start: ast.Position{
												Column: 9,
												Line:   127,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   141,
												},
												File:   "slack.flux",
												Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100,\n                ),\n            }\n        }",
												Start: ast.Position{
													Column: 9,
													Line:   127,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   127,
													},
													File:   "slack.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   127,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   141,
													},
													File:   "slack.flux",
													Source: "(r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100,\n                ),\n            }\n        }",
													Start: ast.Position{
														Column: 13,
														Line:   127,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   141,
														},
														File:   "slack.flux",
														Source: "{\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100,\n                ),\n            }\n        }",
														Start: ast.Position{
															Column: 20,
															Line:   127,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   128,
															},
															File:   "slack.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 13,
																Line:   128,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   128,
																},
																File:   "slack.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 13,
																	Line:   128,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   128,
																	},
																	File:   "slack.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   128,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   128,
																		},
																		File:   "slack.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 25,
																			Line:   128,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   128,
																			},
																			File:   "slack.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 25,
																				Line:   128,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   128,
																			},
																			File:   "slack.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 28,
																				Line:   128,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   128,
																},
																File:   "slack.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 19,
																	Line:   128,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   128,
																	},
																	File:   "slack.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 19,
																		Line:   128,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   140,
																},
																File:   "slack.flux",
																Source: "{r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100,\n                ),\n            }",
																Start: ast.Position{
																	Column: 20,
																	Line:   130,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   139,
																	},
																	File:   "slack.flux",
																	Source: "_sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100,\n                )",
																	Start: ast.Position{
																		Column: 17,
																		Line:   131,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   131,
																		},
																		File:   "slack.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 17,
																			Line:   131,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   138,
																			},
																			File:   "slack.flux",
																			Source: "v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100",
																			Start: ast.Position{
																				Column: 21,
																				Line:   132,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   138,
																				},
																				File:   "slack.flux",
																				Source: "v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100",
																				Start: ast.Position{
																					Column: 21,
																					Line:   132,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   132,
																					},
																					File:   "slack.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 21,
																						Line:   132,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 28,
																						Line:   138,
																					},
																					File:   "slack.flux",
																					Source: "2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100",
																					Start: ast.Position{
																						Column: 24,
																						Line:   132,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   132,
																						},
																						File:   "slack.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 24,
																							Line:   132,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 28,
																							Line:   138,
																						},
																						File:   "slack.flux",
																						Source: "message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100",
																						Start: ast.Position{
																							Column: 29,
																							Line:   132,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 41,
																									Line:   137,
																								},
																								File:   "slack.flux",
																								Source: "url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color",
																								Start: ast.Position{
																									Column: 25,
																									Line:   133,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 33,
																										Line:   133,
																									},
																									File:   "slack.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 25,
																										Line:   133,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   133,
																										},
																										File:   "slack.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 25,
																											Line:   133,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   133,
																										},
																										File:   "slack.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 30,
																											Line:   133,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 37,
																										Line:   134,
																									},
																									File:   "slack.flux",
																									Source: "token: token",
																									Start: ast.Position{
																										Column: 25,
																										Line:   134,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   134,
																										},
																										File:   "slack.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 25,
																											Line:   134,
																										},
																									},
																								},
																								Name: "token",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 37,
																											Line:   134,
																										},
																										File:   "slack.flux",
																										Source: "token",
																										Start: ast.Position{
																											Column: 32,
																											Line:   134,
																										},
																									},
																								},
																								Name: "token",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   135,
																									},
																									File:   "slack.flux",
																									Source: "channel: obj.channel",
																									Start: ast.Position{
																										Column: 25,
																										Line:   135,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 32,
																											Line:   135,
																										},
																										File:   "slack.flux",
																										Source: "channel",
																										Start: ast.Position{
																											Column: 25,
																											Line:   135,
																										},
																									},
																								},
																								Name: "channel",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   135,
																										},
																										File:   "slack.flux",
																										Source: "obj.channel",
																										Start: ast.Position{
																											Column: 34,
																											Line:   135,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   135,
																											},
																											File:   "slack.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 34,
																												Line:   135,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   135,
																											},
																											File:   "slack.flux",
																											Source: "channel",
																											Start: ast.Position{
																												Column: 38,
																												Line:   135,
																											},
																										},
																									},
																									Name: "channel",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   136,
																									},
																									File:   "slack.flux",
																									Source: "text: obj.text",
																									Start: ast.Position{
																										Column: 25,
																										Line:   136,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   136,
																										},
																										File:   "slack.flux",
																										Source: "text",
																										Start: ast.Position{
																											Column: 25,
																											Line:   136,
																										},
																									},
																								},
																								Name: "text",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   136,
																										},
																										File:   "slack.flux",
																										Source: "obj.text",
																										Start: ast.Position{
																											Column: 31,
																											Line:   136,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 34,
																												Line:   136,
																											},
																											File:   "slack.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 31,
																												Line:   136,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   136,
																											},
																											File:   "slack.flux",
																											Source: "text",
																											Start: ast.Position{
																												Column: 35,
																												Line:   136,
																											},
																										},
																									},
																									Name: "text",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 41,
																										Line:   137,
																									},
																									File:   "slack.flux",
																									Source: "color: obj.color",
																									Start: ast.Position{
																										Column: 25,
																										Line:   137,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 30,
																											Line:   137,
																										},
																										File:   "slack.flux",
																										Source: "color",
																										Start: ast.Position{
																											Column: 25,
																											Line:   137,
																										},
																									},
																								},
																								Name: "color",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 41,
																											Line:   137,
																										},
																										File:   "slack.flux",
																										Source: "obj.color",
																										Start: ast.Position{
																											Column: 32,
																											Line:   137,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 35,
																												Line:   137,
																											},
																											File:   "slack.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 32,
																												Line:   137,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 41,
																												Line:   137,
																											},
																											File:   "slack.flux",
																											Source: "color",
																											Start: ast.Position{
																												Column: 36,
																												Line:   137,
																											},
																										},
																									},
																									Name: "color",
																								},
																								Rbrack: nil,
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   138,
																							},
																							File:   "slack.flux",
																							Source: "message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    )",
																							Start: ast.Position{
																								Column: 29,
																								Line:   132,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 36,
																									Line:   132,
																								},
																								File:   "slack.flux",
																								Source: "message",
																								Start: ast.Position{
																									Column: 29,
																									Line:   132,
																								},
																							},
																						},
																						Name: "message",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 28,
																								Line:   138,
																							},
																							File:   "slack.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 25,
																								Line:   138,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   139,
																		},
																		File:   "slack.flux",
																		Source: "string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100,\n                )",
																		Start: ast.Position{
																			Column: 24,
																			Line:   131,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   131,
																			},
																			File:   "slack.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 24,
																				Line:   131,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   130,
																	},
																	File:   "slack.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   130,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   140,
															},
															File:   "slack.flux",
															Source: "return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100,\n                ),\n            }",
															Start: ast.Position{
																Column: 13,
																Line:   130,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   127,
														},
														File:   "slack.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   127,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   127,
															},
															File:   "slack.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   127,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   142,
										},
										File:   "slack.flux",
										Source: "map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == message(\n                        url: url,\n                        token: token,\n                        channel: obj.channel,\n                        text: obj.text,\n                        color: obj.color,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   126,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   126,
											},
											File:   "slack.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   126,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   125,
									},
									File:   "slack.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 54,
										Line:   125,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 60,
											Line:   125,
										},
										File:   "slack.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 54,
											Line:   125,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 63,
										Line:   125,
									},
									File:   "slack.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 61,
										Line:   125,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   125,
								},
								File:   "slack.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 43,
									Line:   125,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   125,
									},
									File:   "slack.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 43,
										Line:   125,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   125,
							},
							File:   "slack.flux",
							Source: "url=defaultURL",
							Start: ast.Position{
								Column: 13,
								Line:   125,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   125,
								},
								File:   "slack.flux",
								Source: "url",
								Start: ast.Position{
									Column: 13,
									Line:   125,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   125,
								},
								File:   "slack.flux",
								Source: "defaultURL",
								Start: ast.Position{
									Column: 17,
									Line:   125,
								},
							},
						},
						Name: "defaultURL",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 37,
								Line:   125,
							},
							File:   "slack.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 29,
								Line:   125,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 34,
									Line:   125,
								},
								File:   "slack.flux",
								Source: "token",
								Start: ast.Position{
									Column: 29,
									Line:   125,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   125,
								},
								File:   "slack.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 35,
									Line:   125,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "slack.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "slack.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   6,
					},
					File:   "slack.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   6,
						},
						File:   "slack.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "json",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "slack.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Package slack provides functions for sending data to Slack.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   2,
					},
					File:   "slack.flux",
					Source: "package slack",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   2,
						},
						File:   "slack.flux",
						Source: "slack",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "slack",
			},
		},
	}},
	Package: "slack",
	Path:    "slack",
}
