---
layout: "functions"
page_title: "uuidv5 - Functions - Configuration Language"
sidebar_current: "docs-funcs-crypto-uuidv5"
description: |-
  The uuidv5 function generates a uuid v5 string representation of the value in the specified namespace.
---

# `uuidv5` Function

-> **Note:** This page is about Terraform 0.12 and later. For Terraform 0.11 and
earlier, see
[0.11 Configuration Language: Interpolation Syntax](../../configuration-0-11/interpolation.html).

`uuidv5` generates a _name-based_ UUID, as described in
[RFC 4122 section 4.3](https://tools.ietf.org/html/rfc4122#section-4.3),
also known as a "version 5" UUID.

```
uuidv5(namespace, name)
```

Unlike the pseudo-random UUIDs generated by
[`uuid`](./uuid.html), name-based UUIDs derive from namespace and an name,
producing the same UUID value every time if the namespace and name are
unchanged.

Name-based UUID namespaces are themselves UUIDs, but for readability this
function accepts some keywords as aliases for the namespaces that were
assigned by RFC 4122:

| Keyword | Namespace ID | Name format |
| ------- | ------------ | ----------- |
| `"dns"` | `6ba7b810-9dad-11d1-80b4-00c04fd430c8` | A fully-qualified DNS domain name. |
| `"url"` | `6ba7b811-9dad-11d1-80b4-00c04fd430c8` | Any valid URL as defined in [RFC 3986](https://tools.ietf.org/html/rfc3986). |
| `"oid"` | `6ba7b812-9dad-11d1-80b4-00c04fd430c8` | An [ISO/IEC object identifier](https://oidref.com/) |
| `"x500"` | `6ba7b814-9dad-11d1-80b4-00c04fd430c8` | [X.500 Distinguished Name](https://tools.ietf.org/html/rfc1779) |

To use any other namespace not included in the above table, pass its assigned
namespace ID directly in the first argument in the usual UUID string format.

## Examples

Use the namespace keywords where possible, to make the intent more obvious to
a future reader:

```
> uuidv5("dns", "www.terraform.io")
a5008fae-b28c-5ba5-96cd-82b4c53552d6

> uuidv5("url", "https://www.terraform.io/")
9db6f67c-dd95-5ea0-aa5b-e70e5c5f7cf5

> uuidv5("oid", "1.3.6.1.4")
af9d40a5-7a36-5c07-b23a-851cd99fbfa5

> uuidv5("x500", "CN=Example,C=GB")
84e09961-4aa4-57f8-95b7-03edb1073253
```

The namespace keywords treated as equivalent to their corresponding namespace
UUIDs, and in some special cases it may be more appropriate to use the
UUID form:

```
> uuidv5("6ba7b810-9dad-11d1-80b4-00c04fd430c8", "www.terraform.io")
a5008fae-b28c-5ba5-96cd-82b4c53552d6
```

If you wish to use a namespace defined outside of RFC 4122, using the namespace
UUID is required because no corresponding keyword is available:

```
> uuidv5("743ac3c0-3bf7-4a5b-9e6c-59360447c757", "LIBS:diskfont.library")
ede1a974-df7e-5f17-84b9-76208818b2c8
```

When using raw UUID namespaces, consider including a comment alongside the
expression that indicates which namespace this represents in a
human-significant manner, such as by reference to the standard that
defined it.

## Related Functions

* [`uuid`](./uuid.html), which generates pseudorandom UUIDs.
