package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreDropTable invokes the emr.MetastoreDropTable API synchronously
// api document: https://help.aliyun.com/api/emr/metastoredroptable.html
func (client *Client) MetastoreDropTable(request *MetastoreDropTableRequest) (response *MetastoreDropTableResponse, err error) {
	response = CreateMetastoreDropTableResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreDropTableWithChan invokes the emr.MetastoreDropTable API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoredroptable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreDropTableWithChan(request *MetastoreDropTableRequest) (<-chan *MetastoreDropTableResponse, <-chan error) {
	responseChan := make(chan *MetastoreDropTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreDropTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreDropTableWithCallback invokes the emr.MetastoreDropTable API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoredroptable.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreDropTableWithCallback(request *MetastoreDropTableRequest, callback func(response *MetastoreDropTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreDropTableResponse
		var err error
		defer close(result)
		response, err = client.MetastoreDropTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreDropTableRequest is the request struct for api MetastoreDropTable
type MetastoreDropTableRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DbName          string           `position:"Query" name:"DbName"`
	TableId         string           `position:"Query" name:"TableId"`
	TableName       string           `position:"Query" name:"TableName"`
	DatabaseId      string           `position:"Query" name:"DatabaseId"`
}

// MetastoreDropTableResponse is the response struct for api MetastoreDropTable
type MetastoreDropTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateMetastoreDropTableRequest creates a request to invoke MetastoreDropTable API
func CreateMetastoreDropTableRequest() (request *MetastoreDropTableRequest) {
	request = &MetastoreDropTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreDropTable", "emr", "openAPI")
	return
}

// CreateMetastoreDropTableResponse creates a response to parse from MetastoreDropTable response
func CreateMetastoreDropTableResponse() (response *MetastoreDropTableResponse) {
	response = &MetastoreDropTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
