package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MigrateJobs invokes the emr.MigrateJobs API synchronously
// api document: https://help.aliyun.com/api/emr/migratejobs.html
func (client *Client) MigrateJobs(request *MigrateJobsRequest) (response *MigrateJobsResponse, err error) {
	response = CreateMigrateJobsResponse()
	err = client.DoAction(request, response)
	return
}

// MigrateJobsWithChan invokes the emr.MigrateJobs API asynchronously
// api document: https://help.aliyun.com/api/emr/migratejobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MigrateJobsWithChan(request *MigrateJobsRequest) (<-chan *MigrateJobsResponse, <-chan error) {
	responseChan := make(chan *MigrateJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MigrateJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MigrateJobsWithCallback invokes the emr.MigrateJobs API asynchronously
// api document: https://help.aliyun.com/api/emr/migratejobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MigrateJobsWithCallback(request *MigrateJobsRequest, callback func(response *MigrateJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MigrateJobsResponse
		var err error
		defer close(result)
		response, err = client.MigrateJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MigrateJobsRequest is the request struct for api MigrateJobs
type MigrateJobsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ProjectName     string           `position:"Query" name:"ProjectName"`
}

// MigrateJobsResponse is the response struct for api MigrateJobs
type MigrateJobsResponse struct {
	*responses.BaseResponse
	Result string `json:"Result" xml:"Result"`
}

// CreateMigrateJobsRequest creates a request to invoke MigrateJobs API
func CreateMigrateJobsRequest() (request *MigrateJobsRequest) {
	request = &MigrateJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MigrateJobs", "emr", "openAPI")
	return
}

// CreateMigrateJobsResponse creates a response to parse from MigrateJobs response
func CreateMigrateJobsResponse() (response *MigrateJobsResponse) {
	response = &MigrateJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
