// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/recommendationengine/v1beta1/prediction_service.proto

package recommendationengine

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_struct "github.com/golang/protobuf/ptypes/struct"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for Predict method.
type PredictRequest struct {
	// Required. Full resource name of the format:
	// {name=projects/*/locations/global/catalogs/default_catalog/eventStores/default_event_store/placements/*}
	// The id of the recommendation engine placement. This id is used to identify
	// the set of models that will be used to make the prediction.
	//
	// We currently support three placements with the following IDs by default:
	//
	// * `shopping_cart`: Predicts items frequently bought together with one or
	//   more catalog items in the same shopping session. Commonly displayed after
	//   `add-to-cart` events, on product detail pages, or on the shopping cart
	//   page.
	//
	// * `home_page`: Predicts the next product that a user will most likely
	//   engage with or purchase based on the shopping or viewing history of the
	//   specified `userId` or `visitorId`. For example - Recommendations for you.
	//
	// * `product_detail`: Predicts the next product that a user will most likely
	//   engage with or purchase. The prediction is based on the shopping or
	//   viewing history of the specified `userId` or `visitorId` and its
	//   relevance to a specified `CatalogItem`. Typically used on product detail
	//   pages. For example - More items like this.
	//
	// * `recently_viewed_default`: Returns up to 75 items recently viewed by the
	//   specified `userId` or `visitorId`, most recent ones first. Returns
	//   nothing if neither of them has viewed any items yet. For example -
	//   Recently viewed.
	//
	// The full list of available placements can be seen at
	// https://console.cloud.google.com/recommendation/datafeeds/default_catalog/dashboard
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Context about the user, what they are looking at and what action
	// they took to trigger the predict request. Note that this user event detail
	// won't be ingested to userEvent logs. Thus, a separate userEvent write
	// request is required for event logging.
	UserEvent *UserEvent `protobuf:"bytes,2,opt,name=user_event,json=userEvent,proto3" json:"user_event,omitempty"`
	// Optional. Maximum number of results to return per page. Set this property
	// to the number of prediction results required. If zero, the service will
	// choose a reasonable default.
	PageSize int32 `protobuf:"varint,7,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The previous PredictResponse.next_page_token.
	PageToken string `protobuf:"bytes,8,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter for restricting prediction results. Accepts values for
	// tags and the `filterOutOfStockItems` flag.
	//
	//  * Tag expressions. Restricts predictions to items that match all of the
	//    specified tags. Boolean operators `OR` and `NOT` are supported if the
	//    expression is enclosed in parentheses, and must be separated from the
	//    tag values by a space. `-"tagA"` is also supported and is equivalent to
	//    `NOT "tagA"`. Tag values must be enclosed in double quotes, and can
	//    contain only alphanumeric characters, underscores, and dashes.
	//
	//  * filterOutOfStockItems. Restricts predictions to items that do not have a
	//    stockState value of OUT_OF_STOCK.
	//
	// Examples:
	//
	//  * tag=("Red" OR "Blue") tag="New-Arrival" tag=(NOT "promotional")
	//  * filterOutOfStockItems  tag=(-"promotional")
	//  * filterOutOfStockItems
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Use dryRun mode for this prediction query. If set to true, a
	// dummy model will be used that returns arbitrary catalog items.
	// Note that the dryRun mode should only be used for testing the API, or if
	// the model is not ready.
	DryRun bool `protobuf:"varint,4,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// Optional. Additional domain specific parameters for the predictions.
	//
	// Allowed values:
	//
	// * `returnCatalogItem`: Boolean. If set to true, the associated catalogItem
	//   object will be returned in the
	//   `PredictResponse.PredictionResult.itemMetadata` object in the method
	//    response.
	Params map[string]*_struct.Value `protobuf:"bytes,6,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The labels for the predict request.
	//
	//  * Label keys can contain lowercase letters, digits and hyphens, must start
	//    with a letter, and must end with a letter or digit.
	//  * Non-zero label values can contain lowercase letters, digits and hyphens,
	//    must start with a letter, and must end with a letter or digit.
	//  * No more than 64 labels can be associated with a given request.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	Labels               map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PredictRequest) Reset()         { *m = PredictRequest{} }
func (m *PredictRequest) String() string { return proto.CompactTextString(m) }
func (*PredictRequest) ProtoMessage()    {}
func (*PredictRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_73deb4cba861f96f, []int{0}
}

func (m *PredictRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictRequest.Unmarshal(m, b)
}
func (m *PredictRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictRequest.Marshal(b, m, deterministic)
}
func (m *PredictRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictRequest.Merge(m, src)
}
func (m *PredictRequest) XXX_Size() int {
	return xxx_messageInfo_PredictRequest.Size(m)
}
func (m *PredictRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PredictRequest proto.InternalMessageInfo

func (m *PredictRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PredictRequest) GetUserEvent() *UserEvent {
	if m != nil {
		return m.UserEvent
	}
	return nil
}

func (m *PredictRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *PredictRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *PredictRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *PredictRequest) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *PredictRequest) GetParams() map[string]*_struct.Value {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *PredictRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Response message for predict method.
type PredictResponse struct {
	// A list of recommended items. The order represents the ranking (from the
	// most relevant item to the least).
	Results []*PredictResponse_PredictionResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// A unique recommendation token. This should be included in the user event
	// logs resulting from this recommendation, which enables accurate attribution
	// of recommendation model performance.
	RecommendationToken string `protobuf:"bytes,2,opt,name=recommendation_token,json=recommendationToken,proto3" json:"recommendation_token,omitempty"`
	// IDs of items in the request that were missing from the catalog.
	ItemsMissingInCatalog []string `protobuf:"bytes,3,rep,name=items_missing_in_catalog,json=itemsMissingInCatalog,proto3" json:"items_missing_in_catalog,omitempty"`
	// True if the dryRun property was set in the request.
	DryRun bool `protobuf:"varint,4,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
	// Additional domain specific prediction response metadata.
	Metadata map[string]*_struct.Value `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// If empty, the list is complete. If nonempty, the token to pass to the next
	// request's PredictRequest.page_token.
	NextPageToken        string   `protobuf:"bytes,6,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PredictResponse) Reset()         { *m = PredictResponse{} }
func (m *PredictResponse) String() string { return proto.CompactTextString(m) }
func (*PredictResponse) ProtoMessage()    {}
func (*PredictResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_73deb4cba861f96f, []int{1}
}

func (m *PredictResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictResponse.Unmarshal(m, b)
}
func (m *PredictResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictResponse.Marshal(b, m, deterministic)
}
func (m *PredictResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictResponse.Merge(m, src)
}
func (m *PredictResponse) XXX_Size() int {
	return xxx_messageInfo_PredictResponse.Size(m)
}
func (m *PredictResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PredictResponse proto.InternalMessageInfo

func (m *PredictResponse) GetResults() []*PredictResponse_PredictionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *PredictResponse) GetRecommendationToken() string {
	if m != nil {
		return m.RecommendationToken
	}
	return ""
}

func (m *PredictResponse) GetItemsMissingInCatalog() []string {
	if m != nil {
		return m.ItemsMissingInCatalog
	}
	return nil
}

func (m *PredictResponse) GetDryRun() bool {
	if m != nil {
		return m.DryRun
	}
	return false
}

func (m *PredictResponse) GetMetadata() map[string]*_struct.Value {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *PredictResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// PredictionResult represents the recommendation prediction results.
type PredictResponse_PredictionResult struct {
	// ID of the recommended catalog item
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Additional item metadata / annotations.
	//
	// Possible values:
	//
	// * `catalogItem`: JSON representation of the catalogItem. Will be set if
	//   `returnCatalogItem` is set to true in `PredictRequest.params`.
	ItemMetadata         map[string]*_struct.Value `protobuf:"bytes,2,rep,name=item_metadata,json=itemMetadata,proto3" json:"item_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *PredictResponse_PredictionResult) Reset()         { *m = PredictResponse_PredictionResult{} }
func (m *PredictResponse_PredictionResult) String() string { return proto.CompactTextString(m) }
func (*PredictResponse_PredictionResult) ProtoMessage()    {}
func (*PredictResponse_PredictionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_73deb4cba861f96f, []int{1, 0}
}

func (m *PredictResponse_PredictionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictResponse_PredictionResult.Unmarshal(m, b)
}
func (m *PredictResponse_PredictionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictResponse_PredictionResult.Marshal(b, m, deterministic)
}
func (m *PredictResponse_PredictionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictResponse_PredictionResult.Merge(m, src)
}
func (m *PredictResponse_PredictionResult) XXX_Size() int {
	return xxx_messageInfo_PredictResponse_PredictionResult.Size(m)
}
func (m *PredictResponse_PredictionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictResponse_PredictionResult.DiscardUnknown(m)
}

var xxx_messageInfo_PredictResponse_PredictionResult proto.InternalMessageInfo

func (m *PredictResponse_PredictionResult) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *PredictResponse_PredictionResult) GetItemMetadata() map[string]*_struct.Value {
	if m != nil {
		return m.ItemMetadata
	}
	return nil
}

func init() {
	proto.RegisterType((*PredictRequest)(nil), "google.cloud.recommendationengine.v1beta1.PredictRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.recommendationengine.v1beta1.PredictRequest.LabelsEntry")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.recommendationengine.v1beta1.PredictRequest.ParamsEntry")
	proto.RegisterType((*PredictResponse)(nil), "google.cloud.recommendationengine.v1beta1.PredictResponse")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.recommendationengine.v1beta1.PredictResponse.MetadataEntry")
	proto.RegisterType((*PredictResponse_PredictionResult)(nil), "google.cloud.recommendationengine.v1beta1.PredictResponse.PredictionResult")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.recommendationengine.v1beta1.PredictResponse.PredictionResult.ItemMetadataEntry")
}

func init() {
	proto.RegisterFile("google/cloud/recommendationengine/v1beta1/prediction_service.proto", fileDescriptor_73deb4cba861f96f)
}

var fileDescriptor_73deb4cba861f96f = []byte{
	// 757 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x95, 0xeb, 0x6a, 0x34, 0x35,
	0x18, 0xc7, 0x99, 0xd9, 0xee, 0x29, 0x6b, 0xdf, 0x43, 0x7c, 0x6d, 0x87, 0x51, 0x61, 0x59, 0x41,
	0xd6, 0xa2, 0x33, 0xb4, 0x0a, 0xda, 0x15, 0x3f, 0xb4, 0x52, 0xb0, 0x68, 0xa1, 0xce, 0x56, 0x8b,
	0x42, 0x19, 0xb2, 0x33, 0x4f, 0xa7, 0xb1, 0x33, 0xc9, 0x98, 0x64, 0xb6, 0x6e, 0x45, 0x90, 0xde,
	0x82, 0x77, 0xe2, 0x65, 0xf8, 0x49, 0xf4, 0x0a, 0x44, 0x2f, 0x44, 0x26, 0x93, 0x3d, 0xd5, 0x15,
	0xfa, 0xb6, 0xfd, 0x96, 0xe4, 0x9f, 0xfc, 0x9e, 0x63, 0x12, 0xb4, 0x9f, 0x70, 0x9e, 0xa4, 0xe0,
	0x47, 0x29, 0x2f, 0x62, 0x5f, 0x40, 0xc4, 0xb3, 0x0c, 0x58, 0x4c, 0x14, 0xe5, 0x0c, 0x58, 0x42,
	0x19, 0xf8, 0xe3, 0xed, 0x11, 0x28, 0xb2, 0xed, 0xe7, 0x02, 0x62, 0x1a, 0x95, 0x42, 0x28, 0x41,
	0x8c, 0x69, 0x04, 0x5e, 0x2e, 0xb8, 0xe2, 0xf8, 0x9d, 0x8a, 0xe1, 0x69, 0x86, 0xb7, 0x8a, 0xe1,
	0x19, 0x86, 0xfb, 0x86, 0x31, 0x47, 0x72, 0xea, 0x13, 0xc6, 0xb8, 0xd2, 0x9b, 0x64, 0x05, 0x72,
	0x37, 0x17, 0xd4, 0x28, 0xa5, 0xc0, 0x94, 0x11, 0x06, 0x77, 0xf7, 0xb2, 0x90, 0x20, 0x42, 0x18,
	0xcf, 0xcf, 0x4e, 0x4d, 0xea, 0xd9, 0xa8, 0x38, 0xf7, 0xa5, 0x12, 0x45, 0x64, 0xd4, 0xde, 0xaf,
	0x6b, 0xe8, 0xc9, 0x71, 0x15, 0x58, 0x00, 0xdf, 0x17, 0x20, 0x15, 0xc6, 0x68, 0x8d, 0x91, 0x0c,
	0x1c, 0xab, 0x6b, 0xf5, 0xdb, 0x81, 0x1e, 0xe3, 0x21, 0x42, 0x73, 0xb0, 0x63, 0x77, 0xad, 0x7e,
	0x67, 0xe7, 0x03, 0xef, 0xce, 0x71, 0x7b, 0x5f, 0x49, 0x10, 0x07, 0xe5, 0xd9, 0xa0, 0x5d, 0x4c,
	0x87, 0xf8, 0x75, 0xd4, 0xce, 0x49, 0x02, 0xa1, 0xa4, 0xd7, 0xe0, 0x34, 0xbb, 0x56, 0xbf, 0x1e,
	0xb4, 0xca, 0x85, 0x21, 0xbd, 0x06, 0xfc, 0x26, 0x42, 0x5a, 0x54, 0xfc, 0x12, 0x98, 0xd3, 0xd2,
	0xbe, 0xe8, 0xed, 0x27, 0xe5, 0x02, 0xde, 0x40, 0x8d, 0x73, 0x9a, 0x2a, 0x10, 0x4e, 0x4d, 0x4b,
	0x66, 0x86, 0x37, 0x51, 0x33, 0x16, 0x93, 0x50, 0x14, 0xcc, 0x59, 0xeb, 0x5a, 0xfd, 0x56, 0xd0,
	0x88, 0xc5, 0x24, 0x28, 0x18, 0x3e, 0x43, 0x8d, 0x9c, 0x08, 0x92, 0x49, 0xa7, 0xd1, 0xad, 0xf5,
	0x3b, 0x3b, 0x07, 0x2f, 0xe1, 0xfd, 0x72, 0x82, 0xbc, 0x63, 0xcd, 0x39, 0x60, 0x4a, 0x4c, 0x02,
	0x03, 0x2d, 0xf1, 0x29, 0x19, 0x41, 0x2a, 0x9d, 0xf6, 0x43, 0xf1, 0x5f, 0x68, 0x8e, 0xc1, 0x57,
	0x50, 0xf7, 0x4b, 0xd4, 0x59, 0xb0, 0x8a, 0x9f, 0xa1, 0xda, 0x25, 0x4c, 0x4c, 0x85, 0xca, 0x21,
	0x7e, 0x17, 0xd5, 0xc7, 0x24, 0x2d, 0xc0, 0xd4, 0x66, 0x63, 0x6a, 0x7e, 0x5a, 0x75, 0xef, 0xeb,
	0x52, 0x0d, 0xaa, 0x4d, 0x03, 0xfb, 0x23, 0xcb, 0xdd, 0x45, 0x9d, 0x05, 0x4b, 0x2b, 0x90, 0x2f,
	0x16, 0x91, 0xed, 0x85, 0xa3, 0xbd, 0xbf, 0xeb, 0xe8, 0xe9, 0xcc, 0x69, 0x99, 0x73, 0x26, 0x01,
	0x03, 0x6a, 0x0a, 0x90, 0x45, 0xaa, 0xa4, 0x63, 0xe9, 0x0c, 0x7c, 0x7e, 0x9f, 0x0c, 0x54, 0xb0,
	0xe9, 0x9c, 0x72, 0x16, 0x68, 0x66, 0x30, 0x65, 0xe3, 0x6d, 0xf4, 0x62, 0x99, 0x64, 0x1a, 0xa4,
	0xf2, 0xf1, 0xd5, 0x65, 0xad, 0x6a, 0x95, 0x0f, 0x91, 0x43, 0x15, 0x64, 0x32, 0xcc, 0xa8, 0x94,
	0x94, 0x25, 0x21, 0x65, 0x61, 0x44, 0x14, 0x49, 0x79, 0xe2, 0xd4, 0xba, 0xb5, 0x7e, 0x3b, 0x78,
	0x4d, 0xeb, 0x47, 0x95, 0x7c, 0xc8, 0x3e, 0xad, 0xc4, 0xff, 0xef, 0xa5, 0x18, 0xb5, 0x32, 0x50,
	0x24, 0x26, 0x8a, 0x38, 0x75, 0x1d, 0xec, 0x67, 0x0f, 0x08, 0xf6, 0xc8, 0xa0, 0xaa, 0x8a, 0xcf,
	0xc8, 0xf8, 0x6d, 0xf4, 0x94, 0xc1, 0x0f, 0x2a, 0x5c, 0xb8, 0x06, 0x0d, 0x1d, 0xe5, 0x7a, 0xb9,
	0x7c, 0x3c, 0xbd, 0x0a, 0xee, 0xcf, 0x36, 0x7a, 0x76, 0x3b, 0x61, 0xf8, 0x09, 0xb2, 0x69, 0x6c,
	0xaa, 0x69, 0xd3, 0x18, 0xdf, 0x58, 0x68, 0xbd, 0x8c, 0x32, 0x9c, 0x39, 0x6e, 0x6b, 0xc7, 0xcf,
	0x1e, 0xb1, 0x4a, 0xde, 0xa1, 0x82, 0x6c, 0x39, 0x9a, 0x57, 0xe8, 0xc2, 0x92, 0x7b, 0x8a, 0x9e,
	0xff, 0x67, 0xcb, 0xa3, 0xf4, 0xf2, 0x10, 0xad, 0x3f, 0x3a, 0x74, 0xe7, 0x77, 0x1b, 0x3d, 0x9f,
	0x87, 0x38, 0xac, 0x9e, 0x7c, 0xfc, 0x97, 0x85, 0x9a, 0x66, 0x15, 0xef, 0xde, 0xfb, 0x92, 0xbb,
	0x83, 0xfb, 0xe7, 0xbd, 0x17, 0xde, 0xfc, 0xf9, 0xcf, 0x2f, 0xf6, 0x37, 0xbd, 0x93, 0xd9, 0xa3,
	0xff, 0x63, 0xf9, 0x48, 0x7f, 0x92, 0x0b, 0xfe, 0x1d, 0x44, 0x4a, 0xfa, 0x5b, 0x7e, 0xca, 0xa3,
	0xea, 0x67, 0xf1, 0xb7, 0x7c, 0xd3, 0xeb, 0xe5, 0x50, 0x3f, 0xdf, 0x43, 0xc5, 0x05, 0x94, 0xb3,
	0x3c, 0x25, 0x11, 0x64, 0xc0, 0xca, 0x13, 0x3f, 0x0d, 0xcc, 0xf7, 0x36, 0xb0, 0xb6, 0xdc, 0xd3,
	0xdf, 0xf6, 0xde, 0x5a, 0xe9, 0x51, 0xe5, 0x33, 0xc9, 0xa9, 0xf4, 0x22, 0x9e, 0xfd, 0xb1, 0xe7,
	0x5d, 0x28, 0x95, 0xcb, 0x81, 0xef, 0x5f, 0x5d, 0x5d, 0xdd, 0x12, 0x7d, 0x52, 0xa8, 0x8b, 0xea,
	0xc3, 0x7a, 0x2f, 0x4f, 0x89, 0x3a, 0xe7, 0x22, 0xdb, 0x0f, 0xbf, 0x3d, 0x33, 0x61, 0x27, 0x3c,
	0x25, 0x2c, 0xf1, 0xb8, 0x48, 0xfc, 0x04, 0x98, 0x2e, 0x82, 0x3f, 0x07, 0xdc, 0xe1, 0xa3, 0xfb,
	0x78, 0x95, 0x38, 0x6a, 0x68, 0xd2, 0xfb, 0xff, 0x06, 0x00, 0x00, 0xff, 0xff, 0x67, 0x5d, 0xcf,
	0x65, 0xd7, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// PredictionServiceClient is the client API for PredictionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PredictionServiceClient interface {
	// Makes a recommendation prediction. If using API Key based authentication,
	// the API Key must be registered using the
	// [PredictionApiKeyRegistry][google.cloud.recommendationengine.v1beta1.PredictionApiKeyRegistry]
	// service. [Learn more](/recommendations-ai/docs/setting-up#register-key).
	Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error)
}

type predictionServiceClient struct {
	cc *grpc.ClientConn
}

func NewPredictionServiceClient(cc *grpc.ClientConn) PredictionServiceClient {
	return &predictionServiceClient{cc}
}

func (c *predictionServiceClient) Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error) {
	out := new(PredictResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.recommendationengine.v1beta1.PredictionService/Predict", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PredictionServiceServer is the server API for PredictionService service.
type PredictionServiceServer interface {
	// Makes a recommendation prediction. If using API Key based authentication,
	// the API Key must be registered using the
	// [PredictionApiKeyRegistry][google.cloud.recommendationengine.v1beta1.PredictionApiKeyRegistry]
	// service. [Learn more](/recommendations-ai/docs/setting-up#register-key).
	Predict(context.Context, *PredictRequest) (*PredictResponse, error)
}

// UnimplementedPredictionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedPredictionServiceServer struct {
}

func (*UnimplementedPredictionServiceServer) Predict(ctx context.Context, req *PredictRequest) (*PredictResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Predict not implemented")
}

func RegisterPredictionServiceServer(s *grpc.Server, srv PredictionServiceServer) {
	s.RegisterService(&_PredictionService_serviceDesc, srv)
}

func _PredictionService_Predict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).Predict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.recommendationengine.v1beta1.PredictionService/Predict",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).Predict(ctx, req.(*PredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PredictionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.recommendationengine.v1beta1.PredictionService",
	HandlerType: (*PredictionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Predict",
			Handler:    _PredictionService_Predict_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/recommendationengine/v1beta1/prediction_service.proto",
}
