"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var assert_1 = tslib_1.__importDefault(require("assert"));
var invariant_1 = tslib_1.__importStar(require("./invariant"));
var invariant_2 = tslib_1.__importDefault(require("invariant"));
describe("ts-invariant", function () {
    it("should support both named and default exports", function () {
        assert_1.default.strictEqual(invariant_1.default, invariant_1.invariant);
    });
    it("should support very basic usage", function () {
        invariant_1.invariant(true, "ok");
        try {
            invariant_1.invariant(false, "expected");
            throw new Error("unexpected");
        }
        catch (e) {
            assert_1.default.strictEqual(e.message, "expected");
            assert_1.default.strictEqual(String(e), "Invariant Violation: expected");
        }
    });
    it("should throw InvariantError instance", function () {
        try {
            invariant_1.invariant(false, "expected");
            throw new Error("unexpected");
        }
        catch (e) {
            assert_1.default.strictEqual(e.message, "expected");
            assert_1.default(e instanceof Error);
            assert_1.default(e instanceof invariant_1.InvariantError);
            assert_1.default.strictEqual(e.name, "Invariant Violation");
            assert_1.default.strictEqual(e.framesToPop, 1);
            assert_1.default.strictEqual(typeof e.stack, "string");
        }
    });
    it("should behave like the React invariant function", function () {
        var reactError;
        try {
            invariant_2.default(false, "oyez");
        }
        catch (e) {
            reactError = e;
        }
        var ourError;
        try {
            invariant_1.invariant(false, "oyez");
        }
        catch (e) {
            ourError = e;
        }
        assert_1.default.strictEqual(reactError.message, "oyez");
        assert_1.default.strictEqual(ourError.message, "oyez");
        assert_1.default.deepEqual(reactError, ourError);
        assert_1.default.deepEqual(Object.keys(ourError).sort(), [
            "framesToPop",
            "name",
        ]);
    });
    it("invariant.warn", function () {
        var argsReceived = [];
        var warn = console.warn;
        console.warn = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            argsReceived.push(args);
        };
        try {
            invariant_1.invariant.warn("named", "export");
            assert_1.default.deepEqual(argsReceived, [
                ["named", "export"],
            ]);
            invariant_1.default.warn("default", "export");
            assert_1.default.deepEqual(argsReceived, [
                ["named", "export"],
                ["default", "export"],
            ]);
        }
        finally {
            console.warn = warn;
        }
    });
    it("invariant.error", function () {
        var argsReceived = [];
        var error = console.error;
        console.error = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            argsReceived.push(args);
        };
        try {
            invariant_1.invariant.error("named", "export");
            assert_1.default.deepEqual(argsReceived, [
                ["named", "export"],
            ]);
            invariant_1.default.error("default", "export");
            assert_1.default.deepEqual(argsReceived, [
                ["named", "export"],
                ["default", "export"],
            ]);
        }
        finally {
            console.error = error;
        }
    });
});
