"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const git_executor_chain_1 = require("./git-executor-chain");
class GitExecutor {
    constructor(binary = 'git', cwd, _scheduler) {
        this.binary = binary;
        this.cwd = cwd;
        this._scheduler = _scheduler;
        this._chain = new git_executor_chain_1.GitExecutorChain(this, this._scheduler);
    }
    chain() {
        return new git_executor_chain_1.GitExecutorChain(this, this._scheduler);
    }
    push(task) {
        return this._chain.push(task);
    }
}
exports.GitExecutor = GitExecutor;
//# sourceMappingURL=git-executor.js.map