'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Slider = require('../Slider');

var _Slider2 = _interopRequireDefault(_Slider);

var _TextInput = require('../TextInput');

var _TextInput2 = _interopRequireDefault(_TextInput);

var _enzyme = require('enzyme');

require('requestanimationframe');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

describe('Slider', function () {
  describe('Renders as expected', function () {
    var mockFn = jest.fn();
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(
      _Slider2.default,
      {
        id: 'slider',
        className: 'extra-class',
        value: 50,
        min: 0,
        max: 100,
        step: 1,
        onChange: mockFn },
      _react2.default.createElement(_TextInput2.default, {
        id: 'input-for-slider',
        labelText: 'testlabel',
        className: 'bx-slider-text-input'
      })
    ));

    it('renders children as expected', function () {
      expect(wrapper.find('.bx--text-input').length).toBe(1);
    });

    it('has the expected classes', function () {
      expect(wrapper.find('.bx--slider').length).toBe(1);
    });

    it('renders extra classes passed in via className', function () {
      expect(wrapper.find('.bx--slider').hasClass('extra-class')).toEqual(true);
    });

    it('can be disabled', function () {
      wrapper.setProps({ disabled: true });
      expect(wrapper.props().disabled).toEqual(true);
    });

    it('can set value via props', function () {
      wrapper.setProps({ value: 55 });
      expect(wrapper.props().value).toEqual(55);
    });
  });

  describe('updatePosition method', function () {
    var mockFn = jest.fn();
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(_Slider2.default, {
      id: 'slider',
      className: 'extra-class',
      value: 50,
      min: 0,
      max: 100,
      step: 1,
      onChange: mockFn
    }));

    it('sets correct state from event with a right/up keydown', function () {
      var evt = {
        type: 'keydown',
        which: '38'
      };
      wrapper.instance().updatePosition(evt);
      expect(mockFn).lastCalledWith({ value: 51 });
      expect(wrapper.state().value).toEqual(51);
    });

    it('sets correct state from event with a left/down keydown', function () {
      var evt = {
        type: 'keydown',
        which: '40'
      };
      wrapper.instance().updatePosition(evt);
      expect(mockFn).lastCalledWith({ value: 50 });
      expect(wrapper.state().value).toEqual(50);
    });

    it('sets correct state from event with a clientX', function () {
      var evt = {
        type: 'click',
        clientX: '1000'
      };
      wrapper.instance().updatePosition(evt);
      expect(mockFn).lastCalledWith({ value: 100 });
      expect(wrapper.state().value).toEqual(100);
    });
  });
});