---
id: 'Description list'
section: components
beta: true
cssPrefix: pf-c-description-list
---## Examples

### Default

```html
<dl class="pf-c-description-list">
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Name</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Namespace</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <a href="#">mary-test</a>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Labels</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Pod selector</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <button class="pf-c-button pf-m-link pf-m-inline" type="button">
          <span class="pf-c-button__icon pf-m-start">
            <i class="fas fa-plus-circle" aria-hidden="true"></i>
          </span>app=MyApp</button>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Annotation</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">2 Annotations</div>
    </dd>
  </div>
</dl>
```

### Default 2 col

```html
<dl class="pf-c-description-list pf-m-2-col">
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Name</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Namespace</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <a href="#">mary-test</a>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Labels</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Pod selector</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <button class="pf-c-button pf-m-link pf-m-inline" type="button">
          <span class="pf-c-button__icon pf-m-start">
            <i class="fas fa-plus-circle" aria-hidden="true"></i>
          </span>app=MyApp</button>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Annotation</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">2 Annotations</div>
    </dd>
  </div>
</dl>
```

### Default 3 col on lg

```html
<dl class="pf-c-description-list pf-m-3-col-on-lg">
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Name</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Namespace</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <a href="#">mary-test</a>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Labels</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Pod selector</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <button class="pf-c-button pf-m-link pf-m-inline" type="button">
          <span class="pf-c-button__icon pf-m-start">
            <i class="fas fa-plus-circle" aria-hidden="true"></i>
          </span>app=MyApp</button>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Annotation</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">2 Annotations</div>
    </dd>
  </div>
</dl>
```

### Horizontal

```html
<dl class="pf-c-description-list pf-m-horizontal">
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Name</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Namespace</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <a href="#">mary-test</a>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Labels</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Pod selector</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <button class="pf-c-button pf-m-link pf-m-inline" type="button">
          <span class="pf-c-button__icon pf-m-start">
            <i class="fas fa-plus-circle" aria-hidden="true"></i>
          </span>app=MyApp</button>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Annotation</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">2 Annotations</div>
    </dd>
  </div>
</dl>
```

### Horizontal 2 col

```html
<dl class="pf-c-description-list pf-m-horizontal pf-m-2-col">
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Name</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Namespace</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <a href="#">mary-test</a>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Labels</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Pod selector</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <button class="pf-c-button pf-m-link pf-m-inline" type="button">
          <span class="pf-c-button__icon pf-m-start">
            <i class="fas fa-plus-circle" aria-hidden="true"></i>
          </span>app=MyApp</button>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Annotation</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">2 Annotations</div>
    </dd>
  </div>
</dl>
```

### Horizontal 3 col on lg

```html
<dl class="pf-c-description-list pf-m-horizontal pf-m-3-col-on-lg">
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Name</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Namespace</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <a href="#">mary-test</a>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Labels</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Pod selector</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <button class="pf-c-button pf-m-link pf-m-inline" type="button">
          <span class="pf-c-button__icon pf-m-start">
            <i class="fas fa-plus-circle" aria-hidden="true"></i>
          </span>app=MyApp</button>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Annotation</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">2 Annotations</div>
    </dd>
  </div>
</dl>
```

## Responsive column definitions

### Default responsive columns

```html
<dl class="pf-c-description-list pf-m-2-col-on-lg pf-m-3-col-on-xl">
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Name</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Namespace</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <a href="#">mary-test</a>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Labels</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Pod selector</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <button class="pf-c-button pf-m-link pf-m-inline" type="button">
          <span class="pf-c-button__icon pf-m-start">
            <i class="fas fa-plus-circle" aria-hidden="true"></i>
          </span>app=MyApp</button>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Annotation</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">2 Annotations</div>
    </dd>
  </div>
</dl>
```

### Horizontal responsive columns

```html
<dl class="pf-c-description-list pf-m-horizontal pf-m-2-col-on-lg pf-m-3-col-on-xl">
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Name</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Namespace</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <a href="#">mary-test</a>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Labels</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Pod selector</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <button class="pf-c-button pf-m-link pf-m-inline" type="button">
          <span class="pf-c-button__icon pf-m-start">
            <i class="fas fa-plus-circle" aria-hidden="true"></i>
          </span>app=MyApp</button>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Annotation</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">2 Annotations</div>
    </dd>
  </div>
</dl>
```

## Auto-column-width

### Default auto columns width

```html
<dl class="pf-c-description-list pf-m-auto-column-widths pf-m-3-col">
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Name</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Namespace</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <a href="#">mary-test</a>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Labels</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Pod selector</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <button class="pf-c-button pf-m-link pf-m-inline" type="button">
          <span class="pf-c-button__icon pf-m-start">
            <i class="fas fa-plus-circle" aria-hidden="true"></i>
          </span>app=MyApp</button>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Annotation</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">2 Annotations</div>
    </dd>
  </div>
</dl>
```

### Horizontal auto column width

```html
<dl class="pf-c-description-list pf-m-horizontal pf-m-auto-column-widths pf-m-2-col-on-lg">
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Name</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Namespace</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <a href="#">mary-test</a>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Labels</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Pod selector</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <button class="pf-c-button pf-m-link pf-m-inline" type="button">
          <span class="pf-c-button__icon pf-m-start">
            <i class="fas fa-plus-circle" aria-hidden="true"></i>
          </span>app=MyApp</button>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Annotation</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">2 Annotations</div>
    </dd>
  </div>
</dl>
```

## Inline grid

### Default inline grid

```html
<dl class="pf-c-description-list pf-m-3-col pf-m-inline-grid">
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Name</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Namespace</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <a href="#">mary-test</a>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Labels</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">example</div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Pod selector</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">
        <button class="pf-c-button pf-m-link pf-m-inline" type="button">
          <span class="pf-c-button__icon pf-m-start">
            <i class="fas fa-plus-circle" aria-hidden="true"></i>
          </span>app=MyApp</button>
      </div>
    </dd>
  </div>
  <div class="pf-c-description-list__group">
    <dt class="pf-c-description-list__term">
      <span class="pf-c-description-list__text">Annotation</span>
    </dt>
    <dd class="pf-c-description-list__description">
      <div class="pf-c-description-list__text">2 Annotations</div>
    </dd>
  </div>
</dl>
```

<!-- ## Auto term with is only supported in FF currently

### Horizontal 2 col auto term width
```hbs
{{> description-list__example description-list--title="Horizontal 2 column DL" description-list--modifier="pf-m-horizontal pf-m-auto-term-widths pf-m-2-col"}}
``` -->

## Documentation

### Accessibility

| Attribute | Applied to               | Outcome                                                             |
| --------- | ------------------------ | ------------------------------------------------------------------- |
| `title`   | `.pf-c-description-list` | Provides an accessible title for the description list. **Required** |

### Usage

| Class                                      | Applied to               | Outcome                                                                                                                          |
| ------------------------------------------ | ------------------------ | -------------------------------------------------------------------------------------------------------------------------------- |
| `.pf-c-description-list`                   | `<dl>`                   | Initiates the description list component. **Required**                                                                           |
| `.pf-c-description-list__group`            | `<div>`                  | Initiates a description list component group. **Required**                                                                       |
| `.pf-c-description-list__term`             | `<dt>`                   | Initiates a description list component term. **Required**                                                                        |
| `.pf-c-description-list__description`      | `<dd>`                   | Initiates a description list component description. **Required**                                                                 |
| `.pf-c-description-list__text`             | `<span>`, `<div>`        | Initiates a description list component text element. Use a `<span>` when a child of `.pf-c-description-list__term`. **Required** |
| `.pf-m-horizontal`                         | `.pf-c-description-list` | Modifies the description list component term and description pair to a horizontal layout.                                        |
| `.pf-m-auto-column-widths`                 | `.pf-c-description-list` | Modifies the description list to format automatically.                                                                           |
| `.pf-m-inline-grid`                        | `.pf-c-description-list` | Modifies the description list display to inline-grid.                                                                            |
| `.pf-m-{1,2,3}-col{-on-[md, lg, xl, 2xl]}` | `.pf-c-description-list` | Modifies the description list number of columns.                                                                                 |

<!-- | `.pf-m-order[0-12]{-on-[breakpoint]}` | `.pf-c-description-list__group` | Modifies the order of the flex layout element. |
| `.pf-m-order-first{-on-[breakpoint]}` | `.pf-c-description-list__group` | Modifies the order of the flex layout element to -1. |
| `.pf-m-order-last{-on-[breakpoint]}` | `..pf-c-description-list__group` | Modifies the order of the flex layout element to $limit + 1. | -->
