import * as React from 'react';
import { OUIAProps } from '@patternfly/react-core';
import { DropdownDirection, DropdownPosition } from '@patternfly/react-core/dist/js/components/Dropdown/dropdownConstants';
import { DropdownItemProps } from '@patternfly/react-core/dist/js/components/Dropdown/DropdownItem';
import { RowWrapperProps } from './RowWrapper';
import { formatterValueType, ColumnType, RowType, RowKeyType, ColumnsType } from './base';
export declare enum TableGridBreakpoint {
    none = "",
    grid = "grid",
    gridMd = "grid-md",
    gridLg = "grid-lg",
    gridXl = "grid-xl",
    grid2xl = "grid-2xl"
}
export declare enum TableVariant {
    compact = "compact"
}
export declare type RowEditType = 'save' | 'cancel' | 'edit';
export interface RowErrors {
    [name: string]: string[];
}
export declare type OnSort = (event: React.MouseEvent, columnIndex: number, sortByDirection: SortByDirection, extraData: IExtraColumnData) => void;
export declare type OnCollapse = (event: React.MouseEvent, rowIndex: number, isOpen: boolean, rowData: IRowData, extraData: IExtraData) => void;
export declare type OnExpand = (event: React.MouseEvent, rowIndex: number, colIndex: number, isOpen: boolean, rowData: IRowData, extraData: IExtraData) => void;
export declare type OnSelect = (event: React.FormEvent<HTMLInputElement>, isSelected: boolean, rowIndex: number, rowData: IRowData, extraData: IExtraData) => void;
export declare type OnRowEdit = (event: React.MouseEvent<HTMLButtonElement>, type: RowEditType, isEditable?: boolean, rowIndex?: number, validationErrors?: RowErrors) => void;
export declare enum SortByDirection {
    asc = "asc",
    desc = "desc"
}
export interface IHeaderRow extends ColumnType {
}
export interface IRowData extends IRow {
    disableActions?: boolean;
}
export interface IColumn {
    extraParams: {
        sortBy?: ISortBy;
        onSort?: OnSort;
        onCollapse?: OnCollapse;
        onExpand?: OnExpand;
        onSelect?: OnSelect;
        onRowEdit?: OnRowEdit;
        rowLabeledBy?: string;
        expandId?: string;
        contentId?: string;
        dropdownPosition?: DropdownPosition;
        dropdownDirection?: DropdownDirection;
        allRowsSelected?: boolean;
    };
}
export interface IExtraRowData {
    rowIndex?: number;
    rowKey?: RowKeyType;
}
export interface IExtraColumnData {
    columnIndex?: number;
    column?: IColumn;
    property?: string;
}
export interface IExtraData extends IExtraColumnData, IExtraRowData {
}
export interface IExtra extends IExtraData {
    rowData?: IRowData;
}
export declare type IFormatterValueType = formatterValueType & {
    title?: string | React.ReactNode;
    props?: any;
};
export interface ISortBy {
    index?: number;
    direction?: 'asc' | 'desc';
}
export interface IAction extends Omit<DropdownItemProps, 'title' | 'onClick'> {
    isSeparator?: boolean;
    itemKey?: string;
    title?: string | React.ReactNode;
    onClick?: (event: React.MouseEvent, rowIndex: number, rowData: IRowData, extraData: IExtraData) => void;
}
export interface ISeparator extends IAction {
    isSeparator: boolean;
}
export declare type IActions = (IAction | ISeparator)[];
export declare type IActionsResolver = (rowData: IRowData, extraData: IExtraData) => (IAction | ISeparator)[];
export declare type IAreActionsDisabled = (rowData: IRowData, extraData: IExtraData) => boolean;
export interface IDecorator extends React.HTMLProps<HTMLElement> {
    isVisible: boolean;
    children?: React.ReactNode;
}
export interface decoratorReturnType {
    className?: string;
    'aria-sort'?: string;
    children?: React.ReactNode;
    textCenter?: boolean;
    component?: string;
    isVisible?: boolean;
    title?: string | React.ReactNode;
    props?: any;
    scope?: string;
    parentId?: number;
    colSpan?: number;
    id?: React.ReactText;
}
export declare type ITransform = (label?: IFormatterValueType, extra?: IExtra) => decoratorReturnType;
export declare type IFormatter = (data?: IFormatterValueType, extra?: IExtra) => formatterValueType & decoratorReturnType;
export interface ICell {
    title?: string | React.ReactNode;
    transforms?: ITransform[];
    cellTransforms?: ITransform[];
    columnTransforms?: ITransform[];
    formatters?: IFormatter[];
    cellFormatters?: IFormatter[];
    props?: any;
    data?: any;
    header?: any;
    cell?: any;
    dataLabel?: string;
}
export declare type RowCellContent = (value?: string, rowIndex?: number, cellIndex?: number, props?: any) => void;
export interface IRowCell {
    title?: string | React.ReactNode | RowCellContent;
    props?: any;
}
export interface IValidatorDef {
    validator: (value: string) => boolean;
    errorText: string;
    name: string;
}
export interface IRow extends RowType {
    cells?: (React.ReactNode | IRowCell)[];
    isOpen?: boolean;
    isEditable?: boolean;
    isValid?: boolean;
    /** An array of validation functions to run against every cell for a given row */
    rowEditValidationRules?: IValidatorDef[];
    /** Aria label for edit button in inline edit */
    rowEditBtnAriaLabel?: (idx: number) => string;
    /** Aria label for save button in inline edit */
    rowSaveBtnAriaLabel?: (idx: number) => string;
    /** Aria label for cancel button in inline edit */
    rowCancelBtnAriaLabel?: (idx: number) => string;
    parent?: number;
    compoundParent?: number;
    props?: any;
    fullWidth?: boolean;
    noPadding?: boolean;
    heightAuto?: boolean;
    showSelect?: boolean;
    isExpanded?: boolean;
    isFirstVisible?: boolean;
    isLastVisible?: boolean;
    selected?: boolean;
    disableCheckbox?: boolean;
}
export interface TableProps extends OUIAProps {
    /** Adds an accessible name for the Table */
    'aria-label'?: string;
    /** Content rendered inside the Table */
    children?: React.ReactNode;
    /** Additional classes added to the Table  */
    className?: string;
    /** Style variant for the Table  */
    variant?: 'compact';
    /** Render borders  */
    borders?: boolean;
    /** Specifies the grid breakpoints  */
    gridBreakPoint?: '' | 'grid' | 'grid-md' | 'grid-lg' | 'grid-xl' | 'grid-2xl';
    /** Specifies the initial sorting pattern for the table - asc/desc and the index of the column to sort by */
    sortBy?: ISortBy;
    /** Function triggered when an expandable content is collapsed. When this is used, one expandable toggle button will be positioned in the first cell of a non-expandable row, preceding an expandable row */
    onCollapse?: OnCollapse;
    /** Function triggered when a compound expandable item is clicked */
    onExpand?: OnExpand;
    /** Function triggered when a row's checkbox is selected. When this is used, one checkbox will be positioned in the first or second cell of a non-expandable row */
    onSelect?: OnSelect;
    /** Enables or Disables the ability to select all  */
    canSelectAll?: boolean;
    /** @beta Function triggered when a row's inline edit is activated. Adds a column for inline edit when present. */
    onRowEdit?: OnRowEdit;
    /** Function triggered when sort icon is clicked */
    onSort?: OnSort;
    /** Actions to add to the Table */
    actions?: IActions;
    /** Resolver for the given action  */
    actionResolver?: IActionsResolver;
    /** Specifies if the Kebab for actions is disabled */
    areActionsDisabled?: IAreActionsDisabled;
    /** Component to place in the header */
    header?: React.ReactNode;
    /** Component used for caption*/
    caption?: React.ReactNode;
    /** label for row */
    rowLabeledBy?: string;
    /** ID for expand */
    expandId?: string;
    /** ID for content */
    contentId?: string;
    /** The desired position to show the dropdown when clicking on the actions Kebab. Can only be used together with `actions` property */
    dropdownPosition?: 'right' | 'left';
    /** The desired direction to show the dropdown when clicking on the actions Kebab. Can only be used together with `actions` property */
    dropdownDirection?: 'up' | 'down';
    /** Row data */
    rows: (IRow | string[])[];
    /** Cell data */
    cells: (ICell | string)[];
    /** Wrapper for the body  */
    bodyWrapper?: Function;
    /** Wrapper for the row */
    rowWrapper?: (props: RowWrapperProps) => JSX.Element;
    /** A valid WAI-ARIA role to be applied to the table element */
    role?: string;
    /** If set to true, the table header sticks to the top of its container */
    isStickyHeader?: boolean;
}
export declare const TableContext: React.Context<{
    headerData: ColumnsType;
    headerRows: IHeaderRow[];
    rows: (string[] | IRow)[];
}>;
export declare class Table extends React.Component<TableProps, {}> {
    static displayName: string;
    static hasWarnBeta: boolean;
    static defaultProps: Partial<TableProps>;
    state: {
        ouiaStateId: string;
    };
    isSelected: (row: IRow) => boolean;
    areAllRowsSelected: (rows: IRow[]) => boolean;
    componentDidMount(): void;
    render(): JSX.Element;
}
//# sourceMappingURL=Table.d.ts.map