"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const base_1 = require("./base");
const Table_1 = require("./Table");
const utils_1 = require("./utils");
const flagVisibility = (rows) => {
    const visibleRows = rows.filter((oneRow) => !oneRow.parent || oneRow.isExpanded);
    if (visibleRows.length > 0) {
        visibleRows[0].isFirstVisible = true;
        visibleRows[visibleRows.length - 1].isLastVisible = true;
    }
};
class ContextBody extends React.Component {
    constructor() {
        super(...arguments);
        this.onRow = (row, rowProps) => {
            const { onRowClick, onRow } = this.props;
            const extendedRowProps = Object.assign(Object.assign({}, rowProps), (onRow ? onRow(row, rowProps) : {}));
            return {
                row,
                rowProps: extendedRowProps,
                onMouseDown: (event) => {
                    const computedData = {
                        isInput: event.target.tagName !== 'INPUT',
                        isButton: event.target.tagName !== 'BUTTON'
                    };
                    onRowClick(event, row, rowProps, computedData);
                }
            };
        };
        this.mapCells = (headerData, row, rowKey) => {
            // column indexes start after generated optional columns
            let additionalColsIndexShift = headerData[0].extraParams.firstUserColumnIndex;
            return Object.assign({}, (row &&
                (row.cells || row).reduce((acc, cell, cellIndex) => {
                    const isCellObject = cell === Object(cell);
                    const isCellFunction = cell && typeof cell.title === 'function';
                    const mappedCell = {
                        [headerData[cellIndex + additionalColsIndexShift].property]: {
                            title: isCellObject
                                ? isCellFunction
                                    ? cell.title(cell.props.value, rowKey, cellIndex, cell.props)
                                    : cell.title
                                : cell,
                            props: Object.assign({ isVisible: true }, (isCellObject ? cell.props : null))
                        }
                    };
                    // increment the shift index when a cell spans multiple columns
                    if (isCellObject && cell.props && cell.props.colSpan) {
                        additionalColsIndexShift += cell.props.colSpan - 1;
                    }
                    return Object.assign(Object.assign({}, acc), mappedCell);
                }, { id: row.id !== undefined ? row.id : rowKey })));
        };
    }
    render() {
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        const _a = this.props, { className, headerData, rows, rowKey, children, onRowClick } = _a, props = tslib_1.__rest(_a, ["className", "headerData", "rows", "rowKey", "children", "onRowClick"]);
        let mappedRows;
        if (headerData.length > 0) {
            mappedRows = rows.map((oneRow, oneRowKey) => (Object.assign(Object.assign(Object.assign({}, oneRow), this.mapCells(headerData, oneRow, oneRowKey)), { isExpanded: utils_1.isRowExpanded(oneRow, rows), isHeightAuto: oneRow.heightAuto || false, isFirst: oneRowKey === 0, isLast: oneRowKey === rows.length - 1, isFirstVisible: false, isLastVisible: false })));
            flagVisibility(mappedRows);
        }
        return (React.createElement(React.Fragment, null, mappedRows && (React.createElement(base_1.Body, Object.assign({}, props, { mappedRows: mappedRows, rows: mappedRows, onRow: this.onRow, rowKey: rowKey, className: className })))));
    }
}
exports.TableBody = (_a) => {
    var { className = '', children = null, rowKey = 'id', 
    /* eslint-disable @typescript-eslint/no-unused-vars */
    onRow = (...args) => Object, onRowClick = (event, row, rowProps, computedData) => 
    /* eslint-enable @typescript-eslint/no-unused-vars */
    undefined } = _a, props = tslib_1.__rest(_a, ["className", "children", "rowKey", "onRow", "onRowClick"]);
    return (React.createElement(Table_1.TableContext.Consumer, null, (_a) => {
        var { headerData = [], rows = [] } = _a, rest = tslib_1.__rest(_a, ["headerData", "rows"]);
        return (React.createElement(ContextBody, Object.assign({ headerData: headerData, rows: rows, onRow: onRow, className: className, rowKey: rowKey, onRowClick: onRowClick }, props, rest), children));
    }));
};
//# sourceMappingURL=Body.js.map